/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import chemaxon.struc.Molecule;
import java.awt.Color;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.compound.MolarConcentration;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.gui.actions.MetadataDataType;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ToolTipSupplier;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.multivariate.MultivariateFloatListFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapterProperties;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.FixedSizeAbstractDataset;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.SlicedDatasetView;
import org.broadinstitute.genee.matrix.TransposedDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class DatasetUtil {
    private DatasetUtil() {
    }

    public static Dataset applyFunction(Dataset[] datasets, MultivariateFloatListFunction function) {
        FloatList[] views = new DatasetColumnView[datasets.length];
        int length = views.length;
        for (int i = 0; i < length; ++i) {
            views[i] = new DatasetColumnView(datasets[i]);
        }
        RowMajorArray2DDataset stats = new RowMajorArray2DDataset(function.toString(), datasets[0].getColumnCount(), 1);
        int cols = datasets[0].getColumnCount();
        for (int j = 0; j < cols; ++j) {
            for (DatasetColumnView datasetColumnView : views) {
                datasetColumnView.setIndex(j);
            }
            stats.setValue(j, 0, function.evaluate(views));
        }
        return stats;
    }

    public static Dataset asDataset(final List<GeneSet> geneSets) {
        HashSet<String> union = new HashSet<String>();
        for (GeneSet set : geneSets) {
            union.addAll(set.getMembers());
        }
        final ArrayList genes = new ArrayList(union);
        FixedSizeAbstractDataset dataset = new FixedSizeAbstractDataset("", genes.size(), geneSets.size()){

            @Override
            public float getValue(int i, int j) {
                return ((GeneSet)geneSets.get(j)).contains((String)genes.get(i)) ? 1.0f : 0.0f;
            }

            @Override
            public void setValue(int r, int c, float value) {
            }
        };
        Vector ids = dataset.getColumnMetadata().add("id", String.class);
        Vector desc = dataset.getColumnMetadata().add("description", String.class);
        int size = geneSets.size();
        for (int i = 0; i < size; ++i) {
            ids.setValue(i, geneSets.get(i).getName());
            desc.setValue(i, geneSets.get(i).getDescription());
        }
        Vector geneIds = dataset.getRowMetadata().add("id", String.class);
        int size2 = genes.size();
        for (int i = 0; i < size2; ++i) {
            geneIds.setValue(i, genes.get(i));
        }
        return dataset;
    }

    public static FloatList asFloatList(final Dataset dataset) {
        return new FloatList(){

            @Override
            public float getValue(int index) {
                int rowIndex = index / dataset.getColumnCount();
                int columnIndex = index % dataset.getColumnCount();
                return dataset.getValue(rowIndex, columnIndex);
            }

            @Override
            public void setValue(int index, float value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return dataset.getRowCount() * dataset.getColumnCount();
            }
        };
    }

    public static void changeDataType(Project project, boolean rows, String columnName, MetadataDataType newDataType) {
        VectorColorModel colorModel = rows ? project.getRowColorModel() : project.getColumnColorModel();
        MetadataModel metadata = rows ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata();
        Vector vector = metadata.get(columnName);
        if (newDataType.equals((Object)MetadataDataType.MOLAR_CONCENTRATION)) {
            try {
                int i;
                Object[] newValues = new Object[metadata.getItemCount()];
                int length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Object val = vector.getValue(i);
                    if (val == null) continue;
                    newValues[i] = MolarConcentration.parse(String.valueOf(val));
                }
                vector.setColumnClass(MolarConcentration.class);
                length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Color c = (Color)colorModel.getMappedValue(vector, vector.getValue(i));
                    Object newValue = newValues[i];
                    vector.setValue(i, newValue);
                    if (c == null) continue;
                    colorModel.setMappedValue(vector, newValue, c);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                throw new IllegalArgumentException("Unable to convert " + columnName + " to a molar concentration.");
            }
        } else if (newDataType.equals((Object)MetadataDataType.DATE)) {
            DateFormat df = DateFormat.getDateInstance();
            try {
                int i;
                Object[] newValues = new Object[metadata.getItemCount()];
                int length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Object val = vector.getValue(i);
                    if (val == null) continue;
                    newValues[i] = val instanceof Long ? new Date((Long)val) : df.parse(String.valueOf(val));
                }
                vector.setColumnClass(Date.class);
                length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Color c = (Color)colorModel.getMappedValue(vector, vector.getValue(i));
                    Object newValue = newValues[i];
                    vector.setValue(i, newValue);
                    if (c == null) continue;
                    colorModel.setMappedValue(vector, newValue, c);
                }
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Unable to convert " + columnName + " to a date.");
            }
        } else if (newDataType.equals((Object)MetadataDataType.TEXT)) {
            vector.setColumnClass(String.class);
            int nitems = metadata.getItemCount();
            for (int i = 0; i < nitems; ++i) {
                Object value = vector.getValue(i);
                if (value == null) continue;
                Color c = (Color)colorModel.getMappedValue(vector, value);
                String newValue = Formatter.toString(value);
                vector.setValue(i, newValue);
                if (c == null) continue;
                colorModel.setMappedValue(vector, newValue, c);
            }
        } else if (newDataType.equals((Object)MetadataDataType.URL)) {
            try {
                int i;
                Object[] newValues = new Object[metadata.getItemCount()];
                int length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Object val = vector.getValue(i);
                    if (val == null) continue;
                    newValues[i] = new URL(String.valueOf(val));
                }
                vector.setColumnClass(URL.class);
                length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Color c = (Color)colorModel.getMappedValue(vector, vector.getValue(i));
                    Object newValue = newValues[i];
                    vector.setValue(i, newValue);
                    if (c == null) continue;
                    colorModel.setMappedValue(vector, newValue, c);
                }
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Unable to convert " + columnName + " to a URL.");
            }
        } else if (newDataType.equals((Object)MetadataDataType.NUMBER)) {
            try {
                int i;
                boolean oldDataTypeIsMolarConc = MolarConcentration.class.isAssignableFrom(vector.getColumnClass());
                Object[] newValues = new Object[metadata.getItemCount()];
                int length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Object val = vector.getValue(i);
                    if (val == null) continue;
                    newValues[i] = oldDataTypeIsMolarConc ? Float.valueOf(((MolarConcentration)val).getConcentration()) : Float.valueOf(ParserHelper.parseFloatNaN(String.valueOf(val)));
                }
                vector.setColumnClass(Float.class);
                length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Color c = (Color)colorModel.getMappedValue(vector, vector.getValue(i));
                    Object newValue = newValues[i];
                    vector.setValue(i, newValue);
                    if (c == null) continue;
                    colorModel.setMappedValue(vector, newValue, c);
                }
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Unable to convert " + columnName + " to a number.");
            }
        } else if (newDataType.equals((Object)MetadataDataType.MOLECULE)) {
            try {
                int i;
                Object[] newValues = new Object[metadata.getItemCount()];
                int length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Object val = vector.getValue(i);
                    if (val == null) continue;
                    newValues[i] = MoleculeUtil.read(String.valueOf(val));
                }
                vector.setColumnClass(Molecule.class);
                length = newValues.length;
                for (i = 0; i < length; ++i) {
                    Color c = (Color)colorModel.getMappedValue(vector, vector.getValue(i));
                    Object newValue = newValues[i];
                    vector.setValue(i, newValue);
                    if (c == null) continue;
                    colorModel.setMappedValue(vector, newValue, c);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                throw new IllegalArgumentException("Unable to convert " + columnName + " to a molecule.");
            }
        } else {
            System.err.println("Unknown data type");
        }
    }

    public static RowMajorArray2DDataset combineRows(Dataset[] datasets, String name) {
        if (datasets.length == 0) {
            throw new IllegalArgumentException("Datasets array is empty.");
        }
        int rows = 0;
        for (int i = 0; i < datasets.length; ++i) {
            rows += datasets[i].getRowCount();
        }
        RowMajorArray2DDataset mergedDataset = new RowMajorArray2DDataset(name, rows, datasets[0].getColumnCount());
        for (int j = 0; j < datasets[0].getSeriesCount(); ++j) {
            mergedDataset.addSeries(datasets[0].getSeriesName(j), datasets[0].getSeriesClass(j));
        }
        MetadataUtil.copy(datasets[0].getColumnMetadata(), mergedDataset.getColumnMetadata());
        int rowOffset = 0;
        for (int datasetIdx = 0; datasetIdx < datasets.length; ++datasetIdx) {
            int i;
            Vector sourceVector;
            Vector mergedVector;
            int metadataIndex;
            Dataset d = datasets[datasetIdx];
            int nmetadata = d.getColumnMetadata().getMetadataCount();
            for (metadataIndex = 0; metadataIndex < nmetadata; ++metadataIndex) {
                mergedVector = mergedDataset.getColumnMetadata().get(d.getColumnMetadata().getColumnName(metadataIndex));
                sourceVector = d.getColumnMetadata().get(metadataIndex);
                for (i = 0; i < d.getColumnCount(); ++i) {
                    mergedVector.setValue(i, sourceVector.getValue(i));
                }
            }
            nmetadata = d.getRowMetadata().getMetadataCount();
            for (metadataIndex = 0; metadataIndex < nmetadata; ++metadataIndex) {
                Vector srcVector = d.getRowMetadata().get(metadataIndex);
                if (mergedDataset.getRowMetadata().getColumnIndex(srcVector.getName()) != -1) continue;
                Vector dest = mergedDataset.getRowMetadata().add(srcVector.getName(), srcVector.getColumnClass());
                VectorUtil.copyProperties(srcVector, dest);
            }
            nmetadata = d.getRowMetadata().getMetadataCount();
            for (metadataIndex = 0; metadataIndex < nmetadata; ++metadataIndex) {
                mergedVector = mergedDataset.getRowMetadata().get(d.getRowMetadata().getColumnName(metadataIndex));
                sourceVector = d.getRowMetadata().get(metadataIndex);
                for (i = 0; i < d.getRowCount(); ++i) {
                    mergedVector.setValue(i + rowOffset, sourceVector.getValue(i));
                }
            }
            for (int i2 = 0; i2 < d.getRowCount(); ++i2) {
                int cols = mergedDataset.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    mergedDataset.setValue(i2 + rowOffset, j, d.getValue(i2, j));
                }
            }
            for (int seriesIdx = 0; seriesIdx < d.getSeriesCount(); ++seriesIdx) {
                for (int i3 = 0; i3 < d.getRowCount(); ++i3) {
                    int cols = mergedDataset.getColumnCount();
                    for (int j = 0; j < cols; ++j) {
                        mergedDataset.setObjectValue(i3 + rowOffset, j, d.getObjectValue(i3, j, seriesIdx), seriesIdx);
                    }
                }
            }
            rowOffset += datasets[datasetIdx].getRowCount();
        }
        MetadataUtil.copyProperties(datasets[0].getColumnMetadata(), mergedDataset.getColumnMetadata());
        return mergedDataset;
    }

    public static void copy(Dataset src, float[][] data) {
        int rows = src.getRowCount();
        int columns = src.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                data[i][j] = src.getValue(i, j);
            }
        }
    }

    public static FloatList createFloatListFromFloatListFunction(final Project project, final FloatListFunction f) {
        final DatasetRowView rowView = new DatasetRowView(project.getOriginalDataset());
        return new FloatList(){

            @Override
            public float getValue(int index) {
                rowView.setIndex(index);
                return f.evaluate(rowView);
            }

            @Override
            public void setValue(int index, float value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return project.getOriginalDataset().getRowCount();
            }

            public String toString() {
                return f.toString();
            }
        };
    }

    public static FloatList createFloatListFromRowMetadata(final Project project, final String metadataColumnName) {
        return new FloatList(){

            @Override
            public float getValue(int index) {
                return ((Number)project.getOriginalDataset().getRowMetadata().getValue(index, metadataColumnName)).floatValue();
            }

            @Override
            public void setValue(int index, float value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return project.getOriginalDataset().getRowCount();
            }

            public String toString() {
                return metadataColumnName;
            }
        };
    }

    public static RowMajorArray2DDataset deepCopy(Dataset dataset) {
        int seriesIndex;
        if (dataset == null) {
            throw new NullPointerException("Dataset is null.");
        }
        float[][] data = new float[dataset.getRowCount()][dataset.getColumnCount()];
        DatasetUtil.copy(dataset, data);
        RowMajorArray2DDataset copy = new RowMajorArray2DDataset(dataset.getName(), data);
        int seriesCount = dataset.getSeriesCount();
        for (seriesIndex = 0; seriesIndex < seriesCount; ++seriesIndex) {
            copy.addSeries(dataset.getSeriesName(seriesIndex), dataset.getSeriesClass(seriesIndex));
        }
        seriesCount = dataset.getSeriesCount();
        for (seriesIndex = 0; seriesIndex < seriesCount; ++seriesIndex) {
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                int cols = dataset.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    copy.setObjectValue(i, j, dataset.getObjectValue(i, j, seriesIndex), seriesIndex);
                }
            }
        }
        MetadataUtil.copy(dataset.getRowMetadata(), copy.getRowMetadata());
        MetadataUtil.copy(dataset.getColumnMetadata(), copy.getColumnMetadata());
        return copy;
    }

    public static void fill(Dataset dataset, float value) {
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int cols = dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                dataset.setValue(i, j, value);
            }
        }
    }

    public static FloatList floatListView(final Dataset dataset) {
        return new FloatList(){
            private final int ncols;
            private final int size;
            {
                this.ncols = dataset.getColumnCount();
                this.size = this.ncols * dataset.getRowCount();
            }

            @Override
            public float getValue(int index) {
                int rowIndex = index / this.ncols;
                int columnIndex = index % this.ncols;
                return dataset.getValue(rowIndex, columnIndex);
            }

            @Override
            public void setValue(int index, float value) {
                int rowIndex = index / this.ncols;
                int columnIndex = index % this.ncols;
                dataset.setValue(rowIndex, columnIndex, value);
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    public static float[] getColumn(Dataset dataset, int columnIndex) {
        float[] data = new float[dataset.getRowCount()];
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            data[i] = dataset.getValue(i, columnIndex);
        }
        return data;
    }

    public static <T> T[] getMetadata(MetadataModel metadata, String name, T[] a) {
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            a[i] = metadata.getValue(i, name);
        }
        return a;
    }

    public static float[] getRow(Dataset dataset, int rowIndex) {
        int columns = dataset.getColumnCount();
        float[] row = new float[columns];
        for (int j = 0; j < columns; ++j) {
            row[j] = dataset.getValue(rowIndex, j);
        }
        return row;
    }

    public static int getSeriesIndex(Dataset data, Class<?> c) {
        int size = data.getSeriesCount();
        for (int i = 0; i < size; ++i) {
            if (!c.isAssignableFrom(data.getSeriesClass(i))) continue;
            return i;
        }
        return -1;
    }

    public static int getSeriesIndex(Dataset data, String name) {
        if (name == null) {
            return -1;
        }
        int size = data.getSeriesCount();
        for (int i = 0; i < size; ++i) {
            if (!data.getSeriesName(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static String[] getSeriesNames(Dataset data) {
        String[] s = new String[data.getSeriesCount()];
        int size = data.getSeriesCount();
        for (int i = 0; i < size; ++i) {
            s[i] = data.getSeriesName(i);
        }
        return s;
    }

    public static List<String> getSeriesNames(Dataset data, Class<?> c) {
        ArrayList<String> list = new ArrayList<String>();
        int size = data.getSeriesCount();
        for (int i = 0; i < size; ++i) {
            if (!c.isAssignableFrom(data.getSeriesClass(i))) continue;
            list.add(data.getSeriesName(i));
        }
        return list;
    }

    public static String getToolTipText(Dataset dataset, int rowIndex, int columnIndex, String rowMetadataField, String columnMetadataField) {
        Object value;
        Vector v;
        int ncols;
        Object value2;
        Vector selectedColumnVector;
        Object value3;
        Vector selectedRowVector;
        MetadataModel rowMetadata = null;
        if (rowIndex >= 0) {
            rowMetadata = dataset.getRowMetadata();
        }
        MetadataModel columnMetadata = null;
        if (columnIndex >= 0) {
            columnMetadata = dataset.getColumnMetadata();
        }
        StringBuilder tip = new StringBuilder();
        tip.append("<html><table>");
        Vector vector = selectedRowVector = rowMetadataField != null ? rowMetadata.get(rowMetadataField) : null;
        if (selectedRowVector != null && MetadataUtil.isToolTipVisible(selectedRowVector) && (value3 = selectedRowVector.getValue(rowIndex)) != null) {
            tip.append("<tr><td><b>");
            tip.append(selectedRowVector.getName());
            tip.append(":<td><b>");
            tip.append(Formatter.toString(value3));
        }
        Vector vector2 = selectedColumnVector = columnMetadataField != null ? columnMetadata.get(columnMetadataField) : null;
        if (selectedColumnVector != null && MetadataUtil.isToolTipVisible(selectedColumnVector) && (value2 = selectedColumnVector.getValue(columnIndex)) != null) {
            tip.append("<tr><td><b>");
            tip.append(selectedColumnVector.getName());
            tip.append(":<td><b>");
            tip.append(Formatter.toString(value2));
        }
        if (rowMetadata != null && columnMetadata != null) {
            int count = dataset.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < count; ++seriesIndex) {
                Object seriesValue = dataset.getObjectValue(rowIndex, columnIndex, seriesIndex);
                if (seriesValue == null) continue;
                tip.append("<tr><td>");
                tip.append(count == 1 ? "Value" : dataset.getSeriesName(seriesIndex));
                tip.append(":<td>");
                if (seriesValue instanceof ToolTipSupplier) {
                    tip.append(((ToolTipSupplier)seriesValue).getToolTipText());
                    continue;
                }
                tip.append(seriesValue instanceof Number ? Formatter.format((Number)seriesValue) : seriesValue);
            }
        }
        if (rowMetadata != null) {
            ncols = rowMetadata.getMetadataCount();
            for (int j = 0; j < ncols; ++j) {
                v = rowMetadata.get(j);
                if (v.getName().equals(rowMetadataField) || !MetadataUtil.isToolTipVisible(v) || (value = v.getValue(rowIndex)) == null) continue;
                tip.append("<tr><td>");
                tip.append(rowMetadata.getColumnName(j));
                tip.append(":<td>");
                tip.append(Formatter.toString(value));
            }
        }
        if (columnMetadata != null) {
            ncols = columnMetadata.getMetadataCount();
            for (int j = 0; j < ncols; ++j) {
                v = columnMetadata.get(j);
                if (v.getName().equals(columnMetadataField) || !MetadataUtil.isToolTipVisible(v) || (value = v.getValue(columnIndex)) == null) continue;
                tip.append("<tr>");
                tip.append(v.getName());
                tip.append(":<td>");
                tip.append(Formatter.toString(value));
            }
        }
        tip.append("</table>");
        return tip.toString();
    }

    public static float max(Dataset dataset) {
        float max = -3.4028235E38f;
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int columns = dataset.getColumnCount();
            for (int j = 0; j < columns; ++j) {
                float d = dataset.getValue(i, j);
                if (Float.isInfinite(d) || Float.isNaN(d)) continue;
                max = Math.max(max, d);
            }
        }
        return max;
    }

    public static float min(Dataset dataset) {
        float min = Float.MAX_VALUE;
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int columns = dataset.getColumnCount();
            for (int j = 0; j < columns; ++j) {
                float d = dataset.getValue(i, j);
                if (Float.isInfinite(d) || Float.isNaN(d)) continue;
                min = Math.min(min, d);
            }
        }
        return min;
    }

    public static void printValues(Dataset dataset) {
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            for (int j = 0; j < dataset.getColumnCount(); ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(Formatter.format(dataset.getValue(i, j)));
            }
            System.out.println();
        }
    }

    public static Dataset shallowCopy(Dataset dataset) {
        final DefaultMetadataModel copyRowMetadata = new DefaultMetadataModel(dataset.getRowCount());
        final DefaultMetadataModel copyColumnMetadata = new DefaultMetadataModel(dataset.getColumnCount());
        MetadataUtil.copy(dataset.getRowMetadata(), copyRowMetadata);
        MetadataUtil.copy(dataset.getColumnMetadata(), copyColumnMetadata);
        DatasetAdapterProperties shallowCopy = new DatasetAdapterProperties(dataset){
            private String name;
            {
                super(x0);
                this.name = this.dataset.getName();
            }

            @Override
            public MetadataModel getColumnMetadata() {
                return copyColumnMetadata;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public MetadataModel getRowMetadata() {
                return copyRowMetadata;
            }

            @Override
            public void setName(String name) {
                this.name = name;
            }
        };
        MetadataUtil.updateFormulaValues(new DatasetRowView(shallowCopy), shallowCopy.getRowMetadata());
        MetadataUtil.updateFormulaValues(new DatasetColumnView(shallowCopy), shallowCopy.getColumnMetadata());
        return shallowCopy;
    }

    public static Dataset sliceView(Dataset dataset, int[] rowIndices, int[] columnIndices) {
        return rowIndices == null && columnIndices == null ? dataset : new SlicedDatasetView(dataset, rowIndices, columnIndices);
    }

    public static float[] toColumnMajorArray(Dataset dataset) {
        float[] array = new float[dataset.getColumnCount() * dataset.getRowCount()];
        int ncols = dataset.getColumnCount();
        for (int j = 0; j < ncols; ++j) {
            int nrows = dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                array[i + j * nrows] = dataset.getValue(i, j);
            }
        }
        return array;
    }

    public static Dataset transposeView(Dataset dataset) {
        return new TransposedDataset(dataset);
    }

    public static String valuesToString(Dataset dataset) {
        StringBuilder sb = new StringBuilder();
        int nrows = dataset.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            if (i > 0) {
                sb.append("\n");
            }
            int ncols = dataset.getColumnCount();
            for (int j = 0; j < ncols; ++j) {
                if (j > 0) {
                    sb.append(",");
                }
                sb.append(Formatter.format(dataset.getValue(i, j)));
            }
        }
        return sb.toString();
    }
}

