/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.SlicedVector;
import org.broadinstitute.genee.matrix.Vector;

public class MetadataModelItemView
implements MetadataModel {
    private int[] indices;
    private MetadataModel metadata;

    public MetadataModelItemView(MetadataModel metaData, int[] indices) {
        this.metadata = metaData;
        this.indices = indices;
    }

    @Override
    public Vector add(String columnName, Class<?> columnClass) {
        Vector v = this.metadata.add(columnName, columnClass);
        return this.indices == null ? v : new SlicedVector(v, this.indices);
    }

    @Override
    public Vector get(int columnIndex) {
        return this.indices == null ? this.metadata.get(columnIndex) : new SlicedVector(this.metadata.get(columnIndex), this.indices);
    }

    @Override
    public Vector get(String name) {
        int index = this.metadata.getColumnIndex(name);
        if (index == -1) {
            return null;
        }
        return this.indices == null ? this.metadata.get(index) : new SlicedVector(this.metadata.get(index), this.indices);
    }

    @Override
    public int getColumnIndex(String columnName) {
        return this.metadata.getColumnIndex(columnName);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.metadata.getColumnName(columnIndex);
    }

    @Override
    public int getItemCount() {
        return this.indices != null ? this.indices.length : this.metadata.getItemCount();
    }

    @Override
    public Object getValue(int rowIndex, int columnIndex) {
        return this.metadata.getValue(this.getMappedRowIndex(rowIndex), columnIndex);
    }

    @Override
    public Object getValue(int rowIndex, String columnName) {
        return this.metadata.getValue(this.getMappedRowIndex(rowIndex), columnName);
    }

    @Override
    public void remove(int index) {
        this.metadata.remove(index);
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, Object aValue) {
        this.metadata.setValue(this.getMappedRowIndex(rowIndex), columnIndex, aValue);
    }

    @Override
    public void setValue(int rowIndex, String columnName, Object value) {
        this.metadata.setValue(this.getMappedRowIndex(rowIndex), columnName, value);
    }

    @Override
    public int getMetadataCount() {
        return this.metadata.getMetadataCount();
    }

    private final int getMappedRowIndex(int row) {
        return this.indices != null ? this.indices[row] : row;
    }
}

