/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.FloatList;

public class RowArrayFloatList
implements FloatList {
    private int rowIndex;
    private float[][] data;
    private int columns;

    public RowArrayFloatList(Dataset dataset) {
        if (dataset == null) {
            throw new NullPointerException("dataset is null");
        }
        int rows = dataset.getRowCount();
        this.columns = dataset.getColumnCount();
        this.data = new float[rows][this.columns];
        DatasetUtil.copy(dataset, this.data);
    }

    public RowArrayFloatList(float[][] data) {
        this.columns = data[0].length;
        this.data = data;
    }

    @Override
    public float getValue(int index) {
        return this.data[this.rowIndex][index];
    }

    public float[][] getArray() {
        return this.data;
    }

    @Override
    public void setValue(int index, float value) {
        this.data[this.rowIndex][index] = value;
    }

    public void setRowIndex(int index) {
        this.rowIndex = index;
    }

    @Override
    public int size() {
        return this.columns;
    }
}

