/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.adjust.LogScaleUnivariateFunction;
import org.broadinstitute.genee.math.stat.function.MedianAbsoluteDeviation;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapterProperties;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.FloatListAdapter;

public class TransformedDataset
extends DatasetAdapterProperties {
    private boolean logScale;
    private boolean zScoreTransform;
    private int cachedRow = -1;
    private float cachedRowMean = -1.0f;
    private float cachedRowStdev = -1.0f;
    private float maxValue;
    private float minValue;
    private DatasetRowView rowView;
    private boolean applyCeiling;
    private boolean applyFloor;
    private boolean inverseLogScale;
    private boolean robustZScoreTransform;
    private MedianAbsoluteDeviation madFunction;
    private float cachedRowMAD;
    private float cachedRowMedian;

    public TransformedDataset(Dataset dataset, boolean logScale, boolean zScoreTransform, boolean robustZScoreTransform, float ceiling, float floor, boolean inverseLogScale) {
        super(dataset);
        this.logScale = logScale;
        this.inverseLogScale = inverseLogScale;
        this.zScoreTransform = zScoreTransform;
        this.robustZScoreTransform = robustZScoreTransform;
        this.maxValue = ceiling;
        this.minValue = floor;
        this.applyCeiling = !Float.isNaN(ceiling);
        this.applyFloor = !Float.isNaN(floor);
        this.rowView = new DatasetRowView(dataset);
        this.madFunction = new MedianAbsoluteDeviation();
    }

    @Override
    public Object getObjectValue(final int rowIndex, int columnIndex, int seriesIndex) {
        Object object = super.getObjectValue(rowIndex, columnIndex, seriesIndex);
        if (object instanceof FloatList) {
            FloatList list = (FloatList)object;
            return new FloatListAdapter(list){

                @Override
                public float getValue(int index) {
                    float val = super.getValue(index);
                    return TransformedDataset.this.transform(val, rowIndex);
                }
            };
        }
        return object;
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        float val = this.dataset.getValue(rowIndex, columnIndex);
        return this.transform(val, rowIndex);
    }

    private float transform(float val, int rowIndex) {
        if (this.applyCeiling && val > this.maxValue) {
            val = this.maxValue;
        }
        if (this.applyFloor && val < this.minValue) {
            val = this.minValue;
        }
        if (this.logScale) {
            val = LogScaleUnivariateFunction.log2(val);
        }
        if (this.inverseLogScale) {
            val = (float)Math.pow(2.0, val);
        }
        if (this.zScoreTransform) {
            if (this.cachedRow != rowIndex) {
                this.rowView.setIndex(rowIndex);
                this.cachedRowMean = FloatListStatUtils.mean(this.rowView);
                this.cachedRowStdev = FloatListStatUtils.stdev(this.rowView, this.cachedRowMean);
                this.cachedRow = rowIndex;
            }
            val = (val - this.cachedRowMean) / this.cachedRowStdev;
        }
        if (this.robustZScoreTransform) {
            if (this.cachedRow != rowIndex) {
                this.rowView.setIndex(rowIndex);
                this.cachedRowMAD = this.madFunction.evaluate(this.rowView);
                this.cachedRowMedian = this.madFunction.getMedian();
                this.cachedRow = rowIndex;
            }
            val = (val - this.cachedRowMedian) / this.cachedRowMAD;
        }
        return val;
    }
}

