/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix.rankedlist;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.broadinstitute.genee.application.UniqueEventListenerList;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;
import org.broadinstitute.genee.matrix.rankedlist.RankedListCollection;

public class DefaultRankedListCollection
implements RankedListCollection {
    private RankedList[] rankedLists;
    private MetadataModel listMetadata;
    private VectorColorModel instanceColorModel;
    private VectorColorModel listColorModel;
    private EventListenerList listenerList = new UniqueEventListenerList();

    public DefaultRankedListCollection(MetadataModel listMetadata, VectorColorModel listColorModel, VectorColorModel instanceColorModel, RankedList[] lists) {
        this.listMetadata = listMetadata;
        this.listColorModel = listColorModel;
        this.instanceColorModel = instanceColorModel;
        this.rankedLists = lists;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public VectorColorModel getInstanceColorModel() {
        return this.instanceColorModel;
    }

    @Override
    public VectorColorModel getListColorModel() {
        return this.listColorModel;
    }

    @Override
    public MetadataModel getListMetadata() {
        return this.listMetadata;
    }

    @Override
    public RankedList getRankedList(int index) {
        return this.rankedLists[index];
    }

    @Override
    public void notifyListeners() {
        ChangeEvent e = new ChangeEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    public void setRankedLists(RankedList[] rankedLists, MetadataModel listMetadata) {
        this.rankedLists = rankedLists;
        this.listMetadata = listMetadata;
        this.notifyListeners();
    }

    @Override
    public int size() {
        return this.rankedLists.length;
    }
}

