/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.SwingUtilities;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;

public class ToGeneeServlet
extends HttpServlet {
    static JsonFactory jsonFactory = new JsonFactory();

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        String fileName = "API";
        FileItem fileDataItem = null;
        File tmpDir = IOUtil.getTmpFsDir();
        String fileType = "gctx";
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                factory.setSizeThreshold(0);
                factory.setRepository(tmpDir);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List items = upload.parseRequest(req);
                int size = items.size();
                for (int i = 0; i < size; ++i) {
                    FileItem item = (FileItem)items.get(i);
                    String name = item.getFieldName();
                    if ("fileData".equals(name)) {
                        fileDataItem = item;
                        continue;
                    }
                    if ("fileName".equals(name)) {
                        fileName = item.getString();
                        continue;
                    }
                    if ("fileType".equals(name)) {
                        fileType = item.getString();
                        continue;
                    }
                    System.out.println("Unknown param " + name);
                }
            } else {
                System.out.println("Not multipart");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        File file = null;
        try {
            String suffix = "." + fileType;
            file = File.createTempFile("import", suffix, tmpDir);
            fileDataItem.write(file);
            this._uploadFile(file.getCanonicalPath(), fileName, (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    private void _uploadFile(String path, String name, OutputStream os) throws IOException {
        Project project = ProjectIO.readProject(path);
        if (name == null || name.equals("")) {
            name = IOUtil.getBaseFileName(path);
        }
        project.getOriginalDataset().setName(name);
        History history = new History("Import " + name);
        ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(project, history);
        final GENEEFolderNode folder = new GENEEFolderNode("Import", history, node);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.add(folder);
            }
        });
        JsonGenerator gen = jsonFactory.createJsonGenerator(os);
        gen.writeStartObject();
        gen.writeFieldName("id");
        gen.writeObject((Object)project.getId());
        gen.close();
    }
}

