/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import com.jidesoft.grid.AbstractMultiTableModel;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class DatasetValuesTableModel
extends AbstractMultiTableModel {
    private Dataset dataset;
    MetadataModel textRowMetadata;
    MetadataModel textColumnMetadata;

    public DatasetValuesTableModel(Dataset dataset) {
        this.dataset = dataset;
    }

    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return this.dataset == null ? 0 : this.dataset.getColumnCount() + this.textRowMetadata.getMetadataCount();
    }

    public String getColumnName(int columnIndex) {
        return columnIndex < this.textRowMetadata.getMetadataCount() ? this.textRowMetadata.getColumnName(columnIndex) : ToStringUtil.toString(this.dataset.getColumnMetadata(), columnIndex - this.textRowMetadata.getMetadataCount());
    }

    public int getColumnType(int column) {
        if (column < this.textRowMetadata.getMetadataCount()) {
            return 1;
        }
        return 0;
    }

    public int getRowCount() {
        return this.dataset == null ? 0 : this.dataset.getRowCount();
    }

    public int getTableIndex(int arg0) {
        return 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < this.textRowMetadata.getMetadataCount()) {
            return this.textRowMetadata.getValue(rowIndex, columnIndex);
        }
        return Formatter.format(this.dataset.getValue(rowIndex, columnIndex - this.textRowMetadata.getMetadataCount()));
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
        this.textRowMetadata = MetadataUtil.getTextColumns(dataset.getRowMetadata());
        this.textColumnMetadata = MetadataUtil.getTextColumns(dataset.getColumnMetadata());
        this.fireTableStructureChanged();
    }
}

