/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import com.jidesoft.grid.TableModelWrapper;
import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.table.SortKey;

public class FilterableTableModel
extends AbstractTableModel
implements TableModelWrapper {
    private LuceneSearchParser.IndexedSearchPredicate filter;
    private int[] rowOrder;
    private int[] rowSortOrder;
    private List<? extends SortKey> sortKeys;
    protected TableModel tableModel;

    public FilterableTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public void filter() {
        int rows;
        int n = rows = this.rowSortOrder == null ? this.tableModel.getRowCount() : this.rowSortOrder.length;
        if (this.filter != null) {
            this.filter.setData(this);
            TIntArrayList indices = new TIntArrayList();
            for (int i = 0; i < rows; ++i) {
                int index;
                int n2 = index = this.rowSortOrder == null ? i : this.rowSortOrder[i];
                if (!this.filter.accept(index)) continue;
                indices.add(index);
            }
            this.rowOrder = indices.toArray();
        } else {
            this.rowOrder = this.rowSortOrder;
        }
        this.fireTableStructureChanged();
    }

    public TableModel getActualModel() {
        return this.tableModel;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.tableModel.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.tableModel.getColumnName(columnIndex);
    }

    public int getModelIndex(int rowIndex) {
        return this.rowOrder != null ? this.rowOrder[rowIndex] : rowIndex;
    }

    public int getOriginalRowCount() {
        return this.tableModel.getRowCount();
    }

    public Object getOriginalValueAt(int rowIndex, int columnIndex) {
        return this.tableModel.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rowOrder != null ? this.rowOrder.length : this.tableModel.getRowCount();
    }

    public List<? extends SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableModel.getValueAt(this.rowOrder != null ? this.rowOrder[rowIndex] : rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableModel.isCellEditable(this.rowOrder != null ? this.rowOrder[rowIndex] : rowIndex, columnIndex);
    }

    public void setFilter(LuceneSearchParser.IndexedSearchPredicate f) {
        this.filter = f;
        this.filter();
    }

    public void setSortOrder(int[] sortOrder, List<? extends SortKey> newSortKeys) {
        this.rowSortOrder = sortOrder;
        this.sortKeys = newSortKeys;
        this.filter();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.tableModel.setValueAt(aValue, this.rowOrder != null ? this.rowOrder[rowIndex] : rowIndex, columnIndex);
    }
}

