/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.gui.BrowserLauncher;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.ZoomInAction;
import org.broadinstitute.genee.gui.ZoomOutAction;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.heatmap.CurveTableCellRenderer;
import org.broadinstitute.genee.heatmap.DefaultSizesAndPositions;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ZoomActions;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.table.BasicHeatMapColumnTable;
import org.broadinstitute.genee.table.HeatMapColumnTableModel;

public class HeatMapColumnTable
extends BasicHeatMapColumnTable {
    private HeatMapPanel heatMapPanel;
    private MatrixElement mouseMovedElement;

    public HeatMapColumnTable(HeatMapPanel heatMapPanel) {
        super(new HeatMapColumnTableModel());
        this.heatMapPanel = heatMapPanel;
        this.setDefaultRenderer(CurveElementList.class, new CurveTableCellRenderer(heatMapPanel, false));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object value;
                int columnIndex;
                int rowIndex = HeatMapColumnTable.this.convertRowIndexToModel(HeatMapColumnTable.this.rowAtPoint(event.getPoint()));
                if (rowIndex >= 0 && rowIndex < HeatMapColumnTable.this.getRowCount() && URL.class.isAssignableFrom(((HeatMapColumnTableModel)HeatMapColumnTable.this.getModel()).getRowClass(rowIndex)) && (columnIndex = HeatMapColumnTable.this.convertColumnIndexToModel(HeatMapColumnTable.this.columnAtPoint(event.getPoint()))) >= 0 && columnIndex < HeatMapColumnTable.this.getColumnCount() && (value = HeatMapColumnTable.this.getValueAt(rowIndex, columnIndex)) != null) {
                    BrowserLauncher.openURL(value.toString());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Object value;
                int columnIndex;
                int rowIndex = HeatMapColumnTable.this.convertRowIndexToModel(HeatMapColumnTable.this.rowAtPoint(e.getPoint()));
                if (rowIndex >= 0 && rowIndex < HeatMapColumnTable.this.getRowCount() && URL.class.isAssignableFrom(((HeatMapColumnTableModel)HeatMapColumnTable.this.getModel()).getRowClass(rowIndex)) && (columnIndex = HeatMapColumnTable.this.convertColumnIndexToModel(HeatMapColumnTable.this.columnAtPoint(e.getPoint()))) >= 0 && columnIndex < HeatMapColumnTable.this.getColumnCount() && (value = HeatMapColumnTable.this.getValueAt(rowIndex, columnIndex)) != null) {
                    HeatMapColumnTable.this.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                HeatMapColumnTable.this.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        HeatMapColumnTableModel model = (HeatMapColumnTableModel)this.getModel();
        Class<?> c = model.getRowClass(row);
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            renderer = this.getDefaultRenderer(c);
        }
        return renderer;
    }

    public Project getProject() {
        return this.heatMapPanel.getProject();
    }

    public String getToolTipText(MouseEvent e) {
        HeatMapColumnTableModel model = (HeatMapColumnTableModel)this.getModel();
        Dataset dataset = model.getDataset();
        int[] indices = DefaultSizesAndPositions.getIndices(this.viewSizesAndPositions, e.getPoint().x);
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        int rowIndex = this.rowAtPoint(e.getPoint());
        String metadataName = model.getMetadataRowName(rowIndex);
        for (int index : indices) {
            buf.append(DatasetUtil.getToolTipText(dataset, -1, index, null, metadataName));
            buf.append("<br>");
        }
        return buf.toString();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (column < 0 || column >= this.getColumnCount() || renderer == null) {
            return null;
        }
        Component c = super.prepareRenderer(renderer, row, column);
        float fontSize = Math.min(this.viewSizesAndPositions.getSize() - 1.0f, 16.0f);
        int fontStyle = 0;
        if (this.mouseMovedElement != null && this.mouseMovedElement.getRow() != -1 && ((HeatMapColumnTableModel)this.getModel()).getProject().convertModelColumnIndexToView(this.mouseMovedElement.getColumn()) == column) {
            fontStyle = 1;
        }
        c.setFont(this.getFont().deriveFont(fontStyle, fontSize));
        int modelRow = this.convertRowIndexToModel(row);
        Vector vector = ((HeatMapColumnTableModel)this.getModel()).getAsVector(modelRow);
        Color color = null;
        if (vector != null && MetadataUtil.getBoolean(vector, "Text Color Visible")) {
            Object value = vector.getValue(column);
            color = (Color)this.heatMapPanel.getProject().getColumnColorModel().getMappedValue(vector, value);
        }
        if (color == null) {
            color = Color.BLACK;
        }
        JComponent jc = (JComponent)c;
        jc.setForeground(color);
        jc.setBackground(Color.WHITE);
        jc.setBorder(null);
        if (this.heatMapPanel.getQuickColumnSearch().isHighlighted(column)) {
            jc.setBorder(BorderFactory.createLineBorder(UIUtil.HIGHLIGHT_COLOR, 1));
        }
        if (((HeatMapColumnTableModel)this.getModel()).getProject().getColumnSelectionModel().isViewIndexSelected(column)) {
            jc.setBackground(UIUtil.SELECTION_COLOR);
        }
        return c;
    }

    public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.equals(ZoomActions.ZOOM_IN_ROWS_KEY_STROKE) || ks.equals(ZoomActions.ZOOM_IN_COLUMNS_KEY_STROKE) || ks.equals(ZoomActions.ZOOM_OUT_ROWS_KEY_STROKE) || ks.equals(ZoomActions.ZOOM_OUT_COLUMNS_KEY_STROKE) || ks.equals(ZoomInAction.ZOOM_IN_KEY_STROKE) || ks.equals(ZoomOutAction.ZOOM_OUT_KEY_STROKE)) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger() && this.heatMapPanel.getColumnPopupMenu() != null) {
            this.heatMapPanel.getColumnPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        } else {
            super.processMouseEvent(e);
        }
    }

    public void setMouseMovedElement(MatrixElement mouseMovedElement) {
        this.mouseMovedElement = mouseMovedElement;
    }
}

