/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.table.HeatMapRowTableModel;
import org.broadinstitute.genee.table.TableDrawer;

public class HeatMapRowTableDrawer
extends TableDrawer {
    private HeatMapRowTableModel model;
    private SizesAndPositions sizesAndPositions;

    public HeatMapRowTableDrawer(JTable table, SizesAndPositions sizesAndPositions, int maximumCharactersClip) {
        super(table);
        this.model = (HeatMapRowTableModel)table.getModel();
        this.sizesAndPositions = sizesAndPositions;
        this.setMaximumCharactersClip(maximumCharactersClip);
        this.init();
    }

    @Override
    protected Color getColor(int row, int column) {
        Vector vector = this.model.getAsVector(column);
        Color color = null;
        if (vector != null && MetadataUtil.getBoolean(vector, "Text Color Visible")) {
            color = (Color)this.model.getProject().getRowColorModel().getMappedValue(vector, this.model.getValueAt(row, column));
        }
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    @Override
    protected float getPosition(int row) {
        return this.sizesAndPositions.getPosition(row);
    }

    @Override
    protected float getRowSize() {
        return this.sizesAndPositions.getSize();
    }

    @Override
    protected int getRowEnd(Rectangle clip) {
        return HeatMapElementPanel.getBottom(this.sizesAndPositions.getLength(), clip, this.sizesAndPositions);
    }

    @Override
    protected int getRowStart(Rectangle clip) {
        return HeatMapElementPanel.getTop(this.sizesAndPositions.getLength(), clip, this.sizesAndPositions);
    }
}

