/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class IconAdapter
implements Icon {
    private Icon image;
    private int sortIndex;

    public IconAdapter(Icon image, int sortIndex) {
        this.image = image;
        this.sortIndex = sortIndex;
    }

    @Override
    public int getIconHeight() {
        return this.image.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.image.getIconWidth() + 10;
    }

    public Icon getIcon() {
        return this.image;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.image.paintIcon(c, g, x, y);
        g.setColor(Color.BLACK);
        FontMetrics fm = ((Graphics2D)g).getFontMetrics();
        Font font = g.getFont();
        g.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        g.drawString(String.valueOf(this.sortIndex + 1), x + this.image.getIconWidth() + 1, y + fm.getHeight() / 2);
        g.setFont(font);
    }

    public void setImage(Icon image) {
        this.image = image;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }
}

