/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.broadinstitute.genee.heatmap.AbstractIndexedQuickSearch;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.table.FilterableTableModel;

public abstract class TableFilterField
extends AbstractIndexedQuickSearch {
    private String[] additionalFilterColumnNames;
    private FilterableTableModel model;

    public TableFilterField(FilterableTableModel model, String[] additionalFilterColumnNames) {
        this.model = model;
        this.additionalFilterColumnNames = additionalFilterColumnNames;
    }

    @Override
    protected LuceneSearchParser.SearchPredicateAdapterCreator createSearchPredicateAdapterCreator() {
        return new LuceneSearchParser.SearchPredicateAdapterCreator(){

            @Override
            public LuceneSearchParser.IndexedSearchPredicate create(LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
                return new LuceneSearchParser.FilterableTableModelSearchPredicateAdapter(internalSearchPredicate);
            }
        };
    }

    @Override
    protected Collection<String> getAvailableFieldNames() {
        ArrayList<String> availableFieldNames = new ArrayList<String>();
        int cols = this.model.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            if (!String.class.isAssignableFrom(this.model.getColumnClass(j)) && !Number.class.isAssignableFrom(this.model.getColumnClass(j))) continue;
            String name = this.model.getColumnName(j);
            availableFieldNames.add(name);
        }
        if (this.additionalFilterColumnNames != null) {
            availableFieldNames.addAll(Arrays.asList(this.additionalFilterColumnNames));
        }
        return availableFieldNames;
    }

    @Override
    protected void notifyFilterChanged() {
        this.model.setFilter(this.searchPredicate);
        if (this.searchPredicate == null) {
            this.clearLabelText();
        } else {
            int matches = this.model.getRowCount();
            int available = this.model.getOriginalRowCount();
            this.setLabelText(matches, available);
        }
    }
}

