/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import com.jidesoft.grid.TableUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.gui.BrowserLauncher;
import org.broadinstitute.genee.heatmap.SparklineTableCellRenderer;
import org.broadinstitute.genee.heatmap.URLTableCellRenderer;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.stats.Sorting;
import org.broadinstitute.genee.table.AbstractComparableSortableHeaderRenderer;
import org.broadinstitute.genee.table.FilterableTableModel;
import org.broadinstitute.genee.table.JideLabelTableCellRenderer;
import org.broadinstitute.genee.table.LinkTextPair;
import org.broadinstitute.genee.table.SortKey;
import org.broadinstitute.genee.table.SortingHelper;
import org.broadinstitute.genee.table.TableColumnSortKey;

public class TableUtil {
    private TableUtil() {
    }

    public static void addHandCursorMouseMotionListener(final JTable table, final Class<?> c) {
        table.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int columnIndex = table.convertColumnIndexToModel(table.columnAtPoint(e.getPoint()));
                if (columnIndex >= 0 && columnIndex <= table.getColumnCount() && c.isAssignableFrom(table.getModel().getColumnClass(columnIndex))) {
                    int rowIndex = table.convertRowIndexToModel(table.rowAtPoint(e.getPoint()));
                    Object value = table.getModel().getValueAt(rowIndex, columnIndex);
                    if (value != null) {
                        table.setCursor(Cursor.getPredefinedCursor(12));
                        return;
                    }
                }
                table.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public static void addURLMouseListener(final JTable table, final Class<?> c) {
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object value;
                int rowIndex;
                int columnIndex = table.convertColumnIndexToModel(table.columnAtPoint(event.getPoint()));
                if (c.isAssignableFrom(table.getColumnClass(columnIndex)) && (rowIndex = table.rowAtPoint(event.getPoint())) >= 0 && rowIndex < table.getRowCount() && (value = table.getValueAt(rowIndex, columnIndex)) != null) {
                    String url = null;
                    if (value instanceof URL) {
                        url = value.toString();
                    } else if (value instanceof LinkTextPair) {
                        url = ((LinkTextPair)value).getUrl();
                    }
                    if (url != null) {
                        BrowserLauncher.openURL(url);
                    }
                }
            }
        });
    }

    public static int getColumnCount(TableModel tableModel, Class<?> c) {
        int count = 0;
        int cols = tableModel.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            if (!c.isAssignableFrom(tableModel.getColumnClass(j))) continue;
            ++count;
        }
        return count;
    }

    public static String[] getColumnNames(JTable table, Class<?> c) {
        ArrayList<String> names = new ArrayList<String>();
        TableModel tableModel = table.getModel();
        for (int j = 0; j < tableModel.getColumnCount(); ++j) {
            if (tableModel.getColumnClass(j) != c) continue;
            names.add(tableModel.getColumnName(j));
        }
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        return names.toArray(new String[0]);
    }

    public static void setRenderers(JTable table, boolean isRows) {
        TableCellRenderer renderer;
        if (!isRows) {
            JideLabelTableCellRenderer labelTableCellRenderer = new JideLabelTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return super.getTableCellRendererComponent(table, Formatter.toString(value), isSelected, hasFocus, row, column);
                }
            };
            labelTableCellRenderer.setOrientation(1);
            labelTableCellRenderer.setClockwise(false);
            renderer = labelTableCellRenderer;
        } else {
            renderer = new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    this.setText(value == null ? "" : Formatter.toString(value));
                }
            };
        }
        table.setDefaultRenderer(Collection.class, renderer);
        table.setDefaultRenderer(Object.class, renderer);
        table.setDefaultRenderer(GeneSet.class, renderer);
        table.setDefaultRenderer(Integer.TYPE, renderer);
        table.setDefaultRenderer(Float.TYPE, renderer);
        table.setDefaultRenderer(Double.TYPE, renderer);
        table.setDefaultRenderer(Number.class, renderer);
        table.setDefaultRenderer(Float.class, renderer);
        table.setDefaultRenderer(Integer.class, renderer);
        table.setDefaultRenderer(Dataset.class, new SparklineTableCellRenderer());
        if (!GraphicsEnvironment.isHeadless()) {
            table.setDefaultRenderer(URL.class, new URLTableCellRenderer());
            try {
                if (UserUtil.isBroadUser()) {
                    Object mViewRenderer = Class.forName("chemaxon.marvin.beans.MViewRenderer").newInstance();
                    table.setDefaultRenderer(MoleculeUtil.getMoleculeClass(), (TableCellRenderer)mViewRenderer);
                    Object mViewEditor = Class.forName("chemaxon.marvin.beans.MViewEditor").newInstance();
                    table.setDefaultEditor(MoleculeUtil.getMoleculeClass(), (TableCellEditor)mViewEditor);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setSortable(JTable table, final FilterableTableModel filterTableModel) {
        AbstractComparableSortableHeaderRenderer sortableHeaderRenderer = new AbstractComparableSortableHeaderRenderer(table.getTableHeader(), false){

            @Override
            public SortKey createSortKey(String columnName) {
                return new TableColumnSortKey(columnName, filterTableModel.getActualModel());
            }

            @Override
            protected void clearSorting() {
                filterTableModel.setSortOrder(null, null);
            }

            @Override
            protected Comparable<?>[][] createComparableArray(List<? extends SortKey> sortKeys) {
                int rowCount = filterTableModel.getOriginalRowCount();
                int sortLevels = sortKeys.size();
                Comparable[][] items = new Comparable[rowCount][sortLevels];
                for (int sortLevel = 0; sortLevel < sortLevels; ++sortLevel) {
                    SortKey sortKey = sortKeys.get(sortLevel);
                    for (int i = 0; i < rowCount; ++i) {
                        items[i][sortLevel] = sortKey.getValue(i);
                    }
                }
                return items;
            }

            @Override
            protected List<? extends SortKey> getSortKeys() {
                return filterTableModel.getSortKeys();
            }

            @Override
            protected void setGroupBy(SortKey[] sortKey) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void setOrder(List<? extends SortKey> sortKeys) {
                for (SortKey sortKey : sortKeys) {
                    if (!(sortKey instanceof TableColumnSortKey)) continue;
                    ((TableColumnSortKey)sortKey).setColumnIndex();
                }
                Comparable<?>[][] items = this.createComparableArray(sortKeys);
                int[] nArray = Sorting.index(items, (Comparator)SortingHelper.createComparableArrayComparator(sortKeys), true);
                filterTableModel.setSortOrder(nArray, sortKeys);
            }
        };
        table.getTableHeader().setDefaultRenderer(sortableHeaderRenderer);
    }

    public static void sizeColumn(JTable table, TableColumn c) {
        try {
            int columnIndex = table.getColumnModel().getColumnIndex(c.getIdentifier());
            if ("#".equals(c.getIdentifier())) {
                c.setWidth(new JLabel((String)new StringBuilder().append((String)"").append((int)table.getRowCount()).toString()).getPreferredSize().width + 4);
                c.setPreferredWidth(c.getWidth());
            } else {
                TableModel model = table.getModel();
                TableCellRenderer renderer = table.getDefaultRenderer(model.getColumnClass(columnIndex));
                int width = 0;
                int nrows = Math.min(model.getRowCount(), 100);
                for (int i = 0; i < nrows; ++i) {
                    Object value = model.getValueAt(i, columnIndex);
                    Component comp = renderer.getTableCellRendererComponent(table, value, false, false, i, columnIndex);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
                if (width > 0) {
                    c.setWidth(width);
                    c.setPreferredWidth(width);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            System.err.println("Error setting " + c.getHeaderValue() + " width.");
        }
    }

    public static void sizeColumns(JTable table) {
        int[] widths = TableUtils.autoResizeAllColumns((JTable)table, (boolean)true);
        int cols = table.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            table.getColumnModel().getColumn(j).setWidth(widths[j]);
        }
    }
}

