/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.io.util.Formatter;

public abstract class VerticalTableDrawer
implements Drawable {
    private TableModel model;
    protected JTable table;
    private int height;
    private int width;
    private int[] stringWidth;

    public VerticalTableDrawer(JTable table) {
        this.model = table.getModel();
        this.table = table;
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        float size;
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.BLACK);
        g2.rotate(-1.5707963267948966);
        Font font = this.table.getFont();
        float fontSize = size = this.getSize();
        if (fontSize > 30.0f) {
            fontSize = 30.0f;
        }
        g2.setFont(font.deriveFont(0, fontSize));
        int descent = g2.getFontMetrics().getDescent();
        int y = 2;
        int colStart = this.getColumnStart(clip);
        int colEnd = this.getColumnEnd(clip);
        int rows = this.table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            y -= this.stringWidth[i];
            int modelRow = this.table.convertRowIndexToModel(i);
            for (int j = colStart; j < colEnd; ++j) {
                float x = this.getPosition(j) + size / 2.0f + (float)descent;
                int modelColumn = this.table.convertColumnIndexToModel(j);
                Object val = this.model.getValueAt(modelRow, modelColumn);
                if (val == null) continue;
                g2.setColor(this.getColor(modelRow, modelColumn));
                g2.drawString(Formatter.toString(val), (float)y, x);
            }
        }
        g2.rotate(1.5707963267948966);
    }

    @Override
    public Dimension getDrawableSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void init() {
        FontMetrics fm;
        Font font = this.table.getFont();
        float fontSize = this.getSize();
        if (fontSize > 30.0f) {
            fontSize = 30.0f;
        }
        if ((fm = this.table.getFontMetrics(font = font.deriveFont(0, fontSize))) == null) {
            BufferedImage image = new BufferedImage(2, 2, 5);
            Graphics g = image.getGraphics();
            g.setFont(font);
            fm = g.getFontMetrics();
            g.dispose();
        }
        int rowCount = this.table.getRowCount();
        this.width = 0;
        if (rowCount > 0 && this.table.getColumnCount() > 0) {
            Rectangle r = this.table.getCellRect(rowCount - 1, this.table.getColumnCount() - 1, true);
            this.width = r.x + r.width;
        }
        this.stringWidth = new int[this.model.getRowCount()];
        this.height = 2;
        if (this.model.getRowCount() > 0) {
            int rows = this.table.getRowCount();
            for (int i = 0; i < rows; ++i) {
                int modelRow = this.table.convertRowIndexToModel(i);
                int cols = this.table.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    int modelColumn = this.table.convertColumnIndexToModel(j);
                    Object s = this.model.getValueAt(modelRow, modelColumn);
                    if (s == null) continue;
                    this.stringWidth[i] = Math.max(this.stringWidth[i], fm.stringWidth(Formatter.toString(s)));
                }
                int n = i;
                this.stringWidth[n] = this.stringWidth[n] + 8;
                this.height += this.stringWidth[i];
            }
        }
    }

    protected Color getColor(int row, int column) {
        return Color.BLACK;
    }

    protected abstract int getColumnEnd(Rectangle var1);

    protected abstract int getColumnStart(Rectangle var1);

    protected abstract float getPosition(int var1);

    protected abstract float getSize();
}

