/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster;

import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.util.ConfMap;

public class Node {
    private ConfMap properties;
    private NodeList childNodes;
    private NodeValueList values;
    private int[] featuresIndexes;
    private int[] probesIndexes;

    public Node() {
        this(new NodeValueList());
    }

    public Node(NodeValueList values) {
        this(null, values);
    }

    public Node(NodeList nodeList, NodeValueList values) {
        this(nodeList, values, null);
    }

    public Node(NodeList nodeList, NodeValueList values, ConfMap map) {
        this.childNodes = nodeList;
        this.setProperties(map);
        this.setValues(values);
    }

    public Node(int[] featuresIndexes) {
        this.setFeaturesIndexes(featuresIndexes);
    }

    public ConfMap getProperties() {
        return this.properties;
    }

    public void setProperties(ConfMap map) {
        this.properties = map;
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new ConfMap();
        }
        this.properties.setProperty(name, value);
    }

    public NodeList getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(NodeList l) {
        this.childNodes = l;
    }

    public int[] getFeaturesIndexes() {
        return this.featuresIndexes;
    }

    public void setFeaturesIndexes(int[] idx) {
        this.featuresIndexes = idx;
    }

    public int[] getProbesIndexes() {
        return this.probesIndexes;
    }

    public void setProbesIndexes(int[] idx) {
        this.probesIndexes = idx;
    }

    public NodeValueList getValues() {
        return this.values;
    }

    public void setValues(NodeValueList values) {
        this.values = values;
    }
}

