/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm;

import javax.swing.event.EventListenerList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;

public abstract class AbstractAlgorithm
implements Algorithm {
    private EventListenerList listenerList = new EventListenerList();

    public static String getDistanceName(int function) {
        String functionName = "";
        switch (function) {
            case 0: {
                functionName = "Pearson correlation";
                break;
            }
            case 1: {
                functionName = "Pearson correlation";
                break;
            }
            case 2: {
                functionName = "Cosine correlation";
                break;
            }
            case 3: {
                functionName = "Covariance";
                break;
            }
            case 4: {
                functionName = "Euclidean";
                break;
            }
            case 5: {
                functionName = "Dot product";
                break;
            }
            case 6: {
                functionName = "Pearson uncentered";
                break;
            }
            case 7: {
                functionName = "Pearson squared";
                break;
            }
            case 8: {
                functionName = "Manhattan";
                break;
            }
            case 9: {
                functionName = "Spearman rank";
                break;
            }
            case 10: {
                functionName = "Kendall's Tau";
                break;
            }
            case 11: {
                functionName = "Mutual information";
                break;
            }
            default: {
                functionName = "Undefined";
            }
        }
        return functionName;
    }

    @Override
    public void addAlgorithmListener(AlgorithmListener l) {
        this.listenerList.add(AlgorithmListener.class, l);
    }

    @Override
    public void removeAlgorithmListener(AlgorithmListener l) {
        this.listenerList.remove(AlgorithmListener.class, l);
    }

    public void fireValueChanged(AlgorithmEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AlgorithmListener.class) continue;
            ((AlgorithmListener)listeners[i + 1]).valueChanged(event);
        }
    }
}

