/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import javax.swing.JOptionPane;
import org.tigr.util.FloatMatrix;

public class ExperimentUtil {
    public static float distance(FloatMatrix matrix, int e1, int e2, int function, float factor, boolean absolute) {
        float result = Float.NaN;
        switch (function) {
            case 1: {
                result = ExperimentUtil.pearson(matrix, e1, e2, factor);
                factor *= -1.0f;
                break;
            }
            case 2: {
                result = ExperimentUtil.cosine(matrix, e1, e2, factor);
                factor *= -1.0f;
                break;
            }
            case 3: {
                result = ExperimentUtil.covariance(matrix, e1, e2, factor);
                factor *= -1.0f;
                break;
            }
            case 4: {
                result = ExperimentUtil.euclidian(matrix, e1, e2, factor);
                break;
            }
            case 5: {
                result = ExperimentUtil.dotProduct(matrix, e1, e2, factor);
                factor *= -1.0f;
                break;
            }
            case 6: {
                result = ExperimentUtil.pearsonUncentered(matrix, e1, e2, factor);
                factor *= -1.0f;
                break;
            }
            case 7: {
                result = (float)Math.pow(ExperimentUtil.pearsonUncentered(matrix, e1, e2, factor), 2.0);
                factor *= -1.0f;
                break;
            }
            case 8: {
                result = ExperimentUtil.manhattan(matrix, e1, e2, factor);
                break;
            }
            case 9: {
                result = ExperimentUtil.spearmanRank(matrix, e1, e2, factor);
                factor *= -1.0f;
                break;
            }
            case 10: {
                result = ExperimentUtil.kendallsTau(matrix, e1, e2, factor);
                factor *= -1.0f;
                break;
            }
            case 11: {
                result = ExperimentUtil.mutualInformation(matrix, e1, e2, factor);
                break;
            }
        }
        if (absolute) {
            result = Math.abs(result);
        }
        return result * factor;
    }

    public static float geneDistance(FloatMatrix matrix, FloatMatrix M, int g1, int g2, int function, float factor, boolean absolute) {
        float result = Float.NaN;
        switch (function) {
            case 1: {
                result = ExperimentUtil.genePearson(matrix, M, g1, g2, factor);
                factor *= -1.0f;
                break;
            }
            case 2: {
                result = ExperimentUtil.geneCosine(matrix, M, g1, g2, factor);
                factor *= -1.0f;
                break;
            }
            case 3: {
                result = ExperimentUtil.geneCovariance(matrix, M, g1, g2, factor);
                factor *= -1.0f;
                break;
            }
            case 4: {
                result = ExperimentUtil.geneEuclidianDistance(matrix, M, g1, g2, factor);
                break;
            }
            case 5: {
                result = ExperimentUtil.geneDotProduct(matrix, M, g1, g2, factor);
                factor *= -1.0f;
                break;
            }
            case 6: {
                result = ExperimentUtil.genePearsonUncentered(matrix, M, g1, g2, factor);
                factor *= -1.0f;
                break;
            }
            case 7: {
                result = (float)Math.pow(ExperimentUtil.genePearsonUncentered(matrix, M, g1, g2, factor), 2.0) * factor;
                factor *= -1.0f;
                break;
            }
            case 8: {
                result = ExperimentUtil.geneManhattan(matrix, M, g1, g2, factor);
                break;
            }
            case 9: {
                result = ExperimentUtil.geneSpearmanRank(matrix, M, g1, g2, factor);
                factor *= -1.0f;
                break;
            }
            case 10: {
                result = ExperimentUtil.geneKendallsTau(matrix, M, g1, g2, factor);
                factor *= -1.0f;
                break;
            }
            case 11: {
                result = ExperimentUtil.geneMutualInformation(matrix, M, g1, g2, factor);
                break;
            }
        }
        if (absolute) {
            result = Math.abs(result);
        }
        return result * factor;
    }

    public static float genePearsonOld(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        int j;
        if (M == null) {
            M = matrix;
        }
        float TINY = Float.MIN_VALUE;
        double sxx = 0.0;
        double syy = 0.0;
        double sxy = 0.0;
        double ax = 0.0;
        double ay = 0.0;
        int k = matrix.getColumnDimension();
        int n = 0;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(g1, j)) || Float.isNaN(M.get(g2, j))) continue;
            ax += (double)matrix.get(g1, j);
            ay += (double)M.get(g2, j);
            ++n;
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(g1, j)) || Float.isNaN(M.get(g2, j))) continue;
            double xt = (double)matrix.get(g1, j) - ax;
            double yt = (double)M.get(g2, j) - ay;
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        return (float)(sxy / (Math.sqrt(sxx * syy) + (double)TINY) * (double)factor);
    }

    public static float genePearson(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        if (M == null) {
            M = matrix;
        }
        float[] arrX = matrix.A[g1];
        float[] arrY = M.A[g2];
        int nArrSize = matrix.getColumnDimension();
        double dblXY = 0.0;
        double dblX = 0.0;
        double dblXX = 0.0;
        double dblY = 0.0;
        double dblYY = 0.0;
        int iValidValCount = 0;
        for (int i = 0; i < nArrSize; ++i) {
            double v_1 = arrX[i];
            double v_2 = arrY[i];
            if (Double.isNaN(v_1) || Double.isNaN(v_2)) continue;
            ++iValidValCount;
            dblXY += v_1 * v_2;
            dblXX += v_1 * v_1;
            dblYY += v_2 * v_2;
            dblX += v_1;
            dblY += v_2;
        }
        if (iValidValCount == 0) {
            return 0.0f;
        }
        boolean nonFlat = false;
        for (int j = 1; j < nArrSize; ++j) {
            if (Float.isNaN(arrX[j]) || Float.isNaN(arrY[j])) continue;
            if (arrX[j] != arrX[j - 1]) {
                nonFlat = true;
                break;
            }
            if (arrY[j] == arrY[j - 1]) continue;
            nonFlat = true;
            break;
        }
        if (!nonFlat) {
            return 1.0f;
        }
        double dblAvgX = dblX / (double)iValidValCount;
        double dblAvgY = dblY / (double)iValidValCount;
        double dblUpper = dblXY - dblX * dblAvgY - dblAvgX * dblY + dblAvgX * dblAvgY * (double)iValidValCount;
        double p1 = dblXX - dblAvgX * dblX * 2.0 + dblAvgX * dblAvgX * (double)iValidValCount;
        double p2 = dblYY - dblAvgY * dblY * 2.0 + dblAvgY * dblAvgY * (double)iValidValCount;
        double dblLower = p1 * p2;
        return (float)(dblUpper / (Math.sqrt(dblLower) + Double.MIN_VALUE) * (double)factor);
    }

    public static float geneCosine(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        if (M == null) {
            M = matrix;
        }
        double sxy = 0.0;
        double sxx = 0.0;
        double syy = 0.0;
        double tx = 0.0;
        double ty = 0.0;
        int k = matrix.getColumnDimension();
        int n = 0;
        for (int j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(g1, j)) || Float.isNaN(M.get(g2, j))) continue;
            tx = matrix.get(g1, j);
            ty = M.get(g2, j);
            sxy += tx * ty;
            sxx += tx * tx;
            syy += ty * ty;
            ++n;
        }
        return (float)(sxy / (Math.sqrt(sxx) * Math.sqrt(syy)) * (double)factor);
    }

    public static float geneCovariance(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        int j;
        if (M == null) {
            M = matrix;
        }
        double sxy = 0.0;
        double ax = 0.0;
        double ay = 0.0;
        int k = matrix.getColumnDimension();
        int n = 0;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(g1, j)) || Float.isNaN(M.get(g2, j))) continue;
            ax += (double)matrix.get(g1, j);
            ay += (double)M.get(g2, j);
            ++n;
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(g1, j)) || Float.isNaN(M.get(g2, j))) continue;
            double xt = (double)matrix.get(g1, j) - ax;
            double yt = (double)M.get(g2, j) - ay;
            sxy += xt * yt;
        }
        return (float)(sxy / ((double)(n - 1) * 1.0) * (double)factor);
    }

    public static float geneEuclidianDistance(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        if (M == null) {
            M = matrix;
        }
        int k = matrix.getColumnDimension();
        int n = 0;
        double sum = 0.0;
        for (int i = 0; i < k; ++i) {
            if (Float.isNaN(matrix.get(g1, i)) || Float.isNaN(M.get(g2, i))) continue;
            sum += Math.pow(matrix.get(g1, i) - M.get(g2, i), 2.0);
            ++n;
        }
        return (float)(Math.sqrt(sum) * (double)factor);
    }

    public static float geneDotProduct(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        if (M == null) {
            M = matrix;
        }
        int k = matrix.getColumnDimension();
        int n = 0;
        double sum = 0.0;
        for (int i = 0; i < k; ++i) {
            if (Float.isNaN(matrix.get(g1, i)) || Float.isNaN(M.get(g2, i))) continue;
            sum += (double)(matrix.get(g1, i) * M.get(g2, i));
            ++n;
        }
        return (float)(sum / (double)n * (double)factor);
    }

    public static float genePearsonUncentered(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        int j;
        if (M == null) {
            M = matrix;
        }
        float TINY = Float.MIN_VALUE;
        double sxx = 0.0;
        double syy = 0.0;
        double sxy = 0.0;
        double ax = 0.0;
        double ay = 0.0;
        int k = matrix.getColumnDimension();
        int n = 0;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(g1, j)) || Float.isNaN(M.get(g2, j))) continue;
            ax += (double)matrix.get(g1, j);
            ay += (double)M.get(g2, j);
            ++n;
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(g1, j)) || Float.isNaN(M.get(g2, j))) continue;
            double xt = matrix.get(g1, j);
            double yt = M.get(g2, j);
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        return (float)(sxy / (Math.sqrt(sxx * syy) + (double)TINY) * (double)factor);
    }

    public static float geneManhattan(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        if (M == null) {
            M = matrix;
        }
        double sum = 0.0;
        int n = matrix.getColumnDimension();
        for (int j = 0; j < n; ++j) {
            if (Float.isNaN(matrix.get(g1, j)) || Float.isNaN(M.get(g2, j))) continue;
            sum += (double)Math.abs(matrix.get(g1, j) - matrix.get(g2, j));
        }
        return (float)(sum * (double)factor);
    }

    public static float geneSpearmanRank(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        int j;
        if (M == null) {
            M = matrix;
        }
        int n = matrix.getColumnDimension();
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (j = 0; j < n; ++j) {
            wksp1[j] = matrix.get(g1, j);
            wksp2[j] = M.get(g2, j);
        }
        ExperimentUtil.sort2(wksp1, wksp2);
        double sf = ExperimentUtil.crank(wksp1);
        ExperimentUtil.sort2(wksp2, wksp1);
        double sg = ExperimentUtil.crank(wksp2);
        double d = 0.0;
        for (j = 0; j < n; ++j) {
            d += Math.pow(wksp1[j] - wksp2[j], 2.0);
        }
        double en = n;
        double en3n = en * en * en - en;
        double aved = en3n / 6.0 - (sf + sg) / 12.0;
        double fac = (1.0 - sf / en3n) * (1.0 - sg / en3n);
        double vard = (en - 1.0) * en * en * Math.pow(en + 1.0, 2.0) / 36.0 * fac;
        return (float)((1.0 - 6.0 / en3n * (d + (sf + sg) / 12.0)) / Math.sqrt(fac) * (double)factor);
    }

    public static float geneKendallsTau(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        if (M == null) {
            M = matrix;
        }
        float TINY = Float.MIN_VALUE;
        int n = matrix.getColumnDimension();
        int n2 = 0;
        int n1 = 0;
        int is = 0;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a2;
                double a1 = matrix.get(g1, j) - matrix.get(g1, k);
                double aa = a1 * (a2 = (double)(M.get(g2, j) - M.get(g2, k)));
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        return (float)((double)is / (Math.sqrt(n1) * Math.sqrt(n2) + (double)TINY) * (double)factor);
    }

    public static float geneMutualInformation(FloatMatrix matrix, FloatMatrix M, int g1, int g2, float factor) {
        int i;
        if (M == null) {
            M = matrix;
        }
        int n = M.getColumnDimension();
        int NumberOfBins = (int)Math.floor(Math.log(n) / Math.log(2.0));
        int Values2 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            if (Float.isNaN(matrix.get(g1, i2)) || Float.isNaN(M.get(g2, i2))) continue;
            ++Values2;
        }
        FloatMatrix Gene1Array = new FloatMatrix(Values2, 1);
        FloatMatrix Gene2Array = new FloatMatrix(Values2, 1);
        int k = 0;
        for (int i3 = 0; i3 < n; ++i3) {
            if (Float.isNaN(matrix.get(g1, i3)) || Float.isNaN(matrix.get(g2, i3))) continue;
            Gene1Array.set(k, 0, matrix.get(g1, i3));
            Gene2Array.set(k, 0, M.get(g2, i3));
            ++k;
        }
        n = Values2;
        ExperimentUtil.makeDigitalExperiment(Gene1Array, 0);
        ExperimentUtil.makeDigitalExperiment(Gene2Array, 0);
        double[] P1 = new double[NumberOfBins];
        double[] P2 = new double[NumberOfBins];
        double[][] P12 = new double[NumberOfBins][NumberOfBins];
        for (i = 0; i < n; ++i) {
            int n2 = (int)Gene1Array.get(0, i) - 1;
            P1[n2] = P1[n2] + 1.0;
            int n3 = (int)Gene2Array.get(0, i) - 1;
            P2[n3] = P2[n3] + 1.0;
            double[] dArray = P12[(int)Gene1Array.get(0, i) - 1];
            int n4 = (int)Gene2Array.get(0, i) - 1;
            dArray[n4] = dArray[n4] + 1.0;
        }
        for (i = 0; i < P1.length; ++i) {
            int n5 = i;
            P1[n5] = P1[n5] / (double)n;
            int n6 = i;
            P2[n6] = P2[n6] / (double)n;
            int j = 0;
            while (j < P1.length) {
                double[] dArray = P12[i];
                int n7 = j++;
                dArray[n7] = dArray[n7] / (double)n;
            }
        }
        double H1 = 0.0;
        double H2 = 0.0;
        double H12 = 0.0;
        double MI = 0.0;
        for (int i4 = 0; i4 < P1.length; ++i4) {
            if (P1[i4] != 0.0) {
                H1 += P1[i4] * Math.log(P1[i4]) / Math.log(2.0);
            }
            if (P2[i4] != 0.0) {
                H2 += P2[i4] * Math.log(P2[i4]) / Math.log(2.0);
            }
            for (int j = 0; j < P2.length; ++j) {
                if (P12[i4][j] == 0.0) continue;
                H12 += P12[i4][j] * Math.log(P12[i4][j]) / Math.log(2.0);
            }
        }
        H1 = -H1;
        H2 = -H2;
        H12 = -H12;
        MI = (H1 + H2 - H12) / Math.max(H1, H2);
        return (float)((1.0 - MI) * (double)factor);
    }

    public static float pearson(FloatMatrix matrix, int e1, int e2, float factor) {
        int j;
        float TINY = Float.MIN_VALUE;
        double sxx = 0.0;
        double syy = 0.0;
        double sxy = 0.0;
        double ax = 0.0;
        double ay = 0.0;
        int k = matrix.getRowDimension();
        int n = 0;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(j, e1)) || Float.isNaN(matrix.get(j, e2))) continue;
            ax += (double)matrix.get(j, e1);
            ay += (double)matrix.get(j, e2);
            ++n;
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(j, e1)) || Float.isNaN(matrix.get(j, e2))) continue;
            double xt = (double)matrix.get(j, e1) - ax;
            double yt = (double)matrix.get(j, e2) - ay;
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        return (float)(sxy / (Math.sqrt(sxx * syy) + (double)TINY) * (double)factor);
    }

    public static float cosine(FloatMatrix matrix, int e1, int e2, float factor) {
        double sxy = 0.0;
        double sxx = 0.0;
        double syy = 0.0;
        double tx = 0.0;
        double ty = 0.0;
        int k = matrix.getRowDimension();
        for (int j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(j, e1)) || Float.isNaN(matrix.get(j, e2))) continue;
            tx = matrix.get(j, e1);
            ty = matrix.get(j, e2);
            sxy += tx * ty;
            sxx += tx * tx;
            syy += ty * ty;
        }
        return (float)(sxy / (Math.sqrt(sxx) * Math.sqrt(syy)) * (double)factor);
    }

    public static float covariance(FloatMatrix matrix, int e1, int e2, float factor) {
        int j;
        double sxy = 0.0;
        double ax = 0.0;
        double ay = 0.0;
        int k = matrix.getRowDimension();
        int n = 0;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(j, e1)) || Float.isNaN(matrix.get(j, e2))) continue;
            ax += (double)matrix.get(j, e1);
            ay += (double)matrix.get(j, e2);
            ++n;
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(j, e1)) || Float.isNaN(matrix.get(j, e2))) continue;
            double xt = (double)matrix.get(j, e1) - ax;
            double yt = (double)matrix.get(j, e2) - ay;
            sxy += xt * yt;
        }
        return (float)(sxy / (double)((float)(n - 1) * 1.0f) * (double)factor);
    }

    public static float euclidian(FloatMatrix matrix, int e1, int e2, float factor) {
        int n = matrix.getRowDimension();
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Float.isNaN(matrix.get(i, e1)) || Float.isNaN(matrix.get(i, e2))) continue;
            sum += Math.pow(matrix.get(i, e1) - matrix.get(i, e2), 2.0);
        }
        return (float)(Math.sqrt(sum) * (double)factor);
    }

    public static float dotProduct(FloatMatrix matrix, int e1, int e2, float factor) {
        int k = matrix.getRowDimension();
        double sum = 0.0;
        int n = 0;
        for (int i = 0; i < k; ++i) {
            if (Float.isNaN(matrix.get(i, e1)) || Float.isNaN(matrix.get(i, e2))) continue;
            sum += (double)(matrix.get(i, e1) * matrix.get(i, e2));
            ++n;
        }
        return (float)(sum / (double)n * (double)factor);
    }

    public static float pearsonUncentered(FloatMatrix matrix, int e1, int e2, float factor) {
        int j;
        float TINY = Float.MIN_VALUE;
        double sxx = 0.0;
        double syy = 0.0;
        double sxy = 0.0;
        double ax = 0.0;
        double ay = 0.0;
        int k = matrix.getRowDimension();
        int n = 0;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(j, e1)) || Float.isNaN(matrix.get(j, e2))) continue;
            ax += (double)matrix.get(j, e1);
            ay += (double)matrix.get(j, e2);
            ++n;
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < k; ++j) {
            if (Float.isNaN(matrix.get(j, e1)) || Float.isNaN(matrix.get(j, e2))) continue;
            double xt = matrix.get(j, e1);
            double yt = matrix.get(j, e2);
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        return (float)(sxy / (Math.sqrt(sxx * syy) + (double)TINY) * (double)factor);
    }

    public static float manhattan(FloatMatrix matrix, int e1, int e2, float factor) {
        double sum = 0.0;
        int n = matrix.getRowDimension();
        for (int j = 0; j < n; ++j) {
            if (Float.isNaN(matrix.get(j, e1)) || Float.isNaN(matrix.get(j, e2))) continue;
            sum += (double)Math.abs(matrix.get(j, e1) - matrix.get(j, e2));
        }
        return (float)(sum * (double)factor);
    }

    public static float spearmanRank(FloatMatrix matrix, int e1, int e2, float factor) {
        int j;
        int n = matrix.getRowDimension();
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (j = 0; j < n; ++j) {
            wksp1[j] = matrix.get(j, e1);
            wksp2[j] = matrix.get(j, e2);
        }
        ExperimentUtil.sort2(wksp1, wksp2);
        double sf = ExperimentUtil.crank(wksp1);
        ExperimentUtil.sort2(wksp2, wksp1);
        double sg = ExperimentUtil.crank(wksp2);
        double d = 0.0;
        for (j = 0; j < n; ++j) {
            d += Math.pow(wksp1[j] - wksp2[j], 2.0);
        }
        double en = n;
        double en3n = en * en * en - en;
        double aved = en3n / 6.0 - (sf + sg) / 12.0;
        double fac = (1.0 - sf / en3n) * (1.0 - sg / en3n);
        double vard = (en - 1.0) * en * en * Math.pow(en + 1.0, 2.0) / 36.0 * fac;
        return (float)((1.0 - 6.0 / en3n * (d + (sf + sg) / 12.0)) / Math.sqrt(fac) * (double)factor);
    }

    public static float kendallsTau(FloatMatrix matrix, int e1, int e2, float factor) {
        float TINY = Float.MIN_VALUE;
        int n = matrix.getRowDimension();
        int n2 = 0;
        int n1 = 0;
        int is = 0;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a2;
                double a1 = matrix.get(j, e1) - matrix.get(k, e1);
                double aa = a1 * (a2 = (double)(matrix.get(j, e2) - matrix.get(k, e2)));
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        return (float)((double)is / (Math.sqrt(n1) * Math.sqrt(n2) + (double)TINY) * (double)factor);
    }

    public static float mutualInformation(FloatMatrix matrix, int e1, int e2, float factor) {
        int i;
        int n = matrix.getRowDimension();
        int NumberOfBins = (int)Math.floor(Math.log(n) / Math.log(2.0));
        int Values2 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            if (Float.isNaN(matrix.get(i2, e1)) || Float.isNaN(matrix.get(i2, e2))) continue;
            ++Values2;
        }
        FloatMatrix Experiment1Array = new FloatMatrix(1, Values2);
        FloatMatrix Experiment2Array = new FloatMatrix(1, Values2);
        int k = 0;
        for (int i3 = 0; i3 < n; ++i3) {
            if (Float.isNaN(matrix.get(i3, e1)) || Float.isNaN(matrix.get(i3, e2))) continue;
            Experiment1Array.set(k, 0, matrix.get(i3, e1));
            Experiment2Array.set(k, 0, matrix.get(i3, e2));
            ++k;
        }
        n = Values2;
        ExperimentUtil.makeDigitalExperiment(Experiment1Array, 0);
        ExperimentUtil.makeDigitalExperiment(Experiment2Array, 0);
        double[] P1 = new double[NumberOfBins];
        double[] P2 = new double[NumberOfBins];
        double[][] P12 = new double[NumberOfBins][NumberOfBins];
        for (i = 0; i < n; ++i) {
            int n2 = (int)Experiment1Array.get(i, 0) - 1;
            P1[n2] = P1[n2] + 1.0;
            int n3 = (int)Experiment2Array.get(i, 0) - 1;
            P2[n3] = P2[n3] + 1.0;
            double[] dArray = P12[(int)Experiment1Array.get(i, 0) - 1];
            int n4 = (int)Experiment2Array.get(i, 0) - 1;
            dArray[n4] = dArray[n4] + 1.0;
        }
        for (i = 0; i < P1.length; ++i) {
            int n5 = i;
            P1[n5] = P1[n5] / (double)n;
            int n6 = i;
            P2[n6] = P2[n6] / (double)n;
            int j = 0;
            while (j < P1.length) {
                double[] dArray = P12[i];
                int n7 = j++;
                dArray[n7] = dArray[n7] / (double)n;
            }
        }
        double H1 = 0.0;
        double H2 = 0.0;
        double H12 = 0.0;
        double MI = 0.0;
        for (int i4 = 0; i4 < P1.length; ++i4) {
            if (P1[i4] != 0.0) {
                H1 += P1[i4] * Math.log(P1[i4]) / Math.log(2.0);
            }
            if (P2[i4] != 0.0) {
                H2 += P2[i4] * Math.log(P2[i4]) / Math.log(2.0);
            }
            for (int j = 0; j < P2.length; ++j) {
                if (P12[i4][j] == 0.0) continue;
                H12 += P12[i4][j] * Math.log(P12[i4][j]) / Math.log(2.0);
            }
        }
        H1 = -H1;
        H2 = -H2;
        H12 = -H12;
        MI = Math.max(H1, H2) != 0.0 ? (H1 + H2 - H12) / Math.max(H1, H2) : H1 + H2 - H12;
        return (float)((1.0 - MI) * (double)factor);
    }

    public static void makeDigitalExperiment(FloatMatrix matrix, int e) {
        int i;
        int n = matrix.getRowDimension();
        int NumberOfBins = (int)Math.floor(Math.log(n) / Math.log(2.0));
        int Step = 1000000 / NumberOfBins;
        float Minimum = Float.MAX_VALUE;
        float Maximum = 0.0f;
        for (i = 0; i < n; ++i) {
            if (!(matrix.get(i, e) < Minimum)) continue;
            Minimum = matrix.get(i, e);
        }
        for (i = 0; i < n; ++i) {
            matrix.set(i, e, matrix.get(i, e) - Minimum);
        }
        for (i = 0; i < n; ++i) {
            if (!(matrix.get(i, e) > Maximum)) continue;
            Maximum = matrix.get(i, e);
        }
        if (Maximum != 0.0f) {
            for (i = 0; i < n; ++i) {
                matrix.set(i, e, matrix.get(i, e) / Maximum);
            }
        }
        for (i = 0; i < n; ++i) {
            if ((double)matrix.get(i, e) == 1.0) {
                matrix.set(i, e, NumberOfBins);
                continue;
            }
            matrix.set(i, e, (float)(Math.floor(matrix.get(i, e) * 1000000.0f / (float)Step) + 1.0));
        }
    }

    public static int javaHCLMemoryAssess(int n, boolean ordered) {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long totalFreeMemory = freeMemory + (maxMemory - allocatedMemory);
        int maxGenes = (int)(Math.sqrt(totalFreeMemory / 1024L * 256L) * Math.sqrt(2.0));
        String opt = " ";
        if (ordered) {
            maxGenes = (int)(Math.sqrt(totalFreeMemory / 1024L * 256L) / Math.sqrt(2.0));
            opt = " optimized ";
        }
        Object[] optionInfo = new Object[]{"INFO", "OK"};
        if (maxGenes < n) {
            int option = JOptionPane.showOptionDialog(null, "Java does not currently have enough memory to run this analysis.\nFree memory: " + freeMemory / 1024L + " kb" + "\n" + "Allocated memory: " + allocatedMemory / 1024L + " kb" + "\n" + "Max memory: " + maxMemory / 1024L + " kb" + "\n" + "Total free memory: " + totalFreeMemory / 1024L + " kb" + "\n" + "Your system can handle up to " + maxGenes + " genes for" + opt + "Hierarchical Clustering." + "\n" + "You are attempting to run " + n + " genes." + "\n" + "----------------------------------------------------------------------------------" + "\n" + "Click 'INFO' for instructions on increasing your Java memory.", "Not Enough Java Memory Error", -1, 2, null, optionInfo, optionInfo[0]);
            if (option == 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static double crank(double[] w) {
        int j = 0;
        double s = 0.0;
        int n = w.length;
        while (j < n - 1) {
            int jt;
            if (w[j + 1] != w[j]) {
                w[j] = j;
                ++j;
                continue;
            }
            for (jt = j + 1; jt < n && w[jt] == w[j]; ++jt) {
            }
            double rank = 0.5 * (double)(j + jt - 1);
            for (int ji = j; ji <= jt - 1; ++ji) {
                w[ji] = rank;
            }
            double t = jt - j;
            s += t * t * t - t;
            j = jt;
        }
        if (j == n - 1) {
            w[n - 1] = n - 1;
        }
        return s;
    }

    public static void sort2(double[] arr, double[] brr) {
        int n = arr.length;
        int ir = n - 1;
        int l = 0;
        int jstack = 0;
        int[] istack = new int[50];
        while (true) {
            int i;
            double b;
            double a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && !(arr[i] <= a); --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack == 0) {
                    istack = null;
                    return;
                }
                ir = istack[jstack];
                l = istack[jstack - 1];
                jstack -= 2;
                continue;
            }
            int k = l + ir >> 1;
            double dummy = arr[k];
            arr[k] = arr[l + 1];
            arr[l + 1] = dummy;
            dummy = brr[k];
            brr[k] = brr[l + 1];
            brr[l + 1] = dummy;
            if (arr[l] > arr[ir]) {
                dummy = arr[l];
                arr[l] = arr[ir];
                arr[ir] = dummy;
                dummy = brr[l];
                brr[l] = brr[ir];
                brr[ir] = dummy;
            }
            if (arr[l + 1] > arr[ir]) {
                dummy = arr[l + 1];
                arr[l + 1] = arr[ir];
                arr[ir] = dummy;
                dummy = brr[l + 1];
                brr[l + 1] = brr[ir];
                brr[ir] = dummy;
            }
            if (arr[l] > arr[l + 1]) {
                dummy = arr[l];
                arr[l] = arr[l + 1];
                arr[l + 1] = dummy;
                dummy = brr[l];
                brr[l] = brr[l + 1];
                brr[l + 1] = dummy;
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                dummy = arr[i];
                arr[i] = arr[j];
                arr[j] = dummy;
                dummy = brr[i];
                brr[i] = brr[j];
                brr[j] = dummy;
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) > 50) {
                System.out.println("NSTACK too small in sort2.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort2(float[] arr, float[] brr) {
        int n = arr.length;
        int ir = n - 1;
        int l = 0;
        int jstack = 0;
        int[] istack = new int[50];
        while (true) {
            int i;
            float b;
            float a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && !(arr[i] <= a); --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack == 0) {
                    istack = null;
                    return;
                }
                ir = istack[jstack];
                l = istack[jstack - 1];
                jstack -= 2;
                continue;
            }
            int k = l + ir >> 1;
            float dummy = arr[k];
            arr[k] = arr[l + 1];
            arr[l + 1] = dummy;
            dummy = brr[k];
            brr[k] = brr[l + 1];
            brr[l + 1] = dummy;
            if (arr[l] > arr[ir]) {
                dummy = arr[l];
                arr[l] = arr[ir];
                arr[ir] = dummy;
                dummy = brr[l];
                brr[l] = brr[ir];
                brr[ir] = dummy;
            }
            if (arr[l + 1] > arr[ir]) {
                dummy = arr[l + 1];
                arr[l + 1] = arr[ir];
                arr[ir] = dummy;
                dummy = brr[l + 1];
                brr[l + 1] = brr[ir];
                brr[ir] = dummy;
            }
            if (arr[l] > arr[l + 1]) {
                dummy = arr[l];
                arr[l] = arr[l + 1];
                arr[l + 1] = dummy;
                dummy = brr[l];
                brr[l] = brr[l + 1];
                brr[l + 1] = dummy;
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                dummy = arr[i];
                arr[i] = arr[j];
                arr[j] = dummy;
                dummy = brr[i];
                brr[i] = brr[j];
                brr[j] = dummy;
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) > 50) {
                System.out.println("NSTACK too small in sort2.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }
}

