/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class KMC
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private int number_of_genes;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    private boolean calculateMeans;
    private int iterations;
    private boolean converged;
    private boolean kmcGenes;
    private int validN;
    private int hcl_function;
    private boolean hcl_absolute;
    int[] clusterConvergence;

    @Override
    public void abort() {
        this.stop = true;
    }

    @Override
    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        KMCluster[] clusters;
        AlgorithmParameters map = data.getParams();
        this.function = map.getInt("distance-function", 4);
        this.factor = map.getFloat("distance-factor", 1.0f);
        this.absolute = map.getBoolean("distance-absolute", false);
        this.calculateMeans = map.getBoolean("calculate-means", true);
        this.kmcGenes = map.getBoolean("kmc-cluster-genes", true);
        this.hcl_function = map.getInt("hcl-distance-function", 4);
        this.hcl_absolute = map.getBoolean("hcl-distance-absolute", false);
        int number_of_iterations = map.getInt("number-of-iterations", 0);
        int number_of_clusters = map.getInt("number-of-clusters", 0);
        boolean hierarchical_tree = map.getBoolean("hierarchical-tree", false);
        int method_linkage = map.getInt("method-linkage", 0);
        boolean calculate_genes = map.getBoolean("calculate-genes", false);
        boolean calculate_experiments = map.getBoolean("calculate-experiments", false);
        this.expMatrix = data.getMatrix("experiment");
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        this.clusterConvergence = new int[number_of_clusters];
        FloatMatrix means = null;
        FloatMatrix medians = null;
        FloatMatrix variances = null;
        if (this.calculateMeans) {
            clusters = this.calculate(this.number_of_genes, number_of_clusters, number_of_iterations);
            means = this.getMeans(clusters);
            variances = this.getVariances(clusters, means);
        } else {
            clusters = this.calculateMedians(this.number_of_genes, number_of_clusters, number_of_iterations);
            medians = this.getMedians(clusters);
            variances = this.getVariances(clusters, medians);
        }
        float[] tempConv = new float[this.clusterConvergence.length];
        for (int i = 0; i < this.clusterConvergence.length; ++i) {
            tempConv[i] = this.clusterConvergence[i];
        }
        QSort qsort = new QSort(tempConv);
        tempConv = qsort.getSorted();
        int[] sortedClusterIndices = qsort.getOrigIndx();
        for (int i = 0; i < number_of_clusters - 1; ++i) {
            for (int j = 0; j < number_of_clusters - 1 - i; ++j) {
                if (tempConv[j] != tempConv[j + 1] || clusters[sortedClusterIndices[j]].size() >= clusters[sortedClusterIndices[j + 1]].size()) continue;
                int temp = sortedClusterIndices[j];
                sortedClusterIndices[j] = sortedClusterIndices[j + 1];
                sortedClusterIndices[j + 1] = temp;
            }
        }
        KMCluster[] newClusterOrder = new KMCluster[clusters.length];
        FloatMatrix newMeansMedsOrder = new FloatMatrix(clusters.length, this.number_of_samples);
        FloatMatrix newVariancesOrder = new FloatMatrix(clusters.length, this.number_of_samples);
        for (int i = 0; i < clusters.length; ++i) {
            newClusterOrder[i] = clusters[sortedClusterIndices[i]];
            newVariancesOrder.A[i] = variances.A[sortedClusterIndices[i]];
            newMeansMedsOrder.A[i] = this.calculateMeans ? means.A[sortedClusterIndices[i]] : medians.A[sortedClusterIndices[i]];
            this.clusterConvergence[i] = (int)tempConv[i];
        }
        clusters = newClusterOrder;
        variances = newVariancesOrder;
        if (this.calculateMeans) {
            means = newMeansMedsOrder;
        } else {
            medians = newMeansMedsOrder;
        }
        AlgorithmEvent event = null;
        if (hierarchical_tree) {
            event = new AlgorithmEvent(this, 1, clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(event);
            event.setIntValue(0);
            event.setId(2);
            this.fireValueChanged(event);
        }
        Cluster result_cluster = new Cluster();
        NodeList nodeList = result_cluster.getNodeList();
        for (int i = 0; i < clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] features = this.convert2int(clusters[i]);
            Node node = new Node(features);
            nodeList.addNode(node);
        }
        AlgorithmData result = new AlgorithmData();
        result.addCluster("cluster", result_cluster);
        if (this.calculateMeans) {
            result.addMatrix("clusters_means", means);
        } else {
            result.addMatrix("clusters_means", medians);
        }
        result.addMatrix("clusters_variances", variances);
        result.addParam("iterations", String.valueOf(this.getIterations()));
        result.addParam("converged", String.valueOf(this.getConverged()));
        result.addIntArray("convergence-iterations", this.clusterConvergence);
        return result;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", source_result.getMatrix("height").getRowPackedCopy()));
    }

    private KMCluster[] calculate(int number_of_genes, int number_of_clusters, int number_of_iterations) throws AlgorithmException {
        int i;
        int address = 0;
        int counter = 0;
        float[] dissim = new float[number_of_clusters];
        int[] location = new int[number_of_genes];
        Float[] elements = new Float[number_of_genes];
        KMCluster[] clusters = new KMCluster[number_of_clusters];
        for (i = 0; i < clusters.length; ++i) {
            clusters[i] = new KMCluster();
        }
        int clusterIndex = 0;
        Random random = new Random();
        for (i = 0; i < number_of_genes; ++i) {
            clusterIndex = (int)Math.floor(random.nextFloat() * (float)number_of_clusters);
            clusterIndex = Math.min(clusterIndex, number_of_clusters - 1);
            elements[i] = new Float(i);
            location[i] = clusterIndex;
            clusters[clusterIndex].add(elements[i]);
        }
        AlgorithmEvent event = new AlgorithmEvent(this, 1, 200);
        this.fireValueChanged(event);
        int currentProgress = 0;
        int oldCurrentProgress = 0;
        double Factor = 200.0 / (double)(number_of_genes * number_of_iterations);
        for (i = 0; i < number_of_clusters; ++i) {
            clusters[i].calculateMean();
        }
        int current = 0;
        int iterations = 0;
        boolean converged = false;
        int reallocations = 0;
        while (counter != number_of_genes * number_of_iterations) {
            if (this.stop) {
                throw new AbortException();
            }
            currentProgress = (int)((double)counter * Factor);
            if (currentProgress > oldCurrentProgress) {
                event.setId(2);
                event.setIntValue(currentProgress);
                this.fireValueChanged(event);
                oldCurrentProgress = currentProgress;
            }
            for (i = 0; i < number_of_clusters; ++i) {
                dissim[i] = ExperimentUtil.geneDistance(this.expMatrix, clusters[i].getMean(), current, 0, this.function, this.factor, this.absolute);
            }
            address = this.findNearest(dissim);
            if (address != location[current]) {
                ++reallocations;
                clusters[location[current]].updateMeanForLoosingCluster(elements[current].intValue());
                clusters[location[current]].remove(elements[current]);
                clusters[address].updateMeanForWinningCluster(elements[current].intValue());
                clusters[address].add(elements[current]);
                location[current] = address;
                this.clusterConvergence[location[current]] = iterations + 1;
                this.clusterConvergence[address] = iterations + 1;
            }
            if (++current == number_of_genes) {
                current = 0;
            }
            if (++counter % number_of_genes != 0) continue;
            ++iterations;
            if (reallocations == 0) {
                converged = true;
                break;
            }
            event.setId(3);
            event.setIntValue(reallocations);
            this.fireValueChanged(event);
            reallocations = 0;
        }
        event.setId(3);
        event.setIntValue(-1);
        this.fireValueChanged(event);
        this.setIterations(iterations);
        this.setConverged(converged);
        return clusters;
    }

    private KMCluster[] calculateMedians(int number_of_genes, int number_of_clusters, int number_of_iterations) throws AlgorithmException {
        int i;
        int address = 0;
        int counter = 0;
        float[] dissim = new float[number_of_clusters];
        int[] location = new int[number_of_genes];
        Float[] elements = new Float[number_of_genes];
        KMCluster[] clusters = new KMCluster[number_of_clusters];
        for (i = 0; i < clusters.length; ++i) {
            clusters[i] = new KMCluster();
        }
        int clusterIndex = 0;
        Random random = new Random();
        for (i = 0; i < number_of_genes; ++i) {
            clusterIndex = (int)Math.floor(random.nextFloat() * (float)number_of_clusters);
            clusterIndex = Math.min(clusterIndex, number_of_clusters - 1);
            elements[i] = new Float(i);
            location[i] = clusterIndex;
            clusters[clusterIndex].add(elements[i]);
        }
        AlgorithmEvent event = new AlgorithmEvent(this, 1, 200);
        this.fireValueChanged(event);
        int currentProgress = 0;
        int oldCurrentProgress = 0;
        double Factor = 200.0 / (double)(number_of_genes * number_of_iterations);
        for (i = 0; i < number_of_clusters; ++i) {
            clusters[i].calculateMedian();
        }
        int current = 0;
        int iterations = 0;
        boolean converged = false;
        int reallocations = 0;
        while (counter != number_of_genes * number_of_iterations) {
            if (this.stop) {
                throw new AbortException();
            }
            currentProgress = (int)((double)counter * Factor);
            if (currentProgress > oldCurrentProgress) {
                event.setId(2);
                event.setIntValue(currentProgress);
                this.fireValueChanged(event);
                oldCurrentProgress = currentProgress;
            }
            for (i = 0; i < number_of_clusters; ++i) {
                dissim[i] = ExperimentUtil.geneDistance(this.expMatrix, clusters[i].getMedian(), current, 0, this.function, this.factor, this.absolute);
            }
            address = this.findNearest(dissim);
            if (address != location[current]) {
                ++reallocations;
                clusters[location[current]].remove(elements[current]);
                clusters[address].add(elements[current]);
                clusters[location[current]].calculateMedian();
                clusters[address].calculateMedian();
                location[current] = address;
            }
            if (++current == number_of_genes) {
                current = 0;
            }
            if (++counter % number_of_genes != 0) continue;
            ++iterations;
            if (reallocations == 0) {
                converged = true;
                break;
            }
            event.setId(3);
            event.setIntValue(reallocations);
            this.fireValueChanged(event);
            reallocations = 0;
        }
        event.setId(3);
        event.setIntValue(-1);
        this.fireValueChanged(event);
        this.setIterations(iterations);
        this.setConverged(converged);
        return clusters;
    }

    private int[] convert2int(ArrayList source) {
        int[] int_matrix = new int[source.size()];
        for (int i = 0; i < int_matrix.length; ++i) {
            int_matrix[i] = (int)((Float)source.get(i)).floatValue();
        }
        return int_matrix;
    }

    private int findNearest(float[] x) {
        int address = 0;
        float smallest = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < smallest)) continue;
            smallest = x[i];
            address = i;
        }
        return address;
    }

    private boolean getConverged() {
        return this.converged;
    }

    private int getIterations() {
        return this.iterations;
    }

    private FloatMatrix getMeans(KMCluster[] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.number_of_samples);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = clusters[i].getMean();
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMedians(KMCluster[] clusters) {
        FloatMatrix medians = new FloatMatrix(clusters.length, this.number_of_samples);
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix median = clusters[i].getMedian();
            medians.A[i] = median.A[0];
        }
        return medians;
    }

    private float getSampleNormalizedSum(KMCluster cluster, int column, float mean) {
        int size = cluster.size();
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.expMatrix.get(((Float)cluster.get(i)).intValue(), column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    private float getSampleVariance(KMCluster cluster, int column, float mean) {
        if (this.validN > 1) {
            return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
        }
        return 0.0f;
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private FloatMatrix getVariances(KMCluster[] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private void setConverged(boolean converged) {
        this.converged = converged;
    }

    private void setIterations(int iterations) {
        this.iterations = iterations;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private class KMCluster
    extends ArrayList {
        private FloatMatrix mean;
        private FloatMatrix median;
        private float[] sums;
        private int[] validNList;

        public KMCluster() {
            this.mean = new FloatMatrix(1, KMC.this.number_of_samples);
            this.median = new FloatMatrix(1, KMC.this.number_of_samples);
            this.sums = new float[KMC.this.number_of_samples];
            this.validNList = new int[KMC.this.number_of_samples];
        }

        public void calculateMean() {
            int n = this.size();
            for (int i = 0; i < KMC.this.number_of_samples; ++i) {
                float currentMean = 0.0f;
                KMC.this.validN = 0;
                for (int j = 0; j < n; ++j) {
                    float value = KMC.this.expMatrix.get(((Float)this.get(j)).intValue(), i);
                    if (Float.isNaN(value)) continue;
                    currentMean += value;
                    KMC.this.validN++;
                }
                this.sums[i] = currentMean;
                this.validNList[i] = KMC.this.validN;
                this.mean.set(0, i, currentMean / (float)KMC.this.validN);
            }
        }

        public float getElementMedian(float[] array, int start, int end, int medNum) {
            if (start == end) {
                return array[start];
            }
            int part = this.randomPartition(array, start, end);
            int k = part - start + 1;
            if (medNum <= k) {
                return this.getElementMedian(array, start, part, medNum);
            }
            return this.getElementMedian(array, part + 1, end, medNum - k);
        }

        public FloatMatrix getMean() {
            return this.mean;
        }

        public FloatMatrix getMedian() {
            return this.median;
        }

        public int partition(float[] array, int start, int end) {
            float x = array[start];
            int i = start - 1;
            int j = end + 1;
            boolean currExpIndex = false;
            while (true) {
                if (array[--j] > x) {
                    continue;
                }
                while (array[++i] < x) {
                }
                if (i >= j) break;
                this.swap(array, i, j);
            }
            return j;
        }

        public void updateMeanForLoosingCluster(int index) {
            float[] currValues = ((KMC)KMC.this).expMatrix.A[index];
            for (int i = 0; i < KMC.this.number_of_samples; ++i) {
                if (Float.isNaN(currValues[i])) continue;
                int n = i;
                this.validNList[n] = this.validNList[n] - 1;
                int n2 = i;
                this.sums[n2] = this.sums[n2] - currValues[i];
                this.mean.set(0, i, this.sums[i] / (float)this.validNList[i]);
            }
        }

        public void updateMeanForWinningCluster(int index) {
            float[] currValues = ((KMC)KMC.this).expMatrix.A[index];
            for (int i = 0; i < KMC.this.number_of_samples; ++i) {
                if (Float.isNaN(currValues[i])) continue;
                int n = i;
                this.validNList[n] = this.validNList[n] + 1;
                int n2 = i;
                this.sums[n2] = this.sums[n2] + currValues[i];
                this.mean.set(0, i, this.sums[i] / (float)this.validNList[i]);
            }
        }

        private void calculateMedian() {
            float[] values;
            int numberOfValidValues;
            for (int i = 0; i < KMC.this.number_of_samples && (numberOfValidValues = this.getValues(values = new float[this.size()], i)) != 0; ++i) {
                this.median.set(0, i, this.computeMedian(values));
            }
        }

        private float computeMedian(float[] array) {
            float returnValue;
            Arrays.sort(array);
            int numberOfItems = array.length;
            if (numberOfItems % 2 == 1) {
                returnValue = array[numberOfItems / 2];
            } else {
                returnValue = array[numberOfItems / 2 - 1];
                returnValue += array[numberOfItems / 2];
                returnValue = (float)((double)returnValue / 2.0);
            }
            return returnValue;
        }

        private int getValues(float[] values, int sampleIndex) {
            int currIndex = 0;
            int numberOfValues = 0;
            for (int i = 0; i < values.length; ++i) {
                float currVal = KMC.this.expMatrix.get(((Float)this.get(i)).intValue(), sampleIndex);
                if (Float.isNaN(currVal)) continue;
                values[currIndex] = currVal;
                ++numberOfValues;
                ++currIndex;
            }
            return numberOfValues;
        }

        private int randomPartition(float[] array, int start, int end) {
            int i = (int)((double)(end - start + 1) * Math.random()) + start;
            this.swap(array, i, start);
            return this.partition(array, start, end);
        }

        private void swap(float[] array, int i, int j) {
            float temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }
}

