/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ExtraMath;
import JSci.maths.Mapping;
import JSci.maths.MathVector;
import JSci.maths.algebras.BanachSpace;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;

public abstract class AbstractDoubleVector
extends MathVector
implements BanachSpace.Member {
    protected AbstractDoubleVector(int n) {
        super(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(this.getComponent(n));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.getComponent(n));
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public abstract double getComponent(int var1);

    public abstract void setComponent(int var1, double var2);

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.getComponent(0)), n);
        int n2 = 1;
        while (n2 < this.N) {
            d += Math.pow(Math.abs(this.getComponent(n2)), n);
            ++n2;
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.getComponent(0);
        int n = 1;
        while (n < this.N) {
            d = ExtraMath.hypot(d, this.getComponent(n));
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d = Math.abs(this.getComponent(0));
        int n = 1;
        while (n < this.N) {
            double d2 = Math.abs(this.getComponent(n));
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double mass() {
        double d = 0.0;
        int n = 1;
        while (n < this.N) {
            d += this.getComponent(n);
            ++n;
        }
        return d;
    }

    public abstract AbstractDoubleVector add(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector subtract(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector scalarMultiply(double var1);

    public abstract AbstractDoubleVector scalarDivide(double var1);

    public AbstractDoubleVector normalize() {
        return this.scalarDivide(this.norm());
    }

    public abstract double scalarProduct(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector mapComponents(Mapping var1);

    public abstract VectorSpace.Member scalarDivide(Field.Member var1);
}

