/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ExtraMath;
import JSci.maths.MathVector;

public abstract class AbstractIntegerVector
extends MathVector {
    protected AbstractIntegerVector(int n) {
        super(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(this.getComponent(n));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.getComponent(n));
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public abstract int getComponent(int var1);

    public abstract void setComponent(int var1, int var2);

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.getComponent(0)), n);
        int n2 = 1;
        while (n2 < this.N) {
            d += Math.pow(Math.abs(this.getComponent(n2)), n);
            ++n2;
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.getComponent(0);
        int n = 1;
        while (n < this.N) {
            d = ExtraMath.hypot(d, this.getComponent(n));
            ++n;
        }
        return d;
    }

    public double infNorm() {
        int n = Math.abs(this.getComponent(0));
        int n2 = 1;
        while (n2 < this.N) {
            int n3 = Math.abs(this.getComponent(n2));
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public abstract AbstractIntegerVector add(AbstractIntegerVector var1);

    public abstract AbstractIntegerVector subtract(AbstractIntegerVector var1);

    public abstract AbstractIntegerVector scalarMultiply(int var1);

    public abstract int scalarProduct(AbstractIntegerVector var1);
}

