/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ExtraMath;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.CStarAlgebra;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.ComplexField;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class Complex
implements Field.Member,
CStarAlgebra.Member {
    private static final long serialVersionUID = 6561957920497208796L;
    private double re;
    private double im;
    private transient boolean isModCached = false;
    private transient double modCache;
    private transient boolean isArgCached = false;
    private transient double argCache;
    public static final Complex I = ComplexField.I;
    public static final Complex ONE = ComplexField.ONE;
    public static final Complex ZERO = ComplexField.ZERO;

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public Complex(String string) throws NumberFormatException {
        int n = string.indexOf(105);
        if (n == -1) {
            this.re = Double.parseDouble(string);
            this.im = 0.0;
        } else {
            String string2;
            int n2 = string.indexOf(43, 1);
            if (n2 == -1) {
                n2 = string.indexOf(45, 1);
            }
            if (n2 == -1) {
                this.re = 0.0;
                string2 = string;
            } else {
                int n3 = string.indexOf(69, 1);
                if (n3 == -1) {
                    n3 = string.indexOf(101, 1);
                }
                if (n2 == n3 + 1 && (n2 = string.indexOf(43, 1)) == -1) {
                    n2 = string.indexOf(45, 1);
                }
                if (n < n2) {
                    string2 = string.substring(0, n2);
                    this.re = Double.parseDouble(string.substring(n2 + 1));
                } else {
                    this.re = Double.parseDouble(string.substring(0, n2));
                    string2 = string.substring(n2 + 1);
                }
            }
            if (string2.startsWith("i")) {
                this.im = Double.parseDouble(string2.substring(1));
            } else if (string2.endsWith("i")) {
                this.im = Double.parseDouble(string2.substring(0, string2.length() - 1));
            }
        }
    }

    public static Complex polar(double d, double d2) {
        Complex complex = new Complex(d * Math.cos(d2), d * Math.sin(d2));
        complex.modCache = d;
        complex.isModCached = true;
        complex.argCache = d2;
        complex.isArgCached = true;
        return complex;
    }

    public boolean equals(Object object) {
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            return this.equals(complex.re, complex.im);
        }
        return false;
    }

    public boolean equals(double d, double d2) {
        return Math.abs(this.re - d) <= GlobalSettings.ZERO_TOL && Math.abs(this.im - d2) <= GlobalSettings.ZERO_TOL;
    }

    public String toString() {
        return Complex.toString(this.re, this.im);
    }

    public static String toString(double d, double d2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(d);
        if (d2 >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(d2);
        stringBuffer.append("i");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.mod());
    }

    public boolean isNaN() {
        return this.re == Double.NaN || this.im == Double.NaN;
    }

    public boolean isInfinite() {
        return this.re == Double.POSITIVE_INFINITY || this.re == Double.NEGATIVE_INFINITY || this.im == Double.POSITIVE_INFINITY || this.im == Double.NEGATIVE_INFINITY;
    }

    public double real() {
        return this.re;
    }

    public double imag() {
        return this.im;
    }

    public double mod() {
        if (this.isModCached) {
            return this.modCache;
        }
        this.modCache = Complex.mod(this.re, this.im);
        this.isModCached = true;
        return this.modCache;
    }

    private static double mod(double d, double d2) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        if (d3 == 0.0 && d4 == 0.0) {
            return 0.0;
        }
        if (d3 < d4) {
            return d4 * Math.sqrt(1.0 + d / d2 * (d / d2));
        }
        return d3 * Math.sqrt(1.0 + d2 / d * (d2 / d));
    }

    public double arg() {
        if (this.isArgCached) {
            return this.argCache;
        }
        this.argCache = Complex.arg(this.re, this.im);
        this.isArgCached = true;
        return this.argCache;
    }

    private static double arg(double d, double d2) {
        return Math.atan2(d2, d);
    }

    public double norm() {
        return this.mod();
    }

    public AbelianGroup.Member negate() {
        return new Complex(-this.re, -this.im);
    }

    public Field.Member inverse() {
        double d;
        double d2;
        double d3;
        if (Math.abs(this.re) < Math.abs(this.im)) {
            d3 = this.re / this.im;
            d2 = -1.0;
            d = this.re * d3 + this.im;
        } else {
            d3 = 1.0;
            d2 = -this.im / this.re;
            d = this.re - this.im * d2;
        }
        return new Complex(d3 / d, d2 / d);
    }

    public CStarAlgebra.Member involution() {
        return this.conjugate();
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof Complex) {
            return this.add((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.addReal(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.addReal(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex add(Complex complex) {
        return new Complex(this.re + complex.re, this.im + complex.im);
    }

    public Complex addReal(double d) {
        return new Complex(this.re + d, this.im);
    }

    public Complex addImag(double d) {
        return new Complex(this.re, this.im + d);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof Complex) {
            return this.subtract((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.subtractReal(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.subtractReal(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex subtract(Complex complex) {
        return new Complex(this.re - complex.re, this.im - complex.im);
    }

    public Complex subtractReal(double d) {
        return new Complex(this.re - d, this.im);
    }

    public Complex subtractImag(double d) {
        return new Complex(this.re, this.im - d);
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        return (Complex)this.multiply(member);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof Complex) {
            return this.multiply((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.multiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.multiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex multiply(Complex complex) {
        return new Complex(this.re * complex.re - this.im * complex.im, this.re * complex.im + this.im * complex.re);
    }

    public Complex multiply(double d) {
        return new Complex(d * this.re, d * this.im);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        return (Complex)this.divide(member);
    }

    public Field.Member divide(Field.Member member) {
        if (member instanceof Complex) {
            return this.divide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.divide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex divide(Complex complex) {
        double d;
        double d2;
        double d3;
        if (Math.abs(complex.re) < Math.abs(complex.im)) {
            double d4 = complex.re / complex.im;
            d3 = complex.re * d4 + complex.im;
            d2 = this.re * d4 + this.im;
            d = this.im * d4 - this.re;
        } else {
            double d5 = complex.im / complex.re;
            d3 = complex.re + complex.im * d5;
            d2 = this.re + this.im * d5;
            d = this.im - this.re * d5;
        }
        return new Complex(d2 / d3, d / d3);
    }

    public Complex divide(double d) {
        return new Complex(this.re / d, this.im / d);
    }

    public Complex pow(Complex complex) {
        double d = this.mod();
        double d2 = this.arg();
        double d3 = Math.pow(d, complex.re) / Math.exp(d2 * complex.im);
        double d4 = d2 * complex.re + Math.log(d) * complex.im;
        return Complex.polar(d3, d4);
    }

    public Complex pow(double d) {
        return Complex.polar(Math.pow(this.mod(), d), this.arg() * d);
    }

    public Complex sqr() {
        return new Complex(this.re * this.re - this.im * this.im, 2.0 * this.re * this.im);
    }

    public Complex sqrt() {
        return Complex.polar(Math.sqrt(this.mod()), this.arg() / 2.0);
    }

    private static Complex sqrt(double d, double d2) {
        return Complex.polar(Math.sqrt(Complex.mod(d, d2)), Complex.arg(d, d2) / 2.0);
    }

    public static Complex exp(Complex complex) {
        return new Complex(Math.exp(complex.re) * Math.cos(complex.im), Math.exp(complex.re) * Math.sin(complex.im));
    }

    public static Complex log(Complex complex) {
        return new Complex(Math.log(complex.mod()), complex.arg());
    }

    private static final Complex log(double d, double d2) {
        return new Complex(Math.log(Complex.mod(d, d2)), Complex.arg(d, d2));
    }

    private static final Complex log_2(double d, double d2) {
        return new Complex(Math.log(Complex.mod(d, d2)) / 2.0, Complex.arg(d, d2) / 2.0);
    }

    private static final Complex log_2I(double d, double d2) {
        return new Complex(Complex.arg(d, d2) / 2.0, -Math.log(Complex.mod(d, d2)) / 2.0);
    }

    private static final Complex log_2IplusPI_2(double d, double d2) {
        return new Complex((Complex.arg(d, d2) + Math.PI) / 2.0, -Math.log(Complex.mod(d, d2)) / 2.0);
    }

    public static Complex sin(Complex complex) {
        return new Complex(Math.sin(complex.re) * ExtraMath.cosh(complex.im), Math.cos(complex.re) * ExtraMath.sinh(complex.im));
    }

    public static Complex cos(Complex complex) {
        return new Complex(Math.cos(complex.re) * ExtraMath.cosh(complex.im), -Math.sin(complex.re) * ExtraMath.sinh(complex.im));
    }

    public static Complex tan(Complex complex) {
        double d = Math.sin(complex.re);
        double d2 = Math.cos(complex.re);
        double d3 = ExtraMath.sinh(complex.im);
        double d4 = ExtraMath.cosh(complex.im);
        double d5 = d2 * d2 * d4 * d4 + d * d * d3 * d3;
        return new Complex(d * d2 / d5, d3 * d4 / d5);
    }

    public static Complex sinh(Complex complex) {
        return new Complex(ExtraMath.sinh(complex.re) * Math.cos(complex.im), ExtraMath.cosh(complex.re) * Math.sin(complex.im));
    }

    public static Complex cosh(Complex complex) {
        return new Complex(ExtraMath.cosh(complex.re) * Math.cos(complex.im), ExtraMath.sinh(complex.re) * Math.sin(complex.im));
    }

    public static Complex tanh(Complex complex) {
        double d = ExtraMath.sinh(complex.re);
        double d2 = ExtraMath.cosh(complex.re);
        double d3 = Math.sin(complex.im);
        double d4 = Math.cos(complex.im);
        double d5 = d2 * d2 * d4 * d4 + d * d * d3 * d3;
        return new Complex(d * d2 / d5, d3 * d4 / d5);
    }

    public static Complex asin(Complex complex) {
        if (complex.equals(ONE)) {
            return ComplexField.PI_2;
        }
        if (complex.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.MINUS_PI_2;
        }
        Complex complex2 = Complex.sqrt(1.0 - complex.re * complex.re + complex.im * complex.im, -2.0 * complex.re * complex.im);
        double d = complex.re * complex.re + complex.im * complex.im;
        double d2 = complex2.re * complex2.re + complex2.im * complex2.im;
        double d3 = d2 + d + 2.0 * (complex2.re * complex.im - complex2.im * complex.re);
        return Complex.log_2I((d2 - d) / d3, 2.0 * (complex2.re * complex.re + complex2.im * complex.im) / d3);
    }

    public static Complex acos(Complex complex) {
        if (complex.equals(ONE)) {
            return ZERO;
        }
        if (complex.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.PI;
        }
        Complex complex2 = Complex.sqrt(1.0 - complex.re * complex.re + complex.im * complex.im, -2.0 * complex.re * complex.im);
        double d = complex.re * complex.re + complex.im * complex.im;
        double d2 = complex2.re * complex2.re + complex2.im * complex2.im;
        double d3 = d2 + d + 2.0 * (complex2.im * complex.re - complex2.re * complex.im);
        return Complex.log_2IplusPI_2((d2 - d) / d3, -2.0 * (complex2.re * complex.re + complex2.im * complex.im) / d3);
    }

    public static Complex atan(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        double d2 = 1.0 + d + 2.0 * complex.im;
        return Complex.log_2I((1.0 - d) / d2, 2.0 * complex.re / d2);
    }

    public static Complex asinh(Complex complex) {
        if (complex.equals(I)) {
            return ComplexField.PI_2_I;
        }
        if (complex.equals(ComplexField.MINUS_I)) {
            return ComplexField.MINUS_PI_2_I;
        }
        Complex complex2 = Complex.sqrt(complex.re * complex.re - complex.im * complex.im + 1.0, 2.0 * complex.re * complex.im);
        return Complex.log(complex.re + complex2.re, complex.im + complex2.im);
    }

    public static Complex acosh(Complex complex) {
        if (complex.equals(ONE)) {
            return ZERO;
        }
        if (complex.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.PI_I;
        }
        Complex complex2 = Complex.sqrt(complex.re * complex.re - complex.im * complex.im - 1.0, 2.0 * complex.re * complex.im);
        return Complex.log(complex.re + complex2.re, complex.im + complex2.im);
    }

    public static Complex atanh(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        double d2 = 1.0 + d - 2.0 * complex.re;
        return Complex.log_2((1.0 - d) / d2, 2.0 * complex.im / d2);
    }
}

