/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractComplexSquareMatrix;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.LinearMath;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.TridiagonalMatrix;

public class ComplexTridiagonalMatrix
extends AbstractComplexSquareMatrix
implements TridiagonalMatrix {
    protected final double[] ldiagRe;
    protected final double[] ldiagIm;
    protected final double[] diagRe;
    protected final double[] diagIm;
    protected final double[] udiagRe;
    protected final double[] udiagIm;

    public ComplexTridiagonalMatrix(int n) {
        super(n);
        this.ldiagRe = new double[n];
        this.ldiagIm = new double[n];
        this.diagRe = new double[n];
        this.diagIm = new double[n];
        this.udiagRe = new double[n];
        this.udiagIm = new double[n];
    }

    public ComplexTridiagonalMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        if (!ArrayMath.isSquare(complexArray)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.diagRe[0] = complexArray[0][0].real();
        this.diagIm[0] = complexArray[0][0].imag();
        this.udiagRe[0] = complexArray[0][1].real();
        this.udiagIm[0] = complexArray[0][1].imag();
        int n = 1;
        while (n < complexArray.length - 1) {
            this.ldiagRe[n] = complexArray[n][n - 1].real();
            this.ldiagIm[n] = complexArray[n][n - 1].imag();
            this.diagRe[n] = complexArray[n][n].real();
            this.diagIm[n] = complexArray[n][n].imag();
            this.udiagRe[n] = complexArray[n][n + 1].real();
            this.udiagIm[n] = complexArray[n][n + 1].imag();
            ++n;
        }
        this.ldiagRe[n] = complexArray[n][n - 1].real();
        this.ldiagIm[n] = complexArray[n][n - 1].imag();
        this.diagRe[n] = complexArray[n][n].real();
        this.diagIm[n] = complexArray[n][n].imag();
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix instanceof TridiagonalMatrix) {
            if (this.numRows != abstractComplexMatrix.rows() || this.numCols != abstractComplexMatrix.columns()) {
                return false;
            }
            if (!abstractComplexMatrix.getElement(0, 0).equals(this.diagRe[0], this.diagIm[0])) {
                return false;
            }
            if (!abstractComplexMatrix.getElement(0, 1).equals(this.udiagRe[0], this.udiagIm[0])) {
                return false;
            }
            int n = 1;
            while (n < this.numRows - 1) {
                if (!abstractComplexMatrix.getElement(n, n - 1).equals(this.ldiagRe[n], this.ldiagIm[n])) {
                    return false;
                }
                if (!abstractComplexMatrix.getElement(n, n).equals(this.diagRe[n], this.diagIm[n])) {
                    return false;
                }
                if (!abstractComplexMatrix.getElement(n, n + 1).equals(this.udiagRe[n], this.udiagIm[n])) {
                    return false;
                }
                ++n;
            }
            if (!abstractComplexMatrix.getElement(n, n - 1).equals(this.ldiagRe[n], this.ldiagIm[n])) {
                return false;
            }
            return abstractComplexMatrix.getElement(n, n).equals(this.diagRe[n], this.diagIm[n]);
        }
        return super.equals(abstractComplexMatrix);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.rows() * this.columns());
        int n = 0;
        while (n < this.rows()) {
            int n2 = 0;
            while (n2 < this.columns()) {
                stringBuffer.append(this.getElement(n, n2).toString());
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public AbstractDoubleMatrix real() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        doubleTridiagonalMatrix.diag[0] = this.diagRe[0];
        doubleTridiagonalMatrix.udiag[0] = this.udiagRe[0];
        int n = 1;
        while (n < this.numRows - 1) {
            doubleTridiagonalMatrix.ldiag[n] = this.ldiagRe[n];
            doubleTridiagonalMatrix.diag[n] = this.diagRe[n];
            doubleTridiagonalMatrix.udiag[n] = this.udiagRe[n];
            ++n;
        }
        doubleTridiagonalMatrix.ldiag[n] = this.ldiagRe[n];
        doubleTridiagonalMatrix.diag[n] = this.diagRe[n];
        return doubleTridiagonalMatrix;
    }

    public AbstractDoubleMatrix imag() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        doubleTridiagonalMatrix.diag[0] = this.diagIm[0];
        doubleTridiagonalMatrix.udiag[0] = this.udiagIm[0];
        int n = 1;
        while (n < this.numRows - 1) {
            doubleTridiagonalMatrix.ldiag[n] = this.ldiagIm[n];
            doubleTridiagonalMatrix.diag[n] = this.diagIm[n];
            doubleTridiagonalMatrix.udiag[n] = this.udiagIm[n];
            ++n;
        }
        doubleTridiagonalMatrix.ldiag[n] = this.ldiagIm[n];
        doubleTridiagonalMatrix.diag[n] = this.diagIm[n];
        return doubleTridiagonalMatrix;
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 == n - 1) {
                return new Complex(this.ldiagRe[n], this.ldiagIm[n]);
            }
            if (n2 == n) {
                return new Complex(this.diagRe[n], this.diagIm[n]);
            }
            if (n2 == n + 1) {
                return new Complex(this.udiagRe[n], this.udiagIm[n]);
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getRealElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 == n - 1) {
                return this.ldiagRe[n];
            }
            if (n2 == n) {
                return this.diagRe[n];
            }
            if (n2 == n + 1) {
                return this.udiagRe[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getImagElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 == n - 1) {
                return this.ldiagIm[n];
            }
            if (n2 == n) {
                return this.diagIm[n];
            }
            if (n2 == n + 1) {
                return this.udiagIm[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        if (n2 == n - 1) {
            this.ldiagRe[n] = complex.real();
            this.ldiagIm[n] = complex.imag();
            return;
        } else if (n2 == n) {
            this.diagRe[n] = complex.real();
            this.diagIm[n] = complex.imag();
            return;
        } else {
            if (n2 != n + 1) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            this.udiagRe[n] = complex.real();
            this.udiagIm[n] = complex.imag();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        if (n2 == n - 1) {
            this.ldiagRe[n] = d;
            this.ldiagIm[n] = d2;
            return;
        } else if (n2 == n) {
            this.diagRe[n] = d;
            this.diagIm[n] = d2;
            return;
        } else {
            if (n2 != n + 1) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            this.udiagRe[n] = d;
            this.udiagIm[n] = d2;
        }
    }

    public Complex trace() {
        double d = this.diagRe[0];
        double d2 = this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diagRe[n];
            d2 += this.diagIm[n];
            ++n;
        }
        return new Complex(d, d2);
    }

    public double infNorm() {
        double d;
        double d2 = Math.sqrt(this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0]) + Math.sqrt(this.udiagRe[0] * this.udiagRe[0] + this.udiagIm[0] * this.udiagIm[0]);
        int n = 1;
        while (n < this.numRows - 1) {
            d = Math.sqrt(this.ldiagRe[n] * this.ldiagRe[n] + this.ldiagIm[n] * this.ldiagIm[n]) + Math.sqrt(this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n]) + Math.sqrt(this.udiagRe[n] * this.udiagRe[n] + this.udiagIm[n] * this.udiagIm[n]);
            if (d > d2) {
                d2 = d;
            }
            ++n;
        }
        d = Math.sqrt(this.ldiagRe[n] * this.ldiagRe[n] + this.ldiagIm[n] * this.ldiagIm[n]) + Math.sqrt(this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n]);
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public double frobeniusNorm() {
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0] + this.udiagRe[0] * this.udiagRe[0] + this.udiagIm[0] * this.udiagIm[0];
        int n = 1;
        while (n < this.numRows - 1) {
            d += this.ldiagRe[n] * this.ldiagRe[n] + this.ldiagIm[n] * this.ldiagIm[n] + this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n] + this.udiagRe[n] * this.udiagRe[n] + this.udiagIm[n] * this.udiagIm[n];
            ++n;
        }
        return Math.sqrt(d += this.ldiagRe[n] * this.ldiagRe[n] + this.ldiagIm[n] * this.ldiagIm[n] + this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n]);
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveHermitian((ComplexTridiagonalMatrix)this.hermitianAdjoint().multiply(this))));
    }

    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = this.getElement(n, 0).add(abstractComplexSquareMatrix.getElement(n, 0));
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = this.getElement(n, n2).add(abstractComplexSquareMatrix.getElement(n, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numRows];
            double[][] dArray2 = new double[this.numRows][this.numRows];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(complexSquareMatrix.matrixRe[n], 0, dArray[n], 0, this.numRows);
                System.arraycopy(complexSquareMatrix.matrixIm[n], 0, dArray2[n], 0, this.numRows);
                ++n;
            }
            double[] dArray3 = dArray[0];
            dArray3[0] = dArray3[0] + this.diagRe[0];
            double[] dArray4 = dArray2[0];
            dArray4[0] = dArray4[0] + this.diagIm[0];
            double[] dArray5 = dArray[0];
            dArray5[1] = dArray5[1] + this.udiagRe[0];
            double[] dArray6 = dArray2[0];
            dArray6[1] = dArray6[1] + this.udiagIm[0];
            int n2 = this.numCols - 1;
            int n3 = 1;
            while (n3 < n2) {
                double[] dArray7 = dArray[n3];
                int n4 = n3 - 1;
                dArray7[n4] = dArray7[n4] + this.ldiagRe[n3];
                double[] dArray8 = dArray2[n3];
                int n5 = n3 - 1;
                dArray8[n5] = dArray8[n5] + this.ldiagIm[n3];
                double[] dArray9 = dArray[n3];
                int n6 = n3;
                dArray9[n6] = dArray9[n6] + this.diagRe[n3];
                double[] dArray10 = dArray2[n3];
                int n7 = n3;
                dArray10[n7] = dArray10[n7] + this.diagIm[n3];
                double[] dArray11 = dArray[n3];
                int n8 = n3 + 1;
                dArray11[n8] = dArray11[n8] + this.udiagRe[n3];
                double[] dArray12 = dArray2[n3];
                int n9 = n3 + 1;
                dArray12[n9] = dArray12[n9] + this.udiagIm[n3];
                ++n3;
            }
            double[] dArray13 = dArray[n2];
            int n10 = n2 - 1;
            dArray13[n10] = dArray13[n10] + this.ldiagRe[n2];
            double[] dArray14 = dArray2[n2];
            int n11 = n2 - 1;
            dArray14[n11] = dArray14[n11] + this.ldiagIm[n2];
            double[] dArray15 = dArray[n2];
            int n12 = n2;
            dArray15[n12] = dArray15[n12] + this.diagRe[n2];
            double[] dArray16 = dArray2[n2];
            int n13 = n2;
            dArray16[n13] = dArray16[n13] + this.diagIm[n2];
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (n == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] + complexTridiagonalMatrix.diagRe[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] + complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.udiagRe[0] = this.udiagRe[0] + complexTridiagonalMatrix.udiagRe[0];
            complexTridiagonalMatrix2.udiagIm[0] = this.udiagIm[0] + complexTridiagonalMatrix.udiagIm[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.ldiagRe[n2] = this.ldiagRe[n2] + complexTridiagonalMatrix.ldiagRe[n2];
                complexTridiagonalMatrix2.ldiagIm[n2] = this.ldiagIm[n2] + complexTridiagonalMatrix.ldiagIm[n2];
                complexTridiagonalMatrix2.diagRe[n2] = this.diagRe[n2] + complexTridiagonalMatrix.diagRe[n2];
                complexTridiagonalMatrix2.diagIm[n2] = this.diagIm[n2] + complexTridiagonalMatrix.diagIm[n2];
                complexTridiagonalMatrix2.udiagRe[n2] = this.udiagRe[n2] + complexTridiagonalMatrix.udiagRe[n2];
                complexTridiagonalMatrix2.udiagIm[n2] = this.udiagIm[n2] + complexTridiagonalMatrix.udiagIm[n2];
                ++n2;
            }
            complexTridiagonalMatrix2.ldiagRe[n] = this.ldiagRe[n] + complexTridiagonalMatrix.ldiagRe[n];
            complexTridiagonalMatrix2.ldiagIm[n] = this.ldiagIm[n] + complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] + complexTridiagonalMatrix.diagRe[n];
            complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] + complexTridiagonalMatrix.diagIm[n];
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix addTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (n == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] + complex.real();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] + complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = this.udiagRe[0] + complex.real();
            complexTridiagonalMatrix.udiagIm[0] = this.udiagIm[0] + complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = abstractComplexSquareMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix.ldiagRe[n2] = this.ldiagRe[n2] + complex.real();
                complexTridiagonalMatrix.ldiagIm[n2] = this.ldiagIm[n2] + complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2);
                complexTridiagonalMatrix.diagRe[n2] = this.diagRe[n2] + complex.real();
                complexTridiagonalMatrix.diagIm[n2] = this.diagIm[n2] + complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix.udiagRe[n2] = this.udiagRe[n2] + complex.real();
                complexTridiagonalMatrix.udiagIm[n2] = this.udiagIm[n2] + complex.imag();
                ++n2;
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = this.ldiagRe[n] + complex.real();
            complexTridiagonalMatrix.ldiagIm[n] = this.ldiagIm[n] + complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] + complex.real();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] + complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = this.getElement(n, 0).subtract(abstractComplexSquareMatrix.getElement(n, 0));
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = this.getElement(n, n2).subtract(abstractComplexSquareMatrix.getElement(n, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = this.getElement(n, 0);
                dArray[n][0] = complex.real() - complexSquareMatrix.matrixRe[n][0];
                dArray2[n][0] = complex.imag() - complexSquareMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = this.getElement(n, n2);
                    dArray[n][n2] = complex.real() - complexSquareMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = complex.imag() - complexSquareMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (n == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] - complexTridiagonalMatrix.diagRe[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] - complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.udiagRe[0] = this.udiagRe[0] - complexTridiagonalMatrix.udiagRe[0];
            complexTridiagonalMatrix2.udiagIm[0] = this.udiagIm[0] - complexTridiagonalMatrix.udiagIm[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.ldiagRe[n2] = this.ldiagRe[n2] - complexTridiagonalMatrix.ldiagRe[n2];
                complexTridiagonalMatrix2.ldiagIm[n2] = this.ldiagIm[n2] - complexTridiagonalMatrix.ldiagIm[n2];
                complexTridiagonalMatrix2.diagRe[n2] = this.diagRe[n2] - complexTridiagonalMatrix.diagRe[n2];
                complexTridiagonalMatrix2.diagIm[n2] = this.diagIm[n2] - complexTridiagonalMatrix.diagIm[n2];
                complexTridiagonalMatrix2.udiagRe[n2] = this.udiagRe[n2] - complexTridiagonalMatrix.udiagRe[n2];
                complexTridiagonalMatrix2.udiagIm[n2] = this.udiagIm[n2] - complexTridiagonalMatrix.udiagIm[n2];
                ++n2;
            }
            complexTridiagonalMatrix2.ldiagRe[n] = this.ldiagRe[n] - complexTridiagonalMatrix.ldiagRe[n];
            complexTridiagonalMatrix2.ldiagIm[n] = this.ldiagIm[n] - complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] - complexTridiagonalMatrix.diagRe[n];
            complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] - complexTridiagonalMatrix.diagIm[n];
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix subtractTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (n == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] - complex.real();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] - complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = this.udiagRe[0] - complex.real();
            complexTridiagonalMatrix.udiagIm[0] = this.udiagIm[0] - complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = abstractComplexSquareMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix.ldiagRe[n2] = this.ldiagRe[n2] - complex.real();
                complexTridiagonalMatrix.ldiagIm[n2] = this.ldiagIm[n2] - complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2);
                complexTridiagonalMatrix.diagRe[n2] = this.diagRe[n2] - complex.real();
                complexTridiagonalMatrix.diagIm[n2] = this.diagIm[n2] - complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix.udiagRe[n2] = this.udiagRe[n2] - complex.real();
                complexTridiagonalMatrix.udiagIm[n2] = this.udiagIm[n2] - complex.imag();
                ++n2;
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = this.ldiagRe[n] - complex.real();
            complexTridiagonalMatrix.ldiagIm[n] = this.ldiagIm[n] - complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] - complex.real();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] - complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.diagRe[0] = d * this.diagRe[0] - d2 * this.diagIm[0];
        complexTridiagonalMatrix.diagIm[0] = d2 * this.diagRe[0] + d * this.diagIm[0];
        complexTridiagonalMatrix.udiagRe[0] = d * this.udiagRe[0] - d2 * this.udiagIm[0];
        complexTridiagonalMatrix.udiagIm[0] = d2 * this.udiagRe[0] + d * this.udiagIm[0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.ldiagRe[n2] = d * this.ldiagRe[n2] - d2 * this.ldiagIm[n2];
            complexTridiagonalMatrix.ldiagIm[n2] = d2 * this.ldiagRe[n2] + d * this.ldiagIm[n2];
            complexTridiagonalMatrix.diagRe[n2] = d * this.diagRe[n2] - d2 * this.diagIm[n2];
            complexTridiagonalMatrix.diagIm[n2] = d2 * this.diagRe[n2] + d * this.diagIm[n2];
            complexTridiagonalMatrix.udiagRe[n2] = d * this.udiagRe[n2] - d2 * this.udiagIm[n2];
            complexTridiagonalMatrix.udiagIm[n2] = d2 * this.udiagRe[n2] + d * this.udiagIm[n2];
            ++n2;
        }
        complexTridiagonalMatrix.ldiagRe[n] = d * this.ldiagRe[n] - d2 * this.ldiagIm[n];
        complexTridiagonalMatrix.ldiagIm[n] = d2 * this.ldiagRe[n] + d * this.ldiagIm[n];
        complexTridiagonalMatrix.diagRe[n] = d * this.diagRe[n] - d2 * this.diagIm[n];
        complexTridiagonalMatrix.diagIm[n] = d2 * this.diagRe[n] + d * this.diagIm[n];
        return complexTridiagonalMatrix;
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.diagRe[0] = d * this.diagRe[0];
        complexTridiagonalMatrix.diagIm[0] = d * this.diagIm[0];
        complexTridiagonalMatrix.udiagRe[0] = d * this.udiagRe[0];
        complexTridiagonalMatrix.udiagIm[0] = d * this.udiagIm[0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.ldiagRe[n2] = d * this.ldiagRe[n2];
            complexTridiagonalMatrix.ldiagIm[n2] = d * this.ldiagIm[n2];
            complexTridiagonalMatrix.diagRe[n2] = d * this.diagRe[n2];
            complexTridiagonalMatrix.diagIm[n2] = d * this.diagIm[n2];
            complexTridiagonalMatrix.udiagRe[n2] = d * this.udiagRe[n2];
            complexTridiagonalMatrix.udiagIm[n2] = d * this.udiagIm[n2];
            ++n2;
        }
        complexTridiagonalMatrix.ldiagRe[n] = d * this.ldiagRe[n];
        complexTridiagonalMatrix.ldiagIm[n] = d * this.ldiagIm[n];
        complexTridiagonalMatrix.diagRe[n] = d * this.diagRe[n];
        complexTridiagonalMatrix.diagIm[n] = d * this.diagIm[n];
        return complexTridiagonalMatrix;
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        int n = this.numRows;
        if (n == complexVector.dimension()) {
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            Complex complex = complexVector.getComponent(0);
            dArray[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            dArray2[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            complex = complexVector.getComponent(1);
            dArray[0] = dArray[0] + (this.udiagRe[0] * complex.real() - this.udiagIm[0] * complex.imag());
            dArray2[0] = dArray2[0] + (this.udiagIm[0] * complex.real() + this.udiagRe[0] * complex.imag());
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = complexVector.getComponent(n2 - 1);
                dArray[n2] = this.ldiagRe[n2] * complex.real() - this.ldiagIm[n2] * complex.imag();
                dArray2[n2] = this.ldiagIm[n2] * complex.real() + this.ldiagRe[n2] * complex.imag();
                complex = complexVector.getComponent(n2);
                int n3 = n2;
                dArray[n3] = dArray[n3] + (this.diagRe[n2] * complex.real() - this.diagIm[n2] * complex.imag());
                int n4 = n2;
                dArray2[n4] = dArray2[n4] + (this.diagIm[n2] * complex.real() + this.diagRe[n2] * complex.imag());
                complex = complexVector.getComponent(n2 + 1);
                int n5 = n2;
                dArray[n5] = dArray[n5] + (this.udiagRe[n2] * complex.real() - this.udiagIm[n2] * complex.imag());
                int n6 = n2;
                dArray2[n6] = dArray2[n6] + (this.udiagIm[n2] * complex.real() + this.udiagRe[n2] * complex.imag());
                ++n2;
            }
            complex = complexVector.getComponent(n - 1);
            dArray[n] = this.ldiagRe[n] * complex.real() - this.ldiagIm[n] * complex.imag();
            dArray2[n] = this.ldiagIm[n] * complex.real() + this.ldiagRe[n] * complex.imag();
            complex = complexVector.getComponent(n);
            int n7 = n;
            dArray[n7] = dArray[n7] + (this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag());
            int n8 = n;
            dArray2[n8] = dArray2[n8] + (this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag());
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][abstractComplexSquareMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][abstractComplexSquareMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < abstractComplexSquareMatrix.columns()) {
                    Complex complex = this.getElement(n, 0).multiply(abstractComplexSquareMatrix.getElement(0, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        complex = this.getElement(n, n3).multiply(abstractComplexSquareMatrix.getElement(n3, n2));
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + complex.real();
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + complex.imag();
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numCols == complexSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][complexSquareMatrix.numCols];
            double[][] dArray2 = new double[this.numRows][complexSquareMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < complexSquareMatrix.numCols) {
                    Complex complex = this.getElement(n, 0);
                    double d = complexSquareMatrix.matrixRe[0][n2] * complex.real() - complexSquareMatrix.matrixIm[0][n2] * complex.imag();
                    double d2 = complexSquareMatrix.matrixIm[0][n2] * complex.real() + complexSquareMatrix.matrixRe[0][n2] * complex.imag();
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        complex = this.getElement(n, n3);
                        d += complexSquareMatrix.matrixRe[n3][n2] * complex.real() - complexSquareMatrix.matrixIm[n3][n2] * complex.imag();
                        d2 += complexSquareMatrix.matrixIm[n3][n2] * complex.real() + complexSquareMatrix.matrixRe[n3][n2] * complex.imag();
                        ++n3;
                    }
                    dArray[n][n2] = d;
                    dArray2[n][n2] = d2;
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == complexTridiagonalMatrix.numRows) {
            double[][] dArray = new double[n][n];
            double[][] dArray2 = new double[n][n];
            dArray[0][0] = this.diagRe[0] * complexTridiagonalMatrix.diagRe[0] - this.diagIm[0] * complexTridiagonalMatrix.diagIm[0] + (this.udiagRe[0] * complexTridiagonalMatrix.ldiagRe[1] - this.udiagIm[0] * complexTridiagonalMatrix.ldiagIm[1]);
            dArray2[0][0] = this.diagIm[0] * complexTridiagonalMatrix.diagRe[0] + this.diagRe[0] * complexTridiagonalMatrix.diagIm[0] + (this.udiagIm[0] * complexTridiagonalMatrix.ldiagRe[1] + this.udiagRe[0] * complexTridiagonalMatrix.ldiagIm[1]);
            dArray[0][1] = this.diagRe[0] * complexTridiagonalMatrix.udiagRe[0] - this.diagIm[0] * complexTridiagonalMatrix.udiagIm[0] + (this.udiagRe[0] * complexTridiagonalMatrix.diagRe[1] - this.udiagIm[0] * complexTridiagonalMatrix.diagIm[1]);
            dArray2[0][1] = this.diagIm[0] * complexTridiagonalMatrix.udiagRe[0] + this.diagRe[0] * complexTridiagonalMatrix.udiagIm[0] + (this.udiagIm[0] * complexTridiagonalMatrix.diagRe[1] + this.udiagRe[0] * complexTridiagonalMatrix.diagIm[1]);
            dArray[0][2] = this.udiagRe[0] * complexTridiagonalMatrix.udiagRe[1] - this.udiagIm[0] * complexTridiagonalMatrix.udiagIm[1];
            dArray2[0][2] = this.udiagIm[0] * complexTridiagonalMatrix.udiagRe[1] + this.udiagRe[0] * complexTridiagonalMatrix.udiagIm[1];
            if (n > 3) {
                dArray[1][0] = this.ldiagRe[1] * complexTridiagonalMatrix.diagRe[0] - this.ldiagIm[1] * complexTridiagonalMatrix.diagIm[0] + (this.diagRe[1] * complexTridiagonalMatrix.ldiagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.ldiagIm[1]);
                dArray2[1][0] = this.ldiagIm[1] * complexTridiagonalMatrix.diagRe[0] + this.ldiagRe[1] * complexTridiagonalMatrix.diagIm[0] + (this.diagIm[1] * complexTridiagonalMatrix.ldiagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.ldiagIm[1]);
                dArray[1][1] = this.ldiagRe[1] * complexTridiagonalMatrix.udiagRe[0] - this.ldiagIm[1] * complexTridiagonalMatrix.udiagIm[0] + (this.diagRe[1] * complexTridiagonalMatrix.diagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.diagIm[1]) + (this.udiagRe[1] * complexTridiagonalMatrix.ldiagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.ldiagIm[2]);
                dArray2[1][1] = this.ldiagIm[1] * complexTridiagonalMatrix.udiagRe[0] + this.ldiagRe[1] * complexTridiagonalMatrix.udiagIm[0] + (this.diagIm[1] * complexTridiagonalMatrix.diagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.diagIm[1]) + (this.udiagIm[1] * complexTridiagonalMatrix.ldiagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.ldiagIm[2]);
                dArray[1][2] = this.diagRe[1] * complexTridiagonalMatrix.udiagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.udiagIm[1] + (this.udiagRe[1] * complexTridiagonalMatrix.diagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.diagIm[2]);
                dArray2[1][2] = this.diagIm[1] * complexTridiagonalMatrix.udiagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.udiagIm[1] + (this.udiagIm[1] * complexTridiagonalMatrix.diagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.diagIm[2]);
                dArray[1][3] = this.udiagRe[1] * complexTridiagonalMatrix.udiagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.udiagIm[2];
                dArray2[1][3] = this.udiagIm[1] * complexTridiagonalMatrix.udiagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.udiagIm[2];
            }
            if (n == 3) {
                dArray[1][0] = this.ldiagRe[1] * complexTridiagonalMatrix.diagRe[0] - this.ldiagIm[1] * complexTridiagonalMatrix.diagIm[0] + (this.diagRe[1] * complexTridiagonalMatrix.ldiagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.ldiagIm[1]);
                dArray2[1][0] = this.ldiagIm[1] * complexTridiagonalMatrix.diagRe[0] + this.ldiagRe[1] * complexTridiagonalMatrix.diagIm[0] + (this.diagIm[1] * complexTridiagonalMatrix.ldiagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.ldiagIm[1]);
                dArray[1][1] = this.ldiagRe[1] * complexTridiagonalMatrix.udiagRe[0] - this.ldiagIm[1] * complexTridiagonalMatrix.udiagIm[0] + (this.diagRe[1] * complexTridiagonalMatrix.diagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.diagIm[1]) + (this.udiagRe[1] * complexTridiagonalMatrix.ldiagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.ldiagIm[2]);
                dArray2[1][1] = this.ldiagIm[1] * complexTridiagonalMatrix.udiagRe[0] + this.ldiagRe[1] * complexTridiagonalMatrix.udiagIm[0] + (this.diagIm[1] * complexTridiagonalMatrix.diagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.diagIm[1]) + (this.udiagIm[1] * complexTridiagonalMatrix.ldiagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.ldiagIm[2]);
                dArray[1][2] = this.diagRe[1] * complexTridiagonalMatrix.udiagRe[1] - this.diagIm[1] * complexTridiagonalMatrix.udiagIm[1] + (this.udiagRe[1] * complexTridiagonalMatrix.diagRe[2] - this.udiagIm[1] * complexTridiagonalMatrix.diagIm[2]);
                dArray2[1][2] = this.diagIm[1] * complexTridiagonalMatrix.udiagRe[1] + this.diagRe[1] * complexTridiagonalMatrix.udiagIm[1] + (this.udiagIm[1] * complexTridiagonalMatrix.diagRe[2] + this.udiagRe[1] * complexTridiagonalMatrix.diagIm[2]);
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    dArray[n2][n2 - 2] = this.ldiagRe[n2] * complexTridiagonalMatrix.ldiagRe[n2 - 1] - this.ldiagIm[n2] * complexTridiagonalMatrix.ldiagIm[n2 - 1];
                    dArray2[n2][n2 - 2] = this.ldiagIm[n2] * complexTridiagonalMatrix.ldiagRe[n2 - 1] + this.ldiagRe[n2] * complexTridiagonalMatrix.ldiagIm[n2 - 1];
                    dArray[n2][n2 - 1] = this.ldiagRe[n2] * complexTridiagonalMatrix.diagRe[n2 - 1] - this.ldiagIm[n2] * complexTridiagonalMatrix.diagIm[n2 - 1] + (this.diagRe[n2] * complexTridiagonalMatrix.ldiagRe[n2] - this.diagIm[n2] * complexTridiagonalMatrix.ldiagIm[n2]);
                    dArray2[n2][n2 - 1] = this.ldiagIm[n2] * complexTridiagonalMatrix.diagRe[n2 - 1] + this.ldiagRe[n2] * complexTridiagonalMatrix.diagIm[n2 - 1] + (this.diagIm[n2] * complexTridiagonalMatrix.ldiagRe[n2] + this.diagRe[n2] * complexTridiagonalMatrix.ldiagIm[n2]);
                    dArray[n2][n2] = this.ldiagRe[n2] * complexTridiagonalMatrix.udiagRe[n2 - 1] - this.ldiagIm[n2] * complexTridiagonalMatrix.udiagIm[n2 - 1] + (this.diagRe[n2] * complexTridiagonalMatrix.diagRe[n2] - this.diagIm[n2] * complexTridiagonalMatrix.diagIm[n2]) + (this.udiagRe[n2] * complexTridiagonalMatrix.ldiagRe[n2 + 1] - this.udiagIm[n2] * complexTridiagonalMatrix.ldiagIm[n2 + 1]);
                    dArray2[n2][n2] = this.ldiagIm[n2] * complexTridiagonalMatrix.udiagRe[n2 - 1] + this.ldiagRe[n2] * complexTridiagonalMatrix.udiagIm[n2 - 1] + (this.diagIm[n2] * complexTridiagonalMatrix.diagRe[n2] + this.diagRe[n2] * complexTridiagonalMatrix.diagIm[n2]) + (this.udiagIm[n2] * complexTridiagonalMatrix.ldiagRe[n2 + 1] + this.udiagRe[n2] * complexTridiagonalMatrix.ldiagIm[n2 + 1]);
                    dArray[n2][n2 + 1] = this.diagRe[n2] * complexTridiagonalMatrix.udiagRe[n2] - this.diagIm[n2] * complexTridiagonalMatrix.udiagIm[n2] + (this.udiagRe[n2] * complexTridiagonalMatrix.diagRe[n2 + 1] - this.udiagIm[n2] * complexTridiagonalMatrix.diagIm[n2 + 1]);
                    dArray2[n2][n2 + 1] = this.diagIm[n2] * complexTridiagonalMatrix.udiagRe[n2] + this.diagRe[n2] * complexTridiagonalMatrix.udiagIm[n2] + (this.udiagIm[n2] * complexTridiagonalMatrix.diagRe[n2 + 1] + this.udiagRe[n2] * complexTridiagonalMatrix.diagIm[n2 + 1]);
                    dArray[n2][n2 + 2] = this.udiagRe[n2] * complexTridiagonalMatrix.udiagRe[n2 + 1] - this.udiagIm[n2] * complexTridiagonalMatrix.udiagIm[n2 + 1];
                    dArray2[n2][n2 + 2] = this.udiagIm[n2] * complexTridiagonalMatrix.udiagRe[n2 + 1] + this.udiagRe[n2] * complexTridiagonalMatrix.udiagIm[n2 + 1];
                    ++n2;
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.ldiagRe[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 3] - this.ldiagIm[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 3];
                dArray2[n - 2][n - 4] = this.ldiagIm[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 3] + this.ldiagRe[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 3];
                dArray[n - 2][n - 3] = this.ldiagRe[n - 2] * complexTridiagonalMatrix.diagRe[n - 3] - this.ldiagIm[n - 2] * complexTridiagonalMatrix.diagIm[n - 3] + (this.diagRe[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 2] - this.diagIm[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 2]);
                dArray2[n - 2][n - 3] = this.ldiagIm[n - 2] * complexTridiagonalMatrix.diagRe[n - 3] + this.ldiagRe[n - 2] * complexTridiagonalMatrix.diagIm[n - 3] + (this.diagIm[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 2] + this.diagRe[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 2]);
                dArray[n - 2][n - 2] = this.ldiagRe[n - 2] * complexTridiagonalMatrix.udiagRe[n - 3] - this.ldiagIm[n - 2] * complexTridiagonalMatrix.udiagIm[n - 3] + (this.diagRe[n - 2] * complexTridiagonalMatrix.diagRe[n - 2] - this.diagIm[n - 2] * complexTridiagonalMatrix.diagIm[n - 2]) + (this.udiagRe[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 1] - this.udiagIm[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 1]);
                dArray2[n - 2][n - 2] = this.ldiagIm[n - 2] * complexTridiagonalMatrix.udiagRe[n - 3] + this.ldiagRe[n - 2] * complexTridiagonalMatrix.udiagIm[n - 3] + (this.diagIm[n - 2] * complexTridiagonalMatrix.diagRe[n - 2] + this.diagRe[n - 2] * complexTridiagonalMatrix.diagIm[n - 2]) + (this.udiagIm[n - 2] * complexTridiagonalMatrix.ldiagRe[n - 1] + this.udiagRe[n - 2] * complexTridiagonalMatrix.ldiagIm[n - 1]);
                dArray[n - 2][n - 1] = this.diagRe[n - 2] * complexTridiagonalMatrix.udiagRe[n - 2] - this.diagIm[n - 2] * complexTridiagonalMatrix.udiagIm[n - 2] + (this.udiagRe[n - 2] * complexTridiagonalMatrix.diagRe[n - 1] - this.udiagIm[n - 2] * complexTridiagonalMatrix.diagIm[n - 1]);
                dArray2[n - 2][n - 1] = this.diagIm[n - 2] * complexTridiagonalMatrix.udiagRe[n - 2] + this.diagRe[n - 2] * complexTridiagonalMatrix.udiagIm[n - 2] + (this.udiagIm[n - 2] * complexTridiagonalMatrix.diagRe[n - 1] + this.udiagRe[n - 2] * complexTridiagonalMatrix.diagIm[n - 1]);
            }
            dArray[n][--n - 2] = this.ldiagRe[n] * complexTridiagonalMatrix.ldiagRe[n - 1] - this.ldiagIm[n] * complexTridiagonalMatrix.ldiagIm[n - 1];
            dArray2[n][n - 2] = this.ldiagIm[n] * complexTridiagonalMatrix.ldiagRe[n - 1] + this.ldiagRe[n] * complexTridiagonalMatrix.ldiagIm[n - 1];
            dArray[n][n - 1] = this.ldiagRe[n] * complexTridiagonalMatrix.diagRe[n - 1] - this.ldiagIm[n] * complexTridiagonalMatrix.diagIm[n - 1] + (this.diagRe[n] * complexTridiagonalMatrix.ldiagRe[n] - this.diagIm[n] * complexTridiagonalMatrix.ldiagIm[n]);
            dArray2[n][n - 1] = this.ldiagIm[n] * complexTridiagonalMatrix.diagRe[n - 1] + this.ldiagRe[n] * complexTridiagonalMatrix.diagIm[n - 1] + (this.diagIm[n] * complexTridiagonalMatrix.ldiagRe[n] + this.diagRe[n] * complexTridiagonalMatrix.ldiagIm[n]);
            dArray[n][n] = this.ldiagRe[n] * complexTridiagonalMatrix.udiagRe[n - 1] - this.ldiagIm[n] * complexTridiagonalMatrix.udiagIm[n - 1] + (this.diagRe[n] * complexTridiagonalMatrix.diagRe[n] - this.diagIm[n] * complexTridiagonalMatrix.diagIm[n]);
            dArray2[n][n] = this.ldiagIm[n] * complexTridiagonalMatrix.udiagRe[n - 1] + this.ldiagRe[n] * complexTridiagonalMatrix.udiagIm[n - 1] + (this.diagIm[n] * complexTridiagonalMatrix.diagRe[n] + this.diagRe[n] * complexTridiagonalMatrix.diagIm[n]);
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix multiplyTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            Complex complex;
            double[][] dArray = new double[n][n];
            double[][] dArray2 = new double[n][n];
            Complex complex2 = abstractComplexSquareMatrix.getElement(0, 0);
            Complex complex3 = abstractComplexSquareMatrix.getElement(1, 0);
            dArray[0][0] = this.diagRe[0] * complex2.real() - this.diagIm[0] * complex2.imag() + (this.udiagRe[0] * complex3.real() - this.udiagIm[0] * complex3.imag());
            dArray2[0][0] = this.diagIm[0] * complex2.real() + this.diagRe[0] * complex2.imag() + (this.udiagIm[0] * complex3.real() + this.udiagRe[0] * complex3.imag());
            complex2 = abstractComplexSquareMatrix.getElement(0, 1);
            complex3 = abstractComplexSquareMatrix.getElement(1, 1);
            dArray[0][1] = this.diagRe[0] * complex2.real() - this.diagIm[0] * complex2.imag() + (this.udiagRe[0] * complex3.real() - this.udiagIm[0] * complex3.imag());
            dArray2[0][1] = this.diagIm[0] * complex2.real() + this.diagRe[0] * complex2.imag() + (this.udiagIm[0] * complex3.real() + this.udiagRe[0] * complex3.imag());
            complex2 = abstractComplexSquareMatrix.getElement(1, 2);
            dArray[0][2] = this.udiagRe[0] * complex2.real() - this.udiagIm[0] * complex2.imag();
            dArray2[0][2] = this.udiagIm[0] * complex2.real() + this.udiagRe[0] * complex2.imag();
            if (n > 3) {
                complex2 = abstractComplexSquareMatrix.getElement(0, 0);
                complex3 = abstractComplexSquareMatrix.getElement(1, 0);
                dArray[1][0] = this.ldiagRe[1] * complex2.real() - this.ldiagIm[1] * complex2.imag() + (this.diagRe[1] * complex3.real() - this.diagIm[1] * complex3.imag());
                dArray2[1][0] = this.ldiagIm[1] * complex2.real() + this.ldiagRe[1] * complex2.imag() + (this.diagIm[1] * complex3.real() + this.diagRe[1] * complex3.imag());
                complex2 = abstractComplexSquareMatrix.getElement(0, 1);
                complex3 = abstractComplexSquareMatrix.getElement(1, 1);
                complex = abstractComplexSquareMatrix.getElement(2, 1);
                dArray[1][1] = this.ldiagRe[1] * complex2.real() - this.ldiagIm[1] * complex2.imag() + (this.diagRe[1] * complex3.real() - this.diagIm[1] * complex3.imag()) + (this.udiagRe[1] * complex.real() - this.udiagIm[1] * complex.imag());
                dArray2[1][1] = this.ldiagIm[1] * complex2.real() + this.ldiagRe[1] * complex2.imag() + (this.diagIm[1] * complex3.real() + this.diagRe[1] * complex3.imag()) + (this.udiagIm[1] * complex.real() + this.udiagRe[1] * complex.imag());
                complex2 = abstractComplexSquareMatrix.getElement(1, 2);
                complex3 = abstractComplexSquareMatrix.getElement(2, 2);
                dArray[1][2] = this.diagRe[1] * complex2.real() - this.diagIm[1] * complex2.imag() + (this.udiagRe[1] * complex3.real() - this.udiagIm[1] * complex3.imag());
                dArray2[1][2] = this.diagIm[1] * complex2.real() + this.diagRe[1] * complex2.imag() + (this.udiagIm[1] * complex3.real() + this.udiagRe[1] * complex3.imag());
                complex2 = abstractComplexSquareMatrix.getElement(2, 3);
                dArray[1][3] = this.udiagRe[1] * complex2.real() - this.udiagIm[1] * complex2.imag();
                dArray2[1][3] = this.udiagIm[1] * complex2.real() + this.udiagRe[1] * complex2.imag();
            }
            if (n == 3) {
                complex2 = abstractComplexSquareMatrix.getElement(0, 0);
                complex3 = abstractComplexSquareMatrix.getElement(1, 0);
                dArray[1][0] = this.ldiagRe[1] * complex2.real() - this.ldiagIm[1] * complex2.imag() + (this.diagRe[1] * complex3.real() - this.diagIm[1] * complex3.imag());
                dArray2[1][0] = this.ldiagIm[1] * complex2.real() + this.ldiagRe[1] * complex2.imag() + (this.diagIm[1] * complex3.real() + this.diagRe[1] * complex3.imag());
                complex2 = abstractComplexSquareMatrix.getElement(0, 1);
                complex3 = abstractComplexSquareMatrix.getElement(1, 1);
                complex = abstractComplexSquareMatrix.getElement(2, 1);
                dArray[1][1] = this.ldiagRe[1] * complex2.real() - this.ldiagIm[1] * complex2.imag() + (this.diagRe[1] * complex3.real() - this.diagIm[1] * complex3.imag()) + (this.udiagRe[1] * complex.real() - this.udiagIm[1] * complex.imag());
                dArray2[1][1] = this.ldiagIm[1] * complex2.real() + this.ldiagRe[1] * complex2.imag() + (this.diagIm[1] * complex3.real() + this.diagRe[1] * complex3.imag()) + (this.udiagIm[1] * complex.real() + this.udiagRe[1] * complex.imag());
                complex2 = abstractComplexSquareMatrix.getElement(1, 2);
                complex3 = abstractComplexSquareMatrix.getElement(2, 2);
                dArray[1][2] = this.diagRe[1] * complex2.real() - this.diagIm[1] * complex2.imag() + (this.udiagRe[1] * complex3.real() - this.udiagIm[1] * complex3.imag());
                dArray2[1][2] = this.diagIm[1] * complex2.real() + this.diagRe[1] * complex2.imag() + (this.udiagIm[1] * complex3.real() + this.udiagRe[1] * complex3.imag());
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    complex2 = abstractComplexSquareMatrix.getElement(n2 - 1, n2 - 2);
                    dArray[n2][n2 - 2] = this.ldiagRe[n2] * complex2.real() - this.ldiagIm[n2] * complex2.imag();
                    dArray2[n2][n2 - 2] = this.ldiagIm[n2] * complex2.real() + this.ldiagRe[n2] * complex2.imag();
                    complex2 = abstractComplexSquareMatrix.getElement(n2 - 1, n2 - 1);
                    complex3 = abstractComplexSquareMatrix.getElement(n2, n2 - 1);
                    dArray[n2][n2 - 1] = this.ldiagRe[n2] * complex2.real() - this.ldiagIm[n2] * complex2.imag() + (this.diagRe[n2] * complex3.real() - this.diagIm[n2] * complex3.imag());
                    dArray2[n2][n2 - 1] = this.ldiagIm[n2] * complex2.real() + this.ldiagRe[n2] * complex2.imag() + (this.diagIm[n2] * complex3.real() + this.diagRe[n2] * complex3.imag());
                    complex2 = abstractComplexSquareMatrix.getElement(n2 - 1, n2);
                    complex3 = abstractComplexSquareMatrix.getElement(n2, n2);
                    complex = abstractComplexSquareMatrix.getElement(n2 + 1, n2);
                    dArray[n2][n2] = this.ldiagRe[n2] * complex2.real() - this.ldiagIm[n2] * complex2.imag() + (this.diagRe[n2] * complex3.real() - this.diagIm[n2] * complex3.imag()) + (this.udiagRe[n2] * complex.real() - this.udiagIm[n2] * complex.imag());
                    dArray2[n2][n2] = this.ldiagIm[n2] * complex2.real() + this.ldiagRe[n2] * complex2.imag() + (this.diagIm[n2] * complex3.real() + this.diagRe[n2] * complex3.imag()) + (this.udiagIm[n2] * complex.real() + this.udiagRe[n2] * complex.imag());
                    complex2 = abstractComplexSquareMatrix.getElement(n2, n2 + 1);
                    complex3 = abstractComplexSquareMatrix.getElement(n2 + 1, n2 + 1);
                    dArray[n2][n2 + 1] = this.diagRe[n2] * complex2.real() - this.diagIm[n2] * complex2.imag() + (this.udiagRe[n2] * complex3.real() - this.udiagIm[n2] * complex3.imag());
                    dArray2[n2][n2 + 1] = this.diagIm[n2] * complex2.real() + this.diagRe[n2] * complex2.imag() + (this.udiagIm[n2] * complex3.real() + this.udiagRe[n2] * complex3.imag());
                    complex2 = abstractComplexSquareMatrix.getElement(n2 + 1, n2 + 2);
                    dArray[n2][n2 + 2] = this.udiagRe[n2] * complex2.real() - this.udiagIm[n2] * complex2.imag();
                    dArray2[n2][n2 + 2] = this.udiagIm[n2] * complex2.real() + this.udiagRe[n2] * complex2.imag();
                    ++n2;
                }
            }
            if (n > 3) {
                complex2 = abstractComplexSquareMatrix.getElement(n - 3, n - 4);
                dArray[n - 2][n - 4] = this.ldiagRe[n - 2] * complex2.real() - this.ldiagIm[n - 2] * complex2.imag();
                dArray2[n - 2][n - 4] = this.ldiagIm[n - 2] * complex2.real() + this.ldiagRe[n - 2] * complex2.imag();
                complex2 = abstractComplexSquareMatrix.getElement(n - 3, n - 3);
                complex3 = abstractComplexSquareMatrix.getElement(n - 2, n - 3);
                dArray[n - 2][n - 3] = this.ldiagRe[n - 2] * complex2.real() - this.ldiagIm[n - 2] * complex2.imag() + (this.diagRe[n - 2] * complex3.real() - this.diagIm[n - 2] * complex3.imag());
                dArray2[n - 2][n - 3] = this.ldiagIm[n - 2] * complex2.real() + this.ldiagRe[n - 2] * complex2.imag() + (this.diagIm[n - 2] * complex3.real() + this.diagRe[n - 2] * complex3.imag());
                complex2 = abstractComplexSquareMatrix.getElement(n - 3, n - 2);
                complex3 = abstractComplexSquareMatrix.getElement(n - 2, n - 2);
                complex = abstractComplexSquareMatrix.getElement(n - 1, n - 2);
                dArray[n - 2][n - 2] = this.ldiagRe[n - 2] * complex2.real() - this.ldiagIm[n - 2] * complex2.imag() + (this.diagRe[n - 2] * complex3.real() - this.diagIm[n - 2] * complex3.imag()) + (this.udiagRe[n - 2] * complex.real() - this.udiagIm[n - 2] * complex.imag());
                dArray2[n - 2][n - 2] = this.ldiagIm[n - 2] * complex2.real() + this.ldiagRe[n - 2] * complex2.imag() + (this.diagIm[n - 2] * complex3.real() + this.diagRe[n - 2] * complex3.imag()) + (this.udiagIm[n - 2] * complex.real() + this.udiagRe[n - 2] * complex.imag());
                complex2 = abstractComplexSquareMatrix.getElement(n - 2, n - 1);
                complex3 = abstractComplexSquareMatrix.getElement(n - 1, n - 1);
                dArray[n - 2][n - 1] = this.diagRe[n - 2] * complex2.real() - this.diagIm[n - 2] * complex2.imag() + (this.udiagRe[n - 2] * complex3.real() - this.udiagIm[n - 2] * complex3.imag());
                dArray2[n - 2][n - 1] = this.diagIm[n - 2] * complex2.real() + this.diagRe[n - 2] * complex2.imag() + (this.udiagIm[n - 2] * complex3.real() + this.udiagRe[n - 2] * complex3.imag());
            }
            complex2 = abstractComplexSquareMatrix.getElement(--n - 1, n - 2);
            dArray[n][n - 2] = this.ldiagRe[n] * complex2.real() - this.ldiagIm[n] * complex2.imag();
            dArray2[n][n - 2] = this.ldiagIm[n] * complex2.real() + this.ldiagRe[n] * complex2.imag();
            complex2 = abstractComplexSquareMatrix.getElement(n - 1, n - 1);
            complex3 = abstractComplexSquareMatrix.getElement(n, n - 1);
            dArray[n][n - 1] = this.ldiagRe[n] * complex2.real() - this.ldiagIm[n] * complex2.imag() + (this.diagRe[n] * complex3.real() - this.diagIm[n] * complex3.imag());
            dArray2[n][n - 1] = this.ldiagIm[n] * complex2.real() + this.ldiagRe[n] * complex2.imag() + (this.diagIm[n] * complex3.real() + this.diagRe[n] * complex3.imag());
            complex2 = abstractComplexSquareMatrix.getElement(n - 1, n);
            complex3 = abstractComplexSquareMatrix.getElement(n, n);
            dArray[n][n] = this.ldiagRe[n] * complex2.real() - this.ldiagIm[n] * complex2.imag() + (this.diagRe[n] * complex3.real() - this.diagIm[n] * complex3.imag());
            dArray2[n][n] = this.ldiagIm[n] * complex2.real() + this.ldiagRe[n] * complex2.imag() + (this.diagIm[n] * complex3.real() + this.diagRe[n] * complex3.imag());
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        System.arraycopy(this.ldiagRe, 1, complexTridiagonalMatrix.udiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.diagRe, 0, complexTridiagonalMatrix.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.udiagRe, 0, complexTridiagonalMatrix.ldiagRe, 1, this.udiagRe.length - 1);
        complexTridiagonalMatrix.diagIm[0] = -this.diagIm[0];
        complexTridiagonalMatrix.ldiagIm[1] = -this.udiagIm[0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.udiagIm[n2 - 1] = -this.ldiagIm[n2];
            complexTridiagonalMatrix.diagIm[n2] = -this.diagIm[n2];
            complexTridiagonalMatrix.ldiagIm[n2 + 1] = -this.udiagIm[n2];
            ++n2;
        }
        complexTridiagonalMatrix.udiagIm[n - 1] = -this.ldiagIm[n];
        complexTridiagonalMatrix.diagIm[n] = -this.diagIm[n];
        return complexTridiagonalMatrix;
    }

    public AbstractComplexMatrix conjugate() {
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        System.arraycopy(this.ldiagRe, 1, complexTridiagonalMatrix.ldiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.diagRe, 0, complexTridiagonalMatrix.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.udiagRe, 0, complexTridiagonalMatrix.udiagRe, 1, this.udiagRe.length - 1);
        complexTridiagonalMatrix.diagIm[0] = -this.diagIm[0];
        complexTridiagonalMatrix.udiagIm[0] = -this.udiagIm[0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.ldiagIm[n2] = -this.ldiagIm[n2];
            complexTridiagonalMatrix.diagIm[n2] = -this.diagIm[n2];
            complexTridiagonalMatrix.udiagIm[n2] = -this.udiagIm[n2];
            ++n2;
        }
        complexTridiagonalMatrix.ldiagIm[n] = -this.ldiagIm[n];
        complexTridiagonalMatrix.diagIm[n] = -this.diagIm[n];
        return complexTridiagonalMatrix;
    }

    public Matrix transpose() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.numRows);
        System.arraycopy(this.ldiagRe, 1, complexTridiagonalMatrix.udiagRe, 0, this.ldiagRe.length - 1);
        System.arraycopy(this.ldiagIm, 1, complexTridiagonalMatrix.udiagIm, 0, this.ldiagIm.length - 1);
        System.arraycopy(this.diagRe, 0, complexTridiagonalMatrix.diagRe, 0, this.diagRe.length);
        System.arraycopy(this.diagIm, 0, complexTridiagonalMatrix.diagIm, 0, this.diagIm.length);
        System.arraycopy(this.udiagRe, 0, complexTridiagonalMatrix.ldiagRe, 1, this.udiagRe.length - 1);
        System.arraycopy(this.udiagIm, 0, complexTridiagonalMatrix.ldiagIm, 1, this.udiagIm.length - 1);
        return complexTridiagonalMatrix;
    }

    public AbstractComplexSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        double[] dArray5 = new double[n];
        if (nArray == null) {
            nArray = new int[n + 1];
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        nArray[n] = 1;
        int n3 = 0;
        while (n3 < n) {
            double d;
            double d2;
            double d3;
            int n4;
            double d4;
            double d5;
            Complex complex;
            n2 = 0;
            while (n2 < n3) {
                complex = this.getElement(nArray[n2], n3);
                d5 = complex.real();
                d4 = complex.imag();
                n4 = 0;
                while (n4 < n2) {
                    d5 -= dArray3[n2][n4] * dArray3[n4][n3] - dArray4[n2][n4] * dArray4[n4][n3];
                    d4 -= dArray4[n2][n4] * dArray3[n4][n3] + dArray3[n2][n4] * dArray4[n4][n3];
                    ++n4;
                }
                dArray3[n2][n3] = d5;
                dArray4[n2][n3] = d4;
                ++n2;
            }
            double d6 = 0.0;
            int n5 = n3;
            n2 = n3;
            while (n2 < n) {
                complex = this.getElement(nArray[n2], n3);
                d5 = complex.real();
                d4 = complex.imag();
                n4 = 0;
                while (n4 < n3) {
                    d5 -= dArray3[n2][n4] * dArray3[n4][n3] - dArray4[n2][n4] * dArray4[n4][n3];
                    d4 -= dArray4[n2][n4] * dArray3[n4][n3] + dArray3[n2][n4] * dArray4[n4][n3];
                    ++n4;
                }
                dArray3[n2][n3] = d5;
                dArray4[n2][n3] = d4;
                d3 = d5 * d5 + d4 * d4;
                if (d3 > d6) {
                    d6 = d3;
                    n5 = n2;
                }
                ++n2;
            }
            if (n5 != n3) {
                System.arraycopy(dArray3[n3], 0, dArray5, 0, n3 + 1);
                System.arraycopy(dArray3[n5], 0, dArray3[n3], 0, n3 + 1);
                System.arraycopy(dArray5, 0, dArray3[n5], 0, n3 + 1);
                System.arraycopy(dArray4[n3], 0, dArray5, 0, n3 + 1);
                System.arraycopy(dArray4[n5], 0, dArray4[n3], 0, n3 + 1);
                System.arraycopy(dArray5, 0, dArray4[n5], 0, n3 + 1);
                n4 = nArray[n3];
                nArray[n3] = nArray[n5];
                nArray[n5] = n4;
                nArray[n] = -nArray[n];
            }
            d5 = dArray3[n3][n3];
            d4 = dArray4[n3][n3];
            if (Math.abs(d5) < Math.abs(d4)) {
                d2 = d5 / d4;
                d = d5 * d2 + d4;
                n2 = n3 + 1;
                while (n2 < n) {
                    d3 = (dArray3[n2][n3] * d2 + dArray4[n2][n3]) / d;
                    dArray4[n2][n3] = (dArray4[n2][n3] * d2 - dArray3[n2][n3]) / d;
                    dArray3[n2][n3] = d3;
                    ++n2;
                }
            } else {
                d2 = d4 / d5;
                d = d5 + d4 * d2;
                n2 = n3 + 1;
                while (n2 < n) {
                    d3 = (dArray3[n2][n3] + dArray4[n2][n3] * d2) / d;
                    dArray4[n2][n3] = (dArray4[n2][n3] - dArray3[n2][n3] * d2) / d;
                    dArray3[n2][n3] = d3;
                    ++n2;
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            dArray[n3][n3] = 1.0;
            n2 = n3 + 1;
            while (n2 < n) {
                dArray[n2][n3] = dArray3[n2][n3];
                dArray2[n2][n3] = dArray4[n2][n3];
                dArray3[n2][n3] = 0.0;
                dArray4[n2][n3] = 0.0;
                ++n2;
            }
            ++n3;
        }
        this.LU = new ComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(dArray, dArray2);
        this.LU[1] = new ComplexSquareMatrix(dArray3, dArray4);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        int n = this.numRows;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.setElement(0, 0, complexMapping.map(this.diagRe[0], this.diagIm[0]));
        complexTridiagonalMatrix.setElement(0, 1, complexMapping.map(this.udiagRe[0], this.udiagIm[0]));
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.setElement(n2, n2 - 1, complexMapping.map(this.ldiagRe[n2], this.ldiagIm[n2]));
            complexTridiagonalMatrix.setElement(n2, n2, complexMapping.map(this.diagRe[n2], this.diagIm[n2]));
            complexTridiagonalMatrix.setElement(n2, n2 + 1, complexMapping.map(this.udiagRe[n2], this.udiagIm[n2]));
            ++n2;
        }
        complexTridiagonalMatrix.setElement(n, n - 1, complexMapping.map(this.ldiagRe[n], this.ldiagIm[n]));
        complexTridiagonalMatrix.setElement(n, n, complexMapping.map(this.diagRe[n], this.diagIm[n]));
        return complexTridiagonalMatrix;
    }
}

