/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.AbstractDoubleSquareMatrix;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class DoubleSparseSquareMatrix
extends AbstractDoubleSquareMatrix {
    private double[] elements;
    private int[] colPos;
    private int[] rows;

    public DoubleSparseSquareMatrix(int n) {
        super(n);
        this.elements = new double[0];
        this.colPos = new int[0];
        this.rows = new int[this.numRows + 1];
    }

    public DoubleSparseSquareMatrix(double[][] dArray) {
        super(dArray.length);
        int n;
        this.rows = new int[this.numRows + 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numRows) {
            if (dArray[n3].length != dArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            n = 0;
            while (n < this.numCols) {
                if (Math.abs(dArray[n3][n]) > GlobalSettings.ZERO_TOL) {
                    ++n2;
                }
                ++n;
            }
            ++n3;
        }
        this.elements = new double[n2];
        this.colPos = new int[n2];
        n2 = 0;
        n = 0;
        while (n < this.numRows) {
            this.rows[n] = n2;
            int n4 = 0;
            while (n4 < this.numCols) {
                if (Math.abs(dArray[n][n4]) > GlobalSettings.ZERO_TOL) {
                    this.elements[n2] = dArray[n][n4];
                    this.colPos[n2] = n4;
                    ++n2;
                }
                ++n4;
            }
            ++n;
        }
        this.rows[this.numRows] = n2;
    }

    public boolean equals(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numRows == abstractDoubleSquareMatrix.numRows && this.numCols == abstractDoubleSquareMatrix.numCols) {
            if (abstractDoubleSquareMatrix instanceof DoubleSparseSquareMatrix) {
                DoubleSparseSquareMatrix doubleSparseSquareMatrix = (DoubleSparseSquareMatrix)abstractDoubleSquareMatrix;
                if (this.colPos.length != doubleSparseSquareMatrix.colPos.length) {
                    return false;
                }
                int n = 1;
                while (n < this.rows.length) {
                    if (this.rows[n] != doubleSparseSquareMatrix.rows[n]) {
                        return false;
                    }
                    ++n;
                }
                int n2 = 1;
                while (n2 < this.colPos.length) {
                    if (this.colPos[n2] != doubleSparseSquareMatrix.colPos[n2]) {
                        return false;
                    }
                    if (Math.abs(this.elements[n2] - doubleSparseSquareMatrix.elements[n2]) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            int n = 0;
            while (n < this.numRows) {
                int n3 = 0;
                while (n3 < this.numCols) {
                    if (Math.abs(this.getElement(n, n3) - abstractDoubleSquareMatrix.getElement(n, n3)) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n3;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                nArray[n][n2] = Math.round((float)this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new IntegerSquareMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, new double[this.numRows][this.numCols]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    return this.elements[n3];
                }
                ++n3;
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
                return;
            }
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    this.elements[n3] = d;
                    return;
                }
                ++n3;
            }
            double[] dArray = this.elements;
            int[] nArray = this.colPos;
            this.elements = new double[dArray.length + 1];
            this.colPos = new int[nArray.length + 1];
            System.arraycopy(dArray, 0, this.elements, 0, this.rows[n]);
            System.arraycopy(nArray, 0, this.colPos, 0, this.rows[n]);
            int n4 = this.rows[n];
            while (n4 < this.rows[n + 1] && nArray[n4] < n2) {
                this.elements[n4] = dArray[n4];
                this.colPos[n4] = nArray[n4];
                ++n4;
            }
            this.elements[n4] = d;
            this.colPos[n4] = n2;
            System.arraycopy(dArray, n4, this.elements, n4 + 1, dArray.length - n4);
            System.arraycopy(nArray, n4, this.colPos, n4 + 1, nArray.length - n4);
            n4 = n + 1;
            while (n4 < this.rows.length) {
                int n5 = n4++;
                this.rows[n5] = this.rows[n5] + 1;
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
    }

    public double det() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = this.luDecompose(null);
        double d = abstractDoubleSquareMatrixArray[1].getElement(0, 0);
        int n = 1;
        while (n < this.numRows) {
            d *= abstractDoubleSquareMatrixArray[1].getElement(n, n);
            ++n;
        }
        return d * (double)this.LUpivot[this.numRows];
    }

    public double trace() {
        double d = this.getElement(0, 0);
        int n = 1;
        while (n < this.numRows) {
            d += this.getElement(n, n);
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = this.rows[n];
            while (n2 < this.rows[n + 1]) {
                d2 += Math.abs(this.elements[n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.colPos.length) {
            d += this.elements[n] * this.elements[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSparseSquareMatrix) {
            return this.add((DoubleSparseSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.elements[n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] + abstractDoubleSquareMatrix.getElement(n, 0);
                int n3 = 1;
                while (n3 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] + abstractDoubleSquareMatrix.getElement(n, n3);
                    ++n3;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.elements[n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] + doubleSquareMatrix.matrix[n][0];
                int n3 = 1;
                while (n3 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] + doubleSquareMatrix.matrix[n][n3];
                    ++n3;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseSquareMatrix add(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numRows == doubleSparseSquareMatrix.numRows && this.numCols == doubleSparseSquareMatrix.numCols) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    doubleSparseSquareMatrix2.setElement(n, n2, this.getElement(n, n2) + doubleSparseSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSparseSquareMatrix) {
            return this.subtract((DoubleSparseSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.elements[n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] - abstractDoubleSquareMatrix.getElement(n, 0);
                int n3 = 1;
                while (n3 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] - abstractDoubleSquareMatrix.getElement(n, n3);
                    ++n3;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.elements[n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] - doubleSquareMatrix.matrix[n][0];
                int n3 = 1;
                while (n3 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] - doubleSquareMatrix.matrix[n][n3];
                    ++n3;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseSquareMatrix subtract(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numRows == doubleSparseSquareMatrix.numRows && this.numCols == doubleSparseSquareMatrix.numCols) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    doubleSparseSquareMatrix2.setElement(n, n2, this.getElement(n, n2) - doubleSparseSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        doubleSparseSquareMatrix.elements = new double[this.elements.length];
        doubleSparseSquareMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseSquareMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseSquareMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseSquareMatrix.elements[n] = d * this.elements[n];
            ++n;
        }
        return doubleSparseSquareMatrix;
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        doubleSparseSquareMatrix.elements = new double[this.elements.length];
        doubleSparseSquareMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseSquareMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseSquareMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseSquareMatrix.elements[n] = this.elements[n] / d;
            ++n;
        }
        return doubleSparseSquareMatrix;
    }

    public double scalarProduct(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.scalarProduct((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.numRows && this.numCols == abstractDoubleSquareMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.elements[n2] * abstractDoubleSquareMatrix.getElement(n, this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.elements[n2] * doubleSquareMatrix.matrix[n][this.colPos[n2]];
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.elements[n2] * abstractDoubleVector.getComponent(this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSparseSquareMatrix) {
            return this.multiply((DoubleSparseSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numCols == abstractDoubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][abstractDoubleSquareMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < abstractDoubleSquareMatrix.numCols) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.elements[n3] * abstractDoubleSquareMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleSquareMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleSquareMatrix.numCols) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.elements[n3] * doubleSquareMatrix.matrix[this.colPos[n3]][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSparseSquareMatrix multiply(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numCols == doubleSparseSquareMatrix.numRows) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    double d = 0.0;
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        d += this.elements[n3] * doubleSparseSquareMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    doubleSparseSquareMatrix2.setElement(n, n2, d);
                    ++n2;
                }
                ++n;
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        int n = 0;
        while (n < this.numRows) {
            doubleSparseSquareMatrix.setElement(0, n, this.getElement(n, 0));
            int n2 = 1;
            while (n2 < this.numCols) {
                doubleSparseSquareMatrix.setElement(n2, n, this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return doubleSparseSquareMatrix;
    }

    public AbstractDoubleSquareMatrix[] luDecompose(int[] nArray) {
        int n;
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        double[] dArray3 = new double[this.numRows];
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        int n2 = 0;
        while (n2 < this.numRows) {
            nArray[n2] = n2;
            ++n2;
        }
        nArray[this.numRows] = 1;
        int n3 = 0;
        while (n3 < this.numCols) {
            int n4;
            double d;
            n = 0;
            while (n < n3) {
                d = this.getElement(nArray[n], n3);
                n4 = 0;
                while (n4 < n) {
                    d -= dArray2[n][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n][n3] = d;
                ++n;
            }
            d = 0.0;
            n4 = n3;
            int n5 = n3;
            while (n5 < this.numRows) {
                double d2 = this.getElement(nArray[n5], n3);
                int n6 = 0;
                while (n6 < n3) {
                    d2 -= dArray2[n5][n6] * dArray2[n6][n3];
                    ++n6;
                }
                dArray2[n5][n3] = d2;
                if ((d2 = Math.abs(d2)) > d) {
                    d = d2;
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                System.arraycopy(dArray2[n3], 0, dArray3, 0, n3 + 1);
                System.arraycopy(dArray2[n4], 0, dArray2[n3], 0, n3 + 1);
                System.arraycopy(dArray3, 0, dArray2[n4], 0, n3 + 1);
                int n7 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n7;
                nArray[this.numRows] = -nArray[this.numRows];
            }
            int n8 = n3 + 1;
            while (n8 < this.numRows) {
                double[] dArray4 = dArray2[n8];
                int n9 = n3;
                dArray4[n9] = dArray4[n9] / dArray2[n3][n3];
                ++n8;
            }
            ++n3;
        }
        n = 0;
        while (n < this.numCols) {
            dArray[n][n] = 1.0;
            int n10 = n + 1;
            while (n10 < this.numRows) {
                dArray[n10][n] = dArray2[n10][n];
                dArray2[n10][n] = 0.0;
                ++n10;
            }
            ++n;
        }
        this.LU = new AbstractDoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(dArray);
        this.LU[1] = new DoubleSquareMatrix(dArray2);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        double d = Math.sqrt(this.getElement(0, 0));
        dArray2[0][0] = d;
        dArray[0][0] = d;
        int n = 1;
        while (n < this.numRows) {
            double d2 = this.getElement(n, 0) / dArray[0][0];
            dArray2[0][n] = d2;
            dArray[n][0] = d2;
            ++n;
        }
        int n2 = 1;
        while (n2 < this.numCols) {
            double d3 = this.getElement(n2, n2);
            int n3 = 0;
            while (n3 < n2) {
                d3 -= dArray[n2][n3] * dArray[n2][n3];
                ++n3;
            }
            double d4 = Math.sqrt(d3);
            dArray2[n2][n2] = d4;
            dArray[n2][n2] = d4;
            int n4 = n2 + 1;
            while (n4 < this.numRows) {
                d3 = this.getElement(n4, n2);
                int n5 = 0;
                while (n5 < n4) {
                    d3 -= dArray[n2][n5] * dArray2[n5][n4];
                    ++n5;
                }
                double d5 = d3 / dArray2[n2][n2];
                dArray2[n2][n4] = d5;
                dArray[n4][n2] = d5;
                ++n4;
            }
            ++n2;
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        doubleSparseSquareMatrix.elements = new double[this.elements.length];
        doubleSparseSquareMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseSquareMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseSquareMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseSquareMatrix.elements[n] = mapping.map(this.elements[n]);
            ++n;
        }
        return doubleSparseSquareMatrix;
    }
}

