/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.AbstractDoubleSquareMatrix;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerMatrix;
import JSci.maths.ArrayMath;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.LinearMath;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.groups.AbelianGroup;

public class DoubleSquareMatrix
extends AbstractDoubleSquareMatrix {
    protected final double[][] matrix;

    public DoubleSquareMatrix(double[][] dArray) {
        super(dArray.length);
        if (!ArrayMath.isSquare(dArray)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.matrix = dArray;
    }

    public DoubleSquareMatrix(int n) {
        this(new double[n][n]);
    }

    public DoubleSquareMatrix(DoubleVector[] doubleVectorArray) {
        this(doubleVectorArray.length);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                this.matrix[n][n2] = doubleVectorArray[n2].getComponent(n);
                ++n2;
            }
            ++n;
        }
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix != null && this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if (Math.abs(this.matrix[n][n2] - abstractDoubleMatrix.getElement(n, n2)) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.matrix[n][n2]);
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                nArray[n][n2] = Math.round((float)this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new IntegerSquareMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexSquareMatrix complexSquareMatrix = new ComplexSquareMatrix(this.numRows);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                complexSquareMatrix.setElement(n, n2, this.matrix[n][n2], 0.0);
                ++n2;
            }
            ++n;
        }
        return complexSquareMatrix;
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n][n2] = d;
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.numCols) {
                d2 += Math.abs(this.matrix[n][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                d = ExtraMath.hypot(d, this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public double det() {
        if (this.numRows == 2) {
            return this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = (DoubleSquareMatrix[])this.luDecompose(null);
        double d = doubleSquareMatrixArray[1].matrix[0][0];
        int n = 1;
        while (n < this.numRows) {
            d *= doubleSquareMatrixArray[1].matrix[n][n];
            ++n;
        }
        return d * (double)this.LUpivot[this.numRows];
    }

    public double trace() {
        double d = this.matrix[0][0];
        int n = 1;
        while (n < this.numRows) {
            d += this.matrix[n][n];
            ++n;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] + abstractDoubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] + abstractDoubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] + doubleSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] - abstractDoubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] - abstractDoubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] - doubleSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.matrix[n][0] / d;
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrix[n][n2] / d;
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public double scalarProduct(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.scalarProduct((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.matrix[n][0] * abstractDoubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.matrix[n][n2] * abstractDoubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.matrix[n][0] * doubleSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.matrix[n][n2] * doubleSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                dArray[n] = this.matrix[n][0] * abstractDoubleVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.matrix[n][n2] * abstractDoubleVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            int n = abstractDoubleSquareMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            int n2 = 0;
            while (n2 < this.numRows) {
                int n3 = 0;
                while (n3 < n) {
                    dArray[n2][n3] = this.matrix[n2][0] * abstractDoubleSquareMatrix.getElement(0, n3);
                    int n4 = 1;
                    while (n4 < this.numCols) {
                        double[] dArray2 = dArray[n2];
                        int n5 = n3;
                        dArray2[n5] = dArray2[n5] + this.matrix[n2][n4] * abstractDoubleSquareMatrix.getElement(n4, n3);
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleSquareMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleSquareMatrix.numCols) {
                    dArray[n][n2] = this.matrix[n][0] * doubleSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleSquareMatrix directSum(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n;
        double[][] dArray = new double[this.numRows + abstractDoubleSquareMatrix.numRows][this.numCols + abstractDoubleSquareMatrix.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            n = 0;
            while (n < this.numCols) {
                dArray[n2][n] = this.matrix[n2][n];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < abstractDoubleSquareMatrix.numRows) {
            int n3 = 0;
            while (n3 < abstractDoubleSquareMatrix.numCols) {
                dArray[n + this.numRows][n3 + this.numCols] = abstractDoubleSquareMatrix.getElement(n, n3);
                ++n3;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix tensor(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        double[][] dArray = new double[this.numRows * abstractDoubleSquareMatrix.numRows][this.numCols * abstractDoubleSquareMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < abstractDoubleSquareMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < abstractDoubleSquareMatrix.numCols) {
                        dArray[n * abstractDoubleSquareMatrix.numRows + n3][n2 * abstractDoubleSquareMatrix.numCols + n4] = this.matrix[n][n2] * abstractDoubleSquareMatrix.getElement(n3, n4);
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix inverse() {
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        DoubleSquareMatrix[] doubleSquareMatrixArray = (DoubleSquareMatrix[])this.luDecompose(null);
        dArray[0][0] = 1.0 / doubleSquareMatrixArray[0].matrix[0][0];
        dArray2[0][0] = 1.0 / doubleSquareMatrixArray[1].matrix[0][0];
        int n2 = 1;
        while (n2 < n) {
            dArray[n2][n2] = 1.0 / doubleSquareMatrixArray[0].matrix[n2][n2];
            dArray2[n2][n2] = 1.0 / doubleSquareMatrixArray[1].matrix[n2][n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = n3 + 1;
            while (n4 < n) {
                double d = 0.0;
                double d2 = 0.0;
                int n5 = n3;
                while (n5 < n4) {
                    d -= doubleSquareMatrixArray[0].matrix[n4][n5] * dArray[n5][n3];
                    d2 -= dArray2[n3][n5] * doubleSquareMatrixArray[1].matrix[n5][n4];
                    ++n5;
                }
                dArray[n4][n3] = d / doubleSquareMatrixArray[0].matrix[n4][n4];
                dArray2[n3][n4] = d2 / doubleSquareMatrixArray[1].matrix[n4][n4];
                ++n4;
            }
            ++n3;
        }
        double[][] dArray3 = new double[n][n];
        int n6 = 0;
        while (n6 < n) {
            int n7 = 0;
            while (n7 < n6) {
                int n8 = n6;
                while (n8 < n) {
                    double[] dArray4 = dArray3[n6];
                    int n9 = this.LUpivot[n7];
                    dArray4[n9] = dArray4[n9] + dArray2[n6][n8] * dArray[n8][n7];
                    ++n8;
                }
                ++n7;
            }
            int n10 = n6;
            while (n10 < n) {
                int n11 = n10;
                while (n11 < n) {
                    double[] dArray5 = dArray3[n6];
                    int n12 = this.LUpivot[n10];
                    dArray5[n12] = dArray5[n12] + dArray2[n6][n11] * dArray[n11][n10];
                    ++n11;
                }
                ++n10;
            }
            ++n6;
        }
        return new DoubleSquareMatrix(dArray3);
    }

    public final AbstractDoubleSquareMatrix[] luDecompose(int[] nArray) {
        int n;
        int n2;
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n3 = this.numRows;
        double[][] dArray = new double[n3][n3];
        double[][] dArray2 = new double[n3][n3];
        double[] dArray3 = new double[n3];
        if (nArray == null) {
            nArray = new int[n3 + 1];
        }
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n4;
            ++n4;
        }
        nArray[n3] = 1;
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            double d;
            n2 = 0;
            while (n2 < n5) {
                d = this.matrix[nArray[n2]][n5];
                n = 0;
                while (n < n2) {
                    d -= dArray2[n2][n] * dArray2[n][n5];
                    ++n;
                }
                dArray2[n2][n5] = d;
                ++n2;
            }
            double d2 = 0.0;
            int n7 = n5;
            n = n5;
            while (n < n3) {
                d = this.matrix[nArray[n]][n5];
                n6 = 0;
                while (n6 < n5) {
                    d -= dArray2[n][n6] * dArray2[n6][n5];
                    ++n6;
                }
                dArray2[n][n5] = d;
                if ((d = Math.abs(d)) > d2) {
                    d2 = d;
                    n7 = n;
                }
                ++n;
            }
            if (n7 != n5) {
                System.arraycopy(dArray2[n5], 0, dArray3, 0, n5 + 1);
                System.arraycopy(dArray2[n7], 0, dArray2[n5], 0, n5 + 1);
                System.arraycopy(dArray3, 0, dArray2[n7], 0, n5 + 1);
                n6 = nArray[n5];
                nArray[n5] = nArray[n7];
                nArray[n7] = n6;
                nArray[n3] = -nArray[n3];
            }
            d = dArray2[n5][n5];
            n6 = n5 + 1;
            while (n6 < n3) {
                double[] dArray4 = dArray2[n6];
                int n8 = n5;
                dArray4[n8] = dArray4[n8] / d;
                ++n6;
            }
            ++n5;
        }
        n2 = 0;
        while (n2 < n3) {
            dArray[n2][n2] = 1.0;
            n = n2 + 1;
            while (n < n3) {
                dArray[n][n2] = dArray2[n][n2];
                dArray2[n][n2] = 0.0;
                ++n;
            }
            ++n2;
        }
        this.LU = new DoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(dArray);
        this.LU[1] = new DoubleSquareMatrix(dArray2);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        double d;
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double d2 = d = Math.sqrt(this.matrix[0][0]);
        dArray2[0][0] = d2;
        dArray[0][0] = d2;
        int n2 = 1;
        while (n2 < n) {
            double d3 = this.matrix[n2][0] / d;
            dArray2[0][n2] = d3;
            dArray[n2][0] = d3;
            ++n2;
        }
        int n3 = 1;
        while (n3 < n) {
            d = this.matrix[n3][n3];
            int n4 = 0;
            while (n4 < n3) {
                d -= dArray[n3][n4] * dArray[n3][n4];
                ++n4;
            }
            double d4 = Math.sqrt(d);
            dArray2[n3][n3] = d4;
            dArray[n3][n3] = d4;
            int n5 = n3 + 1;
            while (n5 < n) {
                d = this.matrix[n5][n3];
                int n6 = 0;
                while (n6 < n5) {
                    d -= dArray[n3][n6] * dArray2[n6][n5];
                    ++n6;
                }
                double d5 = d / dArray2[n3][n3];
                dArray2[n3][n5] = d5;
                dArray[n5][n3] = d5;
                ++n5;
            }
            ++n3;
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] qrDecompose() {
        int n;
        int n2;
        int n3;
        int n4 = this.numRows;
        double[][] dArray = new double[n4][n4];
        double[][] dArray2 = new double[n4][n4];
        double[][] dArray3 = new double[n4][n4];
        int n5 = 0;
        while (n5 < n4) {
            dArray[n5][0] = this.matrix[n5][0];
            n3 = 1;
            while (n3 < n4) {
                dArray[n5][n3] = this.matrix[n5][n3];
                ++n3;
            }
            ++n5;
        }
        n3 = 0;
        while (n3 < n4) {
            double d = dArray[n3][n3];
            int n6 = n3 + 1;
            while (n6 < n4) {
                d = ExtraMath.hypot(d, dArray[n6][n3]);
                ++n6;
            }
            if (d != 0.0) {
                if (dArray[n3][n3] < 0.0) {
                    d = -d;
                }
                int n7 = n3;
                while (n7 < n4) {
                    double[] dArray4 = dArray[n7];
                    int n8 = n3;
                    dArray4[n8] = dArray4[n8] / d;
                    ++n7;
                }
                double[] dArray5 = dArray[n3];
                int n9 = n3;
                dArray5[n9] = dArray5[n9] + 1.0;
                n2 = n3 + 1;
                while (n2 < n4) {
                    double d2 = dArray[n3][n3] * dArray[n3][n2];
                    int n10 = n3 + 1;
                    while (n10 < n4) {
                        d2 += dArray[n10][n3] * dArray[n10][n2];
                        ++n10;
                    }
                    d2 /= dArray[n3][n3];
                    int n11 = n3;
                    while (n11 < n4) {
                        double[] dArray6 = dArray[n11];
                        int n12 = n2;
                        dArray6[n12] = dArray6[n12] - d2 * dArray[n11][n3];
                        ++n11;
                    }
                    ++n2;
                }
            }
            dArray3[n3][n3] = -d;
            ++n3;
        }
        int n13 = n4 - 1;
        while (n13 >= 0) {
            dArray2[n13][n13] = 1.0;
            n = n13;
            while (n < n4) {
                if (dArray[n13][n13] != 0.0) {
                    double d = dArray[n13][n13] * dArray2[n13][n];
                    n2 = n13 + 1;
                    while (n2 < n4) {
                        d += dArray[n2][n13] * dArray2[n2][n];
                        ++n2;
                    }
                    d /= dArray[n13][n13];
                    int n14 = n13;
                    while (n14 < n4) {
                        double[] dArray7 = dArray2[n14];
                        int n15 = n;
                        dArray7[n15] = dArray7[n15] - d * dArray[n14][n13];
                        ++n14;
                    }
                }
                ++n;
            }
            --n13;
        }
        n = 0;
        while (n < n4) {
            int n16 = n + 1;
            while (n16 < n4) {
                dArray3[n][n16] = dArray[n][n16];
                ++n16;
            }
            ++n;
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleSquareMatrix(dArray3)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.numRows;
        int n10 = n9 - 1;
        double[][] dArray = new double[n9][n9];
        double[][] dArray2 = new double[n9][n9];
        double[] dArray3 = new double[n9];
        double[][] dArray4 = new double[n9][n9];
        double[] dArray5 = new double[n9];
        double[] dArray6 = new double[n9];
        int n11 = 0;
        while (n11 < n9) {
            dArray[n11][0] = this.matrix[n11][0];
            n8 = 1;
            while (n8 < n9) {
                dArray[n11][n8] = this.matrix[n11][n8];
                ++n8;
            }
            ++n11;
        }
        n8 = 0;
        while (n8 < n10) {
            dArray3[n8] = dArray[n8][n8];
            n7 = n8 + 1;
            while (n7 < n9) {
                dArray3[n8] = ExtraMath.hypot(dArray3[n8], dArray[n7][n8]);
                ++n7;
            }
            if (dArray3[n8] != 0.0) {
                if (dArray[n8][n8] < 0.0) {
                    dArray3[n8] = -dArray3[n8];
                }
                n6 = n8;
                while (n6 < n9) {
                    double[] dArray7 = dArray[n6];
                    int n12 = n8;
                    dArray7[n12] = dArray7[n12] / dArray3[n8];
                    ++n6;
                }
                double[] dArray8 = dArray[n8];
                int n13 = n8;
                dArray8[n13] = dArray8[n13] + 1.0;
            }
            dArray3[n8] = -dArray3[n8];
            n6 = n8 + 1;
            while (n6 < n9) {
                if (dArray3[n8] != 0.0) {
                    double d = dArray[n8][n8] * dArray[n8][n6];
                    n5 = n8 + 1;
                    while (n5 < n9) {
                        d += dArray[n5][n8] * dArray[n5][n6];
                        ++n5;
                    }
                    d /= dArray[n8][n8];
                    n4 = n8;
                    while (n4 < n9) {
                        double[] dArray9 = dArray[n4];
                        int n14 = n6;
                        dArray9[n14] = dArray9[n14] - d * dArray[n4][n8];
                        ++n4;
                    }
                }
                dArray5[n6] = dArray[n8][n6];
                ++n6;
            }
            n3 = n8;
            while (n3 < n9) {
                dArray2[n3][n8] = dArray[n3][n8];
                ++n3;
            }
            if (n8 < n9 - 2) {
                dArray5[n8] = dArray5[n8 + 1];
                n2 = n8 + 2;
                while (n2 < n9) {
                    dArray5[n8] = ExtraMath.hypot(dArray5[n8], dArray5[n2]);
                    ++n2;
                }
                if (dArray5[n8] != 0.0) {
                    if (dArray5[n8 + 1] < 0.0) {
                        dArray5[n8] = -dArray5[n8];
                    }
                    n5 = n8 + 1;
                    while (n5 < n9) {
                        int n15 = n5++;
                        dArray5[n15] = dArray5[n15] / dArray5[n8];
                    }
                    int n16 = n8 + 1;
                    dArray5[n16] = dArray5[n16] + 1.0;
                }
                dArray5[n8] = -dArray5[n8];
                if (dArray5[n8] != 0.0) {
                    n5 = n8 + 1;
                    while (n5 < n9) {
                        dArray6[n5] = 0.0;
                        n4 = n8 + 1;
                        while (n4 < n9) {
                            int n17 = n5;
                            dArray6[n17] = dArray6[n17] + dArray5[n4] * dArray[n5][n4];
                            ++n4;
                        }
                        ++n5;
                    }
                    n4 = n8 + 1;
                    while (n4 < n9) {
                        double d = dArray5[n4] / dArray5[n8 + 1];
                        int n18 = n8 + 1;
                        while (n18 < n9) {
                            double[] dArray10 = dArray[n18];
                            int n19 = n4;
                            dArray10[n19] = dArray10[n19] - d * dArray6[n18];
                            ++n18;
                        }
                        ++n4;
                    }
                }
                n5 = n8 + 1;
                while (n5 < n9) {
                    dArray4[n5][n8] = dArray5[n5];
                    ++n5;
                }
            }
            ++n8;
        }
        n7 = n9;
        dArray3[n10] = dArray[n10][n10];
        dArray5[n9 - 2] = dArray[n9 - 2][n10];
        dArray5[n10] = 0.0;
        dArray2[n10][n10] = 1.0;
        n6 = n9 - 2;
        while (n6 >= 0) {
            if (dArray3[n6] != 0.0) {
                n3 = n6 + 1;
                while (n3 < n9) {
                    double d = dArray2[n6][n6] * dArray2[n6][n3];
                    n4 = n6 + 1;
                    while (n4 < n9) {
                        d += dArray2[n4][n6] * dArray2[n4][n3];
                        ++n4;
                    }
                    d /= dArray2[n6][n6];
                    int n20 = n6;
                    while (n20 < n9) {
                        double[] dArray11 = dArray2[n20];
                        int n21 = n3;
                        dArray11[n21] = dArray11[n21] - d * dArray2[n20][n6];
                        ++n20;
                    }
                    ++n3;
                }
                n2 = n6;
                while (n2 < n9) {
                    dArray2[n2][n6] = -dArray2[n2][n6];
                    ++n2;
                }
                double[] dArray12 = dArray2[n6];
                int n22 = n6;
                dArray12[n22] = dArray12[n22] + 1.0;
                n5 = 0;
                while (n5 < n6 - 1) {
                    dArray2[n5][n6] = 0.0;
                    ++n5;
                }
            } else {
                n3 = 0;
                while (n3 < n9) {
                    dArray2[n3][n6] = 0.0;
                    ++n3;
                }
                dArray2[n6][n6] = 1.0;
            }
            --n6;
        }
        n3 = n10;
        while (n3 >= 0) {
            if (n3 < n9 - 2 && dArray5[n3] != 0.0) {
                n2 = n3 + 1;
                while (n2 < n9) {
                    double d = dArray4[n3 + 1][n3] * dArray4[n3 + 1][n2];
                    int n23 = n3 + 2;
                    while (n23 < n9) {
                        d += dArray4[n23][n3] * dArray4[n23][n2];
                        ++n23;
                    }
                    d /= dArray4[n3 + 1][n3];
                    n = n3 + 1;
                    while (n < n9) {
                        double[] dArray13 = dArray4[n];
                        int n24 = n2;
                        dArray13[n24] = dArray13[n24] - d * dArray4[n][n3];
                        ++n;
                    }
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < n9) {
                dArray4[n2][n3] = 0.0;
                ++n2;
            }
            dArray4[n3][n3] = 1.0;
            --n3;
        }
        double d = Math.pow(2.0, -52.0);
        n4 = 0;
        block34: while (n7 > 0) {
            int n25 = n7 - 2;
            while (n25 >= -1) {
                if (n25 == -1) break;
                if (Math.abs(dArray5[n25]) <= d * (Math.abs(dArray3[n25]) + Math.abs(dArray3[n25 + 1]))) {
                    dArray5[n25] = 0.0;
                    break;
                }
                --n25;
            }
            if (n25 == n7 - 2) {
                n = 4;
            } else {
                int n26 = n7 - 1;
                while (n26 >= n25) {
                    if (n26 == n25) break;
                    double d2 = (n26 != n7 ? Math.abs(dArray5[n26]) : 0.0) + (n26 != n25 + 1 ? Math.abs(dArray5[n26 - 1]) : 0.0);
                    if (Math.abs(dArray3[n26]) <= d * d2) {
                        dArray3[n26] = 0.0;
                        break;
                    }
                    --n26;
                }
                if (n26 == n25) {
                    n = 3;
                } else if (n26 == n7 - 1) {
                    n = 1;
                } else {
                    n = 2;
                    n25 = n26;
                }
            }
            ++n25;
            switch (n) {
                case 1: {
                    int n27;
                    double d3;
                    double d4;
                    double d5;
                    double d6 = dArray5[n7 - 2];
                    dArray5[n7 - 2] = 0.0;
                    int n28 = n7 - 2;
                    while (n28 >= n25) {
                        d5 = ExtraMath.hypot(dArray3[n28], d6);
                        d4 = dArray3[n28] / d5;
                        d3 = d6 / d5;
                        dArray3[n28] = d5;
                        if (n28 != n25) {
                            d6 = -d3 * dArray5[n28 - 1];
                            int n29 = n28 - 1;
                            dArray5[n29] = dArray5[n29] * d4;
                        }
                        n27 = 0;
                        while (n27 < n9) {
                            d5 = d4 * dArray4[n27][n28] + d3 * dArray4[n27][n7 - 1];
                            dArray4[n27][n7 - 1] = -d3 * dArray4[n27][n28] + d4 * dArray4[n27][n7 - 1];
                            dArray4[n27][n28] = d5;
                            ++n27;
                        }
                        --n28;
                    }
                    continue block34;
                }
                case 2: {
                    int n27;
                    double d3;
                    double d4;
                    double d5;
                    double d7 = dArray5[n25 - 1];
                    dArray5[n25 - 1] = 0.0;
                    int n30 = n25;
                    while (n30 < n7) {
                        d5 = ExtraMath.hypot(dArray3[n30], d7);
                        d4 = dArray3[n30] / d5;
                        d3 = d7 / d5;
                        dArray3[n30] = d5;
                        d7 = -d3 * dArray5[n30];
                        int n31 = n30;
                        dArray5[n31] = dArray5[n31] * d4;
                        n27 = 0;
                        while (n27 < n9) {
                            d5 = d4 * dArray2[n27][n30] + d3 * dArray2[n27][n25 - 1];
                            dArray2[n27][n25 - 1] = -d3 * dArray2[n27][n30] + d4 * dArray2[n27][n25 - 1];
                            dArray2[n27][n30] = d5;
                            ++n27;
                        }
                        ++n30;
                    }
                    continue block34;
                }
                case 3: {
                    double d8 = Math.max(Math.max(Math.max(Math.max(Math.abs(dArray3[n7 - 1]), Math.abs(dArray3[n7 - 2])), Math.abs(dArray5[n7 - 2])), Math.abs(dArray3[n25])), Math.abs(dArray5[n25]));
                    double d9 = dArray3[n7 - 1] / d8;
                    double d10 = dArray3[n7 - 2] / d8;
                    double d11 = dArray5[n7 - 2] / d8;
                    double d12 = dArray3[n25] / d8;
                    double d13 = dArray5[n25] / d8;
                    double d14 = ((d10 + d9) * (d10 - d9) + d11 * d11) / 2.0;
                    double d15 = d9 * d11 * (d9 * d11);
                    double d16 = 0.0;
                    if (d14 != 0.0 || d15 != 0.0) {
                        d16 = Math.sqrt(d14 * d14 + d15);
                        if (d14 < 0.0) {
                            d16 = -d16;
                        }
                        d16 = d15 / (d14 + d16);
                    }
                    double d17 = (d12 + d9) * (d12 - d9) + d16;
                    double d18 = d12 * d13;
                    int n32 = n25;
                    while (n32 < n7 - 1) {
                        double d19 = ExtraMath.hypot(d17, d18);
                        double d20 = d17 / d19;
                        double d21 = d18 / d19;
                        if (n32 != n25) {
                            dArray5[n32 - 1] = d19;
                        }
                        d17 = d20 * dArray3[n32] + d21 * dArray5[n32];
                        dArray5[n32] = d20 * dArray5[n32] - d21 * dArray3[n32];
                        d18 = d21 * dArray3[n32 + 1];
                        int n33 = n32 + 1;
                        dArray3[n33] = dArray3[n33] * d20;
                        int n34 = 0;
                        while (n34 < n9) {
                            d19 = d20 * dArray4[n34][n32] + d21 * dArray4[n34][n32 + 1];
                            dArray4[n34][n32 + 1] = -d21 * dArray4[n34][n32] + d20 * dArray4[n34][n32 + 1];
                            dArray4[n34][n32] = d19;
                            ++n34;
                        }
                        d19 = ExtraMath.hypot(d17, d18);
                        d20 = d17 / d19;
                        d21 = d18 / d19;
                        dArray3[n32] = d19;
                        d17 = d20 * dArray5[n32] + d21 * dArray3[n32 + 1];
                        dArray3[n32 + 1] = -d21 * dArray5[n32] + d20 * dArray3[n32 + 1];
                        d18 = d21 * dArray5[n32 + 1];
                        int n35 = n32 + 1;
                        dArray5[n35] = dArray5[n35] * d20;
                        if (n32 < n10) {
                            int n36 = 0;
                            while (n36 < n9) {
                                d19 = d20 * dArray2[n36][n32] + d21 * dArray2[n36][n32 + 1];
                                dArray2[n36][n32 + 1] = -d21 * dArray2[n36][n32] + d20 * dArray2[n36][n32 + 1];
                                dArray2[n36][n32] = d19;
                                ++n36;
                            }
                        }
                        ++n32;
                    }
                    dArray5[n7 - 2] = d17;
                    ++n4;
                    break;
                }
                case 4: {
                    if (dArray3[n25] <= 0.0) {
                        dArray3[n25] = -dArray3[n25];
                        int n37 = 0;
                        while (n37 < n7) {
                            dArray4[n37][n25] = -dArray4[n37][n25];
                            ++n37;
                        }
                    }
                    while (n25 < n7 - 1) {
                        if (dArray3[n25] >= dArray3[n25 + 1]) break;
                        double d22 = dArray3[n25];
                        dArray3[n25] = dArray3[n25 + 1];
                        dArray3[n25 + 1] = d22;
                        if (n25 < n10) {
                            int n38 = 0;
                            while (n38 < n9) {
                                d22 = dArray2[n38][n25 + 1];
                                dArray2[n38][n25 + 1] = dArray2[n38][n25];
                                dArray2[n38][n25] = d22;
                                d22 = dArray4[n38][n25 + 1];
                                dArray4[n38][n25 + 1] = dArray4[n38][n25];
                                dArray4[n38][n25] = d22;
                                ++n38;
                            }
                        }
                        ++n25;
                    }
                    n4 = 0;
                    --n7;
                }
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleDiagonalMatrix(dArray3), new DoubleSquareMatrix(dArray4)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] polarDecompose() {
        double[] dArray;
        int n = this.numRows;
        AbstractDoubleVector[] abstractDoubleVectorArray = new AbstractDoubleVector[n];
        try {
            dArray = LinearMath.eigenSolveSymmetric(this, abstractDoubleVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            double d = Math.abs(dArray[n2]);
            dArray2[n2][0] = dArray[n2] * abstractDoubleVectorArray[n2].getComponent(0) / d;
            dArray3[n2][0] = d * abstractDoubleVectorArray[n2].getComponent(0);
            int n3 = 1;
            while (n3 < n) {
                dArray2[n2][n3] = dArray[n2] * abstractDoubleVectorArray[n2].getComponent(n3) / d;
                dArray3[n2][n3] = d * abstractDoubleVectorArray[n2].getComponent(n3);
                ++n3;
            }
            ++n2;
        }
        double[][] dArray4 = new double[n][n];
        double[][] dArray5 = new double[n][n];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                dArray4[n4][n5] = abstractDoubleVectorArray[0].getComponent(n4) * dArray2[0][n5];
                dArray5[n4][n5] = abstractDoubleVectorArray[0].getComponent(n4) * dArray3[0][n5];
                int n6 = 1;
                while (n6 < n) {
                    double[] dArray6 = dArray4[n4];
                    int n7 = n5;
                    dArray6[n7] = dArray6[n7] + abstractDoubleVectorArray[n6].getComponent(n4) * dArray2[n6][n5];
                    double[] dArray7 = dArray5[n4];
                    int n8 = n5;
                    dArray7[n8] = dArray7[n8] + abstractDoubleVectorArray[n6].getComponent(n4) * dArray3[n6][n5];
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray4), new DoubleSquareMatrix(dArray5)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = mapping.map(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = mapping.map(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }
}

