/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.AbstractDoubleSquareMatrix;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerMatrix;
import JSci.maths.ArrayMath;
import JSci.maths.ComplexTridiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerTridiagonalMatrix;
import JSci.maths.LinearMath;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.TridiagonalMatrix;

public class DoubleTridiagonalMatrix
extends AbstractDoubleSquareMatrix
implements TridiagonalMatrix {
    protected final double[] ldiag;
    protected final double[] diag;
    protected final double[] udiag;

    public DoubleTridiagonalMatrix(int n) {
        super(n);
        this.ldiag = new double[n];
        this.diag = new double[n];
        this.udiag = new double[n];
    }

    public DoubleTridiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        if (!ArrayMath.isSquare(dArray)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.diag[0] = dArray[0][0];
        this.udiag[0] = dArray[0][1];
        int n = 1;
        while (n < dArray.length - 1) {
            this.ldiag[n] = dArray[n][n - 1];
            this.diag[n] = dArray[n][n];
            this.udiag[n] = dArray[n][n + 1];
            ++n;
        }
        this.ldiag[n] = dArray[n][n - 1];
        this.diag[n] = dArray[n][n];
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof TridiagonalMatrix) {
            if (this.numRows != abstractDoubleMatrix.rows() || this.numCols != abstractDoubleMatrix.columns()) {
                return false;
            }
            if (Math.abs(this.diag[0] - abstractDoubleMatrix.getElement(0, 0)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            if (Math.abs(this.udiag[0] - abstractDoubleMatrix.getElement(0, 1)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            int n = 1;
            while (n < this.numRows - 1) {
                if (Math.abs(this.ldiag[n] - abstractDoubleMatrix.getElement(n, n - 1)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                if (Math.abs(this.diag[n] - abstractDoubleMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                if (Math.abs(this.udiag[n] - abstractDoubleMatrix.getElement(n, n + 1)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            if (Math.abs(this.ldiag[n] - abstractDoubleMatrix.getElement(n, n - 1)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            return !(Math.abs(this.diag[n] - abstractDoubleMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.numRows);
        integerTridiagonalMatrix.diag[0] = Math.round((float)this.diag[0]);
        integerTridiagonalMatrix.udiag[0] = Math.round((float)this.udiag[0]);
        int n = 1;
        while (n < this.numRows - 1) {
            integerTridiagonalMatrix.ldiag[n] = Math.round((float)this.ldiag[n]);
            integerTridiagonalMatrix.diag[n] = Math.round((float)this.diag[n]);
            integerTridiagonalMatrix.udiag[n] = Math.round((float)this.udiag[n]);
            ++n;
        }
        integerTridiagonalMatrix.ldiag[n] = Math.round((float)this.ldiag[n]);
        integerTridiagonalMatrix.diag[n] = Math.round((float)this.diag[n]);
        return integerTridiagonalMatrix;
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.numRows);
        complexTridiagonalMatrix.diagRe[0] = this.diag[0];
        complexTridiagonalMatrix.udiagRe[0] = this.udiag[0];
        int n = 1;
        while (n < this.numRows - 1) {
            complexTridiagonalMatrix.ldiagRe[n] = this.ldiag[n];
            complexTridiagonalMatrix.diagRe[n] = this.diag[n];
            complexTridiagonalMatrix.udiagRe[n] = this.udiag[n];
            ++n;
        }
        complexTridiagonalMatrix.ldiagRe[n] = this.ldiag[n];
        complexTridiagonalMatrix.diagRe[n] = this.diag[n];
        return complexTridiagonalMatrix;
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 == n - 1) {
                return this.ldiag[n];
            }
            if (n2 == n) {
                return this.diag[n];
            }
            if (n2 == n + 1) {
                return this.udiag[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        if (n2 == n - 1) {
            this.ldiag[n] = d;
            return;
        } else if (n2 == n) {
            this.diag[n] = d;
            return;
        } else {
            if (n2 != n + 1) throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            this.udiag[n] = d;
        }
    }

    public boolean isSymmetric() {
        if (this.ldiag[1] != this.udiag[0]) {
            return false;
        }
        int n = 1;
        while (n < this.numRows - 1) {
            if (this.ldiag[n + 1] != this.udiag[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public double trace() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diag[n];
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d;
        double d2 = Math.abs(this.diag[0]) + Math.abs(this.udiag[0]);
        int n = 1;
        while (n < this.numRows - 1) {
            d = Math.abs(this.ldiag[n]) + Math.abs(this.diag[n]) + Math.abs(this.udiag[n]);
            if (d > d2) {
                d2 = d;
            }
            ++n;
        }
        d = Math.abs(this.ldiag[n]) + Math.abs(this.diag[n]);
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public double frobeniusNorm() {
        double d = this.diag[0] * this.diag[0] + this.udiag[0] * this.udiag[0];
        int n = 1;
        while (n < this.numRows - 1) {
            d += this.ldiag[n] * this.ldiag[n] + this.diag[n] * this.diag[n] + this.udiag[n] * this.udiag[n];
            ++n;
        }
        return Math.sqrt(d += this.ldiag[n] * this.ldiag[n] + this.diag[n] * this.diag[n]);
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveSymmetric((DoubleTridiagonalMatrix)this.transpose().multiply(this))));
    }

    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.add((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) + abstractDoubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) + abstractDoubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(doubleSquareMatrix.matrix[n], 0, dArray[n], 0, this.numRows);
                ++n;
            }
            double[] dArray2 = dArray[0];
            dArray2[0] = dArray2[0] + this.diag[0];
            double[] dArray3 = dArray[0];
            dArray3[1] = dArray3[1] + this.udiag[0];
            int n2 = this.numRows - 1;
            int n3 = 1;
            while (n3 < n2) {
                double[] dArray4 = dArray[n3];
                int n4 = n3 - 1;
                dArray4[n4] = dArray4[n4] + this.ldiag[n3];
                double[] dArray5 = dArray[n3];
                int n5 = n3;
                dArray5[n5] = dArray5[n5] + this.diag[n3];
                double[] dArray6 = dArray[n3];
                int n6 = n3 + 1;
                dArray6[n6] = dArray6[n6] + this.udiag[n3];
                ++n3;
            }
            double[] dArray7 = dArray[n2];
            int n7 = n2 - 1;
            dArray7[n7] = dArray7[n7] + this.ldiag[n2];
            double[] dArray8 = dArray[n2];
            int n8 = n2;
            dArray8[n8] = dArray8[n8] + this.diag[n2];
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] + doubleTridiagonalMatrix.diag[0];
            doubleTridiagonalMatrix2.udiag[0] = this.udiag[0] + doubleTridiagonalMatrix.udiag[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = this.ldiag[n2] + doubleTridiagonalMatrix.ldiag[n2];
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] + doubleTridiagonalMatrix.diag[n2];
                doubleTridiagonalMatrix2.udiag[n2] = this.udiag[n2] + doubleTridiagonalMatrix.udiag[n2];
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = this.ldiag[n] + doubleTridiagonalMatrix.ldiag[n];
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] + doubleTridiagonalMatrix.diag[n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix addTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (n == abstractDoubleSquareMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] + abstractDoubleSquareMatrix.getElement(0, 0);
            doubleTridiagonalMatrix.udiag[0] = this.udiag[0] + abstractDoubleSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = this.ldiag[n2] + abstractDoubleSquareMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] + abstractDoubleSquareMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix.udiag[n2] = this.udiag[n2] + abstractDoubleSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n] + abstractDoubleSquareMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix.diag[n] = this.diag[n] + abstractDoubleSquareMatrix.getElement(n, n);
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.subtract((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - abstractDoubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - abstractDoubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - doubleSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.numRows;
        if (n == doubleTridiagonalMatrix.numRows) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.diag[0] = this.diag[0] - doubleTridiagonalMatrix.diag[0];
            doubleTridiagonalMatrix2.udiag[0] = this.udiag[0] - doubleTridiagonalMatrix.udiag[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.ldiag[n2] = this.ldiag[n2] - doubleTridiagonalMatrix.ldiag[n2];
                doubleTridiagonalMatrix2.diag[n2] = this.diag[n2] - doubleTridiagonalMatrix.diag[n2];
                doubleTridiagonalMatrix2.udiag[n2] = this.udiag[n2] - doubleTridiagonalMatrix.udiag[n2];
                ++n2;
            }
            doubleTridiagonalMatrix2.ldiag[n] = this.ldiag[n] - doubleTridiagonalMatrix.ldiag[n];
            doubleTridiagonalMatrix2.diag[n] = this.diag[n] - doubleTridiagonalMatrix.diag[n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix subtractTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (n == abstractDoubleSquareMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.diag[0] = this.diag[0] - abstractDoubleSquareMatrix.getElement(0, 0);
            doubleTridiagonalMatrix.udiag[0] = this.udiag[0] - abstractDoubleSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.ldiag[n2] = this.ldiag[n2] - abstractDoubleSquareMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix.diag[n2] = this.diag[n2] - abstractDoubleSquareMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix.udiag[n2] = this.udiag[n2] - abstractDoubleSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n] - abstractDoubleSquareMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix.diag[n] = this.diag[n] - abstractDoubleSquareMatrix.getElement(n, n);
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        int n = this.numRows - 1;
        doubleTridiagonalMatrix.diag[0] = d * this.diag[0];
        doubleTridiagonalMatrix.udiag[0] = d * this.udiag[0];
        int n2 = 1;
        while (n2 < n) {
            doubleTridiagonalMatrix.ldiag[n2] = d * this.ldiag[n2];
            doubleTridiagonalMatrix.diag[n2] = d * this.diag[n2];
            doubleTridiagonalMatrix.udiag[n2] = d * this.udiag[n2];
            ++n2;
        }
        doubleTridiagonalMatrix.ldiag[n] = d * this.ldiag[n];
        doubleTridiagonalMatrix.diag[n] = d * this.diag[n];
        return doubleTridiagonalMatrix;
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        int n = this.numRows - 1;
        doubleTridiagonalMatrix.diag[0] = this.diag[0] / d;
        doubleTridiagonalMatrix.udiag[0] = this.udiag[0] / d;
        int n2 = 1;
        while (n2 < n) {
            doubleTridiagonalMatrix.ldiag[n2] = this.ldiag[n2] / d;
            doubleTridiagonalMatrix.diag[n2] = this.diag[n2] / d;
            doubleTridiagonalMatrix.udiag[n2] = this.udiag[n2] / d;
            ++n2;
        }
        doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n] / d;
        doubleTridiagonalMatrix.diag[n] = this.diag[n] / d;
        return doubleTridiagonalMatrix;
    }

    public double scalarProduct(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.scalarProduct((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.scalarProduct((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double d = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 0) + this.udiag[0] * abstractDoubleSquareMatrix.getElement(0, 1);
            int n = this.numRows - 1;
            int n2 = 1;
            while (n2 < n) {
                d += this.ldiag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2 - 1) + this.diag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2) + this.udiag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            return d += this.ldiag[n] * abstractDoubleSquareMatrix.getElement(n, n - 1) + this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numRows == doubleSquareMatrix.numRows && this.numCols == doubleSquareMatrix.numCols) {
            double d = this.diag[0] * doubleSquareMatrix.matrix[0][0] + this.udiag[0] * doubleSquareMatrix.matrix[0][1];
            int n = this.numRows - 1;
            int n2 = 1;
            while (n2 < n) {
                d += this.ldiag[n2] * doubleSquareMatrix.matrix[n2][n2 - 1] + this.diag[n2] * doubleSquareMatrix.matrix[n2][n2] + this.udiag[n2] * doubleSquareMatrix.matrix[n2][n2 + 1];
                ++n2;
            }
            return d += this.ldiag[n] * doubleSquareMatrix.matrix[n][n - 1] + this.diag[n] * doubleSquareMatrix.matrix[n][n];
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (this.numRows == doubleTridiagonalMatrix.numRows) {
            double d = this.diag[0] * doubleTridiagonalMatrix.diag[0] + this.udiag[0] * doubleTridiagonalMatrix.udiag[0];
            int n = this.numRows - 1;
            int n2 = 1;
            while (n2 < n) {
                d += this.ldiag[n2] * doubleTridiagonalMatrix.ldiag[n2] + this.diag[n2] * doubleTridiagonalMatrix.diag[n2] + this.udiag[n2] * doubleTridiagonalMatrix.udiag[n2];
                ++n2;
            }
            return d += this.ldiag[n] * doubleTridiagonalMatrix.ldiag[n] + this.diag[n] * doubleTridiagonalMatrix.diag[n];
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = this.numRows - 1;
            dArray[0] = this.diag[0] * abstractDoubleVector.getComponent(0) + this.udiag[0] * abstractDoubleVector.getComponent(1);
            int n2 = 1;
            while (n2 < n) {
                dArray[n2] = this.ldiag[n2] * abstractDoubleVector.getComponent(n2 - 1) + this.diag[n2] * abstractDoubleVector.getComponent(n2) + this.udiag[n2] * abstractDoubleVector.getComponent(n2 + 1);
                ++n2;
            }
            dArray[n] = this.ldiag[n] * abstractDoubleVector.getComponent(n - 1) + this.diag[n] * abstractDoubleVector.getComponent(n);
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (abstractDoubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.multiply((DoubleTridiagonalMatrix)abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractDoubleSquareMatrix);
        }
        if (abstractDoubleSquareMatrix instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)abstractDoubleSquareMatrix);
        }
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            int n = abstractDoubleSquareMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            int n2 = this.numRows - 1;
            int n3 = 0;
            while (n3 < this.numRows) {
                dArray[0][n3] = this.diag[0] * abstractDoubleSquareMatrix.getElement(n3, 0) + this.udiag[0] * abstractDoubleSquareMatrix.getElement(n3, 1);
                int n4 = 1;
                while (n4 < n2) {
                    dArray[n4][n3] = this.ldiag[n4] * abstractDoubleSquareMatrix.getElement(n3, n4 - 1) + this.diag[n4] * abstractDoubleSquareMatrix.getElement(n3, n4) + this.udiag[n4] * abstractDoubleSquareMatrix.getElement(n3, n4 + 1);
                    ++n4;
                }
                dArray[n2][n3] = this.ldiag[n2] * abstractDoubleSquareMatrix.getElement(n3, n2 - 1) + this.diag[n2] * abstractDoubleSquareMatrix.getElement(n3, n2);
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleSquareMatrix.numCols];
            int n = this.numRows - 1;
            int n2 = 0;
            while (n2 < this.numRows) {
                dArray[0][n2] = this.diag[0] * doubleSquareMatrix.matrix[n2][0] + this.udiag[0] * doubleSquareMatrix.matrix[n2][1];
                int n3 = 1;
                while (n3 < n) {
                    dArray[n3][n2] = this.ldiag[n3] * doubleSquareMatrix.matrix[n2][n3 - 1] + this.diag[n3] * doubleSquareMatrix.matrix[n2][n3] + this.udiag[n3] * doubleSquareMatrix.matrix[n2][n3 + 1];
                    ++n3;
                }
                dArray[n][n2] = this.ldiag[n] * doubleSquareMatrix.matrix[n2][n - 1] + this.diag[n] * doubleSquareMatrix.matrix[n2][n];
                ++n2;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == doubleTridiagonalMatrix.numRows) {
            double[][] dArray = new double[n][n];
            dArray[0][0] = this.diag[0] * doubleTridiagonalMatrix.diag[0] + this.udiag[0] * doubleTridiagonalMatrix.ldiag[1];
            dArray[0][1] = this.diag[0] * doubleTridiagonalMatrix.udiag[0] + this.udiag[0] * doubleTridiagonalMatrix.diag[1];
            dArray[0][2] = this.udiag[0] * doubleTridiagonalMatrix.udiag[1];
            if (n > 3) {
                dArray[1][0] = this.ldiag[1] * doubleTridiagonalMatrix.diag[0] + this.diag[1] * doubleTridiagonalMatrix.ldiag[1];
                dArray[1][1] = this.ldiag[1] * doubleTridiagonalMatrix.udiag[0] + this.diag[1] * doubleTridiagonalMatrix.diag[1] + this.udiag[1] * doubleTridiagonalMatrix.ldiag[2];
                dArray[1][2] = this.diag[1] * doubleTridiagonalMatrix.udiag[1] + this.udiag[1] * doubleTridiagonalMatrix.diag[2];
                dArray[1][3] = this.udiag[1] * doubleTridiagonalMatrix.udiag[2];
            }
            if (n == 3) {
                dArray[1][0] = this.ldiag[1] * doubleTridiagonalMatrix.diag[0] + this.diag[1] * doubleTridiagonalMatrix.ldiag[1];
                dArray[1][1] = this.ldiag[1] * doubleTridiagonalMatrix.udiag[0] + this.diag[1] * doubleTridiagonalMatrix.diag[1] + this.udiag[1] * doubleTridiagonalMatrix.ldiag[2];
                dArray[1][2] = this.diag[1] * doubleTridiagonalMatrix.udiag[1] + this.udiag[1] * doubleTridiagonalMatrix.diag[2];
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    dArray[n2][n2 - 2] = this.ldiag[n2] * doubleTridiagonalMatrix.ldiag[n2 - 1];
                    dArray[n2][n2 - 1] = this.ldiag[n2] * doubleTridiagonalMatrix.diag[n2 - 1] + this.diag[n2] * doubleTridiagonalMatrix.ldiag[n2];
                    dArray[n2][n2] = this.ldiag[n2] * doubleTridiagonalMatrix.udiag[n2 - 1] + this.diag[n2] * doubleTridiagonalMatrix.diag[n2] + this.udiag[n2] * doubleTridiagonalMatrix.ldiag[n2 + 1];
                    dArray[n2][n2 + 1] = this.diag[n2] * doubleTridiagonalMatrix.udiag[n2] + this.udiag[n2] * doubleTridiagonalMatrix.diag[n2 + 1];
                    dArray[n2][n2 + 2] = this.udiag[n2] * doubleTridiagonalMatrix.udiag[n2 + 1];
                    ++n2;
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.ldiag[n - 2] * doubleTridiagonalMatrix.ldiag[n - 3];
                dArray[n - 2][n - 3] = this.ldiag[n - 2] * doubleTridiagonalMatrix.diag[n - 3] + this.diag[n - 2] * doubleTridiagonalMatrix.ldiag[n - 2];
                dArray[n - 2][n - 2] = this.ldiag[n - 2] * doubleTridiagonalMatrix.udiag[n - 3] + this.diag[n - 2] * doubleTridiagonalMatrix.diag[n - 2] + this.udiag[n - 2] * doubleTridiagonalMatrix.ldiag[n - 1];
                dArray[n - 2][n - 1] = this.diag[n - 2] * doubleTridiagonalMatrix.udiag[n - 2] + this.udiag[n - 2] * doubleTridiagonalMatrix.diag[n - 1];
            }
            dArray[n][--n - 2] = this.ldiag[n] * doubleTridiagonalMatrix.ldiag[n - 1];
            dArray[n][n - 1] = this.ldiag[n] * doubleTridiagonalMatrix.diag[n - 1] + this.diag[n] * doubleTridiagonalMatrix.ldiag[n];
            dArray[n][n] = this.ldiag[n] * doubleTridiagonalMatrix.udiag[n - 1] + this.diag[n] * doubleTridiagonalMatrix.diag[n];
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix multiplyTridiagonal(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            double[][] dArray = new double[n][n];
            dArray[0][0] = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 0) + this.udiag[0] * abstractDoubleSquareMatrix.getElement(1, 0);
            dArray[0][1] = this.diag[0] * abstractDoubleSquareMatrix.getElement(0, 1) + this.udiag[0] * abstractDoubleSquareMatrix.getElement(1, 1);
            dArray[0][2] = this.udiag[0] * abstractDoubleSquareMatrix.getElement(1, 2);
            if (n > 3) {
                dArray[1][0] = this.ldiag[1] * abstractDoubleSquareMatrix.getElement(0, 0) + this.diag[1] * abstractDoubleSquareMatrix.getElement(1, 0);
                dArray[1][1] = this.ldiag[1] * abstractDoubleSquareMatrix.getElement(0, 1) + this.diag[1] * abstractDoubleSquareMatrix.getElement(1, 1) + this.udiag[1] * abstractDoubleSquareMatrix.getElement(2, 1);
                dArray[1][2] = this.diag[1] * abstractDoubleSquareMatrix.getElement(1, 2) + this.udiag[1] * abstractDoubleSquareMatrix.getElement(2, 2);
                dArray[1][3] = this.udiag[1] * abstractDoubleSquareMatrix.getElement(2, 3);
            }
            if (n == 3) {
                dArray[1][0] = this.ldiag[1] * abstractDoubleSquareMatrix.getElement(0, 0) + this.diag[1] * abstractDoubleSquareMatrix.getElement(1, 0);
                dArray[1][1] = this.ldiag[1] * abstractDoubleSquareMatrix.getElement(0, 1) + this.diag[1] * abstractDoubleSquareMatrix.getElement(1, 1) + this.udiag[1] * abstractDoubleSquareMatrix.getElement(2, 1);
                dArray[1][2] = this.diag[1] * abstractDoubleSquareMatrix.getElement(1, 2) + this.udiag[1] * abstractDoubleSquareMatrix.getElement(2, 2);
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    dArray[n2][n2 - 2] = this.ldiag[n2] * abstractDoubleSquareMatrix.getElement(n2 - 1, n2 - 2);
                    dArray[n2][n2 - 1] = this.ldiag[n2] * abstractDoubleSquareMatrix.getElement(n2 - 1, n2 - 1) + this.diag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2 - 1);
                    dArray[n2][n2] = this.ldiag[n2] * abstractDoubleSquareMatrix.getElement(n2 - 1, n2) + this.diag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2) + this.udiag[n2] * abstractDoubleSquareMatrix.getElement(n2 + 1, n2);
                    dArray[n2][n2 + 1] = this.diag[n2] * abstractDoubleSquareMatrix.getElement(n2, n2 + 1) + this.udiag[n2] * abstractDoubleSquareMatrix.getElement(n2 + 1, n2 + 1);
                    dArray[n2][n2 + 2] = this.udiag[n2] * abstractDoubleSquareMatrix.getElement(n2 + 1, n2 + 2);
                    ++n2;
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.ldiag[n - 2] * abstractDoubleSquareMatrix.getElement(n - 3, n - 4);
                dArray[n - 2][n - 3] = this.ldiag[n - 2] * abstractDoubleSquareMatrix.getElement(n - 3, n - 3) + this.diag[n - 2] * abstractDoubleSquareMatrix.getElement(n - 2, n - 3);
                dArray[n - 2][n - 2] = this.ldiag[n - 2] * abstractDoubleSquareMatrix.getElement(n - 3, n - 2) + this.diag[n - 2] * abstractDoubleSquareMatrix.getElement(n - 2, n - 2) + this.udiag[n - 2] * abstractDoubleSquareMatrix.getElement(n - 1, n - 2);
                dArray[n - 2][n - 1] = this.diag[n - 2] * abstractDoubleSquareMatrix.getElement(n - 2, n - 1) + this.udiag[n - 2] * abstractDoubleSquareMatrix.getElement(n - 1, n - 1);
            }
            dArray[n][--n - 2] = this.ldiag[n] * abstractDoubleSquareMatrix.getElement(n - 1, n - 2);
            dArray[n][n - 1] = this.ldiag[n] * abstractDoubleSquareMatrix.getElement(n - 1, n - 1) + this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n - 1);
            dArray[n][n] = this.ldiag[n] * abstractDoubleSquareMatrix.getElement(n - 1, n) + this.diag[n] * abstractDoubleSquareMatrix.getElement(n, n);
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        System.arraycopy(this.ldiag, 1, doubleTridiagonalMatrix.udiag, 0, this.ldiag.length - 1);
        System.arraycopy(this.diag, 0, doubleTridiagonalMatrix.diag, 0, this.diag.length);
        System.arraycopy(this.udiag, 0, doubleTridiagonalMatrix.ldiag, 1, this.udiag.length - 1);
        return doubleTridiagonalMatrix;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        double d;
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double d2 = d = Math.sqrt(this.diag[0]);
        dArray2[0][0] = d2;
        dArray[0][0] = d2;
        double d3 = this.ldiag[1] / d;
        dArray2[0][1] = d3;
        dArray[1][0] = d3;
        int n2 = 1;
        while (n2 < n) {
            d = this.diag[n2];
            int n3 = 0;
            while (n3 < n2) {
                d -= dArray[n2][n3] * dArray[n2][n3];
                ++n3;
            }
            double d4 = Math.sqrt(d);
            dArray2[n2][n2] = d4;
            dArray[n2][n2] = d4;
            if (n2 + 1 < n) {
                d = this.ldiag[n2 + 1];
                int n4 = 0;
                while (n4 < n2 + 1) {
                    d -= dArray[n2][n4] * dArray2[n4][n2 + 1];
                    ++n4;
                }
                double d5 = d / dArray2[n2][n2];
                dArray2[n2][n2 + 1] = d5;
                dArray[n2 + 1][n2] = d5;
                int n5 = n2 + 2;
                while (n5 < n) {
                    d = 0.0;
                    int n6 = 0;
                    while (n6 < n5) {
                        d -= dArray[n2][n6] * dArray2[n6][n5];
                        ++n6;
                    }
                    double d6 = d / dArray2[n2][n2];
                    dArray2[n2][n5] = d6;
                    dArray[n5][n2] = d6;
                    ++n5;
                }
            }
            ++n2;
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] qrDecompose() {
        int n;
        int n2;
        int n3 = this.numRows;
        double[][] dArray = new double[n3][n3];
        double[][] dArray2 = new double[n3][n3];
        double[][] dArray3 = new double[n3][n3];
        dArray[0][0] = this.diag[0];
        dArray[0][1] = this.udiag[0];
        int n4 = 1;
        while (n4 < n3 - 1) {
            dArray[n4][n4 - 1] = this.ldiag[n4];
            dArray[n4][n4] = this.diag[n4];
            dArray[n4][n4 + 1] = this.udiag[n4];
            ++n4;
        }
        dArray[n3 - 1][n3 - 2] = this.ldiag[n3 - 1];
        dArray[n3 - 1][n3 - 1] = this.diag[n3 - 1];
        int n5 = 0;
        while (n5 < n3) {
            double d = dArray[n5][n5];
            int n6 = n5 + 1;
            while (n6 < n3) {
                d = ExtraMath.hypot(d, dArray[n6][n5]);
                ++n6;
            }
            if (d != 0.0) {
                if (dArray[n5][n5] < 0.0) {
                    d = -d;
                }
                int n7 = n5;
                while (n7 < n3) {
                    double[] dArray4 = dArray[n7];
                    int n8 = n5;
                    dArray4[n8] = dArray4[n8] / d;
                    ++n7;
                }
                double[] dArray5 = dArray[n5];
                int n9 = n5;
                dArray5[n9] = dArray5[n9] + 1.0;
                n2 = n5 + 1;
                while (n2 < n3) {
                    double d2 = dArray[n5][n5] * dArray[n5][n2];
                    int n10 = n5 + 1;
                    while (n10 < n3) {
                        d2 += dArray[n10][n5] * dArray[n10][n2];
                        ++n10;
                    }
                    d2 /= dArray[n5][n5];
                    int n11 = n5;
                    while (n11 < n3) {
                        double[] dArray6 = dArray[n11];
                        int n12 = n2;
                        dArray6[n12] = dArray6[n12] - d2 * dArray[n11][n5];
                        ++n11;
                    }
                    ++n2;
                }
            }
            dArray3[n5][n5] = -d;
            ++n5;
        }
        int n13 = n3 - 1;
        while (n13 >= 0) {
            dArray2[n13][n13] = 1.0;
            n = n13;
            while (n < n3) {
                if (dArray[n13][n13] != 0.0) {
                    double d = dArray[n13][n13] * dArray2[n13][n];
                    n2 = n13 + 1;
                    while (n2 < n3) {
                        d += dArray[n2][n13] * dArray2[n2][n];
                        ++n2;
                    }
                    d /= dArray[n13][n13];
                    int n14 = n13;
                    while (n14 < n3) {
                        double[] dArray7 = dArray2[n14];
                        int n15 = n;
                        dArray7[n15] = dArray7[n15] - d * dArray[n14][n13];
                        ++n14;
                    }
                }
                ++n;
            }
            --n13;
        }
        n = 0;
        while (n < n3) {
            int n16 = n + 1;
            while (n16 < n3) {
                dArray3[n][n16] = dArray[n][n16];
                ++n16;
            }
            ++n;
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleSquareMatrix(dArray3)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.numRows;
        int n9 = n8 - 1;
        double[][] dArray = new double[n8][n8];
        double[][] dArray2 = new double[n8][n8];
        double[] dArray3 = new double[n8];
        double[][] dArray4 = new double[n8][n8];
        double[] dArray5 = new double[n8];
        double[] dArray6 = new double[n8];
        dArray[0][0] = this.diag[0];
        dArray[0][1] = this.udiag[0];
        int n10 = 1;
        while (n10 < n9) {
            dArray[n10][n10 - 1] = this.ldiag[n10];
            dArray[n10][n10] = this.diag[n10];
            dArray[n10][n10 + 1] = this.udiag[n10];
            ++n10;
        }
        dArray[n9][n9 - 1] = this.ldiag[n9];
        dArray[n9][n9] = this.diag[n9];
        int n11 = 0;
        while (n11 < n9) {
            dArray3[n11] = dArray[n11][n11];
            n7 = n11 + 1;
            while (n7 < n8) {
                dArray3[n11] = ExtraMath.hypot(dArray3[n11], dArray[n7][n11]);
                ++n7;
            }
            if (dArray3[n11] != 0.0) {
                if (dArray[n11][n11] < 0.0) {
                    dArray3[n11] = -dArray3[n11];
                }
                n6 = n11;
                while (n6 < n8) {
                    double[] dArray7 = dArray[n6];
                    int n12 = n11;
                    dArray7[n12] = dArray7[n12] / dArray3[n11];
                    ++n6;
                }
                double[] dArray8 = dArray[n11];
                int n13 = n11;
                dArray8[n13] = dArray8[n13] + 1.0;
            }
            dArray3[n11] = -dArray3[n11];
            n6 = n11 + 1;
            while (n6 < n8) {
                if (dArray3[n11] != 0.0) {
                    double d = dArray[n11][n11] * dArray[n11][n6];
                    n5 = n11 + 1;
                    while (n5 < n8) {
                        d += dArray[n5][n11] * dArray[n5][n6];
                        ++n5;
                    }
                    d /= dArray[n11][n11];
                    n4 = n11;
                    while (n4 < n8) {
                        double[] dArray9 = dArray[n4];
                        int n14 = n6;
                        dArray9[n14] = dArray9[n14] - d * dArray[n4][n11];
                        ++n4;
                    }
                }
                dArray5[n6] = dArray[n11][n6];
                ++n6;
            }
            n3 = n11;
            while (n3 < n8) {
                dArray2[n3][n11] = dArray[n3][n11];
                ++n3;
            }
            if (n11 < n8 - 2) {
                dArray5[n11] = dArray5[n11 + 1];
                n2 = n11 + 2;
                while (n2 < n8) {
                    dArray5[n11] = ExtraMath.hypot(dArray5[n11], dArray5[n2]);
                    ++n2;
                }
                if (dArray5[n11] != 0.0) {
                    if (dArray5[n11 + 1] < 0.0) {
                        dArray5[n11] = -dArray5[n11];
                    }
                    n5 = n11 + 1;
                    while (n5 < n8) {
                        int n15 = n5++;
                        dArray5[n15] = dArray5[n15] / dArray5[n11];
                    }
                    int n16 = n11 + 1;
                    dArray5[n16] = dArray5[n16] + 1.0;
                }
                dArray5[n11] = -dArray5[n11];
                if (dArray5[n11] != 0.0) {
                    n5 = n11 + 1;
                    while (n5 < n8) {
                        dArray6[n5] = 0.0;
                        n4 = n11 + 1;
                        while (n4 < n8) {
                            int n17 = n5;
                            dArray6[n17] = dArray6[n17] + dArray5[n4] * dArray[n5][n4];
                            ++n4;
                        }
                        ++n5;
                    }
                    n4 = n11 + 1;
                    while (n4 < n8) {
                        double d = dArray5[n4] / dArray5[n11 + 1];
                        int n18 = n11 + 1;
                        while (n18 < n8) {
                            double[] dArray10 = dArray[n18];
                            int n19 = n4;
                            dArray10[n19] = dArray10[n19] - d * dArray6[n18];
                            ++n18;
                        }
                        ++n4;
                    }
                }
                n5 = n11 + 1;
                while (n5 < n8) {
                    dArray4[n5][n11] = dArray5[n5];
                    ++n5;
                }
            }
            ++n11;
        }
        n7 = n8;
        dArray3[n9] = dArray[n9][n9];
        dArray5[n8 - 2] = dArray[n8 - 2][n9];
        dArray5[n9] = 0.0;
        dArray2[n9][n9] = 1.0;
        n6 = n8 - 2;
        while (n6 >= 0) {
            if (dArray3[n6] != 0.0) {
                n3 = n6 + 1;
                while (n3 < n8) {
                    double d = dArray2[n6][n6] * dArray2[n6][n3];
                    n4 = n6 + 1;
                    while (n4 < n8) {
                        d += dArray2[n4][n6] * dArray2[n4][n3];
                        ++n4;
                    }
                    d /= dArray2[n6][n6];
                    int n20 = n6;
                    while (n20 < n8) {
                        double[] dArray11 = dArray2[n20];
                        int n21 = n3;
                        dArray11[n21] = dArray11[n21] - d * dArray2[n20][n6];
                        ++n20;
                    }
                    ++n3;
                }
                n2 = n6;
                while (n2 < n8) {
                    dArray2[n2][n6] = -dArray2[n2][n6];
                    ++n2;
                }
                double[] dArray12 = dArray2[n6];
                int n22 = n6;
                dArray12[n22] = dArray12[n22] + 1.0;
                n5 = 0;
                while (n5 < n6 - 1) {
                    dArray2[n5][n6] = 0.0;
                    ++n5;
                }
            } else {
                n3 = 0;
                while (n3 < n8) {
                    dArray2[n3][n6] = 0.0;
                    ++n3;
                }
                dArray2[n6][n6] = 1.0;
            }
            --n6;
        }
        n3 = n9;
        while (n3 >= 0) {
            if (n3 < n8 - 2 && dArray5[n3] != 0.0) {
                n2 = n3 + 1;
                while (n2 < n8) {
                    double d = dArray4[n3 + 1][n3] * dArray4[n3 + 1][n2];
                    int n23 = n3 + 2;
                    while (n23 < n8) {
                        d += dArray4[n23][n3] * dArray4[n23][n2];
                        ++n23;
                    }
                    d /= dArray4[n3 + 1][n3];
                    n = n3 + 1;
                    while (n < n8) {
                        double[] dArray13 = dArray4[n];
                        int n24 = n2;
                        dArray13[n24] = dArray13[n24] - d * dArray4[n][n3];
                        ++n;
                    }
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < n8) {
                dArray4[n2][n3] = 0.0;
                ++n2;
            }
            dArray4[n3][n3] = 1.0;
            --n3;
        }
        double d = Math.pow(2.0, -52.0);
        n4 = 0;
        block33: while (n7 > 0) {
            int n25 = n7 - 2;
            while (n25 >= -1) {
                if (n25 == -1) break;
                if (Math.abs(dArray5[n25]) <= d * (Math.abs(dArray3[n25]) + Math.abs(dArray3[n25 + 1]))) {
                    dArray5[n25] = 0.0;
                    break;
                }
                --n25;
            }
            if (n25 == n7 - 2) {
                n = 4;
            } else {
                int n26 = n7 - 1;
                while (n26 >= n25) {
                    if (n26 == n25) break;
                    double d2 = (n26 != n7 ? Math.abs(dArray5[n26]) : 0.0) + (n26 != n25 + 1 ? Math.abs(dArray5[n26 - 1]) : 0.0);
                    if (Math.abs(dArray3[n26]) <= d * d2) {
                        dArray3[n26] = 0.0;
                        break;
                    }
                    --n26;
                }
                if (n26 == n25) {
                    n = 3;
                } else if (n26 == n7 - 1) {
                    n = 1;
                } else {
                    n = 2;
                    n25 = n26;
                }
            }
            ++n25;
            switch (n) {
                case 1: {
                    int n27;
                    double d3;
                    double d4;
                    double d5;
                    double d6 = dArray5[n7 - 2];
                    dArray5[n7 - 2] = 0.0;
                    int n28 = n7 - 2;
                    while (n28 >= n25) {
                        d5 = ExtraMath.hypot(dArray3[n28], d6);
                        d4 = dArray3[n28] / d5;
                        d3 = d6 / d5;
                        dArray3[n28] = d5;
                        if (n28 != n25) {
                            d6 = -d3 * dArray5[n28 - 1];
                            int n29 = n28 - 1;
                            dArray5[n29] = dArray5[n29] * d4;
                        }
                        n27 = 0;
                        while (n27 < n8) {
                            d5 = d4 * dArray4[n27][n28] + d3 * dArray4[n27][n7 - 1];
                            dArray4[n27][n7 - 1] = -d3 * dArray4[n27][n28] + d4 * dArray4[n27][n7 - 1];
                            dArray4[n27][n28] = d5;
                            ++n27;
                        }
                        --n28;
                    }
                    continue block33;
                }
                case 2: {
                    int n27;
                    double d3;
                    double d4;
                    double d5;
                    double d7 = dArray5[n25 - 1];
                    dArray5[n25 - 1] = 0.0;
                    int n30 = n25;
                    while (n30 < n7) {
                        d5 = ExtraMath.hypot(dArray3[n30], d7);
                        d4 = dArray3[n30] / d5;
                        d3 = d7 / d5;
                        dArray3[n30] = d5;
                        d7 = -d3 * dArray5[n30];
                        int n31 = n30;
                        dArray5[n31] = dArray5[n31] * d4;
                        n27 = 0;
                        while (n27 < n8) {
                            d5 = d4 * dArray2[n27][n30] + d3 * dArray2[n27][n25 - 1];
                            dArray2[n27][n25 - 1] = -d3 * dArray2[n27][n30] + d4 * dArray2[n27][n25 - 1];
                            dArray2[n27][n30] = d5;
                            ++n27;
                        }
                        ++n30;
                    }
                    continue block33;
                }
                case 3: {
                    double d8 = Math.max(Math.max(Math.max(Math.max(Math.abs(dArray3[n7 - 1]), Math.abs(dArray3[n7 - 2])), Math.abs(dArray5[n7 - 2])), Math.abs(dArray3[n25])), Math.abs(dArray5[n25]));
                    double d9 = dArray3[n7 - 1] / d8;
                    double d10 = dArray3[n7 - 2] / d8;
                    double d11 = dArray5[n7 - 2] / d8;
                    double d12 = dArray3[n25] / d8;
                    double d13 = dArray5[n25] / d8;
                    double d14 = ((d10 + d9) * (d10 - d9) + d11 * d11) / 2.0;
                    double d15 = d9 * d11 * (d9 * d11);
                    double d16 = 0.0;
                    if (d14 != 0.0 || d15 != 0.0) {
                        d16 = Math.sqrt(d14 * d14 + d15);
                        if (d14 < 0.0) {
                            d16 = -d16;
                        }
                        d16 = d15 / (d14 + d16);
                    }
                    double d17 = (d12 + d9) * (d12 - d9) + d16;
                    double d18 = d12 * d13;
                    int n32 = n25;
                    while (n32 < n7 - 1) {
                        double d19 = ExtraMath.hypot(d17, d18);
                        double d20 = d17 / d19;
                        double d21 = d18 / d19;
                        if (n32 != n25) {
                            dArray5[n32 - 1] = d19;
                        }
                        d17 = d20 * dArray3[n32] + d21 * dArray5[n32];
                        dArray5[n32] = d20 * dArray5[n32] - d21 * dArray3[n32];
                        d18 = d21 * dArray3[n32 + 1];
                        int n33 = n32 + 1;
                        dArray3[n33] = dArray3[n33] * d20;
                        int n34 = 0;
                        while (n34 < n8) {
                            d19 = d20 * dArray4[n34][n32] + d21 * dArray4[n34][n32 + 1];
                            dArray4[n34][n32 + 1] = -d21 * dArray4[n34][n32] + d20 * dArray4[n34][n32 + 1];
                            dArray4[n34][n32] = d19;
                            ++n34;
                        }
                        d19 = ExtraMath.hypot(d17, d18);
                        d20 = d17 / d19;
                        d21 = d18 / d19;
                        dArray3[n32] = d19;
                        d17 = d20 * dArray5[n32] + d21 * dArray3[n32 + 1];
                        dArray3[n32 + 1] = -d21 * dArray5[n32] + d20 * dArray3[n32 + 1];
                        d18 = d21 * dArray5[n32 + 1];
                        int n35 = n32 + 1;
                        dArray5[n35] = dArray5[n35] * d20;
                        if (n32 < n9) {
                            int n36 = 0;
                            while (n36 < n8) {
                                d19 = d20 * dArray2[n36][n32] + d21 * dArray2[n36][n32 + 1];
                                dArray2[n36][n32 + 1] = -d21 * dArray2[n36][n32] + d20 * dArray2[n36][n32 + 1];
                                dArray2[n36][n32] = d19;
                                ++n36;
                            }
                        }
                        ++n32;
                    }
                    dArray5[n7 - 2] = d17;
                    ++n4;
                    break;
                }
                case 4: {
                    if (dArray3[n25] <= 0.0) {
                        dArray3[n25] = -dArray3[n25];
                        int n37 = 0;
                        while (n37 < n7) {
                            dArray4[n37][n25] = -dArray4[n37][n25];
                            ++n37;
                        }
                    }
                    while (n25 < n7 - 1) {
                        if (dArray3[n25] >= dArray3[n25 + 1]) break;
                        double d22 = dArray3[n25];
                        dArray3[n25] = dArray3[n25 + 1];
                        dArray3[n25 + 1] = d22;
                        if (n25 < n9) {
                            int n38 = 0;
                            while (n38 < n8) {
                                d22 = dArray2[n38][n25 + 1];
                                dArray2[n38][n25 + 1] = dArray2[n38][n25];
                                dArray2[n38][n25] = d22;
                                d22 = dArray4[n38][n25 + 1];
                                dArray4[n38][n25 + 1] = dArray4[n38][n25];
                                dArray4[n38][n25] = d22;
                                ++n38;
                            }
                        }
                        ++n25;
                    }
                    n4 = 0;
                    --n7;
                }
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleDiagonalMatrix(dArray3), new DoubleSquareMatrix(dArray4)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        int n = this.numRows;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        doubleTridiagonalMatrix.diag[0] = mapping.map(this.diag[0]);
        doubleTridiagonalMatrix.udiag[0] = mapping.map(this.udiag[0]);
        --n;
        int n2 = 1;
        while (n2 < n) {
            doubleTridiagonalMatrix.ldiag[n2] = mapping.map(this.ldiag[n2]);
            doubleTridiagonalMatrix.diag[n2] = mapping.map(this.diag[n2]);
            doubleTridiagonalMatrix.udiag[n2] = mapping.map(this.udiag[n2]);
            ++n2;
        }
        doubleTridiagonalMatrix.ldiag[n] = mapping.map(this.ldiag[n]);
        doubleTridiagonalMatrix.diag[n] = mapping.map(this.diag[n]);
        return doubleTridiagonalMatrix;
    }
}

