/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.MathSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FiniteSet
implements MathSet {
    private final Set elements;

    public FiniteSet(Set set) {
        this.elements = set;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof FiniteSet && this.elements.equals(((FiniteSet)object).elements);
    }

    public String toString() {
        return this.elements.toString();
    }

    public Set getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public int cardinality() {
        return this.elements.size();
    }

    public MathSet union(MathSet mathSet) {
        HashSet hashSet = new HashSet(this.elements);
        hashSet.addAll(((FiniteSet)mathSet).elements);
        return new FiniteSet(hashSet);
    }

    public MathSet intersect(MathSet mathSet) {
        HashSet hashSet = new HashSet(this.elements);
        hashSet.retainAll(((FiniteSet)mathSet).elements);
        return new FiniteSet(hashSet);
    }
}

