/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.AbstractDoubleSquareMatrix;
import JSci.maths.AbstractIntegerMatrix;
import JSci.maths.AbstractIntegerSquareMatrix;
import JSci.maths.AbstractIntegerVector;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.DiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerTridiagonalMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.TridiagonalMatrix;

public class IntegerDiagonalMatrix
extends AbstractIntegerSquareMatrix
implements DiagonalMatrix {
    protected final int[] diag;

    public IntegerDiagonalMatrix(int n) {
        this(new int[n]);
    }

    public IntegerDiagonalMatrix(int[][] nArray) {
        this(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n].length != nArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diag[n] = nArray[n][n];
            ++n;
        }
    }

    public IntegerDiagonalMatrix(int[] nArray) {
        super(nArray.length);
        this.diag = nArray;
    }

    public static IntegerDiagonalMatrix identity(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 1;
            ++n2;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public boolean equals(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (abstractIntegerMatrix instanceof DiagonalMatrix) {
            if (this.numRows != abstractIntegerMatrix.rows() || this.numCols != abstractIntegerMatrix.columns()) {
                return false;
            }
            if ((double)Math.abs(this.diag[0] - abstractIntegerMatrix.getElement(0, 0)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            int n = 1;
            while (n < this.numRows) {
                if ((double)Math.abs(this.diag[n] - abstractIntegerMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public AbstractDoubleMatrix toDoubleMatrix() {
        double[] dArray = new double[this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[n] = this.diag[n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        double[] dArray = new double[this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[n] = this.diag[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, new double[this.numRows]);
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diag[n];
            }
            return 0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, int n3) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n != n2) {
                throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diag[n] = n3;
    }

    public boolean isSymmetric() {
        return true;
    }

    public int det() {
        int n = this.diag[0];
        int n2 = 1;
        while (n2 < this.numRows) {
            n *= this.diag[n2];
            ++n2;
        }
        return n;
    }

    public int trace() {
        int n = this.diag[0];
        int n2 = 1;
        while (n2 < this.numRows) {
            n += this.diag[n2];
            ++n2;
        }
        return n;
    }

    public int infNorm() {
        int n = Math.abs(this.diag[0]);
        int n2 = 1;
        while (n2 < this.numRows) {
            int n3 = Math.abs(this.diag[n2]);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        double d = this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            d = ExtraMath.hypot(d, this.diag[n]);
            ++n;
        }
        return d;
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return this.infNorm();
    }

    public AbstractIntegerSquareMatrix add(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.add((IntegerDiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof DiagonalMatrix) {
            return this.addDiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.add((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.add((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int n;
            int[][] nArray = new int[this.numRows][this.numCols];
            int n2 = 0;
            while (n2 < this.numRows) {
                nArray[n2][0] = abstractIntegerSquareMatrix.getElement(n2, 0);
                n = 1;
                while (n < this.numCols) {
                    nArray[n2][n] = abstractIntegerSquareMatrix.getElement(n2, n);
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n < this.numRows) {
                int[] nArray2 = nArray[n];
                int n3 = n;
                nArray2[n3] = nArray2[n3] + this.diag[n];
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(integerSquareMatrix.matrix[n], 0, nArray[n], 0, this.numRows);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numRows) {
                int[] nArray2 = nArray[n2];
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + this.diag[n2];
                ++n2;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (this.numRows == integerTridiagonalMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(this.numRows);
            System.arraycopy(integerTridiagonalMatrix.ldiag, 0, integerTridiagonalMatrix2.ldiag, 0, integerTridiagonalMatrix.ldiag.length);
            System.arraycopy(integerTridiagonalMatrix.udiag, 0, integerTridiagonalMatrix2.udiag, 0, integerTridiagonalMatrix.udiag.length);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] + integerTridiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                integerTridiagonalMatrix2.diag[n] = this.diag[n] + integerTridiagonalMatrix.diag[n];
                ++n;
            }
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix addTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (n == abstractIntegerSquareMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] + abstractIntegerSquareMatrix.getElement(0, 0);
            integerTridiagonalMatrix.udiag[0] = abstractIntegerSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.ldiag[n2] = abstractIntegerSquareMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix.diag[n2] = this.diag[n2] + abstractIntegerSquareMatrix.getElement(n2, n2);
                integerTridiagonalMatrix.udiag[n2] = abstractIntegerSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix.ldiag[n] = abstractIntegerSquareMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix.diag[n] = this.diag[n] + abstractIntegerSquareMatrix.getElement(n, n);
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix add(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.numRows == integerDiagonalMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] + integerDiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] + integerDiagonalMatrix.diag[n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerDiagonalMatrix addDiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (this.numRows == abstractIntegerSquareMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] + abstractIntegerSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] + abstractIntegerSquareMatrix.getElement(n, n);
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerSquareMatrix subtract(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.subtract((IntegerDiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof DiagonalMatrix) {
            return this.subtractDiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.subtract((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.subtract((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int n;
            int[][] nArray = new int[this.numRows][this.numCols];
            int n2 = 0;
            while (n2 < this.numRows) {
                nArray[n2][0] = -abstractIntegerSquareMatrix.getElement(n2, 0);
                n = 1;
                while (n < this.numCols) {
                    nArray[n2][n] = -abstractIntegerSquareMatrix.getElement(n2, n);
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n < this.numRows) {
                int[] nArray2 = nArray[n];
                int n3 = n;
                nArray2[n3] = nArray2[n3] + this.diag[n];
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int n;
            int[][] nArray = new int[this.numRows][this.numCols];
            int n2 = 0;
            while (n2 < this.numRows) {
                nArray[n2][0] = -integerSquareMatrix.matrix[n2][0];
                n = 1;
                while (n < this.numCols) {
                    nArray[n2][n] = -integerSquareMatrix.matrix[n2][n];
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n < this.numRows) {
                int[] nArray2 = nArray[n];
                int n3 = n;
                nArray2[n3] = nArray2[n3] + this.diag[n];
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] - integerTridiagonalMatrix.diag[0];
            integerTridiagonalMatrix2.udiag[0] = -integerTridiagonalMatrix.udiag[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.ldiag[n2] = -integerTridiagonalMatrix.ldiag[n2];
                integerTridiagonalMatrix2.diag[n2] = this.diag[n2] - integerTridiagonalMatrix.diag[n2];
                integerTridiagonalMatrix2.udiag[n2] = -integerTridiagonalMatrix.udiag[n2];
                ++n2;
            }
            integerTridiagonalMatrix2.ldiag[n] = -integerTridiagonalMatrix.ldiag[n];
            integerTridiagonalMatrix2.diag[n] = this.diag[n] - integerTridiagonalMatrix.diag[n];
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix subtractTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (n == abstractIntegerSquareMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] - abstractIntegerSquareMatrix.getElement(0, 0);
            integerTridiagonalMatrix.udiag[0] = -abstractIntegerSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.ldiag[n2] = -abstractIntegerSquareMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix.diag[n2] = this.diag[n2] - abstractIntegerSquareMatrix.getElement(n2, n2);
                integerTridiagonalMatrix.udiag[n2] = -abstractIntegerSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix.ldiag[n] = -abstractIntegerSquareMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix.diag[n] = this.diag[n] - abstractIntegerSquareMatrix.getElement(n, n);
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix subtract(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.numRows == integerDiagonalMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] - integerDiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] - integerDiagonalMatrix.diag[n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerDiagonalMatrix subtractDiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (this.numRows == abstractIntegerSquareMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] - abstractIntegerSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] - abstractIntegerSquareMatrix.getElement(n, n);
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerMatrix scalarMultiply(int n) {
        int[] nArray = new int[this.numRows];
        nArray[0] = n * this.diag[0];
        int n2 = 1;
        while (n2 < this.numRows) {
            nArray[n2] = n * this.diag[n2];
            ++n2;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public int scalarProduct(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.scalarProduct((IntegerDiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.scalarProduct((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.scalarProduct((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int n = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 0);
            int n2 = 1;
            while (n2 < this.numRows) {
                n += this.diag[n2] * abstractIntegerSquareMatrix.getElement(n2, n2);
                ++n2;
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int n = this.diag[0] * integerSquareMatrix.matrix[0][0];
            int n2 = 1;
            while (n2 < this.numRows) {
                n += this.diag[n2] * integerSquareMatrix.matrix[n2][n2];
                ++n2;
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (this.numRows == integerTridiagonalMatrix.numRows) {
            int n = this.diag[0] * integerTridiagonalMatrix.diag[0];
            int n2 = 1;
            while (n2 < this.numRows) {
                n += this.diag[n2] * integerTridiagonalMatrix.diag[n2];
                ++n2;
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.numRows == integerDiagonalMatrix.numRows) {
            int n = this.diag[0] * integerDiagonalMatrix.diag[0];
            int n2 = 1;
            while (n2 < this.numRows) {
                n += this.diag[n2] * integerDiagonalMatrix.diag[n2];
                ++n2;
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerVector multiply(AbstractIntegerVector abstractIntegerVector) {
        if (this.numCols == abstractIntegerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] * abstractIntegerVector.getComponent(0);
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] * abstractIntegerVector.getComponent(n);
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractIntegerSquareMatrix multiply(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.multiply((IntegerDiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof DiagonalMatrix) {
            return this.multiplyDiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.multiply((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.multiply((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numCols == abstractIntegerSquareMatrix.rows()) {
            int n = abstractIntegerSquareMatrix.columns();
            int[][] nArray = new int[this.numRows][n];
            int n2 = 0;
            while (n2 < this.numRows) {
                nArray[n2][0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(n2, 0);
                int n3 = 1;
                while (n3 < n) {
                    nArray[n2][n3] = this.diag[n2] * abstractIntegerSquareMatrix.getElement(n2, n3);
                    ++n3;
                }
                ++n2;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numCols == integerSquareMatrix.numRows) {
            int[][] nArray = new int[this.numRows][integerSquareMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.diag[0] * integerSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < integerSquareMatrix.numCols) {
                    nArray[n][n2] = this.diag[n] * integerSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerTridiagonalMatrix multiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == integerTridiagonalMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] * integerTridiagonalMatrix.diag[0];
            integerTridiagonalMatrix2.udiag[0] = this.diag[0] * integerTridiagonalMatrix.udiag[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.ldiag[n2] = this.diag[n2] * integerTridiagonalMatrix.ldiag[n2];
                integerTridiagonalMatrix2.diag[n2] = this.diag[n2] * integerTridiagonalMatrix.diag[n2];
                integerTridiagonalMatrix2.udiag[n2] = this.diag[n2] * integerTridiagonalMatrix.udiag[n2];
                ++n2;
            }
            integerTridiagonalMatrix2.ldiag[n] = this.diag[n] * integerTridiagonalMatrix.ldiag[n];
            integerTridiagonalMatrix2.diag[n] = this.diag[n] * integerTridiagonalMatrix.diag[n];
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerTridiagonalMatrix multiplyTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractIntegerSquareMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 0);
            integerTridiagonalMatrix.udiag[0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.ldiag[n2] = this.diag[n2] * abstractIntegerSquareMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix.diag[n2] = this.diag[n2] * abstractIntegerSquareMatrix.getElement(n2, n2);
                integerTridiagonalMatrix.udiag[n2] = this.diag[n2] * abstractIntegerSquareMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix.ldiag[n] = this.diag[n] * abstractIntegerSquareMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix.diag[n] = this.diag[n] * abstractIntegerSquareMatrix.getElement(n, n);
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerDiagonalMatrix multiply(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.numCols == integerDiagonalMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] * integerDiagonalMatrix.diag[0];
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] * integerDiagonalMatrix.diag[n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerDiagonalMatrix multiplyDiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (this.numCols == abstractIntegerSquareMatrix.rows()) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.numRows) {
                nArray[n] = this.diag[n] * abstractIntegerSquareMatrix.getElement(n, n);
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        return this;
    }

    public AbstractDoubleSquareMatrix inverse() {
        double[] dArray = new double[this.numRows];
        dArray[0] = 1.0 / (double)this.diag[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = 1.0 / (double)this.diag[n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.numRows] = 1;
        this.LU = new AbstractDoubleSquareMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.numRows);
        this.LU[1] = (AbstractDoubleSquareMatrix)this.toDoubleMatrix();
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[2];
        double[] dArray = new double[this.numRows];
        dArray[0] = Math.sqrt(this.diag[0]);
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = Math.sqrt(this.diag[n]);
            ++n;
        }
        abstractDoubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        abstractDoubleSquareMatrixArray[1] = abstractDoubleSquareMatrixArray[0];
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] qrDecompose() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{DoubleDiagonalMatrix.identity(this.numRows), (AbstractDoubleSquareMatrix)this.toDoubleMatrix()};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int n = this.numRows;
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = -1.0;
            dArray2[n3] = Math.abs(this.diag[n3]);
            dArray3[n3] = (double)this.diag[n3] < 0.0 ? 1.0 : -1.0;
            ++n3;
        }
        dArray[n2] = 1.0;
        dArray2[n2] = Math.abs(this.diag[n2]);
        dArray3[n2] = (double)this.diag[n2] < 0.0 ? -1.0 : 1.0;
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleDiagonalMatrix(dArray), new DoubleDiagonalMatrix(dArray2), new DoubleDiagonalMatrix(dArray3)};
        return abstractDoubleSquareMatrixArray;
    }
}

