/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.ArrayMath;
import JSci.maths.Mapping;
import JSci.maths.MappingND;
import JSci.maths.analysis.RealFunction2D;

public final class NumericalMath
extends AbstractMath {
    private NumericalMath() {
    }

    public static double[] solveQuadratic(double d, double d2, double d3) {
        double[] dArray = new double[2];
        double d4 = -0.5 * (d2 + (d2 < 0.0 ? -1.0 : 1.0) * Math.sqrt(d2 * d2 - 4.0 * d * d3));
        dArray[0] = d4 / d;
        dArray[1] = d3 / d4;
        return dArray;
    }

    public static double[] euler(double[] dArray, Mapping mapping, double d) {
        int n = 0;
        while (n < dArray.length - 1) {
            dArray[n + 1] = dArray[n] + d * mapping.map(dArray[n]);
            ++n;
        }
        return dArray;
    }

    public static double[] leapFrog(double[] dArray, Mapping mapping, double d) {
        double d2 = 2.0 * d;
        int n = 1;
        while (n < dArray.length - 1) {
            dArray[n + 1] = dArray[n - 1] + d2 * mapping.map(dArray[n]);
            ++n;
        }
        return dArray;
    }

    public static double[] rungeKutta2(double[] dArray, Mapping mapping, double d) {
        double d2 = d / 2.0;
        int n = 0;
        while (n < dArray.length - 1) {
            dArray[n + 1] = dArray[n] + d * mapping.map(dArray[n] + d2 * mapping.map(dArray[n]));
            ++n;
        }
        return dArray;
    }

    public static double[] rungeKutta2(double[] dArray, RealFunction2D realFunction2D, double d, double d2) {
        double d3 = d2 / 2.0;
        double d4 = d;
        int n = 0;
        while (n < dArray.length - 1) {
            dArray[n + 1] = dArray[n] + d2 * realFunction2D.map(dArray[n] + d3 * realFunction2D.map(dArray[n], d4), d4 + d3);
            d4 += d2;
            ++n;
        }
        return dArray;
    }

    public static double[] rungeKutta4(double[] dArray, Mapping mapping, double d) {
        int n = 0;
        while (n < dArray.length - 1) {
            double d2 = d * mapping.map(dArray[n]);
            double d3 = d * mapping.map(dArray[n] + d2 / 2.0);
            double d4 = d * mapping.map(dArray[n] + d3 / 2.0);
            double d5 = d * mapping.map(dArray[n] + d4);
            dArray[n + 1] = dArray[n] + (d2 + d5) / 6.0 + (d3 + d4) / 3.0;
            ++n;
        }
        return dArray;
    }

    public static double[] rungeKutta4(double[] dArray, RealFunction2D realFunction2D, double d, double d2) {
        double d3 = d2 / 2.0;
        double d4 = d;
        int n = 0;
        while (n < dArray.length - 1) {
            double d5 = d2 * realFunction2D.map(dArray[n], d4);
            double d6 = d2 * realFunction2D.map(dArray[n] + d5 / 2.0, d4 + d3);
            double d7 = d2 * realFunction2D.map(dArray[n] + d6 / 2.0, d4 + d3);
            double d8 = d2 * realFunction2D.map(dArray[n] + d7, d4 + d2);
            dArray[n + 1] = dArray[n] + (d5 + d8) / 6.0 + (d6 + d7) / 3.0;
            d4 += d2;
            ++n;
        }
        return dArray;
    }

    public static double trapezium(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = d;
        double d5 = (d2 - d) / (double)n;
        int n2 = 0;
        while (n2 < n) {
            d3 += mapping.map(d4) + mapping.map(d4 + d5);
            d4 += d5;
            ++n2;
        }
        return d3 * d5 / 2.0;
    }

    public static double simpson(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = d;
        double d6 = (d2 - d) / (double)(2 * n);
        int n2 = 0;
        while (n2 < n - 1) {
            d3 += mapping.map(d5 + d6);
            d4 += mapping.map(d5 + 2.0 * d6);
            d5 += 2.0 * d6;
            ++n2;
        }
        return d6 / 3.0 * (mapping.map(d) + 4.0 * (d3 += mapping.map(d5 + d6)) + 2.0 * d4 + mapping.map(d2));
    }

    public static double richardson(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = d;
        double d8 = (d2 - d) / (double)(2 * n);
        double d9 = d8 / 2.0;
        int n2 = 0;
        while (n2 < n - 1) {
            d3 += mapping.map(d7 + d8);
            d4 += mapping.map(d7 + 2.0 * d8);
            d5 += mapping.map(d7 + d9);
            d6 += mapping.map(d7 + 2.0 * d9);
            d5 += mapping.map(d7 + 3.0 * d9);
            d6 += mapping.map(d7 + 4.0 * d9);
            d7 += 2.0 * d8;
            ++n2;
        }
        d5 += mapping.map(d7 + d9);
        double d10 = d8 / 3.0 * (mapping.map(d) + 4.0 * (d3 += mapping.map(d7 + d8)) + 2.0 * d4 + mapping.map(d2));
        double d11 = d9 / 3.0 * (mapping.map(d) + 4.0 * (d5 += mapping.map(d7 + 3.0 * d9)) + 2.0 * (d6 += mapping.map(d7 + 2.0 * d9)) + mapping.map(d2));
        return (16.0 * d11 - d10) / 15.0;
    }

    public static double gaussian4(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = (d2 - d) / (double)n;
        double d5 = d4 / 2.0;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        dArray[2] = 0.33998104358485626;
        dArray[3] = 0.8611363115940526;
        dArray[0] = -dArray[3];
        dArray[1] = -dArray[2];
        dArray2[3] = 0.34785484513745385;
        dArray2[0] = 0.34785484513745385;
        dArray2[2] = 0.6521451548625461;
        dArray2[1] = 0.6521451548625461;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < dArray.length) {
                d3 += dArray2[n3] * mapping.map(d + (dArray[n3] + 1.0) * d5);
                ++n3;
            }
            d += d4;
            ++n2;
        }
        return d3 * d5;
    }

    public static double gaussian8(int n, Mapping mapping, double d, double d2) {
        double d3 = 0.0;
        double d4 = (d2 - d) / (double)n;
        double d5 = d4 / 2.0;
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        dArray[4] = 0.1834346424956498;
        dArray[5] = 0.525532409916329;
        dArray[6] = 0.7966664774136267;
        dArray[7] = 0.9602898564975363;
        dArray[0] = -dArray[7];
        dArray[1] = -dArray[6];
        dArray[2] = -dArray[5];
        dArray[3] = -dArray[4];
        dArray2[7] = 0.10122853629037626;
        dArray2[0] = 0.10122853629037626;
        dArray2[6] = 0.22238103445337448;
        dArray2[1] = 0.22238103445337448;
        dArray2[5] = 0.31370664587788727;
        dArray2[2] = 0.31370664587788727;
        dArray2[4] = 0.362683783378362;
        dArray2[3] = 0.362683783378362;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < dArray.length) {
                d3 += dArray2[n3] * mapping.map(d + (dArray[n3] + 1.0) * d5);
                ++n3;
            }
            d += d4;
            ++n2;
        }
        return d3 * d5;
    }

    public static double[] differentiate(int n, Mapping mapping, double d, double d2) {
        double[] dArray = new double[n];
        double d3 = d;
        double d4 = (d2 - d) / (double)n;
        double d5 = d4 / 2.0;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = (mapping.map(d3 + d5) - mapping.map(d3 - d5)) / d4;
            d3 += d4;
            ++n2;
        }
        return dArray;
    }

    public static double[][] differentiate(MappingND mappingND, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray, 0, dArray4, 0, dArray.length);
        dArray3[0] = dArray3[0] + dArray2[0];
        dArray4[0] = dArray4[0] - dArray2[0];
        double[] dArray5 = ArrayMath.scalarMultiply(0.5 / dArray2[0], ArrayMath.subtract(mappingND.map(dArray3), mappingND.map(dArray4)));
        double[][] dArray6 = new double[dArray5.length][dArray.length];
        int n = 0;
        while (n < dArray5.length) {
            dArray6[n][0] = dArray5[n];
            ++n;
        }
        int n2 = 1;
        while (n2 < dArray.length) {
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            System.arraycopy(dArray, 0, dArray4, 0, dArray.length);
            int n3 = n2;
            dArray3[n3] = dArray3[n3] + dArray2[n2];
            int n4 = n2;
            dArray4[n4] = dArray4[n4] - dArray2[n2];
            dArray5 = ArrayMath.scalarMultiply(0.5 / dArray2[n2], ArrayMath.subtract(mappingND.map(dArray3), mappingND.map(dArray4)));
            int n5 = 0;
            while (n5 < dArray5.length) {
                dArray6[n5][n2] = dArray5[n5];
                ++n5;
            }
            ++n2;
        }
        return dArray6;
    }

    public static double[] metropolis(double[] dArray, Mapping mapping, double d) {
        int n = 0;
        while (n < dArray.length - 1) {
            dArray[n + 1] = dArray[n] + d * (2.0 * Math.random() - 1.0);
            if (mapping.map(dArray[n + 1]) / mapping.map(dArray[n]) < Math.random()) {
                dArray[n + 1] = dArray[n];
            }
            ++n;
        }
        return dArray;
    }
}

