/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractDoubleSquareMatrix;
import JSci.maths.Double3Vector;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.ExtraMath;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.CStarAlgebra;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class Quaternion
implements Field.Member,
CStarAlgebra.Member {
    private static final long serialVersionUID = 1605315490425547301L;
    private double re;
    private double imi;
    private double imj;
    private double imk;
    public static final Quaternion ONE = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);

    public Quaternion(double d, Double3Vector double3Vector) {
        this.re = d;
        this.imi = double3Vector.x;
        this.imj = double3Vector.y;
        this.imk = double3Vector.z;
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.re = d;
        this.imi = d2;
        this.imj = d3;
        this.imk = d4;
    }

    public static Quaternion rotation(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        double d;
        double d2;
        double d3;
        double d4;
        if (abstractDoubleSquareMatrix.rows() != 3 && abstractDoubleSquareMatrix.columns() != 3) {
            throw new MatrixDimensionException("The matrix is not 3-dimensional.");
        }
        double d5 = (1.0 + abstractDoubleSquareMatrix.trace()) / 4.0;
        if (d5 > GlobalSettings.ZERO_TOL) {
            d4 = Math.sqrt(d5);
            d3 = (abstractDoubleSquareMatrix.getElement(2, 1) - abstractDoubleSquareMatrix.getElement(1, 2)) / (d4 * 4.0);
            d2 = (abstractDoubleSquareMatrix.getElement(0, 2) - abstractDoubleSquareMatrix.getElement(2, 0)) / (d4 * 4.0);
            d = (abstractDoubleSquareMatrix.getElement(1, 0) - abstractDoubleSquareMatrix.getElement(0, 1)) / (d4 * 4.0);
        } else {
            double d6 = -(abstractDoubleSquareMatrix.getElement(1, 1) + abstractDoubleSquareMatrix.getElement(2, 2)) / 2.0;
            d4 = 0.0;
            if (d6 > GlobalSettings.ZERO_TOL) {
                d3 = Math.sqrt(d6);
                d2 = abstractDoubleSquareMatrix.getElement(1, 0) / (2.0 * d3);
                d = abstractDoubleSquareMatrix.getElement(2, 0) / (2.0 * d3);
            } else {
                double d7 = (1.0 - abstractDoubleSquareMatrix.getElement(2, 2)) / 2.0;
                d3 = 0.0;
                if (d7 > GlobalSettings.ZERO_TOL) {
                    d2 = Math.sqrt(d7);
                    d = abstractDoubleSquareMatrix.getElement(2, 1) / (2.0 * d2);
                } else {
                    d2 = 0.0;
                    d = 1.0;
                }
            }
        }
        return new Quaternion(d4, d3, d2, d);
    }

    public AbstractDoubleSquareMatrix toRotationMatrix() {
        double[][] dArray = new double[3][3];
        dArray[0][0] = 1.0 - 2.0 * (this.imj * this.imj + this.imk * this.imk);
        dArray[0][1] = 2.0 * (this.imi * this.imj - this.re * this.imk);
        dArray[0][2] = 2.0 * (this.imi * this.imk + this.re * this.imj);
        dArray[1][0] = 2.0 * (this.imi * this.imj + this.re * this.imk);
        dArray[1][1] = 1.0 - 2.0 * (this.imi * this.imi + this.imk * this.imk);
        dArray[1][2] = 2.0 * (this.imj * this.imk - this.re * this.imi);
        dArray[2][0] = 2.0 * (this.imi * this.imk - this.re * this.imj);
        dArray[2][1] = 2.0 * (this.imj * this.imk + this.re * this.imi);
        dArray[2][2] = 1.0 - 2.0 * (this.imi * this.imi + this.imj * this.imj);
        return new DoubleSquareMatrix(dArray);
    }

    public boolean equals(Object object) {
        if (object instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)object;
            return Math.abs(this.re - quaternion.re) <= GlobalSettings.ZERO_TOL && Math.abs(this.imi - quaternion.imi) <= GlobalSettings.ZERO_TOL && Math.abs(this.imj - quaternion.imj) <= GlobalSettings.ZERO_TOL && Math.abs(this.imk - quaternion.imk) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.re);
        if (this.imi >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imi);
        stringBuffer.append("i");
        if (this.imj >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imj);
        stringBuffer.append("j");
        if (this.imk >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imk);
        stringBuffer.append("k");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public boolean isNaN() {
        return this.re == Double.NaN || this.imi == Double.NaN || this.imj == Double.NaN || this.imk == Double.NaN;
    }

    public boolean isInfinite() {
        return this.re == Double.POSITIVE_INFINITY || this.re == Double.NEGATIVE_INFINITY || this.imi == Double.POSITIVE_INFINITY || this.imi == Double.NEGATIVE_INFINITY || this.imj == Double.POSITIVE_INFINITY || this.imj == Double.NEGATIVE_INFINITY || this.imk == Double.POSITIVE_INFINITY || this.imk == Double.NEGATIVE_INFINITY;
    }

    public double real() {
        return this.re;
    }

    public Double3Vector imag() {
        return new Double3Vector(this.imi, this.imj, this.imk);
    }

    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public double sumSquares() {
        return this.re * this.re + this.imi * this.imi + this.imj * this.imj + this.imk * this.imk;
    }

    public AbelianGroup.Member negate() {
        return new Quaternion(-this.re, -this.imi, -this.imj, -this.imk);
    }

    public Field.Member inverse() {
        double d = this.sumSquares();
        return new Quaternion(this.re / d, -this.imi / d, -this.imj / d, -this.imk / d);
    }

    public CStarAlgebra.Member involution() {
        return this.conjugate();
    }

    public Quaternion conjugate() {
        return new Quaternion(this.re, -this.imi, -this.imj, -this.imk);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof Quaternion) {
            return this.add((Quaternion)member);
        }
        if (member instanceof MathDouble) {
            return this.addReal(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.addReal(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion add(Quaternion quaternion) {
        return new Quaternion(this.re + quaternion.re, this.imi + quaternion.imi, this.imj + quaternion.imj, this.imk + quaternion.imk);
    }

    public Quaternion addReal(double d) {
        return new Quaternion(this.re + d, this.imi, this.imj, this.imk);
    }

    public Quaternion addImag(Double3Vector double3Vector) {
        return new Quaternion(this.re, this.imi + double3Vector.x, this.imj + double3Vector.y, this.imk + double3Vector.z);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof Quaternion) {
            return this.subtract((Quaternion)member);
        }
        if (member instanceof MathDouble) {
            return this.subtractReal(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.subtractReal(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion subtract(Quaternion quaternion) {
        return new Quaternion(this.re - quaternion.re, this.imi - quaternion.imi, this.imj - quaternion.imj, this.imk - quaternion.imk);
    }

    public Quaternion subtractReal(double d) {
        return new Quaternion(this.re - d, this.imi, this.imj, this.imk);
    }

    public Quaternion subtractImag(Double3Vector double3Vector) {
        return new Quaternion(this.re, this.imi - double3Vector.x, this.imj - double3Vector.y, this.imk - double3Vector.z);
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.multiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.multiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof Quaternion) {
            return this.multiply((Quaternion)member);
        }
        if (member instanceof MathDouble) {
            return this.multiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.multiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion multiply(Quaternion quaternion) {
        return new Quaternion(this.re * quaternion.re - this.imi * quaternion.imi - this.imj * quaternion.imj - this.imk * quaternion.imk, this.re * quaternion.imi + quaternion.re * this.imi + (this.imj * quaternion.imk - quaternion.imj * this.imk), this.re * quaternion.imj + quaternion.re * this.imj + (this.imk * quaternion.imi - quaternion.imk * this.imi), this.re * quaternion.imk + quaternion.re * this.imk + (this.imi * quaternion.imj - quaternion.imi * this.imj));
    }

    public Quaternion multiply(double d) {
        return new Quaternion(d * this.re, d * this.imi, d * this.imj, d * this.imk);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.divide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Field.Member divide(Field.Member member) {
        if (member instanceof Quaternion) {
            return this.divide((Quaternion)member);
        }
        if (member instanceof MathDouble) {
            return this.divide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion divide(Quaternion quaternion) {
        double d = quaternion.sumSquares();
        return new Quaternion((this.re * quaternion.re + this.imi * quaternion.imi + this.imj * quaternion.imj + this.imk * quaternion.imk) / d, (quaternion.re * this.imi - this.re * quaternion.imi - (this.imj * quaternion.imk - quaternion.imj * this.imk)) / d, (quaternion.re * this.imj - this.re * quaternion.imj - (this.imk * quaternion.imi - quaternion.imk * this.imi)) / d, (quaternion.re * this.imk - this.re * quaternion.imk - (this.imi * quaternion.imj - quaternion.imi * this.imj)) / d);
    }

    public Quaternion divide(double d) {
        return new Quaternion(this.re / d, this.imi / d, this.imj / d, this.imk / d);
    }

    public Quaternion normalize() {
        return this.divide(this.norm());
    }

    public static Quaternion exp(Quaternion quaternion) {
        double d = Math.exp(quaternion.re);
        Double3Vector double3Vector = quaternion.imag();
        double d2 = double3Vector.norm();
        return new Quaternion(d * Math.cos(d2), (Double3Vector)double3Vector.normalize().scalarMultiply(d * Math.sin(d2)));
    }

    public static Quaternion log(Quaternion quaternion) {
        double d = quaternion.norm();
        return new Quaternion(Math.log(d), (Double3Vector)quaternion.imag().normalize().scalarMultiply(Math.acos(quaternion.re / d)));
    }

    public static Quaternion sin(Quaternion quaternion) {
        Double3Vector double3Vector = quaternion.imag();
        double d = double3Vector.norm();
        return new Quaternion(Math.sin(quaternion.re) * ExtraMath.cosh(d), (Double3Vector)double3Vector.normalize().scalarMultiply(Math.cos(quaternion.re) * ExtraMath.sinh(d)));
    }

    public static Quaternion cos(Quaternion quaternion) {
        Double3Vector double3Vector = quaternion.imag();
        double d = double3Vector.norm();
        return new Quaternion(Math.cos(quaternion.re) * ExtraMath.cosh(d), (Double3Vector)double3Vector.normalize().scalarMultiply(-Math.sin(quaternion.re) * ExtraMath.sinh(d)));
    }

    public static Quaternion tan(Quaternion quaternion) {
        return Quaternion.sin(quaternion).divide(Quaternion.cos(quaternion));
    }

    public static Quaternion sinh(Quaternion quaternion) {
        Double3Vector double3Vector = quaternion.imag();
        double d = double3Vector.norm();
        return new Quaternion(ExtraMath.sinh(quaternion.re) * Math.cos(d), (Double3Vector)double3Vector.normalize().scalarMultiply(ExtraMath.cosh(quaternion.re) * Math.sin(d)));
    }

    public static Quaternion cosh(Quaternion quaternion) {
        Double3Vector double3Vector = quaternion.imag();
        double d = double3Vector.norm();
        return new Quaternion(ExtraMath.cosh(quaternion.re) * Math.cos(d), (Double3Vector)double3Vector.normalize().scalarMultiply(ExtraMath.sinh(quaternion.re) * Math.sin(d)));
    }

    public static Quaternion tanh(Quaternion quaternion) {
        return Quaternion.sinh(quaternion).divide(Quaternion.cosh(quaternion));
    }
}

