/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public class RingMatrix
extends Matrix {
    protected Ring.Member[][] matrix;

    protected RingMatrix(int n, int n2) {
        super(n, n2);
    }

    public RingMatrix(Ring.Member[][] memberArray) {
        this(memberArray.length, memberArray[0].length);
        this.matrix = memberArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof RingMatrix && this.numRows == ((RingMatrix)object).rows() && this.numCols == ((RingMatrix)object).columns()) {
            RingMatrix ringMatrix = (RingMatrix)object;
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if (!this.matrix[n][n2].equals(ringMatrix.getElement(n, n2))) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.matrix[n][n2].toString());
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public Ring.Member getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Ring.Member member) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n][n2] = member;
    }

    public AbelianGroup.Member negate() {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            memberArray[n][0] = (Ring.Member)this.matrix[n][0].negate();
            int n2 = 1;
            while (n2 < this.numCols) {
                memberArray[n][n2] = (Ring.Member)this.matrix[n][n2].negate();
                ++n2;
            }
            ++n;
        }
        return new RingMatrix(memberArray);
    }

    public final AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof RingMatrix) {
            return this.add((RingMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix add(RingMatrix ringMatrix) {
        if (this.numRows == ringMatrix.numRows && this.numCols == ringMatrix.numCols) {
            Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                memberArray[n][0] = (Ring.Member)this.matrix[n][0].add(ringMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < this.numCols) {
                    memberArray[n][n2] = (Ring.Member)this.matrix[n][n2].add(ringMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new RingMatrix(memberArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof RingMatrix) {
            return this.subtract((RingMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix subtract(RingMatrix ringMatrix) {
        if (this.numRows == ringMatrix.numRows && this.numCols == ringMatrix.numCols) {
            Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                memberArray[n][0] = (Ring.Member)this.matrix[n][0].subtract(ringMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < this.numCols) {
                    memberArray[n][n2] = (Ring.Member)this.matrix[n][n2].subtract(ringMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new RingMatrix(memberArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            memberArray[n][0] = member.multiply(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < this.numCols) {
                memberArray[n][n2] = member.multiply(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new RingMatrix(memberArray);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            memberArray[n][0] = ((Field.Member)this.matrix[n][0]).divide(member);
            int n2 = 1;
            while (n2 < this.numCols) {
                memberArray[n][n2] = ((Field.Member)this.matrix[n][n2]).divide(member);
                ++n2;
            }
            ++n;
        }
        return new RingMatrix(memberArray);
    }

    public final Ring.Member multiply(Ring.Member member) {
        if (member instanceof RingMatrix) {
            return this.multiply((RingMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix multiply(RingMatrix ringMatrix) {
        if (this.numCols == ringMatrix.numRows) {
            Ring.Member[][] memberArray = new Ring.Member[this.numRows][ringMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < ringMatrix.numCols) {
                    AbelianGroup.Member member = this.matrix[n][0].multiply(ringMatrix.getElement(0, n2));
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        member = member.add(this.matrix[n][n3].multiply(ringMatrix.getElement(n3, n2)));
                        ++n3;
                    }
                    memberArray[n][n2] = member;
                    ++n2;
                }
                ++n;
            }
            return new RingMatrix(memberArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public RingMatrix directSum(RingMatrix ringMatrix) {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows + ringMatrix.numRows][this.numCols + ringMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                memberArray[n][n2] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < ringMatrix.numRows) {
            int n4 = 0;
            while (n4 < ringMatrix.numCols) {
                memberArray[n3 + this.numRows][n4 + this.numCols] = ringMatrix.getElement(n3, n4);
                ++n4;
            }
            ++n3;
        }
        return new RingMatrix(memberArray);
    }

    public RingMatrix tensor(RingMatrix ringMatrix) {
        Ring.Member[][] memberArray = new Ring.Member[this.numRows * ringMatrix.numRows][this.numCols * ringMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < ringMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < ringMatrix.numCols) {
                        memberArray[n * ringMatrix.numRows + n3][n2 * ringMatrix.numCols + n4] = this.matrix[n][n2].multiply(ringMatrix.getElement(n3, n4));
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new RingMatrix(memberArray);
    }

    public Matrix transpose() {
        Ring.Member[][] memberArray = new Ring.Member[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            memberArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                memberArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new RingMatrix(memberArray);
    }
}

