/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.MappingND;

public final class HenonMap
implements MappingND {
    private final double a;
    private final double b;
    public static final double A_CHAOS = 1.4;
    public static final double B_CHAOS = 0.3;

    public HenonMap(double d, double d2) {
        this.a = d;
        this.b = d2;
    }

    public double[] map(double[] dArray) {
        double[] dArray2 = new double[]{1.0 - this.a * dArray[0] * dArray[0] + dArray[1], this.b * dArray[0]};
        return dArray2;
    }

    public double hausdorffDimension() {
        return 1.26;
    }

    public double[] iterate(int n, double[] dArray) {
        double[] dArray2 = this.map(dArray);
        int n2 = 1;
        while (n2 < n) {
            dArray2 = this.map(dArray2);
            ++n2;
        }
        return dArray2;
    }
}

