/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.Mapping;

public final class LogisticMap
implements Mapping {
    private final double r;
    public static final double R_2CYCLE = 3.0;
    public static final double R_4CYCLE = 1.0 + Math.sqrt(6.0);
    public static final double R_8CYCLE = 3.54409;
    public static final double R_16CYCLE = 3.564407;
    public static final double R_ACCUMULATION = 3.569945672;

    public LogisticMap(double d) {
        this.r = d;
    }

    public double map(double d) {
        return this.r * d * (1.0 - d);
    }

    public double hausdorffDimension() {
        return 0.538;
    }

    public double iterate(int n, double d) {
        int n2 = 0;
        while (n2 < n) {
            d = this.map(d);
            ++n2;
        }
        return d;
    }
}

