/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.groups;

import JSci.maths.groups.FiniteGroup;
import JSci.maths.groups.Group;
import JSci.maths.groups.Monoid;
import JSci.maths.groups.Semigroup;

public final class DihedralGroup
extends FiniteGroup {
    private final int n;
    private final Member ONE;

    public DihedralGroup(int n) {
        super(2 * n);
        this.n = n;
        this.ONE = new Member(0, false);
    }

    public boolean equals(Object object) {
        return object instanceof DihedralGroup && ((DihedralGroup)object).order == this.order;
    }

    public String toString() {
        return "D_" + this.n;
    }

    public Group.Member[] getElements() {
        Group.Member[] memberArray = new Group.Member[this.order];
        int n = 0;
        while (n < this.n) {
            memberArray[n] = new Member(n, false);
            memberArray[n + this.n] = new Member(n, true);
            ++n;
        }
        return memberArray;
    }

    public Monoid.Member identity() {
        return this.ONE;
    }

    public boolean isIdentity(Monoid.Member member) {
        return member.equals(this.ONE);
    }

    public boolean isInverse(Group.Member member, Group.Member member2) {
        return member instanceof Member && member2 instanceof Member && member.compose(member2).equals(this.ONE);
    }

    class Member
    implements Group.Member {
        private final int rotate;
        private final boolean reflect;

        public Member(int n, boolean bl) {
            this.rotate = n < 0 ? n % DihedralGroup.this.n + DihedralGroup.this.n : n % DihedralGroup.this.n;
            this.reflect = bl;
        }

        public boolean equals(Object object) {
            return object instanceof Member && this.rotate == ((Member)object).rotate && this.reflect == ((Member)object).reflect;
        }

        public Semigroup.Member compose(Semigroup.Member member) {
            if (this.reflect) {
                return new Member(this.rotate - ((Member)member).rotate, !((Member)member).reflect);
            }
            return new Member(this.rotate + ((Member)member).rotate, ((Member)member).reflect);
        }

        public Group.Member inverse() {
            return new Member(-this.rotate, !this.reflect);
        }
    }
}

