/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.MathDouble;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.polynomials.ComplexPolynomialRing;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialMath;

public class ComplexPolynomial
implements Polynomial {
    private Complex[] _c;

    public ComplexPolynomial(Complex[] complexArray) {
        if (complexArray == null) {
            throw new NullPointerException();
        }
        this._c = complexArray.length == 0 ? new Complex[]{Complex.ZERO} : complexArray;
    }

    public ComplexPolynomial(Field.Member[] memberArray) {
        this._c = ComplexPolynomialRing.toComplex(memberArray);
    }

    public Field.Member getCoefficient(int n) {
        return this.getCoefficientAsComplex(n);
    }

    public Complex getCoefficientAsComplex(int n) {
        if (n >= this._c.length) {
            return Complex.ZERO;
        }
        return this._c[n];
    }

    public Field.Member[] getCoefficients() {
        return this.getCoefficientsAsComplexes();
    }

    public Complex[] getCoefficientsAsComplexes() {
        return this._c;
    }

    public Complex map(Complex complex) {
        return PolynomialMath.evalPolynomial(this._c, complex);
    }

    public Complex map(double d, double d2) {
        return this.map(new Complex(d, d2));
    }

    public int degree() {
        return this._c.length;
    }

    public boolean isNull() {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.degree()) {
            if (this.getCoefficientAsComplex(n).norm() > GlobalSettings.ZERO_TOL * 2.0) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public boolean isOne() {
        boolean bl = this.getCoefficientAsComplex(0).subtract(Complex.ONE).norm() <= GlobalSettings.ZERO_TOL * 2.0;
        int n = 1;
        while (bl && n < this.degree()) {
            if (this.getCoefficientAsComplex(n).norm() > 2.0 * GlobalSettings.ZERO_TOL) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        Complex[] complexArray;
        ComplexPolynomial complexPolynomial = null;
        if (member instanceof ComplexPolynomial) {
            ComplexPolynomial complexPolynomial2 = (ComplexPolynomial)member;
            int n = PolynomialMath.maxDegree(this, complexPolynomial2);
            complexArray = new Complex[n];
            int n2 = 0;
            while (n2 < n) {
                complexArray[n2] = this.getCoefficientAsComplex(n2).add(complexPolynomial2.getCoefficientAsComplex(n2));
                ++n2;
            }
        } else {
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }
        complexPolynomial = new ComplexPolynomial(complexArray);
        return complexPolynomial;
    }

    public Polynomial divide(Field.Member member) {
        if (member instanceof Complex) {
            return this.divide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.divide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexPolynomial divide(Complex complex) {
        Complex[] complexArray = new Complex[this._c.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n] = this._c[n].divide(complex);
            ++n;
        }
        return new ComplexPolynomial(complexArray);
    }

    public ComplexPolynomial divide(double d) {
        Complex[] complexArray = new Complex[this._c.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n] = this._c[n].divide(d);
            ++n;
        }
        return new ComplexPolynomial(complexArray);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == this) {
            bl = true;
        } else if (object instanceof ComplexPolynomial) {
            ComplexPolynomial complexPolynomial = (ComplexPolynomial)object;
            bl = true;
            int n = 0;
            while (bl && n < this.degree()) {
                if (complexPolynomial.getCoefficientAsComplex(n).subtract(this.getCoefficientAsComplex(n)).norm() > 2.0 * GlobalSettings.ZERO_TOL) {
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.degree()) {
            n += (int)(this.getCoefficientAsComplex(n2).norm() * 10.0);
            ++n2;
        }
        return n;
    }

    public Polynomial multiply(Field.Member member) {
        if (member instanceof MathDouble) {
            double d = ((MathDouble)member).value();
            return this.multiply(d);
        }
        if (member instanceof Complex) {
            return this.multiply((Complex)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexPolynomial multiply(double d) {
        Complex[] complexArray = new Complex[this._c.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n] = this._c[n].multiply(d);
            ++n;
        }
        return new ComplexPolynomial(complexArray);
    }

    public ComplexPolynomial multiply(Complex complex) {
        Complex[] complexArray = new Complex[this._c.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n] = this._c[n].multiply(complex);
            ++n;
        }
        return new ComplexPolynomial(complexArray);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof ComplexPolynomial) {
            ComplexPolynomial complexPolynomial = (ComplexPolynomial)member;
            int n = PolynomialMath.maxDegree(this, complexPolynomial);
            int n2 = PolynomialMath.minDegree(this, complexPolynomial);
            int n3 = n + n2 - 1;
            Complex[] complexArray = new Complex[n3];
            int n4 = 0;
            while (n4 < n3) {
                complexArray[n4] = Complex.ZERO;
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.degree()) {
                Complex complex = this.getCoefficientAsComplex(n5);
                int n6 = 0;
                while (n6 < complexPolynomial.degree()) {
                    Complex complex2 = complexPolynomial.getCoefficientAsComplex(n6);
                    complexArray[n5 + n6] = complexArray[n5 + n6].add(complex.multiply(complex2));
                    ++n6;
                }
                ++n5;
            }
            return new ComplexPolynomial(complexArray);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbelianGroup.Member negate() {
        Complex[] complexArray = new Complex[this._c.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n] = (Complex)this._c[n].negate();
            ++n;
        }
        return new ComplexPolynomial(complexArray);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        Complex[] complexArray;
        ComplexPolynomial complexPolynomial = null;
        if (member instanceof ComplexPolynomial) {
            ComplexPolynomial complexPolynomial2 = (ComplexPolynomial)member;
            int n = PolynomialMath.maxDegree(this, complexPolynomial2);
            complexArray = new Complex[n];
            int n2 = 0;
            while (n2 < n) {
                complexArray[n2] = this.getCoefficientAsComplex(n2).subtract(complexPolynomial2.getCoefficientAsComplex(n2));
                ++n2;
            }
        } else {
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }
        complexPolynomial = new ComplexPolynomial(complexArray);
        return complexPolynomial;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("P(z) = ");
        int n = this.degree();
        while (n > 1) {
            stringBuffer.append(this._c[n - 1]).append("z^").append(n - 1).append(" + ");
            --n;
        }
        stringBuffer.append(this._c[0]);
        return stringBuffer.toString();
    }
}

