/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.AlchemistBanner;
import chemaxon.alchemist.AlchemistController;
import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.AlchemistProgressLabel;
import chemaxon.alchemist.MarvinBasedAlchemistApplication;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class Alchemist
extends MarvinBasedAlchemistApplication {
    public static final String WINDOW_CLOSING_ACTION = "WINDOW_CLOSING";
    private static final int SIDEBAR_NORMAL_WIDTH = 150;
    private static final int SIDEBAR_COLLAPSED_WIDTH = 30;
    private static final String HELP_LABEL_TEXT = "Online Help";
    private static final String LICENSE_LABEL_TEXT = "License Manager";
    private static final String HIDE_SIDEBAR_LABEL_TEXT = "Hide Sidebar";
    private AlchemistController controller;
    private JPanel jContentPane = null;
    private JPanel pnlHolder = null;
    private JButton buttBack = null;
    private JButton buttCancel = null;
    private JButton buttNext = null;
    private JButton buttFinish = null;
    private JPanel pnlNavigation = null;
    private JPanel pnlMain = null;
    private JRootPane innerRootPane = null;
    public static final String BUTTON_BACK_DEFAULT = "< Back";
    public static final String BUTTON_NEXT_DEFAULT = "Next >";
    public static final String BUTTON_FINISH_DEFAULT = "Finish";
    public static final String BUTTON_CANCEL_DEFAULT = "Cancel";
    public static final String BUTTON_CANCEL_LASTPAGE = "Close";
    private JPanel sidebar = null;
    private AlchemistLabel helpLabel = null;
    private AlchemistLabel licenseLabel = null;
    private AlchemistLabel toggleSidebarLabel = null;
    protected boolean navCollapsed;
    private Color sidebarBgr1 = AlchemistGraphicsUtilities.ALCHEMIST_SIDEBAR_BGR_GRADIENT1;
    private Color sidebarBgr2 = AlchemistGraphicsUtilities.ALCHEMIST_SIDEBAR_BGR_GRADIENT2;
    private boolean lastPageMode = false;

    public Alchemist(String title, AlchemistController controller) {
        this(title, null, controller);
    }

    public Alchemist(String title, Image image, AlchemistController controller) {
        super(title);
        if (image != null) {
            this.getApplicationFrame().setIconImage(image);
        }
        this.setController(controller);
        this.initialize();
    }

    private void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getJContentPane(), "Center");
    }

    public JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setMinimumSize(new Dimension(640, 480));
            this.jContentPane.setPreferredSize(new Dimension(640, 480));
            this.jContentPane.add((Component)this.getPnlHolder(), "Center");
            this.jContentPane.add((Component)this.getPnlNavigation(), "South");
            this.jContentPane.add((Component)this.getSidebar(), "West");
        }
        return this.jContentPane;
    }

    public void setSidebarBackground(Color top, Color bottom) {
        this.setSidebarBgr1(top);
        this.setSidebarBgr2(bottom);
        this.getSidebar().repaint();
    }

    public Color getSidebarTopBackground() {
        return this.getSidebarBgr1();
    }

    public Color getSidebarBottomBackground() {
        return this.getSidebarBgr2();
    }

    private JPanel getPnlHolder() {
        if (this.pnlHolder == null) {
            this.pnlHolder = new JPanel();
            this.pnlHolder.setLayout(new BorderLayout());
            this.pnlHolder.setOpaque(false);
            this.pnlHolder.add((Component)this.getInnerRootPane(), "Center");
        }
        return this.pnlHolder;
    }

    private JRootPane getInnerRootPane() {
        if (this.innerRootPane == null) {
            this.innerRootPane = new JRootPane();
            this.innerRootPane.setLayout(new BorderLayout());
            this.innerRootPane.setOpaque(false);
            this.innerRootPane.add((Component)this.getPnlMain(), "Center");
        }
        return this.innerRootPane;
    }

    private JButton getButtBack() {
        if (this.buttBack == null) {
            this.buttBack = new JButton(this.getController().BACK_ACTION);
            this.buttBack.setText(BUTTON_BACK_DEFAULT);
        }
        return this.buttBack;
    }

    private JButton getButtCancel() {
        if (this.buttCancel == null) {
            this.buttCancel = new JButton(this.getController().CANCEL_ACTION);
            this.buttCancel.setText(BUTTON_CANCEL_DEFAULT);
        }
        return this.buttCancel;
    }

    private JButton getButtNext() {
        if (this.buttNext == null) {
            this.buttNext = new JButton(this.getController().NEXT_ACTION);
            this.buttNext.setText(BUTTON_NEXT_DEFAULT);
        }
        return this.buttNext;
    }

    private JButton getButtFinish() {
        if (this.buttFinish == null) {
            this.buttFinish = new JButton(this.getController().FINISH_ACTION);
            this.buttFinish.setText(BUTTON_FINISH_DEFAULT);
        }
        return this.buttFinish;
    }

    private JPanel getPnlNavigation() {
        if (this.pnlNavigation == null) {
            this.pnlNavigation = new JPanel();
            this.pnlNavigation.setLayout(new BoxLayout(this.getPnlNavigation(), 2));
            this.pnlNavigation.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(0, 0, 0, 10)));
            this.pnlNavigation.setMaximumSize(new Dimension(33191, 40));
            this.pnlNavigation.setPreferredSize(new Dimension(304, 40));
            this.pnlNavigation.setMinimumSize(new Dimension(304, 40));
            this.pnlNavigation.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.pnlNavigation.setAlignmentY(0.47826087f);
            this.pnlNavigation.add((Component)this.getButtCancel(), null);
            this.pnlNavigation.add((Component)this.getButtFinish(), null);
            this.pnlNavigation.add((Component)this.getButtNext(), null);
            this.pnlNavigation.add((Component)this.getButtBack(), null);
        }
        return this.pnlNavigation;
    }

    private JPanel getPnlMain() {
        if (this.pnlMain == null) {
            this.pnlMain = new JPanel();
            this.pnlMain.setOpaque(false);
        }
        return this.pnlMain;
    }

    @Override
    public void setBanner(AlchemistBanner banner) {
        this.pnlHolder.add((Component)banner, "North");
        this.pnlHolder.validate();
        this.pnlHolder.updateUI();
    }

    public void setPage(AlchemistPage page) {
        this.innerRootPane.remove(this.pnlMain);
        this.pnlMain = page;
        this.innerRootPane.add((Component)this.pnlMain, "Center");
        this.pnlHolder.validate();
        this.pnlHolder.updateUI();
    }

    protected AlchemistLabel getLicenseLabel() {
        if (this.licenseLabel == null) {
            this.licenseLabel = new AlchemistLabel(LICENSE_LABEL_TEXT, 5, 0, "/chemaxon/icons/license/licensekey16.png");
            this.licenseLabel.setMaximumSize(new Dimension(150, 0));
            this.licenseLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.licenseLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Alchemist.this.licenseManagerActionHandler();
                }
            });
        }
        return this.licenseLabel;
    }

    public boolean isLicenseHandlerLabelVisible() {
        return this.getLicenseLabel().isVisible();
    }

    public void setLicenseHandlerLabelVisible(boolean value) {
        this.getLicenseLabel().setVisible(value);
    }

    protected AlchemistLabel getHelpLabel() {
        if (this.helpLabel == null) {
            this.helpLabel = new AlchemistLabel(HELP_LABEL_TEXT, 5, 0, "/chemaxon/icons/marvin/help16.png");
            this.helpLabel.setMaximumSize(new Dimension(150, 0));
            this.helpLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.helpLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Alchemist.this.getController().popupHelpInBrowser();
                }
            });
            if (this.getController().getHelpURL() == null) {
                this.helpLabel.setVisible(false);
            }
        }
        return this.helpLabel;
    }

    protected AlchemistLabel getToggleSidebarLabel() {
        if (this.toggleSidebarLabel == null) {
            this.toggleSidebarLabel = new AlchemistLabel(HIDE_SIDEBAR_LABEL_TEXT, 5, 0, "/chemaxon/alchemist/images/collapse.gif");
            this.toggleSidebarLabel.setMaximumSize(new Dimension(150, 0));
            this.toggleSidebarLabel.setToolTipText("Shows or Hides the Sidebar");
            this.toggleSidebarLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Alchemist.this.navCollapsed) {
                        Alchemist.this.getToggleSidebarLabel().setText(Alchemist.HIDE_SIDEBAR_LABEL_TEXT);
                        Alchemist.this.getLicenseLabel().setText(Alchemist.LICENSE_LABEL_TEXT);
                        if (Alchemist.this.getController().getHelpURL() != null) {
                            Alchemist.this.getHelpLabel().setText(Alchemist.HELP_LABEL_TEXT);
                        }
                        Alchemist.this.getToggleSidebarLabel().setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/collapse.gif")));
                    } else {
                        Alchemist.this.getToggleSidebarLabel().setText("");
                        Alchemist.this.getLicenseLabel().setText("");
                        if (Alchemist.this.getController().getHelpURL() != null) {
                            Alchemist.this.getHelpLabel().setText("");
                        }
                        Alchemist.this.getToggleSidebarLabel().setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/alchemist/images/expand.gif")));
                    }
                    Alchemist.this.getSidebar().setPreferredSize(new Dimension(Alchemist.this.navCollapsed ? 150 : 30, 0));
                    Alchemist.this.navCollapsed = !Alchemist.this.navCollapsed;
                    for (int i = 0; i < Alchemist.this.getSidebar().getComponentCount(); ++i) {
                        Component c = Alchemist.this.getSidebar().getComponent(i);
                        if (!(c instanceof AlchemistProgressLabel)) continue;
                        ((AlchemistProgressLabel)c).setCollapsed(Alchemist.this.navCollapsed);
                    }
                    Alchemist.this.getSidebar().updateUI();
                }
            });
        }
        return this.toggleSidebarLabel;
    }

    public void setProgressObjects(List<AlchemistProgressLabel> progessLabelList) {
        Component[] components = this.getSidebar().getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.getSidebar().remove(components[i]);
        }
        for (AlchemistProgressLabel component : progessLabelList) {
            this.getSidebar().add(component);
        }
        this.getSidebar().add(Box.createVerticalGlue());
        this.getSidebar().add(this.getHelpLabel());
        this.getSidebar().add(Box.createVerticalStrut(2));
        this.getSidebar().add(this.getLicenseLabel());
        this.getSidebar().add(Box.createVerticalStrut(2));
        this.getSidebar().add(this.getToggleSidebarLabel());
    }

    @Override
    protected void exitProgramActionHandler() {
        if (this.frameClosing()) {
            try {
                String pPath = this.getPropertyFilePath();
                if (pPath != null) {
                    this.appState.saveProperties(pPath);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.getController().cancelPressed();
            this.getApplicationFrame().dispose();
            System.exit(0);
        }
    }

    protected JPanel getSidebar() {
        if (this.sidebar == null) {
            this.sidebar = new JPanel(){
                private static final long serialVersionUID = 2236760946372011017L;

                @Override
                protected void paintComponent(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    GradientPaint paint = new GradientPaint(0.0f, 0.0f, Alchemist.this.getSidebarBgr1(), 0.0f, Alchemist.this.getSidebar().getHeight(), Alchemist.this.getSidebarBgr2());
                    g2.setPaint(paint);
                    g2.fill(Alchemist.this.getSidebar().getBounds());
                    g2.dispose();
                }
            };
            this.sidebar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.sidebar.setLayout(new BoxLayout(this.sidebar, 1));
            this.sidebar.setPreferredSize(new Dimension(150, 0));
        }
        return this.sidebar;
    }

    public void setLastPageMode(boolean lastpageMode) {
        this.lastPageMode = lastpageMode;
        this.getButtCancel().setText(lastpageMode ? BUTTON_CANCEL_LASTPAGE : BUTTON_CANCEL_DEFAULT);
    }

    public boolean isLastPageMode() {
        return this.lastPageMode;
    }

    @Override
    protected Dimension getDefaultWindowSize() {
        return new Dimension(800, 600);
    }

    @Override
    protected void licenseManagerClosed() {
        super.licenseManagerClosed();
        this.getController().licenseManagerInvoked();
    }

    protected void setController(AlchemistController controller) {
        this.controller = controller;
    }

    protected AlchemistController getController() {
        return this.controller;
    }

    protected void setSidebarBgr1(Color sidebarBgr1) {
        this.sidebarBgr1 = sidebarBgr1;
    }

    protected Color getSidebarBgr1() {
        return this.sidebarBgr1;
    }

    protected void setSidebarBgr2(Color sidebarBgr2) {
        this.sidebarBgr2 = sidebarBgr2;
    }

    protected Color getSidebarBgr2() {
        return this.sidebarBgr2;
    }
}

