/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import cb.aloe.swing.tools.DockPane;
import chemaxon.alchemist.AlchemistBanner;
import chemaxon.alchemist.utils.AlchemistBrowserLauncher;
import chemaxon.alchemist.utils.AlchemistErrorDialog;
import chemaxon.alchemist.utils.AlchemistFileChooser;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistInnerDialog;
import chemaxon.alchemist.utils.AlchemistProgressMonitor;
import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.AlchemistWaitPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.filechooser.FileFilter;

public class AlchemistApplication {
    protected static final String PROP_KEY_PREFIX = "AlchemistApplication_";
    protected static final String PROP_KEY_VISIBLE_SUFFIX = "Visible";
    public static final String PROPERTY_KEY_APP_INSTANCE = "AlchemistApplication_AppInstance";
    public static final String PROPERTY_KEY_CURRENT_DOCUMENT_PATH = "DocumentPath";
    private static final String ENABLED_PANEL = "enabledPanel";
    private static final String DISABLED_PANEL = "disabledPanel";
    public static final String PROPERTY_KEY_ENABLE = "Alchemist_Enable";
    public static final String PROPERTY_KEY_CONTENT_ENABLED = "AlchemistApplication_ContentDisabled";
    public static final String PROPERTY_VALUE_CONTENT_ENABLED = "enabled";
    public static final String PROPERTY_VALUE_CONTENT_DISABLED = "disabled";
    public static final String PROPERTY_VALUE_CONTENT_DISABLED_WITH_ANIMATION = "disabledAnim";
    private static final String MESSAGE_FILE_ALREADY_EXISTS_CONFIRMATION = "Selected file already exists.\nDo you want to overwrite?";
    private static final String MESSAGE_SAVE_FILE_AS = "Save file as...";
    private static final String PROPERTY_KEY_WINDOW_SIZE = "AlchemistApplication_WindowSize";
    private static final String OPEN_FILE_DIR_SUFFIX = "_OpenFileDir";
    private static final String OPEN_FILE_FILTER_SUFFIX = "_LastOpenFileFilter";
    private static final String SAVE_FILE_DIR_SUFFIX = "_SaveFileDir";
    private static final String SAVE_FILE_FILTER_SUFFIX = "_LastSaveFileFilter";
    public static final int MINIMUM_WINDOW_WIDTH = 800;
    public static final int MINIMUM_WINDOW_HEIGHT = 600;
    protected static final String NO_DOCUMENT = "Untitled";
    protected static final String DOCUMENT_CHANGED = "*";
    private JFrame appFrame = null;
    private JPanel enabledLayerPanel = null;
    private DockPane dockPane = null;
    private JRootPane suspendableContentPane = null;
    private Image disabledImage = null;
    protected AlchemistState appState = null;
    protected AlchemistFileChooser fileChooser = null;
    private FileFilter lastSaveFileFilter = null;
    private JProgressBar progressBar = null;
    private JLabel progressLabel = null;
    private JPanel progressPanel = null;
    private int preferredWidth;
    private int preferredHeight;
    private AlchemistBanner banner = null;
    private boolean isDisabled = false;
    private boolean dirtyBit = false;
    private boolean showDocumentPathInHeader = false;
    private String currentDocumentPath = null;
    private String currentDocumentFormat = null;
    private String appTitle = null;
    protected SwingPropertyChangeSupport notifier = null;
    private AlchemistWaitPanel waitPanel;
    private AlchemistProgressMonitor progressBarMonitor = null;
    private static final int PROGRESSBAR_REFRESH_TIMER_INTERVAL = 200;
    private Timer progressBarTimer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlchemistApplication.this.getProgressBarMonitor() != null) {
                AlchemistApplication.this.getProgressBar().setValue(AlchemistApplication.this.getProgressBarMonitor().getProgressPercent());
                String msg = AlchemistApplication.this.getProgressLabel().getText();
                if (msg == null || !msg.equals(AlchemistApplication.this.getProgressBarMonitor().getMessage())) {
                    AlchemistApplication.this.getProgressLabel().setText(AlchemistApplication.this.getProgressBarMonitor().getMessage());
                }
            } else {
                AlchemistApplication.this.getProgressBarTimer().stop();
            }
        }
    });
    private JButton cancelButton = null;
    private JPanel disabledLayerPanel = null;
    protected Container contentPane = null;
    protected JMenuBar mainMenuBar = null;
    public ComponentAdapter waitPanelAdapter = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent e) {
            Container parent = e.getComponent().getParent();
            if (!parent.isVisible()) {
                parent.setVisible(true);
            }
            parent.validate();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Container parent = e.getComponent().getParent();
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                if (!parent.getComponent(i).isVisible()) continue;
                return;
            }
            parent.setVisible(false);
        }
    };

    public AlchemistApplication() {
        this("Application");
    }

    public AlchemistApplication(String appTitle) {
        this(appTitle, null);
    }

    public AlchemistApplication(String appTitle, Image image) {
        this(appTitle, image, null);
    }

    protected AlchemistApplication(String appTitle, Image image, Container contentPane) {
        this.contentPane = contentPane;
        this.appTitle = appTitle;
        this.initialize();
        this.getApplicationFrame().setTitle(appTitle);
        if (image != null) {
            this.getApplicationFrame().setIconImage(image);
        }
    }

    private void initialize() {
        this.appState = new AlchemistState();
        this.notifier = new SwingPropertyChangeSupport(this.getApplicationFrame());
        try {
            this.fileChooser = new AlchemistFileChooser();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String path = this.getPropertyFilePath();
            if (path != null) {
                this.appState.loadProperties(path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hideProgressBar();
        this.setFrameInitialSize();
    }

    public JFrame getApplicationFrame() {
        if (this.getAppFrame() == null) {
            this.setAppFrame(new JFrame());
            this.getAppFrame().setDefaultCloseOperation(0);
            this.getAppFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    AlchemistApplication.this.exitProgramActionHandler();
                }
            });
            this.getAppFrame().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (AlchemistApplication.this.getAppFrame().isDisplayable()) {
                        int width = AlchemistApplication.this.getAppFrame().getWidth();
                        int height = AlchemistApplication.this.getAppFrame().getHeight();
                        if (width < AlchemistApplication.this.getMinimumWindowWidth()) {
                            width = AlchemistApplication.this.getMinimumWindowWidth();
                        }
                        if (height < AlchemistApplication.this.getMinimumWindowHeight()) {
                            height = AlchemistApplication.this.getMinimumWindowHeight();
                        }
                        AlchemistApplication.this.appState.setPersistentProperty(AlchemistApplication.PROPERTY_KEY_WINDOW_SIZE, new Dimension(width, height));
                        if (width != AlchemistApplication.this.getAppFrame().getWidth() || height != AlchemistApplication.this.getAppFrame().getHeight()) {
                            AlchemistApplication.this.getAppFrame().setSize(width, height);
                        }
                        AlchemistApplication.this.createDisabledImage();
                    }
                }
            });
            this.getAppFrame().getContentPane().setLayout(new BorderLayout());
            if (this.banner != null) {
                this.getAppFrame().getContentPane().add((Component)this.banner, "North");
            }
            this.getAppFrame().getContentPane().add((Component)this.getSuspendableContentPanel(), "Center");
            this.getAppFrame().getContentPane().add((Component)this.getProgressPanel(), "South");
        }
        return this.getAppFrame();
    }

    protected JPanel getEnabledLayerPanel() {
        if (this.enabledLayerPanel == null) {
            this.enabledLayerPanel = new JPanel(new BorderLayout());
            this.enabledLayerPanel.add((Component)this.getDockPane(), "Center");
        }
        return this.enabledLayerPanel;
    }

    protected DockPane getDockPane() {
        if (this.dockPane == null) {
            this.dockPane = new DockPane(0, 0, 0, 0);
            this.dockPane.setContent((Component)this.getContentPane());
        }
        return this.dockPane;
    }

    protected JRootPane getSuspendableContentPanel() {
        if (this.suspendableContentPane == null) {
            this.suspendableContentPane = new JRootPane();
            this.suspendableContentPane.setGlassPane(this.getWaitPanel());
            CardLayout layout = new CardLayout();
            this.suspendableContentPane.getContentPane().setLayout(layout);
            this.suspendableContentPane.getContentPane().add((Component)this.getEnabledLayerPanel(), ENABLED_PANEL);
            this.suspendableContentPane.getContentPane().add((Component)this.getDisabledLayerPanel(), DISABLED_PANEL);
            layout.show(this.suspendableContentPane.getContentPane(), ENABLED_PANEL);
        }
        return this.suspendableContentPane;
    }

    public Container getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
        }
        return this.contentPane;
    }

    private JPanel getDisabledLayerPanel() {
        if (this.disabledLayerPanel == null) {
            this.disabledLayerPanel = new JPanel(null){
                private static final long serialVersionUID = 7996769624222942494L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (AlchemistApplication.this.getDisabledImage() != null) {
                        Graphics g2 = g.create();
                        g2.drawImage(AlchemistApplication.this.getDisabledImage(), 0, 0, null);
                        g2.dispose();
                    }
                }
            };
        }
        return this.disabledLayerPanel;
    }

    private AlchemistWaitPanel getWaitPanel() {
        if (this.waitPanel == null) {
            this.waitPanel = new AlchemistWaitPanel(false, false);
            this.waitPanel.setLayout(null);
            this.waitPanel.setOpaque(false);
            this.waitPanel.addContainerListener(new ContainerListener(){

                @Override
                public void componentRemoved(ContainerEvent e) {
                    e.getChild().removeComponentListener(AlchemistApplication.this.waitPanelAdapter);
                    for (int i = 0; i < AlchemistApplication.this.getWaitPanel().getComponentCount(); ++i) {
                        if (!AlchemistApplication.this.getWaitPanel().getComponent(i).isVisible()) continue;
                        return;
                    }
                    AlchemistApplication.this.getWaitPanel().setVisible(false);
                }

                @Override
                public void componentAdded(ContainerEvent e) {
                    if (e.getChild().isVisible()) {
                        AlchemistApplication.this.getWaitPanel().setVisible(true);
                    }
                    e.getChild().addComponentListener(AlchemistApplication.this.waitPanelAdapter);
                }
            });
        }
        return this.waitPanel;
    }

    private void setFrameInitialSize() {
        Toolkit toolkit = this.getApplicationFrame().getToolkit();
        Insets insets = toolkit.getScreenInsets(this.getApplicationFrame().getGraphicsConfiguration());
        int availableWidth = toolkit.getScreenSize().width - (insets.left + insets.right);
        int availableHeight = toolkit.getScreenSize().height - (insets.top + insets.bottom);
        Dimension windowSize = (Dimension)this.appState.getProperty(PROPERTY_KEY_WINDOW_SIZE);
        if (windowSize != null) {
            this.preferredWidth = windowSize.width;
            this.preferredHeight = windowSize.height;
        }
        if (this.preferredWidth == 0 || this.preferredHeight == 0 || this.preferredHeight > availableHeight || this.preferredWidth > availableWidth) {
            Dimension defaultSize = this.getDefaultWindowSize();
            this.preferredWidth = defaultSize == null ? (int)Math.ceil((double)availableWidth * 0.8) : defaultSize.width;
            int n = this.preferredHeight = defaultSize == null ? (int)Math.ceil((double)availableHeight * 0.8) : defaultSize.height;
        }
        if (this.preferredWidth < this.getMinimumWindowWidth()) {
            this.preferredWidth = this.getMinimumWindowWidth();
        }
        if (this.preferredHeight < this.getMinimumWindowHeight()) {
            this.preferredHeight = this.getMinimumWindowHeight();
        }
        if (this.preferredWidth > availableWidth) {
            this.preferredWidth = availableWidth;
        }
        if (this.preferredHeight > availableHeight) {
            this.preferredHeight = availableHeight;
        }
        this.getApplicationFrame().setSize(this.preferredWidth, this.preferredHeight);
        this.getApplicationFrame().setLocationRelativeTo(null);
    }

    protected boolean frameClosing() {
        return JOptionPane.showConfirmDialog(null, "Do you want to exit?", "Exit Confirmation", 0) == 0;
    }

    protected String getPropertyFilePath() {
        return null;
    }

    protected JLabel getProgressLabel() {
        if (this.progressLabel == null) {
            this.progressLabel = new JLabel();
            this.progressLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
            this.progressLabel.setFont(new Font("Arial", 0, 12));
            this.progressLabel.setOpaque(false);
        }
        return this.progressLabel;
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setMaximum(100);
            this.progressBar.setMinimum(0);
            this.progressBar.setValue(0);
            this.progressBar.setOpaque(false);
            this.progressBar.setForeground(Color.GRAY);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    protected JPanel getProgressPanel() {
        if (this.progressPanel == null) {
            this.progressPanel = new JPanel(){
                private static final long serialVersionUID = -8945648199934865562L;

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics g2 = g.create();
                    g2.setColor(new Color(255, 255, 255, 180));
                    g2.fillRect(0, 0, AlchemistApplication.this.getProgressPanel().getWidth(), AlchemistApplication.this.getProgressPanel().getHeight());
                    g2.dispose();
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                    g2d.setColor(Color.LIGHT_GRAY);
                    g2d.fillRoundRect(5, 5, this.getWidth() - 10, this.getHeight() - 10, 16, 16);
                    g2d.setColor(Color.GRAY);
                    g2d.drawRoundRect(5, 5, this.getWidth() - 10, this.getHeight() - 10, 16, 16);
                    g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
                    g2d.dispose();
                }
            };
            this.progressPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 0));
            this.progressPanel.add(this.getProgressLabel());
            this.progressPanel.add(this.getProgressBar());
            this.progressPanel.setOpaque(false);
            this.progressPanel.add((Component)this.getCancelButton(), null);
        }
        return this.progressPanel;
    }

    public String showOpenDialog(String context) {
        String path = null;
        if (this.fileChooser != null) {
            String lastPath = (String)this.appState.getProperty(context + OPEN_FILE_DIR_SUFFIX);
            this.fileChooser.setCurrentDirectory(lastPath == null ? null : new File(lastPath));
            String title = this.getOpenFileChooserTitle();
            if (title != null) {
                this.fileChooser.setDialogTitle(title);
            }
            this.fileChooser.setSelectedFile(new File(""));
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.addFileFilters(this.getOpenFileFilters(context));
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            String lastFilterDesc = (String)this.appState.getProperty(context + OPEN_FILE_FILTER_SUFFIX);
            FileFilter filter = this.getFileFilterByDescription(lastFilterDesc);
            if (filter != null) {
                this.fileChooser.setFileFilter(filter);
            }
            this.fileChooser.setMultiSelectionEnabled(false);
            if (this.fileChooser.showOpenDialog(this.getApplicationFrame()) == 0) {
                this.appState.setPersistentProperty(context + OPEN_FILE_DIR_SUFFIX, this.fileChooser.getCurrentDirectory().getAbsolutePath());
                this.appState.setPersistentProperty(context + OPEN_FILE_FILTER_SUFFIX, this.fileChooser == null || this.fileChooser.getFileFilter() == null || this.fileChooser.getFileFilter().getDescription() == null ? "" : this.fileChooser.getFileFilter().getDescription());
                path = this.fileChooser.getSelectedFile().getAbsolutePath();
            }
        }
        return path;
    }

    public String showOpenDialog() {
        return this.showOpenDialog(PROPERTY_KEY_APP_INSTANCE);
    }

    public String[] showOpenDialogMultiSel(String context) {
        String[] paths = null;
        if (this.fileChooser != null) {
            String title;
            String lastPath = (String)this.appState.getProperty(context + OPEN_FILE_DIR_SUFFIX);
            this.fileChooser.setCurrentDirectory(lastPath == null ? null : new File(lastPath));
            this.fileChooser.setSelectedFile(new File(""));
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.addFileFilters(this.getOpenFileFilters(context));
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            String lastFilterDesc = (String)this.appState.getProperty(context + OPEN_FILE_FILTER_SUFFIX);
            FileFilter filter = this.getFileFilterByDescription(lastFilterDesc);
            if (filter != null) {
                this.fileChooser.setFileFilter(filter);
            }
            if ((title = this.getOpenFileChooserTitle()) != null) {
                this.fileChooser.setDialogTitle(title);
            }
            this.fileChooser.setMultiSelectionEnabled(true);
            if (this.fileChooser.showOpenDialog(this.getApplicationFrame()) == 0) {
                this.appState.setPersistentProperty(context + OPEN_FILE_DIR_SUFFIX, this.fileChooser.getCurrentDirectory().getAbsolutePath());
                this.appState.setPersistentProperty(context + OPEN_FILE_FILTER_SUFFIX, this.fileChooser.getFileFilter().getDescription());
                File[] files = this.fileChooser.getSelectedFiles();
                paths = new String[files.length];
                for (int i = 0; i < files.length; ++i) {
                    paths[i] = files[i].getAbsolutePath();
                }
            }
        }
        return paths;
    }

    protected FileFilter[] getOpenFileFilters(String context) {
        return new FileFilter[0];
    }

    protected FileFilter[] getSaveFileFilters(String context) {
        return new FileFilter[0];
    }

    public String[] showOpenDialogMultiSel() {
        return this.showOpenDialogMultiSel(PROPERTY_KEY_APP_INSTANCE);
    }

    public String showSaveDialog(String context) {
        String path = null;
        if (this.fileChooser != null) {
            String title;
            String lastPath = (String)this.appState.getProperty(context + SAVE_FILE_DIR_SUFFIX);
            this.fileChooser.setCurrentDirectory(lastPath == null ? null : new File(lastPath));
            this.fileChooser.setSelectedFile(new File(""));
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.addFileFilters(this.getSaveFileFilters(context));
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            String lastFilterDesc = (String)this.appState.getProperty(context + SAVE_FILE_FILTER_SUFFIX);
            FileFilter filter = this.getFileFilterByDescription(lastFilterDesc);
            if (filter != null) {
                this.fileChooser.setFileFilter(filter);
            }
            if ((title = this.getSaveFileChooserTitle()) != null) {
                this.fileChooser.setDialogTitle(title);
            }
            if (this.fileChooser.showSaveDialog(this.getApplicationFrame()) == 0) {
                this.appState.setPersistentProperty(context + SAVE_FILE_DIR_SUFFIX, this.fileChooser.getCurrentDirectory().getAbsolutePath());
                this.appState.setPersistentProperty(context + SAVE_FILE_FILTER_SUFFIX, this.fileChooser.getFileFilter().getDescription());
                path = this.fileChooser.getSelectedFile().getAbsolutePath();
                this.lastSaveFileFilter = this.fileChooser.getFileFilter();
            }
        }
        return path;
    }

    public String showSaveDialog() {
        return this.showSaveDialog(PROPERTY_KEY_APP_INSTANCE);
    }

    protected FileFilter getSaveFilter() {
        return this.lastSaveFileFilter;
    }

    private FileFilter getFileFilterByDescription(String fileFilterDescription) {
        if (fileFilterDescription == null) {
            return null;
        }
        if (this.fileChooser != null) {
            FileFilter[] filters = this.fileChooser.getChoosableFileFilters();
            for (int i = 0; i < filters.length; ++i) {
                if (!filters[i].getDescription().equals(fileFilterDescription)) continue;
                return filters[i];
            }
        }
        return null;
    }

    public void showProgressBar(AlchemistProgressMonitor monitor) {
        this.setProgressBarMonitor(monitor);
        this.getProgressLabel().setText(this.getProgressBarMonitor().getMessage());
        this.getProgressBar().setValue(0);
        this.getProgressPanel().setVisible(true);
        this.getCancelButton().setVisible(false);
        this.getProgressBarTimer().start();
    }

    public void showProgressBar(AlchemistProgressMonitor monitor, Action cancelAction) {
        this.setProgressBarMonitor(monitor);
        this.getProgressLabel().setText(this.getProgressBarMonitor().getMessage());
        this.getProgressBar().setValue(0);
        this.getProgressPanel().setVisible(true);
        this.getCancelButton().setVisible(true);
        this.getCancelButton().setAction(cancelAction);
        this.getCancelButton().setText("Cancel");
        this.getProgressBarTimer().start();
    }

    public void setProgressBarText(String progressLabelText) {
        this.getProgressLabel().setText(progressLabelText);
    }

    public void hideProgressBar() {
        this.getProgressBarTimer().stop();
        this.setProgressBarMonitor(null);
        this.getProgressPanel().setVisible(false);
    }

    public void updateProgressBar(int percent) {
        int newPercent = percent;
        if (percent < 0) {
            newPercent = 0;
        }
        if (percent > 100) {
            newPercent = 100;
        }
        this.getProgressBar().setValue(newPercent);
    }

    protected String getOpenFileChooserTitle() {
        return null;
    }

    protected String getApplicationTitle() {
        return this.appTitle;
    }

    protected String getSaveFileChooserTitle() {
        return null;
    }

    protected int getMinimumWindowWidth() {
        return 800;
    }

    protected int getMinimumWindowHeight() {
        return 600;
    }

    protected Dimension getDefaultWindowSize() {
        return null;
    }

    public AlchemistBanner getBanner() {
        return this.banner;
    }

    public void setBanner(AlchemistBanner banner) {
        if (this.banner != null) {
            this.getApplicationFrame().getContentPane().remove(this.banner);
        }
        this.banner = banner;
        if (this.banner != null) {
            this.getApplicationFrame().getContentPane().add((Component)this.banner, "North");
        }
    }

    public void show() {
        this.getApplicationFrame().setVisible(true);
    }

    public void hide() {
        this.getApplicationFrame().setVisible(false);
    }

    public void showMessageBox(String title, String message, int messageType) {
        JScrollPane scrollPane = new JScrollPane(20, 30);
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setOpaque(false);
        textArea.setText(message);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        scrollPane.setViewportView(textArea);
        scrollPane.setPreferredSize(new Dimension(320, 80));
        JOptionPane.showMessageDialog(this.getApplicationFrame(), scrollPane, title, messageType);
    }

    protected void createDisabledImage() {
        if (this.getContentPane().getWidth() > 0 && this.getContentPane().getHeight() > 0) {
            this.setDisabledImage(AlchemistGraphicsUtilities.createDisabledImage(this.getEnabledLayerPanel()));
        }
    }

    protected void disableContent(boolean showWaitAnim) {
        this.isDisabled = true;
        this.createDisabledImage();
        this.getWaitPanel().setVisible(true);
        this.getWaitPanel().setWheelVisible(showWaitAnim);
        if (showWaitAnim) {
            this.getWaitPanel().start();
        }
        CardLayout cl = (CardLayout)this.getSuspendableContentPanel().getContentPane().getLayout();
        cl.show(this.getSuspendableContentPanel().getContentPane(), DISABLED_PANEL);
    }

    protected void enableContent() {
        this.isDisabled = false;
        this.getWaitPanel().setVisible(false);
        this.getWaitPanel().stop();
        this.getWaitPanel().setWheelVisible(false);
        CardLayout cl = (CardLayout)this.getSuspendableContentPanel().getContentPane().getLayout();
        cl.show(this.getSuspendableContentPanel().getContentPane(), ENABLED_PANEL);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enableContent();
        } else {
            this.disableContent(false);
        }
    }

    public boolean isEnabled() {
        return !this.isDisabled;
    }

    public AlchemistState getApplicationState() {
        return this.appState;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setVisible(false);
        }
        return this.cancelButton;
    }

    public void addInnerDialog(AlchemistInnerDialog dialog) {
        this.getWaitPanel().add(dialog);
    }

    public void removeInnerDialog(AlchemistInnerDialog dialog) {
        this.getWaitPanel().remove(dialog);
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setToolbarVisible(String toolbarId, boolean visible) {
        boolean oldValue = this.isToolbarVisible(toolbarId);
        if (visible != oldValue) {
            if (visible) {
                this.getDockPane().showToolBar(toolbarId);
            } else {
                this.getDockPane().hideToolBar(toolbarId);
            }
            this.getApplicationState().setPersistentProperty(PROP_KEY_PREFIX + toolbarId + PROP_KEY_VISIBLE_SUFFIX, visible);
            this.notifier.firePropertyChange(PROP_KEY_PREFIX + toolbarId + PROP_KEY_VISIBLE_SUFFIX, oldValue, visible);
        }
    }

    public boolean isToolbarVisible(String toolbarId) {
        return this.getDockPane().isToolBarVisible(toolbarId);
    }

    protected void newDocumentActionHandler() {
        this.currentDocumentPath = null;
        this.currentDocumentFormat = null;
        this.setDocumentChanged(false);
        this.refreshDocumentHeader();
    }

    protected void openDocumentActionHandler(String path) {
        this.setDocumentPath(path);
        this.setDocumentChanged(false);
        this.refreshDocumentHeader();
    }

    protected void saveDocumentActionSelector() {
        if (this.currentDocumentPath == null || this.currentDocumentFormat == null) {
            this.saveDocumentAsActionHandler();
        } else {
            this.saveDocumentActionHandler();
        }
    }

    protected void refreshDocumentHeader() {
        if (this.isDocumentPathInFrameTitle() && this.getApplicationTitle() != null) {
            this.getApplicationFrame().setTitle(this.getApplicationTitle() + " - " + (this.getDocumentPath() == null ? NO_DOCUMENT : this.getDocumentPath()) + (this.isDocumentChanged() ? DOCUMENT_CHANGED : ""));
        }
    }

    protected void saveDocumentActionHandler() {
        this.setDocumentChanged(false);
    }

    protected String getSaveFilterFormat() {
        if (this.currentDocumentPath != null) {
            return this.currentDocumentPath.substring(this.currentDocumentPath.lastIndexOf(46) + 1, this.currentDocumentPath.length());
        }
        return "";
    }

    protected void saveDocumentAsActionHandler() {
        int result = 1;
        String newPath = "";
        while (result == 1 && newPath != null) {
            newPath = this.showSaveDialog();
            if (newPath == null) continue;
            File file = new File(newPath);
            result = 0;
            if (file.isFile()) {
                result = JOptionPane.showConfirmDialog(this.getApplicationFrame().getContentPane(), MESSAGE_FILE_ALREADY_EXISTS_CONFIRMATION, MESSAGE_SAVE_FILE_AS, 1, 3);
            }
            if (result == 0) {
                this.currentDocumentPath = newPath;
                this.currentDocumentFormat = this.getSaveFilterFormat();
                this.saveDocumentActionHandler();
                this.refreshDocumentHeader();
                return;
            }
            if (result != 2) continue;
            return;
        }
    }

    protected void aboutActionHandler() {
    }

    protected void licenseManagerActionHandler() {
    }

    protected void helpActionHandler() {
        AlchemistBrowserLauncher.launchBrowser("http://chemaxon.com");
    }

    protected void exitProgramActionHandler() {
        if (this.frameClosing()) {
            try {
                String pPath = this.getPropertyFilePath();
                if (pPath != null) {
                    this.appState.saveProperties(pPath);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.getApplicationFrame().dispose();
        }
    }

    protected void licenseManagerClosed() {
        this.setEnabled(true);
    }

    protected void setDocumentChanged(boolean changed) {
        this.dirtyBit = changed;
        this.refreshDocumentHeader();
    }

    protected boolean isDocumentChanged() {
        return this.dirtyBit;
    }

    protected String getDocumentPath() {
        return this.currentDocumentPath;
    }

    protected void setDocumentPath(String path) {
        String oldValue = this.currentDocumentPath;
        if (path.equals(oldValue)) {
            this.notifier.firePropertyChange(PROPERTY_KEY_CURRENT_DOCUMENT_PATH, oldValue, null);
            oldValue = null;
        }
        this.currentDocumentPath = path;
        this.notifier.firePropertyChange(PROPERTY_KEY_CURRENT_DOCUMENT_PATH, oldValue, this.currentDocumentPath);
    }

    protected String getDocumentFormat() {
        return this.currentDocumentFormat;
    }

    protected void setDocumentFormat(String format2) {
        this.currentDocumentFormat = format2;
    }

    protected void setDocumentPathInFrameTitle(boolean value) {
        this.showDocumentPathInHeader = value;
    }

    protected boolean isDocumentPathInFrameTitle() {
        return this.showDocumentPathInHeader;
    }

    protected void showError(String message, Exception exception) {
        AlchemistErrorDialog.showError(this.getApplicationFrame(), message, exception);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.notifier.addPropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.notifier.getPropertyChangeListeners();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.notifier.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.notifier.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.notifier.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.notifier.removePropertyChangeListener(propertyName, listener);
    }

    protected void setDisabledImage(Image disabledImage) {
        this.disabledImage = disabledImage;
    }

    protected Image getDisabledImage() {
        return this.disabledImage;
    }

    protected void setAppFrame(JFrame appFrame) {
        this.appFrame = appFrame;
    }

    protected JFrame getAppFrame() {
        return this.appFrame;
    }

    protected void setProgressBarMonitor(AlchemistProgressMonitor progressBarMonitor) {
        this.progressBarMonitor = progressBarMonitor;
    }

    protected AlchemistProgressMonitor getProgressBarMonitor() {
        return this.progressBarMonitor;
    }

    protected void setProgressBarTimer(Timer progressBarTimer) {
        this.progressBarTimer = progressBarTimer;
    }

    protected Timer getProgressBarTimer() {
        return this.progressBarTimer;
    }

    public static class HelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 7756132244804825111L;
        public static final String ACTION_ID = "help";

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistApplication app = (AlchemistApplication)this.getValue(AlchemistApplication.PROPERTY_KEY_APP_INSTANCE);
            if (app != null) {
                app.helpActionHandler();
            }
        }
    }

    public static class ExitApplicationAction
    extends AbstractAction {
        private static final long serialVersionUID = -8963958737852702895L;
        public static final String ACTION_ID = "exitApplication";

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistApplication app = (AlchemistApplication)this.getValue(AlchemistApplication.PROPERTY_KEY_APP_INSTANCE);
            app.exitProgramActionHandler();
        }
    }

    public static class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = -2737789389723967011L;
        public static final String ACTION_ID = "about";

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistApplication app = (AlchemistApplication)this.getValue(AlchemistApplication.PROPERTY_KEY_APP_INSTANCE);
            app.aboutActionHandler();
        }
    }

    public static class SaveDocumentAsAction
    extends AbstractAction {
        private static final long serialVersionUID = -907903154360820879L;
        public static final String ACTION_ID = "saveDocumentAs";

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistApplication app = (AlchemistApplication)this.getValue(AlchemistApplication.PROPERTY_KEY_APP_INSTANCE);
            app.saveDocumentAsActionHandler();
        }
    }

    public static class SaveDocumentAction
    extends AbstractAction {
        public static final String ACTION_ID = "saveDocument";
        private static final long serialVersionUID = 8876874402609783013L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistApplication app = (AlchemistApplication)this.getValue(AlchemistApplication.PROPERTY_KEY_APP_INSTANCE);
            app.saveDocumentActionSelector();
        }
    }

    public static class OpenDocumentAction
    extends AbstractAction {
        public static final String ACTION_ID = "openDocument";
        private static final long serialVersionUID = -3077101533489465876L;

        @Override
        public void actionPerformed(ActionEvent e) {
            String path;
            AlchemistApplication app = (AlchemistApplication)this.getValue(AlchemistApplication.PROPERTY_KEY_APP_INSTANCE);
            if (app.isDocumentChanged()) {
                int result = JOptionPane.showConfirmDialog(app.getApplicationFrame(), "Do you want to save changes?", "Open Document", 1, 3);
                if (result == 2) {
                    return;
                }
                if (result == 0) {
                    app.saveDocumentActionSelector();
                }
            }
            if ((path = app.showOpenDialog()) != null && new File(path).canRead()) {
                app.disableContent(true);
                app.openDocumentActionHandler(path);
                app.enableContent();
            }
        }
    }

    public static class NewDocumentAction
    extends AbstractAction {
        public static final String ACTION_ID = "newDocument";
        private static final long serialVersionUID = -3839082790538196785L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistApplication app = (AlchemistApplication)this.getValue(AlchemistApplication.PROPERTY_KEY_APP_INSTANCE);
            if (app.isDocumentChanged()) {
                int result = JOptionPane.showConfirmDialog(app.getApplicationFrame(), "Do you want to save changes?", "Create New Document", 1, 3);
                if (result == 2) {
                    return;
                }
                if (result == 0) {
                    app.saveDocumentActionSelector();
                }
            }
            app.newDocumentActionHandler();
        }
    }
}

