/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.utils.AlchemistBrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class AlchemistBanner
extends JPanel {
    private static final long serialVersionUID = 6880633873706063894L;
    private Image leftImage = null;
    private Image expandableImage = null;
    private Image rightImage = null;
    private JPanel leftPanel = null;
    private JPanel expandablePanel = null;
    private JPanel rightPanel = null;

    public AlchemistBanner(String leftPath, String expandablePath, String rightPath, final String urlToBrowse) {
        this.loadImages(leftPath, expandablePath, rightPath);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY)));
        this.setOpaque(false);
        if (urlToBrowse != null) {
            this.setCursor(new Cursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AlchemistBrowserLauncher.launchBrowser(urlToBrowse);
                }
            });
        }
        this.createPanels();
        if (this.leftPanel != null) {
            this.add((Component)this.leftPanel, "West");
        }
        if (this.expandablePanel != null) {
            this.add((Component)this.expandablePanel, "Center");
        }
        if (this.rightPanel != null) {
            this.add((Component)this.rightPanel, "East");
        }
    }

    private void loadImages(String leftPath, String expandablePath, String rightPath) {
        MediaTracker mediaTracker = new MediaTracker(this);
        URL urlLeft = this.getClass().getResource(leftPath);
        URL urlExpand = this.getClass().getResource(expandablePath);
        URL urlRight = this.getClass().getResource(rightPath);
        if (urlLeft != null) {
            this.setLeftImage(this.getToolkit().getImage(urlLeft));
            mediaTracker.addImage(this.getLeftImage(), 0);
        }
        if (urlExpand != null) {
            this.setExpandableImage(this.getToolkit().getImage(urlExpand));
            mediaTracker.addImage(this.getExpandableImage(), 1);
        }
        if (urlRight != null) {
            this.setRightImage(this.getToolkit().getImage(urlRight));
            mediaTracker.addImage(this.getRightImage(), 2);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private void createPanels() {
        if (this.getLeftImage() != null) {
            this.leftPanel = new JPanel(){
                private static final long serialVersionUID = 3587696449122557203L;

                @Override
                public void paintComponent(Graphics g) {
                    g.drawImage(AlchemistBanner.this.getLeftImage(), 0, 0, null);
                    super.paintComponent(g);
                }
            };
            this.leftPanel.setPreferredSize(new Dimension(this.getLeftImage().getWidth(null), this.getLeftImage().getHeight(null)));
            this.leftPanel.setOpaque(false);
        }
        if (this.getExpandableImage() != null) {
            this.expandablePanel = new JPanel(){
                private static final long serialVersionUID = 7734228625207475209L;

                @Override
                public void paintComponent(Graphics g) {
                    Dimension d = this.getSize();
                    g.drawImage(AlchemistBanner.this.getExpandableImage(), 0, 0, d.width, d.height, null);
                    this.setOpaque(false);
                    super.paintComponent(g);
                }
            };
        }
        if (this.getRightImage() != null) {
            this.rightPanel = new JPanel(){
                private static final long serialVersionUID = 3767710601809239111L;

                @Override
                public void paintComponent(Graphics g) {
                    g.drawImage(AlchemistBanner.this.getRightImage(), 0, 0, null);
                    super.paintComponent(g);
                }
            };
            this.rightPanel.setPreferredSize(new Dimension(this.getRightImage().getWidth(null), this.getRightImage().getHeight(null)));
            this.rightPanel.setOpaque(false);
        }
    }

    protected void setLeftImage(Image leftImage) {
        this.leftImage = leftImage;
    }

    protected Image getLeftImage() {
        return this.leftImage;
    }

    protected void setExpandableImage(Image expandableImage) {
        this.expandableImage = expandableImage;
    }

    protected Image getExpandableImage() {
        return this.expandableImage;
    }

    protected void setRightImage(Image rightImage) {
        this.rightImage = rightImage;
    }

    protected Image getRightImage() {
        return this.rightImage;
    }
}

