/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.AlchemistPage;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public abstract class AlchemistGlassPage
extends AlchemistPage {
    private static final long serialVersionUID = 1836082717872977708L;
    public static final String PROPERTY_KEY_FADE = "AlchemistGlassPage_Fade";
    public static final int PROPERTY_VALUE_SHOWING = 1;
    public static final int PROPERTY_VALUE_HIDING = -1;
    public static final int PROPERTY_VALUE_STOPPED = 0;
    private Image backgroundImage = null;
    private int fadeDelay = 50;
    private float fadeStep = 0.25f;
    private int fadeDirection = -1;
    private float fadeValue = 1.0f;
    private Composite fadeComposite = AlphaComposite.getInstance(3, this.getFadeValue());
    boolean isFading = false;
    int lastFadePropertyValue = 0;
    private Timer fadeTimer = new Timer(this.fadeDelay, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlchemistGlassPage.this.setFadeValue(AlchemistGlassPage.this.getFadeValue() + (float)AlchemistGlassPage.this.getFadeDirection() * AlchemistGlassPage.this.getFadeStep());
            if (AlchemistGlassPage.this.getFadeValue() > 1.0f) {
                AlchemistGlassPage.this.setFadeValue(1.0f);
            }
            if (AlchemistGlassPage.this.getFadeValue() < 0.0f) {
                AlchemistGlassPage.this.setFadeValue(0.0f);
            }
            AlchemistGlassPage.this.setFadeComposite(AlphaComposite.getInstance(3, AlchemistGlassPage.this.getFadeValue()));
            if (AlchemistGlassPage.this.getFadeValue() == 1.0f || AlchemistGlassPage.this.getFadeValue() == 0.0f) {
                AlchemistGlassPage.this.getFadeTimer().stop();
                if (AlchemistGlassPage.this.getFadeDirection() == 1) {
                    AlchemistGlassPage.super.setVisible(false);
                }
                AlchemistGlassPage.this.firePropertyChange(AlchemistGlassPage.PROPERTY_KEY_FADE, AlchemistGlassPage.this.lastFadePropertyValue, 0);
                AlchemistGlassPage.this.lastFadePropertyValue = 0;
            }
            AlchemistGlassPage.this.repaint();
        }
    });

    public boolean isFadingEnabled() {
        return this.isFading;
    }

    public void setFadingEnabled(boolean isFadingEnabled) {
        this.isFading = isFadingEnabled;
    }

    public void setGlassImage(Image image) {
        this.backgroundImage = image;
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.getFadeTimer().stop();
        if (this.isFading && this.backgroundImage != null) {
            if (aFlag) {
                this.setFadeDirection(-1);
                super.setVisible(true);
                this.firePropertyChange(PROPERTY_KEY_FADE, this.lastFadePropertyValue, 1);
                this.lastFadePropertyValue = 1;
            } else {
                this.setFadeDirection(1);
                this.firePropertyChange(PROPERTY_KEY_FADE, this.lastFadePropertyValue, -1);
                this.lastFadePropertyValue = -1;
            }
            this.setFadeComposite(AlphaComposite.getInstance(3, this.getFadeValue()));
            this.getFadeTimer().start();
        } else {
            this.firePropertyChange(PROPERTY_KEY_FADE, this.lastFadePropertyValue, 0);
            this.lastFadePropertyValue = 0;
            this.setFadeValue(aFlag ? 0.0f : 1.0f);
            super.setVisible(aFlag);
        }
    }

    public int getFadeDelay() {
        return this.fadeDelay;
    }

    public void setFadeDelay(int fadeDelay) {
        this.fadeDelay = fadeDelay;
    }

    public float getFadeStep() {
        return this.fadeStep;
    }

    public void setFadeStep(float fadeStep) {
        this.fadeStep = fadeStep;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.backgroundImage != null && this.isFading) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(this.getFadeComposite());
            g2.translate(-this.getX(), -this.getY());
            g2.drawImage(this.backgroundImage, 0, 0, null);
            g2.dispose();
        }
    }

    protected void setFadeValue(float fadeValue) {
        this.fadeValue = fadeValue;
    }

    protected float getFadeValue() {
        return this.fadeValue;
    }

    protected void setFadeDirection(int fadeDirection) {
        this.fadeDirection = fadeDirection;
    }

    protected int getFadeDirection() {
        return this.fadeDirection;
    }

    protected void setFadeComposite(Composite fadeComposite) {
        this.fadeComposite = fadeComposite;
    }

    protected Composite getFadeComposite() {
        return this.fadeComposite;
    }

    protected void setFadeTimer(Timer fadeTimer) {
        this.fadeTimer = fadeTimer;
    }

    protected Timer getFadeTimer() {
        return this.fadeTimer;
    }
}

