/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.utils.AlchemistState;
import chemaxon.alchemist.utils.HelpTextPanelFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AlchemistPage
extends JPanel {
    private static final long serialVersionUID = -3963996127180616976L;
    private final SwingPropertyChangeSupport notifier = new SwingPropertyChangeSupport(this);
    private boolean pageEnabled = true;
    private JPanel pnlTop = null;
    private boolean topIsVisible = false;
    private boolean bottomIsVisible = false;
    private JPanel pnlBottom = null;
    private JLabel lblBottom = null;
    private JProgressBar progressBar = null;
    private JLabel progressLabel = null;
    private JPanel progressPanel = null;
    public static final String PROPERTY_KEY_MOVE_NEXT = "AlchemistPage_MoveNext";
    private JButton cancelButton = null;

    public abstract boolean isCorrect();

    public void setTopText(String title, String text) {
        if (this.pnlTop == null) {
            this.pnlTop = HelpTextPanelFactory.getNewHelpTextPanel(title, text);
        }
    }

    public void setTopTextVisible(boolean visible) {
        if (this.getLayout() instanceof BorderLayout && visible != this.topIsVisible && this.pnlTop != null) {
            if (visible) {
                this.add((Component)this.pnlTop, "North");
            } else {
                this.remove(this.pnlTop);
            }
            this.updateUI();
            this.topIsVisible = visible;
        }
    }

    protected JLabel getBottomTextLabel() {
        if (this.lblBottom == null) {
            this.lblBottom = new JLabel();
            this.lblBottom.setFont(new Font("Arial", 0, 12));
            this.lblBottom.setBackground(Color.WHITE);
            this.lblBottom.setForeground(Color.BLACK);
            this.lblBottom.setOpaque(true);
        }
        return this.lblBottom;
    }

    protected JPanel getBottomPanel() {
        if (this.pnlBottom == null) {
            this.pnlBottom = new JPanel();
            this.pnlBottom.setLayout(new BorderLayout());
            this.pnlBottom.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.pnlBottom.add((Component)this.getBottomTextLabel(), "North");
            this.pnlBottom.setBackground(Color.WHITE);
        }
        return this.pnlBottom;
    }

    public void setBottomText(String bottomText) {
        this.getBottomTextLabel().setText(bottomText);
    }

    public void setBottomTextVisible(boolean visible) {
        if (this.getLayout() instanceof BorderLayout && visible != this.bottomIsVisible) {
            if (visible) {
                this.add((Component)this.getBottomPanel(), "South");
            } else {
                this.remove(this.getBottomPanel());
            }
            this.bottomIsVisible = visible;
            this.updateUI();
        }
    }

    public boolean isBottomTextVisible() {
        return this.bottomIsVisible;
    }

    public boolean isTopTextVisible() {
        return this.topIsVisible;
    }

    public boolean isPageEnabled() {
        return this.pageEnabled;
    }

    public void setPageEnabled(boolean pageEnabled) {
        this.pageEnabled = pageEnabled;
    }

    public abstract void enterPage(AlchemistState var1);

    public abstract void leavePage(AlchemistState var1);

    public void performLeavePage() {
        this.getNotifier().firePropertyChange(PROPERTY_KEY_MOVE_NEXT, null, null);
    }

    public SwingPropertyChangeSupport getNotifier() {
        return this.notifier;
    }

    private JLabel getProgressLabel() {
        if (this.progressLabel == null) {
            this.progressLabel = new JLabel();
            this.progressLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.progressLabel.setFont(new Font("Arial", 0, 12));
            this.progressLabel.setOpaque(false);
        }
        return this.progressLabel;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setMaximum(100);
            this.progressBar.setMinimum(0);
            this.progressBar.setValue(0);
            this.progressBar.setOpaque(false);
            this.progressBar.setForeground(Color.GRAY);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    private JPanel getProgressPanel() {
        if (this.progressPanel == null) {
            this.progressPanel = new JPanel();
            this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 0));
            this.progressPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.progressPanel.add(this.getProgressLabel());
            this.progressPanel.add(this.getProgressBar());
            this.progressPanel.setOpaque(false);
            this.progressPanel.add((Component)this.getCancelButton(), null);
        }
        return this.progressPanel;
    }

    public void showProgressBar(String progressLabelText) {
        this.getProgressLabel().setText(progressLabelText);
        this.getProgressBar().setValue(0);
        this.getBottomPanel().remove(this.getBottomTextLabel());
        this.getBottomPanel().add(this.getProgressPanel());
        this.getBottomPanel().updateUI();
    }

    public void showProgressBar(String progressLabelText, Action cancelAction) {
        this.showProgressBar(progressLabelText);
        this.getCancelButton().setAction(cancelAction);
        this.getCancelButton().setText("Cancel");
        this.getCancelButton().setVisible(true);
    }

    public void hideProgressBar() {
        this.getCancelButton().setVisible(false);
        this.getBottomPanel().remove(this.getProgressPanel());
        this.getBottomPanel().add(this.getBottomTextLabel());
        this.getBottomPanel().updateUI();
    }

    public void updateProgressBar(int percent) {
        int newPercent = percent;
        if (percent < 0) {
            newPercent = 0;
        }
        if (percent > 100) {
            newPercent = 100;
        }
        this.getProgressBar().setValue(newPercent);
        if (this.getProgressBar().getString() != null) {
            this.getProgressBar().setString(null);
        }
    }

    public void updateProgressBar(float percent) {
        int newPercent = (int)percent;
        if (percent < 0.0f) {
            newPercent = 0;
        }
        if (percent > 100.0f) {
            newPercent = 100;
        }
        this.getProgressBar().setValue(newPercent);
        this.getProgressBar().setString(newPercent + "%");
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setVisible(false);
        }
        return this.cancelButton;
    }
}

