/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist;

import chemaxon.alchemist.utils.SwingWorker;
import javax.swing.SwingUtilities;

public abstract class AlchemistTask
implements Cloneable {
    protected long lengthOfTask = 0L;
    protected long current = 0L;
    protected boolean done = false;
    protected boolean canceled = false;
    protected String statMessage;
    protected long timeStart;
    protected long timeEnd;
    public static final String PROPERTY_VALUE_UNDETERMINABLE = "undeterminable";

    public void go() {
        this.go(5);
    }

    public void go(int priority) {
        SwingWorker worker = new SwingWorker(priority){

            @Override
            public Object construct() {
                AlchemistTask.this.current = 0L;
                AlchemistTask.this.done = false;
                AlchemistTask.this.canceled = false;
                AlchemistTask.this.statMessage = "";
                return new ActualTask();
            }

            @Override
            public void finished() {
                super.finished();
                AlchemistTask.this.finished();
            }
        };
        this.lengthOfTask = this.initializeTask();
        if (!this.canceled) {
            worker.start();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlchemistTask.this.finished();
                }
            });
        }
    }

    public long getLengthOfTask() {
        return this.lengthOfTask;
    }

    public long getCurrent() {
        return this.current;
    }

    public void stop() {
        this.timeEnd = System.currentTimeMillis();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlchemistTask.this.finished();
            }
        });
        this.canceled = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getMessage() {
        return this.statMessage;
    }

    protected abstract long initializeTask();

    protected abstract void finished();

    protected abstract void calculate();

    protected String calcTime() {
        long elapsed = this.timeEnd - this.timeStart;
        return this.getFormattedTime(elapsed);
    }

    private String getFormattedTime(long time) {
        long newTime = time;
        if (newTime != -1L) {
            int seconds = (int)((newTime /= 1000L) % 60L);
            int minutes = (int)((newTime /= 60L) % 60L);
            return (newTime /= 60L) + "h " + minutes + "m " + seconds + "s";
        }
        return PROPERTY_VALUE_UNDETERMINABLE;
    }

    protected long getEstimatedTimeAsLong() {
        if (this.lengthOfTask != 0L && this.current != 0L) {
            return (long)((float)(System.currentTimeMillis() - this.timeStart) / ((float)this.current / (float)this.lengthOfTask) - (float)(System.currentTimeMillis() - this.timeStart));
        }
        return -1L;
    }

    public String getEstimatedTime() {
        return this.getFormattedTime(this.getEstimatedTimeAsLong());
    }

    public String getElapsedTime() {
        return this.getFormattedTime(System.currentTimeMillis() - this.timeStart);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    class ActualTask {
        ActualTask() {
            AlchemistTask.this.timeStart = System.currentTimeMillis();
            AlchemistTask.this.calculate();
            AlchemistTask.this.timeEnd = System.currentTimeMillis();
        }
    }
}

