/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.commonpages;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.utils.AlchemistFileChooser;
import chemaxon.alchemist.utils.AlchemistFileChooserForMarvin;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.AlchemistMViewAccessory;
import chemaxon.alchemist.utils.AlchemistMoleculeView;
import chemaxon.alchemist.utils.AlchemistState;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileListHandlerPanel
extends AlchemistPage {
    private static final long serialVersionUID = -1923661099622302455L;
    public static final String PROPERTY_KEY_LAST_USED_DIR = "FileListHandlerPanel_LastUsedDir";
    public static final String PROPERTY_KEY_INPUT_FILE_LIST = "FileListHandlerPanel_InputFileList";
    public static final String PROPERTY_KEY_INPUT_FILE_ORDER = "FileListHandlerPanel_InputFileOrder";
    private JPanel contentPanel = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    private JScrollPane scrollPane = null;
    private JSplitPane previewSplit = null;
    private JList fileList = null;
    private AlchemistFileChooserForMarvin openDialog = null;
    private JButton upButton = null;
    private JButton downButton = null;
    private final boolean preview;
    private AlchemistMoleculeView view = null;
    private final Action ADD_FILE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -3064288345615610667L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent accessory = FileListHandlerPanel.this.getOpenDialog().getAccessory();
            if (accessory instanceof AlchemistMViewAccessory) {
                ((AlchemistMViewAccessory)accessory).forceMoleculeReload();
            }
            if (FileListHandlerPanel.this.getOpenDialog().showOpenDialog(null) == 0) {
                File[] fileArray = FileListHandlerPanel.this.getOpenDialog().getSelectedFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        ((DefaultListModel)FileListHandlerPanel.this.getFileList().getModel()).addElement(fileArray[i]);
                    }
                }
                FileListHandlerPanel.this.getNotifier().firePropertyChange(FileListHandlerPanel.PROPERTY_KEY_INPUT_FILE_LIST, null, ((DefaultListModel)FileListHandlerPanel.this.getFileList().getModel()).elements());
            }
            FileListHandlerPanel.this.getOpenDialog().clear();
            FileListHandlerPanel.this.getNotifier().firePropertyChange(FileListHandlerPanel.PROPERTY_KEY_LAST_USED_DIR, null, FileListHandlerPanel.this.getOpenDialog().getCurrentDirectory().getAbsolutePath());
        }
    };
    private final Action REMOVE_FILE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 5982994604037685858L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FileListHandlerPanel.this.getFileList().getSelectedIndex() != -1) {
                FileListHandlerPanel.this.removeFromList();
            }
            FileListHandlerPanel.this.getNotifier().firePropertyChange(FileListHandlerPanel.PROPERTY_KEY_INPUT_FILE_LIST, null, ((DefaultListModel)FileListHandlerPanel.this.getFileList().getModel()).elements());
        }
    };
    protected final Action MOVE_UP_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -6211277297124760371L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel model = (DefaultListModel)FileListHandlerPanel.this.getFileList().getModel();
            int pos = FileListHandlerPanel.this.getFileList().getSelectedIndex();
            int length = FileListHandlerPanel.this.getFileList().getSelectedIndices().length;
            if (pos > 0) {
                Object obj = model.remove(pos - 1);
                model.add(pos + length - 1, obj);
                FileListHandlerPanel.this.getNotifier().firePropertyChange(FileListHandlerPanel.PROPERTY_KEY_INPUT_FILE_ORDER, pos - 1, pos + length - 1);
            }
            FileListHandlerPanel.this.MOVE_UP_ACTION.setEnabled(FileListHandlerPanel.this.getFileList().getSelectedIndex() > 0);
            FileListHandlerPanel.this.MOVE_DOWN_ACTION.setEnabled(FileListHandlerPanel.this.getFileList().getSelectedIndex() > -1 && FileListHandlerPanel.this.getFileList().getSelectedIndex() + length - 1 < FileListHandlerPanel.this.getFileList().getModel().getSize() - 1);
        }
    };
    protected final Action MOVE_DOWN_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -4793814716331455030L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            DefaultListModel model = (DefaultListModel)FileListHandlerPanel.this.getFileList().getModel();
            int pos = FileListHandlerPanel.this.getFileList().getSelectedIndex();
            if (pos + (length = FileListHandlerPanel.this.getFileList().getSelectedIndices().length) - 1 < model.getSize() - 1) {
                Object obj = model.remove(pos + length);
                model.add(pos, obj);
                FileListHandlerPanel.this.getFileList().setSelectionInterval(pos + 1, pos + length);
                FileListHandlerPanel.this.getNotifier().firePropertyChange(FileListHandlerPanel.PROPERTY_KEY_INPUT_FILE_ORDER, pos + length, pos);
            }
            FileListHandlerPanel.this.MOVE_UP_ACTION.setEnabled(FileListHandlerPanel.this.getFileList().getSelectedIndex() > 0);
            FileListHandlerPanel.this.MOVE_DOWN_ACTION.setEnabled(FileListHandlerPanel.this.getFileList().getSelectedIndex() > -1 && FileListHandlerPanel.this.getFileList().getSelectedIndex() + length - 1 < FileListHandlerPanel.this.getFileList().getModel().getSize() - 1);
        }
    };

    public FileListHandlerPanel() {
        this(false);
    }

    public FileListHandlerPanel(boolean preview) {
        this.preview = preview;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(380, 380);
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(new Dimension(380, 380));
        this.add((Component)this.getContentPanel(), "Center");
        this.setOpenDialog(new AlchemistFileChooserForMarvin(true));
        this.getOpenDialog().setMultiSelectionEnabled(true);
        this.getOpenDialog().addDefaultOpenFileFilters();
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, fill:default:grow, 2dlu, pref, 4dlu", "4dlu, default, 2dlu, pref, 4dlu, pref, 2dlu, pref, fill:pref:grow, 4dlu");
            CellConstraints cc = new CellConstraints();
            this.contentPanel.setLayout((LayoutManager)layout);
            this.contentPanel.add((Component)(this.isPreview() ? this.getPreviewSplit() : this.getScrollPane()), cc.xywh(2, 2, 1, 8));
            String placeConstraint = "left, center";
            this.contentPanel.add((Component)this.getUpButton(), cc.xy(4, 2, placeConstraint));
            this.contentPanel.add((Component)this.getDownButton(), cc.xy(4, 4, placeConstraint));
            this.contentPanel.add((Component)this.getAddbutton(), cc.xy(4, 6, placeConstraint));
            this.contentPanel.add((Component)this.getRemoveButton(), cc.xy(4, 8, placeConstraint));
        }
        return this.contentPanel;
    }

    private JButton getAddbutton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.ADD_FILE_ACTION);
            this.addButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/addmolecule.gif"));
            this.addButton.setToolTipText("Add file...");
            this.addButton.setPreferredSize(new Dimension(23, 23));
        }
        return this.addButton;
    }

    protected JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton(this.REMOVE_FILE_ACTION);
            this.removeButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/toolbar/removemolecule.gif"));
            this.removeButton.setToolTipText("Remove selected file");
            this.removeButton.setPreferredSize(new Dimension(23, 23));
            this.removeButton.setEnabled(false);
        }
        return this.removeButton;
    }

    private JButton getUpButton() {
        if (this.upButton == null) {
            this.upButton = new JButton(this.MOVE_UP_ACTION);
            this.upButton.setToolTipText("Move selected items upwards");
            this.upButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/up.gif"));
            this.upButton.setPreferredSize(new Dimension(23, 23));
            this.MOVE_UP_ACTION.setEnabled(false);
        }
        return this.upButton;
    }

    private JButton getDownButton() {
        if (this.downButton == null) {
            this.downButton = new JButton(this.MOVE_DOWN_ACTION);
            this.downButton.setToolTipText("Move selected items downwards");
            this.downButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif"));
            this.downButton.setPreferredSize(new Dimension(23, 23));
            this.MOVE_DOWN_ACTION.setEnabled(false);
        }
        return this.downButton;
    }

    private JSplitPane getPreviewSplit() {
        if (this.previewSplit == null) {
            this.previewSplit = new JSplitPane(0);
            this.previewSplit.setTopComponent(this.getScrollPane());
            this.previewSplit.setBottomComponent(this.getView());
            this.previewSplit.setResizeWeight(0.8f);
            this.previewSplit.setOneTouchExpandable(true);
        }
        return this.previewSplit;
    }

    protected AlchemistMoleculeView getView() {
        if (this.view == null) {
            this.view = new AlchemistMoleculeView(1, 1, false);
        }
        return this.view;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setVerticalScrollBarPolicy(22);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
            this.scrollPane.setViewportView(this.getFileList());
        }
        return this.scrollPane;
    }

    protected JList getFileList() {
        if (this.fileList == null) {
            this.fileList = new JList(new DefaultListModel());
            this.fileList.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.fileList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int length = FileListHandlerPanel.this.getFileList().getSelectedIndices().length;
                        FileListHandlerPanel.this.getRemoveButton().setEnabled(FileListHandlerPanel.this.getFileList().getSelectedIndex() != -1);
                        FileListHandlerPanel.this.MOVE_UP_ACTION.setEnabled(FileListHandlerPanel.this.getFileList().getSelectedIndex() > 0);
                        FileListHandlerPanel.this.MOVE_DOWN_ACTION.setEnabled(FileListHandlerPanel.this.getFileList().getSelectedIndex() > -1 && FileListHandlerPanel.this.getFileList().getSelectedIndex() + length - 1 < FileListHandlerPanel.this.getFileList().getModel().getSize() - 1);
                        if (FileListHandlerPanel.this.isPreview()) {
                            if (FileListHandlerPanel.this.getFileList().getSelectedValue() == null) {
                                FileListHandlerPanel.this.getView().stopLoading();
                                FileListHandlerPanel.this.getView().clear();
                            } else {
                                FileListHandlerPanel.this.getView().importMolecules(FileListHandlerPanel.this.getFileList().getSelectedValue().toString());
                            }
                        }
                    }
                }
            });
            this.fileList.setSelectionMode(1);
            this.fileList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        FileListHandlerPanel.this.removeFromList();
                    }
                }
            });
        }
        return this.fileList;
    }

    public File getFile(int index) {
        File result = null;
        result = (File)((DefaultListModel)this.getFileList().getModel()).get(index);
        return result;
    }

    public int getFileCount() {
        return this.getFileList().getModel().getSize();
    }

    @Override
    public boolean isCorrect() {
        return ((DefaultListModel)this.getFileList().getModel()).size() > 0;
    }

    public AlchemistFileChooser getFileChooser() {
        return this.getOpenDialog();
    }

    @Override
    public void enterPage(AlchemistState state) {
        String path = (String)state.getProperty(PROPERTY_KEY_LAST_USED_DIR);
        if (path != null) {
            this.getOpenDialog().setCurrentDirectory(new File(path));
        }
    }

    @Override
    public void leavePage(AlchemistState state) {
        state.setPersistentProperty(PROPERTY_KEY_LAST_USED_DIR, this.getOpenDialog().getCurrentDirectory().getAbsolutePath());
        state.setProperty(PROPERTY_KEY_INPUT_FILE_LIST, ((DefaultListModel)this.getFileList().getModel()).toArray());
    }

    protected void removeFromList() {
        if (JOptionPane.showConfirmDialog(this, "Do You want to remove the selected " + (this.getFileList().getSelectedIndices().length > 1 ? "files" : "file") + " from the list?", "Remove Confirmation", 0) == 0) {
            int[] indices = this.getFileList().getSelectedIndices();
            for (int i = indices.length - 1; i > -1; --i) {
                ((DefaultListModel)this.getFileList().getModel()).remove(indices[i]);
            }
        }
    }

    protected void setOpenDialog(AlchemistFileChooserForMarvin openDialog) {
        this.openDialog = openDialog;
    }

    protected AlchemistFileChooserForMarvin getOpenDialog() {
        return this.openDialog;
    }

    protected boolean isPreview() {
        return this.preview;
    }
}

