/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.commonpages;

import chemaxon.alchemist.AlchemistPage;
import chemaxon.alchemist.AlchemistTask;
import chemaxon.alchemist.utils.AlchemistMoleculeView;
import chemaxon.alchemist.utils.AlchemistState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressPanel
extends AlchemistPage {
    private static final long serialVersionUID = -5032783126037811156L;
    public static final int STATE_SUMMARY = 0;
    public static final int STATE_PROGRESS = 1;
    public static final int STATE_RESULT = 2;
    protected int currentState = 0;
    public static final String DEFAULT_PROGRESS_CAPTION = "Operation in progress...";
    private final Action doneAction;
    protected final AlchemistTask task;
    private AlchemistTask currentTask = null;
    protected final Timer timer;
    public static final int DELAY = 500;
    public static final String SHOW_RESULTS = "Show results";
    public static final String CLOSE_RESULTS = "Close results";
    private JPanel processingPanel = null;
    private JProgressBar progressBar = null;
    private JLabel statusLabel = null;
    private JButton cancelButton = null;
    private JPanel summaryPanel = null;
    private JLabel summaryCaption = null;
    private JScrollPane summaryScrollPane = null;
    private JTextArea summaryDetails = null;
    private JPanel resultPanel = null;
    private JLabel resultCaption = null;
    private JScrollPane resultScrollPanel = null;
    private JTextArea resultDetails = null;
    protected JPanel dummyPanel;
    private AlchemistMoleculeView resultView = null;
    private JButton resultButton = null;
    private String outputFilePath = "";
    private JPanel contentPanel = null;

    public ProgressPanel(Action doneAction, AlchemistTask task) {
        this.doneAction = doneAction;
        this.task = task;
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressPanel.this.refreshInformations();
                if (ProgressPanel.this.getCurrentTask().isDone() || ProgressPanel.this.getCurrentTask().isCanceled()) {
                    ProgressPanel.this.getTimer().stop();
                    ProgressPanel.this.getDoneAction().actionPerformed(new ActionEvent(this, 1, "DONE"));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgressPanel.this.setMessage(ProgressPanel.this.getCurrentTask().getMessage(), 2);
                            ProgressPanel.this.setPanelState(2);
                        }
                    });
                }
            }
        });
        this.initialize();
    }

    protected void initialize() {
        this.dummyPanel = this.getSummaryPanel();
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(328, 276));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(SystemColor.controlDkShadow, 1)));
        this.add((Component)this.getContentPanel(), "Center");
        this.getProcessingPanel();
        this.getResultPanel();
    }

    public void runTask() {
        this.runTask(5);
    }

    public void runTask(int priority) {
        try {
            AlchemistTask clonedTask = (AlchemistTask)this.task.clone();
            this.setCurrentTask(clonedTask);
            this.getCurrentTask().go(priority);
            this.startRefresh();
        }
        catch (CloneNotSupportedException e) {
            Object clonedTask = null;
        }
    }

    protected void startRefresh() {
        this.setProgressValue(0);
        if (this.getCurrentTask().getLengthOfTask() == 0L) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setStringPainted(false);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setStringPainted(true);
        }
        this.getTimer().start();
    }

    @Override
    public boolean isCorrect() {
        return this.currentState == 0;
    }

    @Override
    public void enterPage(AlchemistState state) {
        this.setCaption(DEFAULT_PROGRESS_CAPTION, 1);
        this.setPanelState(0);
        this.getResultPanel().add((Component)this.getResultScrollPanel(), "Center");
    }

    @Override
    public void leavePage(AlchemistState state) {
        this.getResultButton().setText(SHOW_RESULTS);
        this.getResultPanel().remove(this.getResultView());
        this.getResultView().clear();
    }

    protected JPanel getProcessingPanel() {
        if (this.processingPanel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText(DEFAULT_PROGRESS_CAPTION);
            this.statusLabel.setAlignmentX(0.5f);
            this.statusLabel.setFont(new Font("Tahoma", 1, 11));
            this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.statusLabel.setHorizontalAlignment(0);
            this.processingPanel = new JPanel();
            this.processingPanel.setLayout(new BoxLayout(this.getProcessingPanel(), 1));
            this.processingPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
            this.processingPanel.add((Component)this.getProgressBar(), null);
            this.processingPanel.add((Component)this.statusLabel, null);
            this.processingPanel.add((Component)this.getCancelButton(), null);
            this.processingPanel.setBackground(Color.WHITE);
        }
        return this.processingPanel;
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setStringPainted(true);
            this.progressBar.setAlignmentX(0.5f);
        }
        return this.progressBar;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setAlignmentX(0.5f);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ProgressPanel.this.timer.isRunning()) {
                        ProgressPanel.this.timer.start();
                    }
                    ProgressPanel.this.getCurrentTask().stop();
                    ProgressPanel.this.getCancelButton().setEnabled(false);
                }
            });
        }
        return this.cancelButton;
    }

    public void setPanelState(int state) {
        this.currentState = state;
        this.getContentPanel().remove(this.dummyPanel);
        switch (state) {
            case 0: {
                this.dummyPanel = this.getSummaryPanel();
                break;
            }
            case 1: {
                this.dummyPanel = this.getProcessingPanel();
                break;
            }
            case 2: {
                this.cancelButton.setEnabled(true);
                this.dummyPanel = this.getResultPanel();
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state occurred. state=" + state);
            }
        }
        this.getContentPanel().add((Component)this.dummyPanel, "Center");
        this.validate();
        this.updateUI();
    }

    public void setCaption(String caption, int state) {
        switch (state) {
            case 0: {
                this.summaryCaption.setText(caption);
                break;
            }
            case 1: {
                this.statusLabel.setText(caption);
                break;
            }
            case 2: {
                this.resultCaption.setText(caption);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state occurred. state=" + state);
            }
        }
    }

    public void setMessage(String message, int state) {
        switch (state) {
            case 0: {
                this.summaryDetails.setText(message);
                break;
            }
            case 2: {
                this.resultDetails.setText(message);
            }
        }
    }

    protected void setProgressValue(int percent) {
        this.progressBar.setValue(percent);
    }

    private JPanel getSummaryPanel() {
        if (this.summaryPanel == null) {
            this.summaryCaption = new JLabel();
            this.summaryCaption.setText("Summary");
            this.summaryCaption.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.summaryCaption.setFont(new Font("Tahoma", 1, 14));
            this.summaryPanel = new JPanel();
            this.summaryPanel.setLayout(new BorderLayout());
            this.summaryPanel.setBackground(Color.WHITE);
            this.summaryPanel.setBorder(null);
            this.summaryPanel.add((Component)this.summaryCaption, "North");
            this.summaryPanel.add((Component)this.getSummaryScrollPane(), "Center");
        }
        return this.summaryPanel;
    }

    private JScrollPane getSummaryScrollPane() {
        if (this.summaryScrollPane == null) {
            this.summaryScrollPane = new JScrollPane();
            this.summaryScrollPane.setBorder(BorderFactory.createLineBorder(Color.white, 1));
            this.summaryScrollPane.setBackground(Color.WHITE);
            this.summaryScrollPane.setViewportView(this.getSummaryDetails());
        }
        return this.summaryScrollPane;
    }

    private JTextArea getSummaryDetails() {
        if (this.summaryDetails == null) {
            this.summaryDetails = new JTextArea();
            this.summaryDetails.setBackground(Color.WHITE);
            this.summaryDetails.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.summaryDetails.setWrapStyleWord(true);
            this.summaryDetails.setEditable(false);
            this.summaryDetails.setLineWrap(true);
        }
        return this.summaryDetails;
    }

    public JPanel getResultPanel() {
        if (this.resultPanel == null) {
            this.resultCaption = new JLabel();
            this.resultCaption.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.resultCaption.setFont(new Font("Tahoma", 1, 14));
            this.resultCaption.setText("Results");
            this.resultPanel = new JPanel();
            this.resultPanel.setLayout(new BorderLayout());
            this.resultPanel.setBackground(Color.WHITE);
            this.resultPanel.setBorder(null);
            this.resultPanel.add((Component)this.resultCaption, "North");
            this.resultPanel.add((Component)this.getResultScrollPanel(), "Center");
        }
        return this.resultPanel;
    }

    public JScrollPane getResultScrollPanel() {
        if (this.resultScrollPanel == null) {
            this.resultScrollPanel = new JScrollPane();
            this.resultScrollPanel.setBorder(BorderFactory.createLineBorder(Color.white, 1));
            this.resultScrollPanel.setBackground(Color.white);
            this.resultScrollPanel.setViewportView(this.getResultDetails());
        }
        return this.resultScrollPanel;
    }

    private JTextArea getResultDetails() {
        if (this.resultDetails == null) {
            this.resultDetails = new JTextArea();
            this.resultDetails.setBackground(Color.WHITE);
            this.resultDetails.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.resultDetails.setEditable(false);
            this.resultDetails.setWrapStyleWord(true);
            this.resultDetails.setLineWrap(true);
        }
        return this.resultDetails;
    }

    public void setResultCustomPanel(JPanel panel) {
        this.resultPanel.add((Component)panel, "South");
        this.resultPanel.validate();
        this.resultPanel.updateUI();
    }

    public void addProgressCustomComponent(Component component) {
        this.processingPanel.add(component);
        this.processingPanel.validate();
        this.processingPanel.updateUI();
    }

    public void refreshInformations() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ProgressPanel.this.getProgressBar().isIndeterminate()) {
                    float num2;
                    float num1 = ProgressPanel.this.getCurrentTask().getCurrent();
                    int percent = (int)(num1 / (num2 = (float)ProgressPanel.this.getCurrentTask().getLengthOfTask()) * 100.0f);
                    ProgressPanel.this.setProgressValue(percent > 100 ? 100 : percent);
                }
            }
        });
    }

    protected JButton getResultButton() {
        if (this.resultButton == null) {
            this.resultButton = new JButton(SHOW_RESULTS);
            this.resultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase(ProgressPanel.SHOW_RESULTS)) {
                        ProgressPanel.this.getResultButton().setText(ProgressPanel.CLOSE_RESULTS);
                        ProgressPanel.this.getResultPanel().setVisible(false);
                        ProgressPanel.this.getResultPanel().remove(ProgressPanel.this.getResultScrollPanel());
                        ProgressPanel.this.getResultPanel().add((Component)ProgressPanel.this.getInitializedResultView(), "Center");
                        ProgressPanel.this.getResultPanel().setVisible(true);
                    } else {
                        ProgressPanel.this.getResultButton().setText(ProgressPanel.SHOW_RESULTS);
                        ProgressPanel.this.getResultPanel().setVisible(false);
                        ProgressPanel.this.getResultPanel().remove(ProgressPanel.this.getResultView());
                        ProgressPanel.this.getResultView().clear();
                        ProgressPanel.this.getResultPanel().add(ProgressPanel.this.getResultScrollPanel());
                        ProgressPanel.this.getResultPanel().setVisible(true);
                    }
                }
            });
        }
        return this.resultButton;
    }

    protected AlchemistMoleculeView getResultView() {
        if (this.resultView == null) {
            this.resultView = new AlchemistMoleculeView(4, 4, 10, 10, true);
        }
        return this.resultView;
    }

    protected AlchemistMoleculeView getInitializedResultView() {
        if (this.outputFilePath != null && !this.outputFilePath.equalsIgnoreCase("")) {
            this.getResultView().importMolecules(this.outputFilePath);
        }
        return this.getResultView();
    }

    public void setOutputFilePath(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    protected JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.add((Component)this.dummyPanel, "Center");
        }
        return this.contentPanel;
    }

    protected Timer getTimer() {
        return this.timer;
    }

    protected Action getDoneAction() {
        return this.doneAction;
    }

    protected void setCurrentTask(AlchemistTask currentTask) {
        this.currentTask = currentTask;
    }

    protected AlchemistTask getCurrentTask() {
        return this.currentTask;
    }
}

