/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ConfigElementEditor;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractConfigElementEditor
implements ConfigElementEditor {
    protected JPanel mainPanel = null;
    private ConfigElement element = null;

    protected JLabel getTitle(String text) {
        JLabel label = new JLabel("<html><b>" + text + "</b></html>");
        label.setBackground(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
        label.setOpaque(true);
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        return label;
    }

    @Override
    public Component getEditorComponent(ConfigElement value) {
        this.setElement(value);
        this.initialize();
        return this.mainPanel;
    }

    @Override
    public ConfigElement getEditorValue() {
        return this.getElement();
    }

    protected void initialize() {
        this.getMainPanel();
    }

    protected abstract LayoutManager getMainLayout();

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(this.getMainLayout());
            this.addComponents();
        }
        return this.mainPanel;
    }

    protected abstract void addComponents();

    public void setElement(ConfigElement element) {
        this.element = element;
    }

    public ConfigElement getElement() {
        return this.element;
    }
}

