/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ConfigElementEditor;
import chemaxon.alchemist.configbuilder.ConfigElementSketchEditor;
import chemaxon.alchemist.configbuilder.ExternalEditorSupport;
import chemaxon.struc.Molecule;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractSketchConfigElement
extends ConfigElement
implements ExternalEditorSupport {
    public static final String PROPERTY_KEY_MOLECULE = "Molecule";
    private String editorMode = "default";
    private Molecule molecule = new Molecule();
    private static final Collection<String> VALID_EDITORMODES = Arrays.asList("default", "external");
    private ConfigElementEditor editor = null;

    @Override
    public String getEditorMode() {
        return this.editorMode;
    }

    @Override
    public ConfigElementEditor getExternalEditor() {
        return this.editor;
    }

    @Override
    public void setEditorMode(String editorMode) {
        if (!VALID_EDITORMODES.contains(editorMode)) {
            throw new IllegalArgumentException("Allowed values: " + VALID_EDITORMODES.toString());
        }
        String oldEditorMode = this.editorMode;
        this.editorMode = editorMode;
        this.getPropertyChangeSupport().firePropertyChange("Editormode", oldEditorMode, editorMode);
        this.validate();
    }

    @Override
    public void setExternalEditor(ConfigElementEditor externalEditor) {
        this.editor = externalEditor;
    }

    public void setMolecule(Molecule molecule) {
        this.molecule = molecule;
        this.validate();
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    @Override
    public AbstractSketchConfigElement clone() throws CloneNotSupportedException {
        AbstractSketchConfigElement clone = (AbstractSketchConfigElement)super.clone();
        clone.molecule = this.molecule.cloneMolecule();
        clone.editor = this.editor;
        return clone;
    }

    @Override
    public String getExternalEditorClassName() {
        return ConfigElementSketchEditor.class.getName();
    }

    protected void accepted(Molecule molecule) {
        this.setMolecule(molecule);
        this.setEditorMode("default");
    }

    protected void canceled() {
        this.setEditorMode("default");
    }

    protected int getDefaultDispOpts() {
        return -1;
    }
}

