/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.AlchemistProfile;
import chemaxon.alchemist.configbuilder.AlchemistProfileSupport;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ConfigElementEditor;
import chemaxon.alchemist.configbuilder.ConfigElementFactory;
import chemaxon.alchemist.configbuilder.ConfigElementListCellRenderer;
import chemaxon.alchemist.configbuilder.ConfigElementPresentationChooser;
import chemaxon.alchemist.configbuilder.ConfigElementTransferHandler;
import chemaxon.alchemist.configbuilder.ConfigurationReader;
import chemaxon.alchemist.configbuilder.ConfigurationWriter;
import chemaxon.alchemist.configbuilder.ExternalEditorSupport;
import chemaxon.alchemist.configbuilder.LicenseSupport;
import chemaxon.alchemist.configbuilder.configuration.marshalling.Configuration;
import chemaxon.alchemist.configbuilder.configuration.marshalling.Element;
import chemaxon.alchemist.utils.AlchemistGraphicsUtilities;
import chemaxon.alchemist.utils.AlchemistIconFactory;
import chemaxon.alchemist.utils.SynchronizedAbstractFilterListModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.naming.OperationNotSupportedException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class ConfigBuilderPanel
extends JPanel {
    private static final long serialVersionUID = 1831281487952208191L;
    public static final String PROPERTY_KEY_ELEMENT_LIST = "ElementList";
    public static final String PROPERTY_KEY_ELEMENT_ORDER = "ElementOrder";
    public static final String PROPERTY_KEY_CONFIGURATION_VALID = "ConfigurationValid";
    private static final String FILE_LOAD_SUPPORT_TEXT = "Add Elements from the list\non the left, or double-click\nhere to open a file";
    private static final String HELP_PANEL = "helpPanel";
    private static final String DEFAULT_HELP_TITLE = "<html><b>Build Your Configuration</b></html>";
    private static final String DEFAULT_HELP_TEXT = "Select a command from the list on the left, and press 'Add >' button to appent it to the end of configuration queue. In some cases, You will be asked for additional informations in order to set the correct parameters of the corresponding command. You can change the order of commands in the right list with the up and down arrow buttons at the right side.";
    private static final String MULTIPLE_HELP_TITLE = "<html><b>Multiple actions selected</b></html>";
    private static final String MULTIPLE_HELP_TEXT = "You may your selection block upwards or downwards in the left list, or you can add or remove all selected actions from the list.\nFor detailed configuration of certain actions, select only one of them at a time from the right list.";
    private static final String NORMAL_VIEW = "normalView";
    private CardLayout mainLayout = null;
    private CardLayout controlLayout = null;
    private JSplitPane normalViewSplit = null;
    private JPanel controlPanel = null;
    private JPanel mainPanel = null;
    private JPanel helpPanel = null;
    private JLabel helpPanelLabel = null;
    private JTextArea helpTextArea = null;
    private JComboBox leftListFilter = null;
    private JPanel sourcePanel = null;
    private JScrollPane leftListScroll = null;
    private JScrollPane rightListScroll = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JList leftList = null;
    private JList rightList = null;
    private ConfigElementPresentationChooser presentationChooser = null;
    private AlchemistProfile profile = null;
    private JButton openFileButton = null;
    private JButton saveFileButton = null;
    private boolean firstResized = true;
    private boolean ignoreMissingLicense = false;
    private SwingPropertyChangeSupport elementPropertyChangeSupport = null;
    private boolean validConfiguration = true;
    private boolean readingConfiguration = false;
    private boolean fileSupportEnabled = false;
    private String defaultHelpText = "Select a command from the list on the left, and press 'Add >' button to appent it to the end of configuration queue. In some cases, You will be asked for additional informations in order to set the correct parameters of the corresponding command. You can change the order of commands in the right list with the up and down arrow buttons at the right side.";
    private LicenseSupport licenseSupport = null;
    protected final AbstractAction ADD_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 3473620375504235954L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] values = ConfigBuilderPanel.this.getLeftList().getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                ConfigBuilderPanel.this.addElement((ConfigElement)values[i]);
            }
        }
    };
    protected final AbstractAction REMOVE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -8690457413167384809L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] elements = ConfigBuilderPanel.this.getRightList().getSelectedValues();
            if (elements.length == 0) {
                return;
            }
            if (!(elements.length <= 1 && ((ConfigElement)elements[0]).isDefault() || JOptionPane.showConfirmDialog(ConfigBuilderPanel.this, this.getMessage(elements), "Remove item", 0) != 1)) {
                return;
            }
            for (int i = 0; i < elements.length; ++i) {
                ConfigBuilderPanel.this.removeElement((ConfigElement)elements[i]);
            }
        }

        private String getMessage(Object[] elements) {
            if (elements.length > 1) {
                return "Remove selected elements?";
            }
            if (!((ConfigElement)elements[0]).isDefault()) {
                return "This element is already configured!\nRemove it anyway?";
            }
            throw new IllegalArgumentException("Elements has to contain minimum one value");
        }
    };
    protected final AbstractAction MOVE_UP_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 9062455272256210223L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel model = (DefaultListModel)ConfigBuilderPanel.this.getRightList().getModel();
            int pos = ConfigBuilderPanel.this.getRightList().getSelectedIndex();
            int length = ConfigBuilderPanel.this.getRightList().getSelectedIndices().length;
            if (pos > 0) {
                ConfigElement element = (ConfigElement)model.remove(pos - 1);
                model.add(pos + length - 1, element);
                ConfigBuilderPanel.this.getElementPropertyChangeSupport().firePropertyChange(ConfigBuilderPanel.PROPERTY_KEY_ELEMENT_ORDER, pos - 1, pos + length - 1);
            }
            ConfigBuilderPanel.this.MOVE_UP_ACTION.setEnabled(ConfigBuilderPanel.this.getRightList().getSelectedIndex() > 0);
            ConfigBuilderPanel.this.MOVE_DOWN_ACTION.setEnabled(ConfigBuilderPanel.this.getRightList().getSelectedIndex() > -1 && ConfigBuilderPanel.this.getRightList().getSelectedIndex() + length - 1 < ConfigBuilderPanel.this.getRightList().getModel().getSize() - 1);
        }
    };
    protected final AbstractAction MOVE_DOWN_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 5531717380790111487L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            DefaultListModel model = (DefaultListModel)ConfigBuilderPanel.this.getRightList().getModel();
            int pos = ConfigBuilderPanel.this.getRightList().getSelectedIndex();
            if (pos + (length = ConfigBuilderPanel.this.getRightList().getSelectedIndices().length) - 1 < model.getSize() - 1) {
                ConfigElement element = (ConfigElement)model.remove(pos + length);
                model.add(pos, element);
                ConfigBuilderPanel.this.getRightList().setSelectionInterval(pos + 1, pos + length);
                ConfigBuilderPanel.this.getElementPropertyChangeSupport().firePropertyChange(ConfigBuilderPanel.PROPERTY_KEY_ELEMENT_ORDER, pos + length, pos);
            }
            ConfigBuilderPanel.this.MOVE_UP_ACTION.setEnabled(ConfigBuilderPanel.this.getRightList().getSelectedIndex() > 0);
            ConfigBuilderPanel.this.MOVE_DOWN_ACTION.setEnabled(ConfigBuilderPanel.this.getRightList().getSelectedIndex() > -1 && ConfigBuilderPanel.this.getRightList().getSelectedIndex() + length - 1 < ConfigBuilderPanel.this.getRightList().getModel().getSize() - 1);
        }
    };
    protected Action openFileAction = null;
    private Action saveFileAction = null;
    private final transient ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ConfigElement element = (ConfigElement)((JList)e.getSource()).getSelectedValue();
                if (element == null) {
                    ConfigBuilderPanel.this.getHelpPanelLabel().setText(ConfigBuilderPanel.DEFAULT_HELP_TITLE);
                    ConfigBuilderPanel.this.getHelpTextArea().setText(ConfigBuilderPanel.this.getDefaultHelpText());
                    ConfigBuilderPanel.this.getControlLayout().show(ConfigBuilderPanel.this.getControlPanel(), ConfigBuilderPanel.HELP_PANEL);
                } else if (e.getSource() == ConfigBuilderPanel.this.getRightList()) {
                    ConfigBuilderPanel.this.getLeftList().clearSelection();
                    if (ConfigBuilderPanel.this.getRightList().getSelectedIndices().length > 1) {
                        ConfigBuilderPanel.this.getHelpPanelLabel().setText(ConfigBuilderPanel.MULTIPLE_HELP_TITLE);
                        ConfigBuilderPanel.this.getHelpTextArea().setText(ConfigBuilderPanel.MULTIPLE_HELP_TEXT);
                        ConfigBuilderPanel.this.getControlLayout().show(ConfigBuilderPanel.this.getControlPanel(), ConfigBuilderPanel.HELP_PANEL);
                    } else {
                        ConfigElementEditor editor = ConfigBuilderPanel.this.getPresentationChooser().get(element.getClass());
                        if (editor != null) {
                            Component component = editor.getEditorComponent(element);
                            if (!ConfigBuilderPanel.this.getControlPanel().isAncestorOf(component)) {
                                ConfigBuilderPanel.this.getControlPanel().add(component, editor.getClass().getName());
                                if (editor instanceof AlchemistProfileSupport) {
                                    ((AlchemistProfileSupport)((Object)editor)).loadFromProfile(ConfigBuilderPanel.this.getProfile());
                                }
                                editor.getEditorComponent(element);
                            }
                            ConfigBuilderPanel.this.getControlLayout().show(ConfigBuilderPanel.this.getControlPanel(), editor.getClass().getName());
                        } else {
                            ConfigBuilderPanel.this.getHelpPanelLabel().setText("No editor is available");
                            ConfigBuilderPanel.this.getHelpTextArea().setText("There is no editor set for this type of action.\nThe usage of this action is restricted, you can not add, or change this action type, however you can remove it from the list.");
                            ConfigBuilderPanel.this.getControlLayout().show(ConfigBuilderPanel.this.getControlPanel(), ConfigBuilderPanel.HELP_PANEL);
                        }
                    }
                } else {
                    ConfigBuilderPanel.this.getRightList().clearSelection();
                    if (ConfigBuilderPanel.this.getLeftList().getSelectedIndices().length > 1) {
                        ConfigBuilderPanel.this.getHelpPanelLabel().setText(ConfigBuilderPanel.MULTIPLE_HELP_TITLE);
                        ConfigBuilderPanel.this.getHelpTextArea().setText(ConfigBuilderPanel.MULTIPLE_HELP_TEXT);
                    } else {
                        StringBuffer buffer = new StringBuffer("<html><b>");
                        buffer.append(element.getTooltip());
                        buffer.append("</b>");
                        if (!ConfigBuilderPanel.this.isIgnoreMissingLicense() && !element.isLicensed()) {
                            buffer.append("<i> - No valid license found</i>");
                        }
                        buffer.append("</html>");
                        ConfigBuilderPanel.this.getHelpPanelLabel().setText(buffer.toString());
                        buffer = new StringBuffer(element.getHelpText());
                        if (!ConfigBuilderPanel.this.isIgnoreMissingLicense() && !element.isLicensed()) {
                            buffer.append("\nThis action requires " + element.getLicenseName() + " license.");
                        }
                        ConfigBuilderPanel.this.getHelpTextArea().setText(buffer.toString());
                    }
                    ConfigBuilderPanel.this.getControlLayout().show(ConfigBuilderPanel.this.getControlPanel(), ConfigBuilderPanel.HELP_PANEL);
                }
                int length = ConfigBuilderPanel.this.getRightList().getSelectedIndices().length;
                ConfigBuilderPanel.this.ADD_ACTION.setEnabled(ConfigBuilderPanel.this.getLeftList().getSelectedIndex() != -1);
                ConfigBuilderPanel.this.REMOVE_ACTION.setEnabled(ConfigBuilderPanel.this.getRightList().getSelectedIndex() != -1);
                ConfigBuilderPanel.this.MOVE_UP_ACTION.setEnabled(ConfigBuilderPanel.this.getRightList().getSelectedIndex() > 0);
                ConfigBuilderPanel.this.MOVE_DOWN_ACTION.setEnabled(ConfigBuilderPanel.this.getRightList().getSelectedIndex() > -1 && ConfigBuilderPanel.this.getRightList().getSelectedIndex() + length - 1 < ConfigBuilderPanel.this.getRightList().getModel().getSize() - 1);
            }
        }
    };
    private final transient PropertyChangeListener elementPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ConfigBuilderPanel.this.getLeftList().repaint();
            ConfigBuilderPanel.this.getRightList().repaint();
            ConfigBuilderPanel.this.getElementPropertyChangeSupport().firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            if (evt.getPropertyName().equalsIgnoreCase("ConfigElement_Valid")) {
                ConfigBuilderPanel.this.handleValidityChanges();
            }
        }
    };
    private final transient PropertyChangeListener editorPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue().equals("external")) {
                try {
                    ConfigElementEditor editor = ConfigBuilderPanel.this.getPresentationChooser().get(Class.forName(((ExternalEditorSupport)evt.getSource()).getExternalEditorClassName()));
                    editor.getEditorComponent((ConfigElement)evt.getSource());
                    ConfigBuilderPanel.this.getMainLayout().show(ConfigBuilderPanel.this, editor.getClass().getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (evt.getNewValue().equals("default")) {
                ConfigBuilderPanel.this.getMainLayout().show(ConfigBuilderPanel.this, ConfigBuilderPanel.NORMAL_VIEW);
            }
        }
    };

    public ConfigBuilderPanel(String configPath) throws MarshalException, ValidationException, FileNotFoundException {
        this(configPath, new AlchemistProfile());
    }

    public ConfigBuilderPanel(String configPath, Action openFileAction, Action saveFileAction) throws MarshalException, ValidationException {
        this(configPath, new AlchemistProfile(), openFileAction, saveFileAction);
    }

    public ConfigBuilderPanel(String configPath, AlchemistProfile profile) throws MarshalException, ValidationException, FileNotFoundException {
        this(configPath == null ? null : Configuration.unmarshal(new InputStreamReader(ConfigBuilderPanel.class.getResourceAsStream(configPath))), profile);
    }

    public ConfigBuilderPanel(String configPath, AlchemistProfile profile, Action openFileAction, Action saveFileAction) throws MarshalException, ValidationException {
        this(Configuration.unmarshal(new InputStreamReader(ConfigBuilderPanel.class.getResourceAsStream(configPath))), profile, openFileAction, saveFileAction);
    }

    public ConfigBuilderPanel(Configuration configuration) {
        this(configuration, new AlchemistProfile());
    }

    public ConfigBuilderPanel(Configuration configuration, Action openFileAction, Action saveFileAction) {
        this(configuration, new AlchemistProfile(), openFileAction, saveFileAction);
    }

    public ConfigBuilderPanel(Configuration configuration, AlchemistProfile profile) {
        this(configuration, profile, null, null);
    }

    public ConfigBuilderPanel(Configuration configuration, AlchemistProfile profile, Action openFileAction, Action saveFileAction) {
        this.setElementPropertyChangeSupport(new SwingPropertyChangeSupport(this));
        this.setMainLayout(new CardLayout());
        this.setControlLayout(new CardLayout());
        this.setPresentationChooser(new ConfigElementPresentationChooser());
        this.profile = profile;
        this.initialize();
        this.initializeElements(configuration);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (ConfigBuilderPanel.this.isFirstResized()) {
                    ConfigBuilderPanel.this.getNormalViewSplit().setDividerLocation(0.55f);
                    ConfigBuilderPanel.this.setFirstResized(false);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
    }

    private void initialize() {
        this.setLayout(this.getMainLayout());
        this.add((Component)this.getNormalView(), NORMAL_VIEW);
        this.getMainLayout().show(this, NORMAL_VIEW);
        this.ADD_ACTION.setEnabled(false);
        this.REMOVE_ACTION.setEnabled(false);
        this.MOVE_UP_ACTION.setEnabled(false);
        this.MOVE_DOWN_ACTION.setEnabled(false);
        this.controlPanel.add((Component)this.getHelpPanel(), HELP_PANEL);
        this.getControlLayout().show(this.getControlPanel(), HELP_PANEL);
        ConfigElementTransferHandler transferHandler = new ConfigElementTransferHandler(this.getLeftList(), this.getRightList(), this);
        this.getLeftList().setTransferHandler(transferHandler);
        this.getRightList().setTransferHandler(transferHandler);
    }

    private void initializeElements(Configuration elementConfiguration) throws IllegalArgumentException {
        if (elementConfiguration != null) {
            ConfigElementFactory factory = new ConfigElementFactory(elementConfiguration, this.licenseSupport);
            final HashSet<String> tagSet = new HashSet<String>();
            Element[] elements = elementConfiguration.getElementList().getElement();
            this.getPresentationChooser().clear();
            this.getLeftList().setModel(new LeftListModel());
            for (int i = 0; i < elements.length; ++i) {
                ConfigElement configElement = factory.create(elements[i]);
                String[] tags = configElement.getTags();
                for (int j = 0; j < tags.length; ++j) {
                    tagSet.add(tags[j]);
                }
                this.addConfigElement(configElement, elements[i].getEditorClass());
            }
            ((LeftListModel)this.getLeftList().getModel()).sort();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigBuilderPanel.this.getLeftListFilter().removeAllItems();
                    Object[] tags = tagSet.toArray(new String[0]);
                    Arrays.sort(tags);
                    for (int i = 0; i < tags.length; ++i) {
                        ConfigBuilderPanel.this.getLeftListFilter().addItem(tags[i]);
                    }
                    ConfigBuilderPanel.this.getLeftListFilter().setSelectedIndex(-1);
                }
            });
        }
    }

    public void addConfigElement(ConfigElement element, String elementEditorClassName) {
        LeftListModel model = (LeftListModel)this.getLeftList().getModel();
        try {
            this.getPresentationChooser().put(element.getClass(), Class.forName(elementEditorClassName));
            if (element instanceof ExternalEditorSupport) {
                this.getPresentationChooser().put(Class.forName(((ExternalEditorSupport)((Object)element)).getExternalEditorClassName()), Class.forName(((ExternalEditorSupport)((Object)element)).getExternalEditorClassName()));
                ConfigElementEditor value = this.getPresentationChooser().get(Class.forName(((ExternalEditorSupport)((Object)element)).getExternalEditorClassName()));
                ((ExternalEditorSupport)((Object)element)).setExternalEditor(value);
                Component component = value.getEditorComponent(element);
                if (!this.isAncestorOf(component)) {
                    this.add(component, ((ExternalEditorSupport)((Object)element)).getExternalEditorClassName());
                    if (value instanceof AlchemistProfileSupport) {
                        ((AlchemistProfileSupport)((Object)value)).loadFromProfile(this.profile);
                    }
                }
            }
            model.addElement(element);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }

    public void removeConfigElement(ConfigElement element) {
        for (int i = 0; i < this.getRightList().getModel().getSize(); ++i) {
            if (!((ConfigElement)this.getRightList().getModel().getElementAt(i)).getId().equalsIgnoreCase(element.getId())) continue;
            ((DefaultListModel)this.getRightList().getModel()).remove(i);
        }
        ConfigElementEditor editor = this.getPresentationChooser().get(element.getClass());
        Component component = editor.getEditorComponent(element);
        if (this.getControlPanel().isAncestorOf(component)) {
            this.getControlPanel().remove(component);
        }
        this.getPresentationChooser().remove(element.getClass());
        ((LeftListModel)this.getLeftList().getModel()).removeElement(element);
    }

    public void removeConfigElement(String elementId) {
        for (int i = 0; i < this.getLeftList().getModel().getSize(); ++i) {
            if (!((ConfigElement)this.getLeftList().getModel().getElementAt(i)).getId().equalsIgnoreCase(elementId)) continue;
            this.removeConfigElement((ConfigElement)this.getLeftList().getModel().getElementAt(i));
            return;
        }
    }

    public void removeConfigElements(String[] elementIds) {
        for (int i = 0; i < elementIds.length; ++i) {
            this.removeConfigElement(elementIds[i]);
        }
    }

    private JSplitPane getNormalView() {
        if (this.getNormalViewSplit() == null) {
            this.setNormalViewSplit(new JSplitPane(0, true));
            BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getNormalViewSplit().getUI()).getDivider();
            divider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
            this.getNormalViewSplit().setTopComponent(this.getMainPanel());
            this.getNormalViewSplit().setBottomComponent(this.getControlPanel());
            this.getNormalViewSplit().setResizeWeight(1.0);
        }
        return this.getNormalViewSplit();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, fill:min:grow, 2dlu, min, 2dlu, fill:min:grow, 2dlu, pref, 4dlu", "4dlu, pref, 2dlu ,pref, 4dlu, pref, 2dlu, pref, default:grow, 4dlu");
            layout.setColumnGroups((int[][])new int[][]{{2, 6}});
            CellConstraints cc = new CellConstraints();
            this.mainPanel.setLayout((LayoutManager)layout);
            this.mainPanel.add((Component)this.getSourcePanel(), cc.xywh(2, 2, 1, 8));
            this.mainPanel.add((Component)this.getRightListScroll(), cc.xywh(6, 2, 1, 8));
            this.mainPanel.add((Component)this.getAddButton(), cc.xy(4, 2));
            this.mainPanel.add((Component)this.getRemoveButton(), cc.xy(4, 4));
            this.mainPanel.add((Component)this.getMoveUpButton(), cc.xy(8, 2));
            this.mainPanel.add((Component)this.getMoveDownButton(), cc.xy(8, 4));
            this.mainPanel.add((Component)this.getOpenFileButton(), cc.xy(8, 6));
            this.mainPanel.add((Component)this.getSaveFileButton(), cc.xy(8, 8));
        }
        return this.mainPanel;
    }

    private JPanel getSourcePanel() {
        if (this.sourcePanel == null) {
            CellConstraints cc = new CellConstraints();
            this.sourcePanel = new JPanel((LayoutManager)new FormLayout("fill:pref:grow", "fill:min:grow, pref"));
            this.sourcePanel.setBackground(this.getLeftList().getBackground());
            this.sourcePanel.add((Component)this.getLeftListScroll(), cc.xy(1, 1));
            this.sourcePanel.add((Component)this.getLeftListFilter(), cc.xy(1, 2));
            this.sourcePanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
        }
        return this.sourcePanel;
    }

    protected JComboBox getLeftListFilter() {
        if (this.leftListFilter == null) {
            this.leftListFilter = new JComboBox(){
                private static final long serialVersionUID = -1365858808443237955L;

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    String str = ConfigBuilderPanel.this.getLeftListFilter().getEditor().getItem().toString();
                    if (str.length() == 0) {
                        Graphics g2 = g.create();
                        AlchemistGraphicsUtilities.renderMessageOnComponent(g2, "<Type filter keywords>", Color.GRAY, ConfigBuilderPanel.this.getLeftListFilter().getWidth(), ConfigBuilderPanel.this.getLeftListFilter().getHeight());
                        g2.dispose();
                    }
                }
            };
            this.leftListFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((LeftListModel)ConfigBuilderPanel.this.getLeftList().getModel()).filter();
                            if (ConfigBuilderPanel.this.getLeftListFilter().getSelectedIndex() != -1) {
                                ConfigBuilderPanel.this.getLeftList().requestFocus();
                            }
                        }
                    });
                }
            });
            this.leftListFilter.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ConfigBuilderPanel.this.getLeftListFilter().setSelectedIndex(-1);
                            ((LeftListModel)ConfigBuilderPanel.this.getLeftList().getModel()).filter();
                        }
                    });
                }
            });
            this.leftListFilter.setEditable(true);
            this.leftListFilter.setSelectedItem("");
            this.leftListFilter.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return this.leftListFilter;
    }

    protected JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(this.getControlLayout());
        }
        return this.controlPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.ADD_ACTION);
            this.addButton.setText("Add >");
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton(this.REMOVE_ACTION);
            this.removeButton.setText("< Remove");
        }
        return this.removeButton;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton(this.MOVE_UP_ACTION);
            this.moveUpButton.setPreferredSize(new Dimension(23, 23));
            this.moveUpButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/up.gif"));
        }
        return this.moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton(this.MOVE_DOWN_ACTION);
            this.moveDownButton.setPreferredSize(new Dimension(23, 23));
            this.moveDownButton.setIcon(AlchemistIconFactory.getIcon("/chemaxon/alchemist/images/down.gif"));
        }
        return this.moveDownButton;
    }

    private JScrollPane getLeftListScroll() {
        if (this.leftListScroll == null) {
            this.leftListScroll = new JScrollPane();
            this.leftListScroll.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
            this.leftListScroll.setViewportView(this.getLeftList());
        }
        return this.leftListScroll;
    }

    private JScrollPane getRightListScroll() {
        if (this.rightListScroll == null) {
            this.rightListScroll = new JScrollPane();
            this.rightListScroll.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.GRAY));
            this.rightListScroll.setViewportView(this.getRightList());
        }
        return this.rightListScroll;
    }

    protected JList getLeftList() {
        if (this.leftList == null) {
            this.leftList = new JList();
            this.leftList.setDragEnabled(true);
            this.leftList.setModel(new LeftListModel());
            this.leftList.setCellRenderer(new ConfigElementListCellRenderer(true));
            this.leftList.setSelectionMode(2);
            this.leftList.addListSelectionListener(this.listSelectionListener);
            this.leftList.setSelectionBackground(AlchemistGraphicsUtilities.greyscale(this.leftList.getSelectionBackground()));
            this.leftList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        ConfigBuilderPanel.this.ADD_ACTION.actionPerformed(null);
                    }
                }
            });
            this.leftList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ConfigBuilderPanel.this.ADD_ACTION.actionPerformed(null);
                    }
                }
            });
        }
        return this.leftList;
    }

    protected JList getRightList() {
        if (this.rightList == null) {
            this.rightList = new JList(){
                private static final long serialVersionUID = -1365858808443237955L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (ConfigBuilderPanel.this.isFileSupportEnabled() && ConfigBuilderPanel.this.getRightList().getModel().getSize() == 0) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        AlchemistGraphicsUtilities.renderMessageOnComponent(g2, ConfigBuilderPanel.FILE_LOAD_SUPPORT_TEXT, Color.GRAY, this.getWidth(), this.getHeight());
                        g2.dispose();
                    }
                }
            };
            this.rightList.setModel(new DefaultListModel());
            this.rightList.setCellRenderer(new ConfigElementListCellRenderer());
            this.rightList.setSelectionMode(1);
            this.rightList.addListSelectionListener(this.listSelectionListener);
            this.rightList.setSelectionBackground(AlchemistGraphicsUtilities.greyscale(this.rightList.getSelectionBackground()));
            this.rightList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        if (ConfigBuilderPanel.this.getRightList().getSelectedIndex() == -1) {
                            if (ConfigBuilderPanel.this.isFileSupportEnabled() && ConfigBuilderPanel.this.openFileAction != null) {
                                ConfigBuilderPanel.this.openFileAction.actionPerformed(null);
                            }
                        } else {
                            ConfigBuilderPanel.this.REMOVE_ACTION.actionPerformed(null);
                        }
                    }
                }
            });
        }
        return this.rightList;
    }

    private JButton getOpenFileButton() {
        if (this.openFileButton == null) {
            this.openFileButton = this.openFileAction == null ? new JButton() : new JButton(this.openFileAction);
            this.openFileButton.setPreferredSize(new Dimension(23, 23));
            this.openFileButton.setVisible(this.fileSupportEnabled && this.openFileAction != null);
        }
        return this.openFileButton;
    }

    private JButton getSaveFileButton() {
        if (this.saveFileButton == null) {
            this.saveFileButton = this.saveFileAction == null ? new JButton() : new JButton(this.saveFileAction);
            this.saveFileButton = new JButton(this.saveFileAction);
            this.saveFileButton.setPreferredSize(new Dimension(23, 23));
            this.saveFileButton.setVisible(this.fileSupportEnabled && this.saveFileAction != null);
        }
        return this.saveFileButton;
    }

    protected JLabel getHelpPanelLabel() {
        if (this.helpPanelLabel == null) {
            this.helpPanelLabel = new JLabel();
            this.helpPanelLabel.setBackground(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
            this.helpPanelLabel.setOpaque(true);
            this.helpPanelLabel.setText(DEFAULT_HELP_TITLE);
            this.helpPanelLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Color.BLACK), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        }
        return this.helpPanelLabel;
    }

    protected JTextArea getHelpTextArea() {
        if (this.helpTextArea == null) {
            this.helpTextArea = new JTextArea();
            this.helpTextArea.setBackground(AlchemistGraphicsUtilities.ALCHEMIST_TOOLTIP_BGR);
            this.helpTextArea.setEditable(false);
            this.helpTextArea.setWrapStyleWord(true);
            this.helpTextArea.setLineWrap(true);
            this.helpTextArea.setText(this.defaultHelpText);
            this.helpTextArea.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            this.helpTextArea.setFont(this.getHelpPanelLabel().getFont());
        }
        return this.helpTextArea;
    }

    public String getDefaultHelpText() {
        return this.defaultHelpText;
    }

    public void setDefaultHelpText(String text) {
        this.defaultHelpText = text;
        if (this.getHelpTextArea().isVisible() && this.getLeftList().getSelectedIndex() == -1) {
            this.getHelpTextArea().setText(text);
        }
    }

    private JPanel getHelpPanel() {
        if (this.helpPanel == null) {
            this.helpPanel = new JPanel();
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(this.getHelpTextArea());
            scrollPane.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.BLACK));
            FormLayout layout = new FormLayout("4dlu, fill:default:grow, 4dlu", "4dlu, fill:default, fill:default:grow, 4dlu");
            CellConstraints cc = new CellConstraints();
            this.helpPanel.setLayout((LayoutManager)layout);
            this.helpPanel.add((Component)this.getHelpPanelLabel(), cc.xy(2, 2));
            this.helpPanel.add((Component)scrollPane, cc.xy(2, 3));
        }
        return this.helpPanel;
    }

    public void refreshLicenses() {
        if (this.licenseSupport != null) {
            this.licenseSupport.refresh();
            for (int i = 0; i < this.getLeftList().getModel().getSize(); ++i) {
                ConfigElement element = (ConfigElement)this.getLeftList().getModel().getElementAt(i);
                if (element.getLicenseName() == null) continue;
                element.setLicensed(this.licenseSupport.isLicensed(element.getLicenseName()));
            }
        }
        if (this.getLeftList().getSelectedIndex() != -1) {
            this.getLeftList().setSelectedIndex(this.getLeftList().getSelectedIndex());
        }
    }

    public LicenseSupport getLicenseSupport() {
        return this.licenseSupport;
    }

    public void setLicenseSupport(LicenseSupport licenseSupport) {
        this.licenseSupport = licenseSupport;
        this.refreshLicenses();
    }

    protected void handleValidityChanges() {
        boolean valid = this.isValidConfiguration();
        if (valid != this.validConfiguration) {
            if (!this.readingConfiguration) {
                this.getElementPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_CONFIGURATION_VALID, this.validConfiguration, valid);
            }
            this.validConfiguration = valid;
        }
    }

    public void setProfile(AlchemistProfile profile) {
        this.profile = profile;
    }

    public void updateProfile() {
        ConfigElementEditor[] editors = this.getPresentationChooser().getEditorInstances();
        for (int i = 0; i < editors.length; ++i) {
            if (!(editors[i] instanceof AlchemistProfileSupport)) continue;
            ((AlchemistProfileSupport)((Object)editors[i])).saveToProfile(this.profile);
        }
    }

    public AlchemistProfile getProfile() {
        return this.profile;
    }

    protected void addElement(ConfigElement element) {
        try {
            ConfigElement clone = element.clone();
            clone.addPropertyChangeListener(this.elementPropertyChangeListener);
            if (element instanceof ExternalEditorSupport) {
                clone.addPropertyChangeListener("Editormode", this.editorPropertyChangeListener);
            }
            ((DefaultListModel)this.getRightList().getModel()).addElement(clone);
            this.getElementPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_ELEMENT_LIST, null, clone);
            this.handleValidityChanges();
        }
        catch (CloneNotSupportedException e1) {
            e1.printStackTrace();
        }
    }

    protected void removeElement(ConfigElement element) {
        element.removePropertyChangeListener(this.elementPropertyChangeListener);
        ((DefaultListModel)this.getRightList().getModel()).removeElement(element);
        this.getElementPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_ELEMENT_LIST, element, null);
        this.handleValidityChanges();
    }

    public void clear() {
        this.getRightList().setModel(new DefaultListModel());
    }

    public void readConfiguration(ConfigurationReader reader) {
        this.readConfiguration(reader, null);
    }

    public void readConfiguration(ConfigurationReader reader, String[] groupFilter) {
        ConfigElement[] elements;
        this.readingConfiguration = true;
        if (groupFilter != null) {
            try {
                elements = reader.readConfiguration(groupFilter);
            }
            catch (OperationNotSupportedException e) {
                elements = reader.readConfiguration();
            }
        } else {
            elements = reader.readConfiguration();
        }
        DefaultListModel<ConfigElement> model = new DefaultListModel<ConfigElement>();
        for (int i = 0; i < elements.length; ++i) {
            try {
                ConfigElement clone = elements[i].clone();
                clone.addPropertyChangeListener(this.elementPropertyChangeListener);
                if (elements[i] instanceof ExternalEditorSupport) {
                    clone.addPropertyChangeListener("Editormode", this.editorPropertyChangeListener);
                }
                model.addElement(clone);
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        this.getRightList().setModel(model);
        this.getElementPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_ELEMENT_LIST, null, model);
        this.handleValidityChanges();
        this.readingConfiguration = false;
    }

    public void writeConfiguration(ConfigurationWriter writer) throws IOException {
        List<Object> itemList = Arrays.asList(((DefaultListModel)this.getRightList().getModel()).toArray());
        writer.writeConfiguration(itemList.toArray(new ConfigElement[itemList.size()]));
    }

    public ConfigElement[] getConfiguration() {
        List<Object> itemList = Arrays.asList(((DefaultListModel)this.getRightList().getModel()).toArray());
        return itemList.toArray(new ConfigElement[itemList.size()]);
    }

    public boolean isValidConfiguration() {
        List<Object> itemList = Arrays.asList(((DefaultListModel)this.getRightList().getModel()).toArray());
        for (ConfigElement configElement : itemList) {
            if (configElement.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isIgnoreMissingLicense() {
        return this.ignoreMissingLicense;
    }

    public void setIgnoreMissingLicense(boolean ignoreMissingLicense) {
        this.ignoreMissingLicense = ignoreMissingLicense;
        ((ConfigElementListCellRenderer)this.getLeftList().getCellRenderer()).setIgnoreLicense(ignoreMissingLicense);
        ((ConfigElementListCellRenderer)this.getRightList().getCellRenderer()).setIgnoreLicense(ignoreMissingLicense);
    }

    public void addElementPropertyChangeListener(PropertyChangeListener listener) {
        this.getElementPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void addElementPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getElementPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public void removeElementPropertyChangeListener(PropertyChangeListener listener) {
        this.getElementPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public void removeElementPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getElementPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    public boolean isFileSupportEnabled() {
        return this.fileSupportEnabled;
    }

    public void setFileSupportEnabled(boolean fileSupportEnabled) {
        this.fileSupportEnabled = fileSupportEnabled;
        this.getOpenFileButton().setVisible(fileSupportEnabled && this.openFileAction != null);
        this.getSaveFileButton().setVisible(fileSupportEnabled && this.saveFileAction != null);
    }

    public Action getOpenFileAction() {
        return this.openFileAction;
    }

    public void setOpenFileAction(Action openFileAction) {
        this.openFileAction = openFileAction;
        this.getOpenFileButton().setVisible(this.fileSupportEnabled && openFileAction != null);
        if (openFileAction != null) {
            this.getOpenFileButton().setAction(openFileAction);
        }
    }

    public Action getSaveFileAction() {
        return this.saveFileAction;
    }

    public void setSaveFileAction(Action saveFileAction) {
        this.saveFileAction = saveFileAction;
        this.getSaveFileButton().setVisible(this.fileSupportEnabled && saveFileAction != null);
        if (saveFileAction != null) {
            this.getSaveFileButton().setAction(saveFileAction);
        }
    }

    public String[] getTags() {
        String[] tags = new String[this.getLeftListFilter().getItemCount()];
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = this.getLeftListFilter().getItemAt(i).toString();
        }
        return tags;
    }

    public void setDefaultTag(String tag) {
        for (int i = 0; i < this.getLeftListFilter().getItemCount(); ++i) {
            if (!tag.equalsIgnoreCase(this.getLeftListFilter().getItemAt(i).toString())) continue;
            this.getLeftListFilter().setSelectedIndex(i);
            return;
        }
    }

    protected void setElementPropertyChangeSupport(SwingPropertyChangeSupport elementPropertyChangeSupport) {
        this.elementPropertyChangeSupport = elementPropertyChangeSupport;
    }

    protected SwingPropertyChangeSupport getElementPropertyChangeSupport() {
        return this.elementPropertyChangeSupport;
    }

    protected void setFirstResized(boolean firstResized) {
        this.firstResized = firstResized;
    }

    protected boolean isFirstResized() {
        return this.firstResized;
    }

    protected void setNormalViewSplit(JSplitPane normalViewSplit) {
        this.normalViewSplit = normalViewSplit;
    }

    protected JSplitPane getNormalViewSplit() {
        return this.normalViewSplit;
    }

    protected void setMainLayout(CardLayout mainLayout) {
        this.mainLayout = mainLayout;
    }

    protected CardLayout getMainLayout() {
        return this.mainLayout;
    }

    protected void setPresentationChooser(ConfigElementPresentationChooser presentationChooser) {
        this.presentationChooser = presentationChooser;
    }

    protected ConfigElementPresentationChooser getPresentationChooser() {
        return this.presentationChooser;
    }

    protected void setControlLayout(CardLayout controlLayout) {
        this.controlLayout = controlLayout;
    }

    protected CardLayout getControlLayout() {
        return this.controlLayout;
    }

    protected final class LeftListModel
    extends SynchronizedAbstractFilterListModel {
        private static final long serialVersionUID = 2968756310518353393L;
        private final transient Comparator<ConfigElement> comparator = new Comparator<ConfigElement>(){

            @Override
            public int compare(ConfigElement o1, ConfigElement o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };

        protected LeftListModel() {
        }

        @Override
        protected synchronized boolean filter(Object element) {
            if (element instanceof ConfigElement) {
                if (ConfigBuilderPanel.this.getLeftListFilter().getSelectedIndex() == -1) {
                    String haystack = ((ConfigElement)element).getName().toLowerCase();
                    String[] needles = ConfigBuilderPanel.this.getLeftListFilter().getEditor().getItem() == null ? new String[]{} : ConfigBuilderPanel.this.getLeftListFilter().getEditor().getItem().toString().trim().toLowerCase().split(" ");
                    for (int i = 0; i < needles.length; ++i) {
                        if (!haystack.contains(needles[i])) continue;
                        return true;
                    }
                } else if (ConfigBuilderPanel.this.getLeftListFilter().getSelectedItem() != null) {
                    return ((ConfigElement)element).hasTag(ConfigBuilderPanel.this.getLeftListFilter().getSelectedItem().toString());
                }
            }
            return false;
        }

        public synchronized void sort() {
            Vector<ConfigElement> v = new Vector<ConfigElement>();
            for (Object o : this.vector) {
                if (!(o instanceof ConfigElement)) continue;
                v.add((ConfigElement)o);
            }
            this.vector.removeAllElements();
            Collections.sort(v, this.comparator);
            this.vector.addAll(v);
            this.filter();
        }
    }
}

