/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.SwingPropertyChangeSupport;
import org.dom4j.Element;

public abstract class ConfigElement
implements Transferable,
Cloneable {
    public static final DataFlavor FLAVOR = new DataFlavor(ConfigElement.class, "ConfigElement");
    public static final String PROPERTY_KEY_VALID = "ConfigElement_Valid";
    public static final String PROPERTY_KEY_EDITABLE = "ConfigElement_editable";
    public static final String PROPERTY_KEY_ID = "ConfigElement_id";
    public static final String PROPERTY_KEY_NAME = "ConfigElement_name";
    public static final String PROPERTY_KEY_ICON = "ConfigElement_icon";
    public static final String PROPERTY_KEY_DISABLEDICON = "ConfigElement_disabledicon";
    public static final String PROPERTY_KEY_DEFAULTICON = "ConfigElement_defaulticon";
    public static final String PROPERTY_KEY_TOOLTIP = "ConfigElement_tooltip";
    public static final String PROPERTY_KEY_HELPTEXT = "ConfigElement_helptext";
    private String id = null;
    private String name = null;
    private Icon icon = null;
    private ImageIcon disabledIcon = null;
    private ImageIcon invalidIcon = null;
    private String tooltip = null;
    private String helpText = null;
    private List<String> groups = null;
    private List<String> tags = null;
    private SwingPropertyChangeSupport propertyChangeSupport = null;
    private boolean editable = true;
    private boolean valid = false;
    private boolean licensed = true;
    private String license = null;

    public ConfigElement() {
        this("Undefined");
    }

    public ConfigElement(String id) {
        this(id, "Unnamed");
    }

    public ConfigElement(String id, String name) {
        this(id, name, null);
    }

    public ConfigElement(String id, String name, Icon icon) {
        this(id, name, icon, "");
    }

    public ConfigElement(String id, String name, Icon icon, String tooltip) {
        this(id, name, icon, tooltip, "");
    }

    public ConfigElement(String id, String name, Icon icon, String tooltip, String helpText) {
        this(id, name, icon, null, tooltip, helpText);
    }

    public ConfigElement(String id, String name, Icon icon, ImageIcon disabledIcon, String tooltip, String helpText) {
        URL invalidIconURL = ConfigElement.class.getResource("/chemaxon/alchemist/images/warning24.png");
        if (invalidIconURL != null) {
            this.invalidIcon = new ImageIcon(invalidIconURL);
        }
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.disabledIcon = disabledIcon;
        this.tooltip = tooltip;
        this.helpText = helpText;
        this.setPropertyChangeSupport(new SwingPropertyChangeSupport(this));
        this.groups = new ArrayList<String>();
        this.tags = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_NAME, oldName, name);
        this.validate();
    }

    public Icon getIcon() {
        return this.isValid() ? this.getDefaultIcon() : this.invalidIcon;
    }

    public ImageIcon getDisabledIcon() {
        return this.disabledIcon;
    }

    public void setDisabledIcon(ImageIcon disabledIcon) {
        ImageIcon oldDisabledIcon = this.disabledIcon;
        this.disabledIcon = disabledIcon;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_DISABLEDICON, oldDisabledIcon, disabledIcon);
    }

    public void setDefaultIcon(Icon icon) {
        Icon oldIcon = this.icon;
        this.icon = icon;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_ICON, oldIcon, icon);
    }

    public Icon getDefaultIcon() {
        return this.icon;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        String oldTooltip = this.tooltip;
        this.tooltip = tooltip;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_TOOLTIP, oldTooltip, tooltip);
        this.validate();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_ID, oldId, id);
        this.validate();
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        String oldHelpText = this.helpText;
        this.helpText = helpText;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_HELPTEXT, oldHelpText, helpText);
        this.validate();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        boolean oldEditable = this.editable;
        this.editable = editable;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_EDITABLE, oldEditable, editable);
        this.validate();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.isMimeTypeEqual(FLAVOR);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        boolean oldValue = this.isValid();
        this.valid = valid;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_KEY_VALID, oldValue, valid);
    }

    protected abstract void validate();

    public void store(Element parent) {
        this.store(parent, this.getId());
    }

    protected Element store(Element parent, String xmlTag) {
        Element e = parent.addElement(xmlTag);
        e.addAttribute("ID", this.getId());
        if (this.hasGroups()) {
            StringBuffer buff = new StringBuffer();
            String[] groups = this.groups.toArray(new String[0]);
            for (int i = 0; i < groups.length - 1; ++i) {
                buff.append(groups[i]);
                buff.append(',');
            }
            buff.append(groups[groups.length - 1]);
            e.addAttribute("Groups", buff.toString());
        }
        return e;
    }

    public abstract boolean isDefault();

    public void addGroup(String groupName) {
        if (!this.groups.contains(groupName)) {
            this.groups.add(groupName);
        }
    }

    public String[] getGroups() {
        return this.groups.toArray(new String[0]);
    }

    public boolean hasGroup(String groupName) {
        return this.groups.contains(groupName);
    }

    public boolean hasGroups() {
        return !this.groups.isEmpty();
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[0]);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public boolean hasTags() {
        return !this.tags.isEmpty();
    }

    public boolean isLicensed() {
        return this.licensed;
    }

    public void setLicensed(boolean licensed) {
        this.licensed = licensed;
    }

    public String getLicenseName() {
        return this.license;
    }

    public void setLicenseName(String licenseName) {
        this.license = licenseName;
    }

    @Deprecated
    public ConfigElement cloneElement() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setPropertyChangeSupport(SwingPropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport;
    }

    public SwingPropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public ConfigElement clone() throws CloneNotSupportedException {
        ConfigElement clone = (ConfigElement)super.clone();
        clone.propertyChangeSupport = new SwingPropertyChangeSupport(clone);
        return clone;
    }
}

