/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.configbuilder.BasicConfigElement;
import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.LicenseSupport;
import chemaxon.alchemist.configbuilder.configuration.marshalling.Configuration;
import chemaxon.alchemist.configbuilder.configuration.marshalling.Element;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;

public class ConfigElementFactory {
    private static final String DEFAULT_TAG = "All";
    private static final String UNDEFINED = "Undefined";
    private static final String NONE = "None";
    private static final String NAME = ".name";
    private static final String ICON = ".icon";
    private static final String DISABLEDICON = ".disabledicon";
    private static final String TOOLTIP = ".tooltip";
    private static final String HELPTEXT = ".helptext";
    private static final String LICENSE = ".license";
    private static final String TAGS = ".tags";
    private final Properties properties = new Properties();
    private final Map<Class<?>, String> idMap = new HashMap();
    private final Map<String, Class<?>> classMap = new HashMap();
    private LicenseSupport licenseSupport = null;

    public ConfigElementFactory(String configPath) {
        this(configPath, null);
    }

    public ConfigElementFactory(String configPath, LicenseSupport licenseSupport) {
        this.licenseSupport = licenseSupport;
        try {
            Configuration config = Configuration.unmarshal(new InputStreamReader(ConfigBuilderPanel.class.getResourceAsStream(configPath)));
            this.initialize(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }

    public ConfigElementFactory(Configuration configuration) throws IllegalArgumentException {
        this(configuration, null);
    }

    public ConfigElementFactory(Configuration configuration, LicenseSupport licenseSupport) throws IllegalArgumentException {
        this.licenseSupport = licenseSupport;
        this.initialize(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Configuration configuration) {
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(configuration.getBundle().getBase());
            try {
                this.properties.load(resourceAsStream);
                Element[] elements = configuration.getElementList().getElement();
                for (int i = 0; i < elements.length; ++i) {
                    Class<?> elementClass = Class.forName(elements[i].getClassName());
                    if (!elementClass.equals(BasicConfigElement.class)) {
                        this.idMap.put(elementClass, elements[i].getId());
                    }
                    this.classMap.put(elements[i].getId(), elementClass);
                    this.properties.put(elements[i].getId() + TAGS, elements[i].getTags());
                }
            }
            finally {
                resourceAsStream.close();
            }
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }

    public ConfigElement create(String configElementId) throws IllegalArgumentException {
        ConfigElement element = null;
        try {
            Class<?> configElementClass = this.classMap.get(configElementId);
            Constructor<?>[] constructors = configElementClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length != 0) continue;
                element = (ConfigElement)constructors[i].newInstance(null);
            }
            if (element == null) {
                throw new IllegalArgumentException("Instantiation Exception occurred.");
            }
            element.setId(configElementId);
            element.setName(this.properties.getProperty(configElementId + NAME, UNDEFINED));
            String iconPath = this.properties.getProperty(configElementId + ICON, UNDEFINED);
            if (this.getClass().getResource(iconPath) != null) {
                element.setDefaultIcon(new ImageIcon(this.getClass().getResource(iconPath)));
            }
            String disabledIconPath = this.properties.getProperty(configElementId + DISABLEDICON, UNDEFINED);
            if (this.getClass().getResource(disabledIconPath) != null) {
                element.setDisabledIcon(new ImageIcon(this.getClass().getResource(disabledIconPath)));
            }
            element.setTooltip(this.properties.getProperty(configElementId + TOOLTIP, UNDEFINED));
            element.setHelpText(this.properties.getProperty(configElementId + HELPTEXT, UNDEFINED));
            String tags = this.properties.getProperty(configElementId + TAGS);
            if (tags != null) {
                String[] tag = tags.split(",");
                for (int i = 0; i < tag.length; ++i) {
                    String trimmed = tag[i].trim();
                    if (trimmed.length() <= 0) continue;
                    element.addTag(trimmed);
                }
            }
            element.addTag(DEFAULT_TAG);
            String license = this.properties.getProperty(configElementId + LICENSE, NONE);
            if (license.equalsIgnoreCase(NONE)) {
                element.setLicensed(true);
            } else {
                element.setLicenseName(license);
                if (this.licenseSupport != null) {
                    element.setLicensed(this.licenseSupport.isLicensed(license));
                }
            }
            element.validate();
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
        return element;
    }

    public ConfigElement create(Class<?> configElementClass) throws IllegalArgumentException {
        if (configElementClass.equals(BasicConfigElement.class)) {
            throw new IllegalArgumentException("BasicConfigElement instances can not be created by class");
        }
        return this.create(this.idMap.get(configElementClass));
    }

    public ConfigElement create(Element xmlElement) throws IllegalArgumentException {
        return this.create(xmlElement.getId());
    }
}

