/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.AlchemistProfile;
import chemaxon.alchemist.configbuilder.AbstractSketchConfigElement;
import chemaxon.alchemist.configbuilder.AlchemistProfileSupport;
import chemaxon.alchemist.configbuilder.ConfigElement;
import chemaxon.alchemist.configbuilder.ConfigElementEditor;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.common.UserSettings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ConfigElementSketchEditor
implements ConfigElementEditor,
AlchemistProfileSupport {
    private static final String PROFILE_KEY_DISPOPTS = "alchemist.configbuilder.ConfigElementSketchEditor.dispoptsmap";
    private Map<Class<?>, Integer> displayOptsMap = new HashMap();
    private MSketchPane msketch = null;
    private final UserSettings sketchUserSettings = new UserSettings("ConfigElementSketchEditor_Marvin.properties");
    private JPanel sketchPanel = null;
    private AbstractSketchConfigElement element = null;
    private JButton acceptSketchButton = null;
    private JButton cancelSketchButton = null;
    private final AbstractAction ACCEPT_SKETCH_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 6582807268915918429L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigElementSketchEditor.this.getElement().accepted(ConfigElementSketchEditor.this.getMsketch().getMol());
            ConfigElementSketchEditor.this.getDisplayOptsMap().put(ConfigElementSketchEditor.this.getElement().getClass(), ConfigElementSketchEditor.this.getMsketch().getDispopts());
        }
    };
    private final AbstractAction CANCEL_SKETCH_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -5059427780874102090L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigElementSketchEditor.this.getElement().canceled();
            ConfigElementSketchEditor.this.getDisplayOptsMap().put(ConfigElementSketchEditor.this.getElement().getClass(), ConfigElementSketchEditor.this.getMsketch().getDispopts());
        }
    };

    @Override
    public Component getEditorComponent(ConfigElement value) {
        this.setElement((AbstractSketchConfigElement)value);
        this.getSketchPanel();
        this.getMsketch().setMol(this.getElement().getMolecule());
        Integer displayOpts = this.getDisplayOptsMap().get(this.getElement().getClass());
        if (displayOpts != null) {
            this.getMsketch().setDispopts(displayOpts);
        } else {
            int dispOpts = this.getElement().getDefaultDispOpts();
            if (dispOpts != -1) {
                this.getMsketch().setDispopts(dispOpts);
            }
        }
        return this.sketchPanel;
    }

    @Override
    public ConfigElement getEditorValue() {
        return this.getElement();
    }

    private JPanel getSketchPanel() {
        if (this.sketchPanel == null) {
            this.sketchPanel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, min, 2dlu, min, fill:default:grow, 4dlu", "4dlu, fill:default:grow, 2dlu, pref, 4dlu");
            layout.setColumnGroups((int[][])new int[][]{{2, 4}});
            CellConstraints cc = new CellConstraints();
            this.sketchPanel.setLayout((LayoutManager)layout);
            this.sketchPanel.add((Component)this.getMSketchPane(), cc.xyw(2, 2, 4));
            this.sketchPanel.add((Component)this.getAcceptSketchButton(), cc.xy(2, 4));
            this.sketchPanel.add((Component)this.getCancelSketchButton(), cc.xy(4, 4));
        }
        return this.sketchPanel;
    }

    private JButton getAcceptSketchButton() {
        if (this.acceptSketchButton == null) {
            this.acceptSketchButton = new JButton(this.ACCEPT_SKETCH_ACTION);
            this.acceptSketchButton.setText("Accept");
        }
        return this.acceptSketchButton;
    }

    private JButton getCancelSketchButton() {
        if (this.cancelSketchButton == null) {
            this.cancelSketchButton = new JButton(this.CANCEL_SKETCH_ACTION);
            this.cancelSketchButton.setText("Cancel");
        }
        return this.cancelSketchButton;
    }

    public MSketchPane getMSketchPane() {
        if (this.getMsketch() == null) {
            this.sketchUserSettings.setCheckerConfigFileName("ConfigElementSketchEditor_MarvinSketch_checkerconfig.xml");
            this.setMsketch(new MSketchPane(this.sketchUserSettings));
            this.getMsketch().setMinimumSize(new Dimension(20, 20));
        }
        return this.getMsketch();
    }

    @Override
    public void loadFromProfile(AlchemistProfile profile) {
        this.setDisplayOptsMap((Map)profile.get(PROFILE_KEY_DISPOPTS));
        if (this.getDisplayOptsMap() == null) {
            this.setDisplayOptsMap(new HashMap());
        }
    }

    @Override
    public void saveToProfile(AlchemistProfile profile) {
        try {
            this.sketchUserSettings.save("Save");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        profile.put(PROFILE_KEY_DISPOPTS, this.getDisplayOptsMap());
    }

    public void setElement(AbstractSketchConfigElement element) {
        this.element = element;
    }

    public AbstractSketchConfigElement getElement() {
        return this.element;
    }

    public void setMsketch(MSketchPane msketch) {
        this.msketch = msketch;
    }

    public MSketchPane getMsketch() {
        return this.msketch;
    }

    public void setDisplayOptsMap(Map<Class<?>, Integer> displayOptsMap) {
        this.displayOptsMap = displayOptsMap;
    }

    public Map<Class<?>, Integer> getDisplayOptsMap() {
        return this.displayOptsMap;
    }
}

