/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.configbuilder.ConfigBuilderPanel;
import chemaxon.alchemist.configbuilder.ConfigElement;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class ConfigElementTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 9146587976990656436L;
    private final JList source;
    private final JList destination;
    private final ConfigBuilderPanel configBuilderPanel;

    public ConfigElementTransferHandler(JList source, JList destination, ConfigBuilderPanel configBuilderPanel) {
        this.source = source;
        this.destination = destination;
        this.configBuilderPanel = configBuilderPanel;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (comp.equals(this.destination)) {
            for (int i = 0; i < transferFlavors.length; ++i) {
                if (!transferFlavors[i].isMimeTypeEqual(ConfigElement.FLAVOR)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return c.equals(this.source) ? (ConfigElement)((JList)c).getSelectedValue() : null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return c.equals(this.source) ? 1 : 0;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (comp.equals(this.destination)) {
            try {
                this.configBuilderPanel.addElement((ConfigElement)t.getTransferData(ConfigElement.FLAVOR));
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }
}

