/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.configbuilder;

import chemaxon.alchemist.configbuilder.ConfigElementFactory;
import chemaxon.alchemist.configbuilder.standardizer.StandardizerConfigurationReader;
import chemaxon.alchemist.configbuilder.structurechecker.StructureCheckerConfigurationReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public final class ConfigurationReaderFactory {
    private ConfigurationReaderFactory() {
    }

    public static StandardizerConfigurationReader createStandardizerConfigurationReader(String configurationString) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(configurationString.getBytes());
        return ConfigurationReaderFactory.createStandardizerConfigurationReader(inputStream);
    }

    public static StandardizerConfigurationReader createStandardizerConfigurationReader(File configurationFile) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(configurationFile);
        return ConfigurationReaderFactory.createStandardizerConfigurationReader(inputStream);
    }

    public static StandardizerConfigurationReader createStandardizerConfigurationReader(InputStream inputStream) {
        ConfigElementFactory factory = new ConfigElementFactory("/chemaxon/alchemist/configbuilder/standardizer/StandardizerConfiguration.xml");
        return new StandardizerConfigurationReader(factory, inputStream);
    }

    public static StructureCheckerConfigurationReader createStructureCheckerConfigurationReader(File configurationFile) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(configurationFile);
        return ConfigurationReaderFactory.createStructureCheckerConfigurationReader(inputStream);
    }

    public static StructureCheckerConfigurationReader createStructureCheckerConfigurationReader(String configurationString) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(configurationString.getBytes());
        return ConfigurationReaderFactory.createStructureCheckerConfigurationReader(inputStream);
    }

    public static StructureCheckerConfigurationReader createStructureCheckerConfigurationReader(InputStream inputStream) {
        return new StructureCheckerConfigurationReader(inputStream);
    }
}

